/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.laf.StyleConstants;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.UIDefaults;

public final class ProprietaryUtils {
    public static void setupUIDefaults(UIDefaults table) {
        try {
            Class su2 = ReflectUtils.getClass("sun.swing.SwingUtilities2");
            Object aaProperty = ReflectUtils.getStaticFieldValue(su2, "AA_TEXT_PROPERTY_KEY");
            Class aaTextInfo = ReflectUtils.getInnerClass(su2, "AATextInfo");
            Object aaValue = ReflectUtils.callStaticMethod(aaTextInfo, "getAATextInfo", true);
            table.put(aaProperty, aaValue);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isWindowTransparencyAllowed() {
        try {
            return SystemUtils.isWindows() || SystemUtils.isMac() || SystemUtils.isSolaris();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void setWindowOpaque(Window window, boolean opaque) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    Color bg = opaque ? StyleConstants.backgroundColor : StyleConstants.transparent;
                    ReflectUtils.callMethod((Object)window, "setBackground", bg);
                } else {
                    ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "setWindowOpaque", window, opaque);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (window instanceof JWindow) {
                Container container;
                JWindow jWindow = (JWindow)window;
                boolean modified = false;
                JRootPane rootPane = jWindow.getRootPane();
                if (rootPane != null && rootPane.isOpaque() != opaque) {
                    rootPane.setOpaque(opaque);
                    modified = true;
                }
                if ((container = jWindow.getContentPane()) != null && container instanceof JComponent && container.isOpaque() != opaque) {
                    ((JComponent)container).setOpaque(opaque);
                    modified = true;
                }
                if (modified) {
                    rootPane.repaint();
                }
            }
        }
    }

    public static boolean isWindowOpaque(Window window) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Color bg;
                Boolean isOpaque = SystemUtils.isJava7orAbove() ? Boolean.valueOf((bg = (Color)ReflectUtils.callMethod((Object)window, "getBackground", new Object[0])).getAlpha() == 255) : (Boolean)ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "isWindowOpaque", window);
                return isOpaque != null ? isOpaque : true;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void setWindowOpacity(Window window, float opacity) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                if (SystemUtils.isJava7orAbove()) {
                    ReflectUtils.callMethod((Object)window, "setOpacity", Float.valueOf(opacity));
                } else {
                    ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "setWindowOpacity", window, Float.valueOf(opacity));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static float getWindowOpacity(Window window) {
        if (window != null && ProprietaryUtils.isWindowTransparencyAllowed()) {
            try {
                Float opacity = SystemUtils.isJava7orAbove() ? (Float)ReflectUtils.callMethod((Object)window, "getOpacity", new Object[0]) : (Float)ReflectUtils.callStaticMethod("com.sun.awt.AWTUtilities", "getWindowOpacity", window);
                return opacity != null ? opacity.floatValue() : 1.0f;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return 1.0f;
    }
}

