/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.MathUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public final class GeometryUtils {
    public static Rectangle getContainingRect(List<Point> points) {
        return points != null && points.size() > 0 ? GeometryUtils.getContainingRect(points.toArray(new Point[points.size()])) : null;
    }

    public static Rectangle getContainingRect(Point ... points) {
        if (points != null && points.length > 0) {
            Rectangle rect = new Rectangle(points[0], new Dimension(0, 0));
            for (int i = 1; i < points.length; ++i) {
                int diff;
                Point p = points[i];
                if (p.x < rect.x) {
                    diff = rect.x - p.x;
                    rect.x = p.x;
                    rect.width += diff;
                } else if (rect.x + rect.width < p.x) {
                    rect.width = p.x - rect.x;
                }
                if (p.y < rect.y) {
                    diff = rect.y - p.y;
                    rect.y = p.y;
                    rect.height += diff;
                    continue;
                }
                if (rect.y + rect.height >= p.y) continue;
                rect.height = p.y - rect.y;
            }
            if (rect.width == 0) {
                rect.width = 1;
            }
            if (rect.height == 0) {
                rect.height = 1;
            }
            return rect;
        }
        return null;
    }

    public static Rectangle getContainingRect(Rectangle ... rects) {
        if (rects != null && rects.length > 0) {
            Rectangle rect = rects[0];
            for (int i = 1; i < rects.length; ++i) {
                rect = GeometryUtils.getContainingRect(rect, rects[i]);
            }
            return rect;
        }
        return null;
    }

    public static Rectangle getContainingRect(Rectangle r1, Rectangle r2) {
        if (r1 == null && r2 != null) {
            return r2;
        }
        if (r2 == null && r1 != null) {
            return r1;
        }
        if (r1 == null && r2 == null) {
            return null;
        }
        int minX = Math.min(r1.x, r2.x);
        int minY = Math.min(r1.y, r2.y);
        int maxX = Math.max(r1.x + r1.width, r2.x + r2.width);
        int maxY = Math.max(r1.y + r1.height, r2.y + r2.height);
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public static Rectangle validateRect(Rectangle rect) {
        if (rect.width >= 0 && rect.height >= 0) {
            return rect;
        }
        int x = rect.x;
        int width = Math.abs(rect.width);
        if (rect.width < 0) {
            x -= width;
        }
        int y = rect.y;
        int height = Math.abs(rect.height);
        if (rect.height < 0) {
            y -= height;
        }
        return new Rectangle(x, y, width, height);
    }

    public static Point middle(Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public static Point middle(Point p1, Point p2) {
        return new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
    }

    public static Point middle(int x1, int y1, int x2, int y2) {
        return new Point((x1 + x2) / 2, (y1 + y2) / 2);
    }

    public static Rectangle expand(Rectangle rect, int expansion) {
        return GeometryUtils.expand(rect, expansion, expansion, expansion, expansion);
    }

    public static Rectangle expand(Rectangle rect, int top, int left, int bottom, int right) {
        return new Rectangle(rect.x - left, rect.y - top, rect.width + left + right, rect.height + top + bottom);
    }

    public static Point modify(Point point, int xMod, int yMod) {
        return new Point(point.x + xMod, point.y + yMod);
    }

    public static double getAngle(Point p1, Point p2) {
        return GeometryUtils.getAngle(p1.x, p1.y, p2.x, p2.y);
    }

    public static double getAngle(int x1, int y1, int x2, int y2) {
        double angle = Math.asin((double)(y2 - y1) / Math.sqrt(MathUtils.sqr(x2 - x1) + MathUtils.sqr(y2 - y1)));
        return x1 > x2 ? -angle - Math.PI : angle;
    }

    public static Point findMiddleLineIntersection(Rectangle rect, Point outer) {
        int y;
        int x;
        int x2;
        int y2;
        Point middle = GeometryUtils.middle(rect);
        int x1 = middle.x;
        int y1 = middle.y;
        int x22 = outer.x;
        int y22 = outer.y;
        if (x22 < rect.x ? (y2 = (x1 * (y22 - y1) - y1 * (x22 - x1) - (x2 = rect.x) * (y22 - y1)) / (x1 - x22)) >= rect.y && y2 <= rect.y + rect.height : x22 > rect.x + rect.width && (y2 = (x1 * (y22 - y1) - y1 * (x22 - x1) - (x2 = rect.x + rect.width) * (y22 - y1)) / (x1 - x22)) >= rect.y && y2 <= rect.y + rect.height) {
            return new Point(x2, y2);
        }
        if (y22 < rect.y ? (x = (x1 * (y22 - y1) - y1 * (x22 - x1) - (y = rect.y) * (x1 - x22)) / (y22 - y1)) >= rect.x && x <= rect.x + rect.width : y22 > rect.y + rect.height && (x = (x1 * (y22 - y1) - y1 * (x22 - x1) - (y = rect.y + rect.height) * (x1 - x22)) / (y22 - y1)) >= rect.x && x <= rect.x + rect.width) {
            return new Point(x, y);
        }
        return middle;
    }
}

