/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.ReflectUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.text.TextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

public final class CollectionUtils {
    public static <T> boolean addAll(Collection<T> collection, T ... objects) {
        boolean result = false;
        for (T object : objects) {
            result |= collection.add(object);
        }
        return result;
    }

    public static <T> List<T> copy(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <T extends Cloneable> List<T> clone(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<Cloneable> cloned = new ArrayList<Cloneable>(collection.size());
        for (Cloneable value : collection) {
            cloned.add(ReflectUtils.cloneSafely(value));
        }
        return cloned;
    }

    public static <T> List<T> copy(T ... data) {
        ArrayList list = new ArrayList(data.length);
        Collections.addAll(list, data);
        return list;
    }

    public static <T> List<T> removeNulls(List<T> list) {
        if (list == null) {
            return null;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
        }
        return list;
    }

    public static boolean areEqual(List list1, List list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if ((list1 == null || list2 == null) && list1 != list2) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (Object object : list1) {
            if (list2.contains(object)) continue;
            return false;
        }
        return true;
    }

    public static <T> List<String> toStringList(List<T> list, TextProvider<T> textProvider) {
        ArrayList<String> stringList = new ArrayList<String>(list.size());
        for (T element : list) {
            stringList.add(textProvider.provide(element));
        }
        return stringList;
    }

    public static int[] toArray(List<Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer integer = list.get(i);
            array[i] = integer != null ? integer : 0;
        }
        return array;
    }

    public static <T> List<T> toList(T[] array) {
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        return list;
    }

    public static <T> List<T> toList(Deque<T> deque) {
        return new ArrayList<T>(deque);
    }

    public static int indexOf(Object object, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if ((obj != null || object != null) && (obj == null || object == null || !obj.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String text, String[] array) {
        return CollectionUtils.indexOf(text, array, false);
    }

    public static int indexOf(String text, String[] array, boolean ignoreCase) {
        for (int i = 0; i < array.length; ++i) {
            String txt = array[i];
            if ((txt != null || text != null) && (txt == null || text == null || !(ignoreCase ? txt.equalsIgnoreCase(text) : txt.equals(text)))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int number, int[] array) {
        for (int i = 0; i < array.length; ++i) {
            int num = array[i];
            if (num != number) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char character, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (ch != character) continue;
            return i;
        }
        return -1;
    }

    public static <T> List<T> filter(Collection<T> collection, Filter<T> filter) {
        ArrayList<T> filtered = new ArrayList<T>(collection.size());
        for (T element : collection) {
            if (!filter.accept(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }
}

