/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.skin.web;

import com.alee.extended.painter.AbstractPainter;
import com.alee.extended.painter.PartialDecoration;
import com.alee.laf.StyleConstants;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.style.skin.web.WebDecorationPainterStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.ShapeCache;
import com.alee.utils.laf.PainterShapeProvider;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.swing.DataProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

public class WebDecorationPainter<E extends JComponent>
extends AbstractPainter<E>
implements PainterShapeProvider<E>,
PartialDecoration {
    protected static final String BORDER_SHAPE = "border";
    protected static final String BACKGROUND_SHAPE = "background";
    protected boolean undecorated = WebDecorationPainterStyle.undecorated;
    protected boolean paintFocus = WebDecorationPainterStyle.paintFocus;
    protected int round = WebDecorationPainterStyle.round;
    protected int shadeWidth = WebDecorationPainterStyle.shadeWidth;
    protected float shadeTransparency = WebDecorationPainterStyle.shadeTransparency;
    protected Stroke borderStroke = WebDecorationPainterStyle.borderStroke;
    protected Color borderColor = WebDecorationPainterStyle.borderColor;
    protected Color disabledBorderColor = WebDecorationPainterStyle.disabledBorderColor;
    protected boolean paintBackground = WebDecorationPainterStyle.paintBackground;
    protected boolean webColoredBackground = WebDecorationPainterStyle.webColoredBackground;
    protected boolean paintTop = true;
    protected boolean paintLeft = true;
    protected boolean paintBottom = true;
    protected boolean paintRight = true;
    protected boolean paintTopLine = false;
    protected boolean paintLeftLine = false;
    protected boolean paintBottomLine = false;
    protected boolean paintRightLine = false;
    protected FocusTracker focusTracker;
    protected boolean focused = false;
    protected boolean ltr;
    protected boolean actualPaintLeft;
    protected boolean actualPaintRight;
    protected int w;
    protected int h;

    @Override
    public void install(E c) {
        super.install(c);
        this.focusTracker = new DefaultFocusTracker(){

            @Override
            public boolean isTrackingEnabled() {
                return !WebDecorationPainter.this.undecorated && WebDecorationPainter.this.paintFocus;
            }

            @Override
            public void focusChanged(boolean focused) {
                WebDecorationPainter.this.focused = focused;
                WebDecorationPainter.this.repaint();
            }
        };
        FocusManager.addFocusTracker(c, this.focusTracker);
    }

    @Override
    public void uninstall(E c) {
        FocusManager.removeFocusTracker(this.focusTracker);
        this.focusTracker = null;
        super.uninstall(c);
    }

    @Override
    public Shape provideShape(E component, Rectangle bounds) {
        return this.undecorated ? bounds : this.getShape(component, true);
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        if (this.undecorated != undecorated) {
            this.undecorated = undecorated;
            this.updateAll();
        }
    }

    public boolean isPaintFocus() {
        return this.paintFocus;
    }

    public void setPaintFocus(boolean paint) {
        if (this.paintFocus != paint) {
            this.paintFocus = paint;
            this.repaint();
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        if (this.round != round) {
            this.round = round;
            this.repaint();
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int width) {
        if (this.shadeWidth != width) {
            this.shadeWidth = width;
            this.revalidate();
        }
    }

    public float getShadeTransparency() {
        return this.shadeTransparency;
    }

    public void setShadeTransparency(float transparency) {
        if (this.shadeTransparency != transparency) {
            this.shadeTransparency = transparency;
            this.repaint();
        }
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(Stroke stroke) {
        if (this.borderStroke != stroke) {
            this.borderStroke = stroke;
            this.repaint();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (this.borderColor != color) {
            this.borderColor = color;
            this.repaint();
        }
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        if (this.disabledBorderColor != color) {
            this.disabledBorderColor = color;
            this.repaint();
        }
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public void setPaintBackground(boolean paint) {
        if (this.paintBackground != paint) {
            this.paintBackground = paint;
            this.repaint();
        }
    }

    public boolean isWebColoredBackground() {
        return this.webColoredBackground;
    }

    public void setWebColoredBackground(boolean webColored) {
        if (this.webColoredBackground != webColored) {
            this.webColoredBackground = webColored;
            this.repaint();
        }
    }

    public boolean isPaintTop() {
        return this.paintTop;
    }

    @Override
    public void setPaintTop(boolean top) {
        if (this.paintTop != top) {
            this.paintTop = top;
            this.updateAll();
        }
    }

    public boolean isPaintLeft() {
        return this.paintLeft;
    }

    @Override
    public void setPaintLeft(boolean left) {
        if (this.paintLeft != left) {
            this.paintLeft = left;
            this.updateAll();
        }
    }

    public boolean isPaintBottom() {
        return this.paintBottom;
    }

    @Override
    public void setPaintBottom(boolean bottom) {
        if (this.paintBottom != bottom) {
            this.paintBottom = bottom;
            this.updateAll();
        }
    }

    public boolean isPaintRight() {
        return this.paintRight;
    }

    @Override
    public void setPaintRight(boolean right) {
        if (this.paintRight != right) {
            this.paintRight = right;
            this.updateAll();
        }
    }

    @Override
    public void setPaintSides(boolean top, boolean left, boolean bottom, boolean right) {
        if (this.paintTop != top || this.paintLeft != left || this.paintBottom != bottom || this.paintRight != right) {
            this.paintTop = top;
            this.paintLeft = left;
            this.paintBottom = bottom;
            this.paintRight = right;
            this.updateAll();
        }
    }

    public boolean isPaintTopLine() {
        return this.paintTopLine;
    }

    @Override
    public void setPaintTopLine(boolean top) {
        if (this.paintTopLine != top) {
            this.paintTopLine = top;
            this.updateAll();
        }
    }

    public boolean isPaintLeftLine() {
        return this.paintLeftLine;
    }

    @Override
    public void setPaintLeftLine(boolean left) {
        if (this.paintLeftLine != left) {
            this.paintLeftLine = left;
            this.updateAll();
        }
    }

    public boolean isPaintBottomLine() {
        return this.paintBottomLine;
    }

    @Override
    public void setPaintBottomLine(boolean bottom) {
        if (this.paintBottomLine != bottom) {
            this.paintBottomLine = bottom;
            this.updateAll();
        }
    }

    public boolean isPaintRightLine() {
        return this.paintRightLine;
    }

    @Override
    public void setPaintRightLine(boolean right) {
        if (this.paintRightLine != right) {
            this.paintRightLine = right;
            this.updateAll();
        }
    }

    @Override
    public void setPaintSideLines(boolean top, boolean left, boolean bottom, boolean right) {
        if (this.paintTopLine != top || this.paintLeftLine != left || this.paintBottomLine != bottom || this.paintRightLine != right) {
            this.paintTopLine = top;
            this.paintLeftLine = left;
            this.paintBottomLine = bottom;
            this.paintRightLine = right;
            this.updateAll();
        }
    }

    @Override
    public Boolean isOpaque(E c) {
        return this.undecorated;
    }

    @Override
    public Insets getMargin(E scrollbar) {
        int bottom;
        int left;
        int top;
        if (this.undecorated) {
            return null;
        }
        int spacing = this.shadeWidth + 1;
        int n = this.paintTop ? spacing : (top = this.paintTopLine ? 1 : 0);
        int n2 = this.paintLeft ? spacing : (left = this.paintLeftLine ? 1 : 0);
        int n3 = this.paintBottom ? spacing : (bottom = this.paintBottomLine ? 1 : 0);
        int right = this.paintRight ? spacing : (this.paintRightLine ? 1 : 0);
        return new Insets(top, left, bottom, right);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        if (!this.undecorated) {
            boolean anyBorder;
            this.ltr = ((Component)c).getComponentOrientation().isLeftToRight();
            this.actualPaintLeft = this.ltr ? this.paintLeft : this.paintRight;
            this.actualPaintRight = this.ltr ? this.paintRight : this.paintLeft;
            this.w = ((JComponent)c).getWidth();
            this.h = ((JComponent)c).getHeight();
            boolean bl = anyBorder = this.paintTop || this.paintRight || this.paintBottom || this.paintLeft;
            if (anyBorder || this.paintBackground) {
                Object aa = LafUtils.setupAntialias(g2d);
                boolean enabled = ((Component)c).isEnabled();
                Shape borderShape = this.getShape(c, false);
                Shape backgroundShape = this.getShape(c, true);
                if (anyBorder && this.shadeWidth > 0) {
                    this.paintShade(g2d, bounds, c, borderShape);
                }
                if (this.paintBackground) {
                    this.paintBackground(g2d, bounds, c, backgroundShape);
                }
                if (anyBorder && (enabled ? this.borderColor != null : this.disabledBorderColor != null)) {
                    this.paintBorder(g2d, bounds, c, borderShape);
                }
                LafUtils.restoreAntialias(g2d, aa);
            }
        }
    }

    protected void paintShade(Graphics2D g2d, Rectangle bounds, E c, Shape borderShape) {
        if (this.shadeWidth < 4) {
            Composite oc = LafUtils.setupAlphaComposite(g2d, Float.valueOf(this.shadeTransparency), this.shadeTransparency < 1.0f);
            Color shadeColor = this.paintFocus && this.focused ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor;
            LafUtils.drawShade(g2d, borderShape, shadeColor, this.shadeWidth);
            LafUtils.restoreComposite(g2d, oc, this.shadeTransparency < 1.0f);
        } else {
            NinePatchIcon shade = NinePatchUtils.getShadeIcon(this.shadeWidth, this.round, this.shadeTransparency);
            int x = this.actualPaintLeft ? 0 : -this.shadeWidth * 2;
            int width = this.w + (this.actualPaintLeft ? 0 : this.shadeWidth * 2) + (this.actualPaintRight ? 0 : this.shadeWidth * 2);
            int y = this.paintTop ? 0 : -this.shadeWidth * 2;
            int height = this.h + (this.paintTop ? 0 : this.shadeWidth * 2) + (this.paintBottom ? 0 : this.shadeWidth * 2);
            shade.paintIcon(g2d, x, y, width, height);
        }
    }

    protected void paintBackground(Graphics2D g2d, Rectangle bounds, E c, Shape backgroundShape) {
        if (this.webColoredBackground) {
            Rectangle bgBounds = backgroundShape.getBounds();
            g2d.setPaint(LafUtils.getWebGradientPaint(0, bgBounds.y, 0, bgBounds.y + bgBounds.height));
        } else {
            g2d.setPaint(((Component)c).getBackground());
        }
        g2d.fill(backgroundShape);
    }

    protected void paintBorder(Graphics2D g2d, Rectangle bounds, E c, Shape borderShape) {
        int y;
        int x;
        Stroke os = LafUtils.setupStroke(g2d, this.borderStroke, this.borderStroke != null);
        g2d.setPaint(((Component)c).isEnabled() ? this.borderColor : this.disabledBorderColor);
        g2d.draw(borderShape);
        if (this.paintTopLine) {
            x = this.actualPaintLeft ? this.shadeWidth : 0;
            g2d.drawLine(x, 0, x + ((JComponent)c).getWidth() - (this.actualPaintLeft ? this.shadeWidth : 0) - (this.actualPaintRight ? this.shadeWidth + 1 : 0), 0);
        }
        if (this.paintBottomLine) {
            x = this.actualPaintLeft ? this.shadeWidth : 0;
            g2d.drawLine(x, ((JComponent)c).getHeight() - 1, x + ((JComponent)c).getWidth() - (this.actualPaintLeft ? this.shadeWidth : 0) - (this.actualPaintRight ? this.shadeWidth + 1 : 0), ((JComponent)c).getHeight() - 1);
        }
        if (this.paintLeftLine) {
            y = this.paintTop ? this.shadeWidth : 0;
            g2d.drawLine(0, y, 0, y + ((JComponent)c).getHeight() - (this.paintTop ? this.shadeWidth : 0) - (this.paintBottom ? this.shadeWidth + 1 : 0));
        }
        if (this.paintRightLine) {
            y = this.paintTop ? this.shadeWidth : 0;
            g2d.drawLine(((JComponent)c).getWidth() - 1, y, ((JComponent)c).getWidth() - 1, y + ((JComponent)c).getHeight() - (this.paintTop ? this.shadeWidth : 0) - (this.paintBottom ? this.shadeWidth + 1 : 0));
        }
        LafUtils.restoreStroke(g2d, os, this.borderStroke != null);
    }

    protected Shape getShape(final E c, final boolean background) {
        return ShapeCache.getShape(c, background ? BACKGROUND_SHAPE : BORDER_SHAPE, new DataProvider<Shape>(){

            @Override
            public Shape provide() {
                return WebDecorationPainter.this.createShape(c, background);
            }
        }, this.getCachedShapeSettings(c));
    }

    protected Object[] getCachedShapeSettings(E c) {
        return new Object[]{this.w, this.h, this.ltr, this.round, this.shadeWidth, this.paintTop, this.paintLeft, this.paintBottom, this.paintRight, this.paintTopLine, this.paintLeftLine, this.paintBottomLine, this.paintRightLine};
    }

    protected Shape createShape(E c, boolean background) {
        if (background) {
            Point[] corners = new Point[4];
            boolean[] rounded = new boolean[4];
            corners[0] = this.p(this.actualPaintLeft ? this.shadeWidth : 0, this.paintTop ? this.shadeWidth : 0);
            rounded[0] = this.actualPaintLeft && this.paintTop;
            corners[1] = this.p(this.actualPaintRight ? this.w - this.shadeWidth : this.w, this.paintTop ? this.shadeWidth : 0);
            rounded[1] = this.actualPaintRight && this.paintTop;
            corners[2] = this.p(this.actualPaintRight ? this.w - this.shadeWidth : this.w, this.paintBottom ? this.h - this.shadeWidth : this.h);
            rounded[2] = this.actualPaintRight && this.paintBottom;
            corners[3] = this.p(this.actualPaintLeft ? this.shadeWidth : 0, this.paintBottom ? this.h - this.shadeWidth : this.h);
            rounded[3] = this.actualPaintLeft && this.paintBottom;
            return LafUtils.createRoundedShape(this.round > 0 ? this.round + 1 : 0, corners, rounded);
        }
        GeneralPath shape = new GeneralPath(0);
        boolean connect = false;
        boolean moved = false;
        if (this.paintTop) {
            shape.moveTo(this.actualPaintLeft ? (float)(this.shadeWidth + this.round) : 0.0f, this.shadeWidth);
            if (this.actualPaintRight) {
                shape.lineTo(this.w - this.shadeWidth - this.round - 1, this.shadeWidth);
                shape.quadTo(this.w - this.shadeWidth - 1, this.shadeWidth, this.w - this.shadeWidth - 1, this.shadeWidth + this.round);
            } else {
                shape.lineTo(this.w - 1, this.shadeWidth);
            }
            connect = true;
        }
        if (this.actualPaintRight) {
            if (!connect) {
                shape.moveTo(this.w - this.shadeWidth - 1, this.paintTop ? (float)(this.shadeWidth + this.round) : 0.0f);
                moved = true;
            }
            if (this.paintBottom) {
                shape.lineTo(this.w - this.shadeWidth - 1, this.h - this.shadeWidth - this.round - 1);
                shape.quadTo(this.w - this.shadeWidth - 1, this.h - this.shadeWidth - 1, this.w - this.shadeWidth - this.round - 1, this.h - this.shadeWidth - 1);
            } else {
                shape.lineTo(this.w - this.shadeWidth - 1, this.h - 1);
            }
            connect = true;
        } else {
            connect = false;
        }
        if (this.paintBottom) {
            if (!connect) {
                shape.moveTo(this.actualPaintRight ? (float)(this.w - this.shadeWidth - this.round - 1) : (float)(this.w - 1), this.h - this.shadeWidth - 1);
                moved = true;
            }
            if (this.actualPaintLeft) {
                shape.lineTo(this.shadeWidth + this.round, this.h - this.shadeWidth - 1);
                shape.quadTo(this.shadeWidth, this.h - this.shadeWidth - 1, this.shadeWidth, this.h - this.shadeWidth - this.round - 1);
            } else {
                shape.lineTo(0.0f, this.h - this.shadeWidth - 1);
            }
            connect = true;
        } else {
            connect = false;
        }
        if (this.actualPaintLeft) {
            if (!connect) {
                shape.moveTo(this.shadeWidth, this.paintBottom ? (float)(this.h - this.shadeWidth - this.round - 1) : (float)(this.h - 1));
                moved = true;
            }
            if (this.paintTop) {
                shape.lineTo(this.shadeWidth, this.shadeWidth + this.round);
                shape.quadTo(this.shadeWidth, this.shadeWidth, this.shadeWidth + this.round, this.shadeWidth);
                if (!moved) {
                    shape.closePath();
                }
            } else {
                shape.lineTo(this.shadeWidth, 0.0f);
            }
        }
        return shape;
    }
}

