/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.managers.style.StyleException;
import com.alee.managers.style.SupportedComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.PainterStyle;
import com.alee.managers.style.data.SkinInfo;
import com.alee.utils.MapUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.xml.ResourceFile;
import com.alee.utils.xml.ResourceLocation;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SkinInfoConverter
extends ReflectionConverter {
    public static final String ID_NODE = "id";
    public static final String NAME_NODE = "name";
    public static final String DESCRIPTION_NODE = "description";
    public static final String AUTHOR_NODE = "author";
    public static final String SUPPORTED_SYSTEMS_NODE = "supportedSystems";
    public static final String CLASS_NODE = "class";
    public static final String INCLUDE_NODE = "include";
    public static final String STYLE_NODE = "style";
    public static final String NEAR_CLASS_ATTRIBUTE = "nearClass";
    private static final Map<String, Map<String, String>> resourceMap = new HashMap<String, Map<String, String>>();

    public SkinInfoConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(SkinInfo.class);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        SkinInfo skinInfo = new SkinInfo();
        ArrayList<ComponentStyle> styles = new ArrayList<ComponentStyle>();
        ArrayList<ResourceFile> includes = new ArrayList<ResourceFile>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals(ID_NODE)) {
                skinInfo.setId(reader.getValue());
            } else if (nodeName.equals(NAME_NODE)) {
                skinInfo.setName(reader.getValue());
            } else if (nodeName.equals(DESCRIPTION_NODE)) {
                skinInfo.setDescription(reader.getValue());
            } else if (nodeName.equals(AUTHOR_NODE)) {
                skinInfo.setAuthor(reader.getValue());
            } else if (nodeName.equals(SUPPORTED_SYSTEMS_NODE)) {
                skinInfo.setSupportedSystems(reader.getValue());
            } else if (nodeName.equals(CLASS_NODE)) {
                skinInfo.setSkinClass(reader.getValue());
            } else if (nodeName.equals(CLASS_NODE)) {
                skinInfo.setSkinClass(reader.getValue());
            } else if (nodeName.equals(STYLE_NODE)) {
                styles.add((ComponentStyle)context.convertAnother(styles, ComponentStyle.class));
            } else if (nodeName.equals(INCLUDE_NODE)) {
                String nearClass = reader.getAttribute(NEAR_CLASS_ATTRIBUTE);
                String string = reader.getValue();
                includes.add(new ResourceFile(ResourceLocation.nearClass, string, nearClass));
            }
            reader.moveUp();
        }
        for (int i = 0; i < includes.size(); ++i) {
            SkinInfo skinInfo2;
            ResourceFile resourceFile = (ResourceFile)includes.get(i);
            if (resourceFile.getClassName() == null) {
                String string = skinInfo.getSkinClass();
                if (string == null) {
                    throw new StyleException("Included skin file \"" + resourceFile.getSource() + "\" specified but skin \"class\" property is not set!");
                }
                resourceFile.setClassName(string);
            }
            if ((skinInfo2 = this.loadSkinInfo(resourceFile)) == null) {
                throw new StyleException("Included skin file \"" + resourceFile.getSource() + "\" cannot be read!");
            }
            styles.addAll(i, skinInfo2.getStyles());
        }
        skinInfo.setStyles(styles);
        HashMap<SupportedComponent, Map<String, ComponentStyle>> stylesCache = new HashMap<SupportedComponent, Map<String, ComponentStyle>>(SupportedComponent.values().length);
        for (ComponentStyle componentStyle : styles) {
            SupportedComponent type = componentStyle.getType();
            HashMap<String, ComponentStyle> componentStyles = (HashMap<String, ComponentStyle>)stylesCache.get((Object)type);
            if (componentStyles == null) {
                componentStyles = new HashMap<String, ComponentStyle>(1);
                stylesCache.put(type, componentStyles);
            }
            componentStyles.put(componentStyle.getId(), componentStyle);
        }
        skinInfo.setStylesCache(stylesCache);
        for (Map.Entry entry : stylesCache.entrySet()) {
            ArrayList<String> compiledStyles = new ArrayList<String>();
            Map stylesById = (Map)entry.getValue();
            for (Map.Entry style : stylesById.entrySet()) {
                this.compileStyle((String)style.getKey(), (ComponentStyle)style.getValue(), stylesById, compiledStyles);
            }
        }
        return skinInfo;
    }

    protected SkinInfo loadSkinInfo(ResourceFile resourceFile) {
        try {
            Map<String, String> nearClassMap = resourceMap.get(resourceFile.getClassName());
            if (nearClassMap != null) {
                String xml = nearClassMap.get(resourceFile.getSource());
                if (xml != null) {
                    return (SkinInfo)XmlUtils.fromXML(xml);
                }
                return (SkinInfo)XmlUtils.fromXML(resourceFile);
            }
            return (SkinInfo)XmlUtils.fromXML(resourceFile);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private void compileStyle(String id, ComponentStyle style, Map<String, ComponentStyle> styles, List<String> compiledStyles) {
        String extendsId = style.getExtendsId();
        if (extendsId == null) {
            return;
        }
        if (compiledStyles.contains(id)) {
            return;
        }
        if (extendsId.equals(id)) {
            throw new StyleException("Component style \"" + (Object)((Object)style.getType()) + ":" + id + "\" extends itself!");
        }
        ComponentStyle extendedStyle = styles.get(extendsId);
        if (extendedStyle == null) {
            throw new StyleException("Component style \"" + (Object)((Object)style.getType()) + ":" + id + "\" extends missing style \"" + extendsId + "\"!");
        }
        compiledStyles.add(id);
        this.compileStyle(extendedStyle.getId(), extendedStyle, styles, compiledStyles);
        this.copyProperties(style.getComponentProperties(), extendedStyle.getComponentProperties());
        this.copyProperties(style.getUIProperties(), extendedStyle.getUIProperties());
        this.copyPainters(style, extendedStyle);
    }

    private void copyProperties(Map<String, Object> properties, Map<String, Object> extendedProperties) {
        for (Map.Entry<String, Object> property : extendedProperties.entrySet()) {
            String key = property.getKey();
            if (properties.containsKey(key)) continue;
            properties.put(key, property.getValue());
        }
    }

    private void copyPainters(ComponentStyle style, ComponentStyle extendedStyle) {
        Map<String, PainterStyle> paintersMap = this.collectPainters(style, style.getPainters());
        Map<String, PainterStyle> extendedPaintersMap = this.collectPainters(extendedStyle, extendedStyle.getPainters());
        for (Map.Entry<String, PainterStyle> entry : extendedPaintersMap.entrySet()) {
            PainterStyle painterStyle;
            String painterId = entry.getKey();
            PainterStyle extendedPainterStyle = entry.getValue();
            if (paintersMap.containsKey(painterId)) {
                painterStyle = paintersMap.get(painterId);
                Class painterClass = ReflectUtils.getClassSafely(painterStyle.getPainterClass());
                Class extendedPainterClass = ReflectUtils.getClassSafely(extendedPainterStyle.getPainterClass());
                if (painterClass == null || extendedPainterClass == null) {
                    String pc = painterClass == null ? painterStyle.getPainterClass() : extendedPainterStyle.getPainterClass();
                    String sid = (Object)((Object)style.getType()) + ":" + style.getId();
                    throw new StyleException("Component style \"" + sid + "\" points to missing painter class: \"" + pc + "\"!");
                }
                if (!ReflectUtils.isAssignable(extendedPainterClass, painterClass)) continue;
                this.copyProperties(painterStyle.getProperties(), extendedPainterStyle.getProperties());
                continue;
            }
            painterStyle = new PainterStyle();
            painterStyle.setId(extendedPainterStyle.getId());
            painterStyle.setPainterClass(extendedPainterStyle.getPainterClass());
            painterStyle.setProperties(MapUtils.copyMap(extendedPainterStyle.getProperties()));
            paintersMap.put(painterId, painterStyle);
        }
        if (paintersMap.size() > 0) {
            boolean hasBase = false;
            for (Map.Entry<String, PainterStyle> entry : paintersMap.entrySet()) {
                PainterStyle painterStyle = entry.getValue();
                if (!painterStyle.isBase()) continue;
                hasBase = true;
                break;
            }
            if (!hasBase) {
                PainterStyle painterStyle = paintersMap.get("painter");
                if (painterStyle == null) {
                    painterStyle = paintersMap.entrySet().iterator().next().getValue();
                }
                painterStyle.setBase(true);
            }
        }
        List<PainterStyle> painters = style.getPainters();
        painters.clear();
        painters.addAll(paintersMap.values());
    }

    private Map<String, PainterStyle> collectPainters(ComponentStyle style, List<PainterStyle> painters) {
        HashMap<String, PainterStyle> paintersMap = new HashMap<String, PainterStyle>(painters.size());
        for (PainterStyle painter : painters) {
            String painterId = painter.getId();
            if (paintersMap.containsKey(painterId)) {
                String sid = (Object)((Object)style.getType()) + ":" + style.getId();
                throw new StyleException("Component style \"" + sid + "\" has duplicate painters for id \"" + painterId + "\"!");
            }
            paintersMap.put(painterId, painter);
        }
        return paintersMap;
    }

    public static void addCustomResource(String nearClass, String src, String xml) {
        Map<String, String> nearClassMap = resourceMap.get(nearClass);
        if (nearClassMap == null) {
            nearClassMap = new HashMap<String, String>();
            resourceMap.put(nearClass, nearClassMap);
        }
        nearClassMap.put(src, xml);
    }
}

