/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.managers.settings.SettingsGroup;
import com.alee.managers.settings.SettingsManager;
import com.alee.utils.xml.XMLChar;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashMap;
import java.util.Map;

public class SettingsConverter
extends ReflectionConverter {
    private static final String ERROR_PREFIX = "[SettingsConverter] ";
    private static final String NULL_TYPE = "null";

    public SettingsConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(SettingsGroup.class);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SettingsGroup settingsGroup = (SettingsGroup)source;
        writer.addAttribute("id", settingsGroup.getId());
        writer.addAttribute("name", settingsGroup.getName());
        for (Map.Entry<String, Object> entry : settingsGroup.getSettings().entrySet()) {
            String nodeName;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (XMLChar.isValidName(key)) {
                nodeName = key;
                writer.startNode(nodeName);
            } else {
                nodeName = "entry";
                writer.startNode(nodeName);
                writer.addAttribute("key", key);
            }
            if (value == null) {
                writer.addAttribute("type", NULL_TYPE);
            } else {
                String serializedType = this.mapper.serializedClass(value.getClass());
                if (!nodeName.equals(serializedType)) {
                    writer.addAttribute("type", serializedType);
                }
                context.convertAnother(value);
            }
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        SettingsGroup settingsGroup = new SettingsGroup(reader.getAttribute("id"), reader.getAttribute("name"));
        HashMap<String, Object> settings = new HashMap<String, Object>();
        while (reader.hasMoreChildren()) {
            block7: {
                reader.moveDown();
                String nodeName = reader.getNodeName();
                if (nodeName.equals("entry") && reader.getAttributeCount() == 0) {
                    reader.moveDown();
                    String key = reader.getValue();
                    reader.moveUp();
                    reader.moveDown();
                    Class type = this.mapper.realClass(reader.getNodeName());
                    Object value = context.convertAnother(settings, type);
                    settings.put(key, value);
                    reader.moveUp();
                } else {
                    String keyAttribue = reader.getAttribute("key");
                    String key = keyAttribue != null ? keyAttribue : nodeName;
                    try {
                        String actualType;
                        String typeAttribute = reader.getAttribute("type");
                        String string = actualType = typeAttribute != null ? typeAttribute : nodeName;
                        if (actualType.equals(NULL_TYPE)) {
                            settings.put(key, null);
                        } else {
                            Class type = this.mapper.realClass(actualType);
                            settings.put(key, context.convertAnother(settings, type));
                        }
                    }
                    catch (Throwable e) {
                        if (!SettingsManager.isDisplayExceptions()) break block7;
                        System.err.println("[SettingsConverter] Unable to load settings entry for group \"" + settingsGroup.getName() + "\" under key \"" + key + "\" due to unexpected exception:");
                        e.printStackTrace();
                    }
                }
            }
            reader.moveUp();
        }
        settingsGroup.setSettings(settings);
        return settingsGroup;
    }
}

