/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.notification;

import com.alee.extended.layout.NotificationsLayout;
import com.alee.laf.label.WebLabel;
import com.alee.managers.notification.DisplayType;
import com.alee.managers.notification.NotificationIcon;
import com.alee.managers.notification.NotificationOption;
import com.alee.managers.notification.WebNotificationPopup;
import com.alee.managers.popup.PopupAdapter;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.PopupManager;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public final class NotificationManager
implements SwingConstants {
    private static int location = 4;
    private static DisplayType displayType = DisplayType.stack;
    private static Insets margin = new Insets(0, 0, 0, 0);
    private static int gap = 10;
    private static boolean cascade = true;
    private static int cascadeAmount = 4;
    private static final Map<PopupLayer, NotificationsLayout> notificationsLayouts = new WeakHashMap<PopupLayer, NotificationsLayout>();
    private static final Map<WebNotificationPopup, PopupLayer> notifications = new WeakHashMap<WebNotificationPopup, PopupLayer>();

    public static int getLocation() {
        return location;
    }

    public static void setLocation(int location) {
        NotificationManager.location = location;
        NotificationManager.updateNotificationLayouts();
    }

    public static DisplayType getDisplayType() {
        return displayType;
    }

    public static void setDisplayType(DisplayType displayType) {
        NotificationManager.displayType = displayType;
        NotificationManager.updateNotificationLayouts();
    }

    public static Insets getMargin() {
        return margin;
    }

    public static void setMargin(int margin) {
        NotificationManager.setMargin(margin, margin, margin, margin);
    }

    public static void setMargin(int top, int left, int bottom, int right) {
        NotificationManager.setMargin(new Insets(top, left, bottom, right));
    }

    public static void setMargin(Insets margin) {
        NotificationManager.margin = margin;
        NotificationManager.updateNotificationLayouts();
    }

    public static int getGap() {
        return gap;
    }

    public static void setGap(int gap) {
        NotificationManager.gap = gap;
        NotificationManager.updateNotificationLayouts();
    }

    public static boolean isCascade() {
        return cascade;
    }

    public static void setCascade(boolean cascade) {
        NotificationManager.cascade = cascade;
        NotificationManager.updateNotificationLayouts();
    }

    public static int getCascadeAmount() {
        return cascadeAmount;
    }

    public static void setCascadeAmount(int cascadeAmount) {
        NotificationManager.cascadeAmount = cascadeAmount;
        if (cascade) {
            NotificationManager.updateNotificationLayouts();
        }
    }

    public static void updateNotificationLayouts() {
        ArrayList<PopupLayer> layers = new ArrayList<PopupLayer>();
        for (Map.Entry<WebNotificationPopup, PopupLayer> entry : notifications.entrySet()) {
            PopupLayer popupLayer = entry.getValue();
            if (layers.contains(popupLayer)) continue;
            layers.add(popupLayer);
            popupLayer.revalidate();
        }
    }

    public static void hideAllNotifications() {
        for (Map.Entry<WebNotificationPopup, PopupLayer> entry : notifications.entrySet()) {
            entry.getKey().hidePopup();
        }
    }

    public static WebNotificationPopup showNotification(String content) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), (Component)new WebLabel(content), (Icon)NotificationIcon.information.getIcon());
    }

    public static WebNotificationPopup showNotification(String content, Icon icon) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), (Component)new WebLabel(content), icon);
    }

    public static WebNotificationPopup showNotification(Component showFor, String content) {
        return NotificationManager.showNotification(showFor, (Component)new WebLabel(content), (Icon)NotificationIcon.information.getIcon());
    }

    public static WebNotificationPopup showNotification(Component showFor, String content, Icon icon) {
        return NotificationManager.showNotification(showFor, (Component)new WebLabel(content), icon);
    }

    public static WebNotificationPopup showNotification(Component content) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), content, (Icon)NotificationIcon.information.getIcon());
    }

    public static WebNotificationPopup showNotification(Component content, Icon icon) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), content, icon);
    }

    public static WebNotificationPopup showNotification(Component showFor, Component content) {
        return NotificationManager.showNotification(showFor, content, (Icon)NotificationIcon.information.getIcon());
    }

    public static WebNotificationPopup showNotification(Component showFor, Component content, Icon icon) {
        WebNotificationPopup notificationPopup = new WebNotificationPopup();
        notificationPopup.setIcon(icon);
        notificationPopup.setContent(content);
        return NotificationManager.showNotification(showFor, notificationPopup);
    }

    public static WebNotificationPopup showNotification(String content, NotificationOption ... options) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), (Component)new WebLabel(content), (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebNotificationPopup showNotification(String content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), (Component)new WebLabel(content), icon, options);
    }

    public static WebNotificationPopup showNotification(Component showFor, String content, NotificationOption ... options) {
        return NotificationManager.showNotification(showFor, (Component)new WebLabel(content), (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebNotificationPopup showNotification(Component showFor, String content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showNotification(showFor, (Component)new WebLabel(content), icon, options);
    }

    public static WebNotificationPopup showNotification(Component content, NotificationOption ... options) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), content, (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebNotificationPopup showNotification(Component content, Icon icon, NotificationOption ... options) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), content, icon, options);
    }

    public static WebNotificationPopup showNotification(Component showFor, Component content, NotificationOption ... options) {
        return NotificationManager.showNotification(showFor, content, (Icon)NotificationIcon.information.getIcon(), options);
    }

    public static WebNotificationPopup showNotification(Component showFor, Component content, Icon icon, NotificationOption ... options) {
        WebNotificationPopup notificationPopup = new WebNotificationPopup();
        notificationPopup.setIcon(icon);
        notificationPopup.setContent(content);
        notificationPopup.setOptions(options);
        return NotificationManager.showNotification(showFor, notificationPopup);
    }

    public static WebNotificationPopup showNotification(WebNotificationPopup notification) {
        return NotificationManager.showNotification((Component)NotificationManager.getDefaulShowForWindow(), notification);
    }

    public static WebNotificationPopup showNotification(Component showFor, final WebNotificationPopup notification) {
        PopupLayer popupLayer = PopupManager.getPopupLayer(showFor);
        if (!notificationsLayouts.containsKey(popupLayer)) {
            NotificationsLayout layout = new NotificationsLayout();
            popupLayer.addLayoutManager(layout);
            notificationsLayouts.put(popupLayer, layout);
        }
        notifications.put(notification, popupLayer);
        notification.addPopupListener(new PopupAdapter(){

            @Override
            public void popupWillBeClosed() {
                notifications.remove(notification);
            }
        });
        notification.showPopup(showFor);
        return notification;
    }

    private static Window getDefaulShowForWindow() {
        Window activeWindow = SwingUtils.getActiveWindow();
        if (activeWindow != null) {
            return activeWindow;
        }
        Window[] allWindows = Window.getWindows();
        if (allWindows != null && allWindows.length > 0) {
            return allWindows[0];
        }
        throw new RuntimeException("There is no visible windows to display notification");
    }
}

