/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.hotkey;

import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.TextUtils;
import java.awt.Component;
import java.lang.ref.WeakReference;

public class HotkeyInfo {
    public static final String ID_PREFIX = "HI";
    private String id = null;
    private boolean hidden = false;
    private WeakReference<Component> topComponent = null;
    private WeakReference<Component> forComponent = null;
    private HotkeyData hotkeyData = null;
    private TooltipWay hotkeyDisplayWay = null;
    private HotkeyRunnable action = null;

    public String getId() {
        if (this.id == null) {
            this.setId();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setId() {
        this.id = TextUtils.generateId(ID_PREFIX);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public HotkeyInfo setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Component getTopComponent() {
        return this.topComponent != null ? (Component)this.topComponent.get() : null;
    }

    public HotkeyInfo setTopComponent(Component topComponent) {
        this.topComponent = new WeakReference<Component>(topComponent);
        return this;
    }

    public Component getForComponent() {
        return this.forComponent != null ? (Component)this.forComponent.get() : null;
    }

    public HotkeyInfo setForComponent(Component forComponent) {
        this.forComponent = new WeakReference<Component>(forComponent);
        return this;
    }

    public HotkeyData getHotkeyData() {
        return this.hotkeyData;
    }

    public HotkeyInfo setHotkeyData(HotkeyData hotkeyData) {
        this.hotkeyData = hotkeyData;
        return this;
    }

    public TooltipWay getHotkeyDisplayWay() {
        return this.hotkeyDisplayWay;
    }

    public HotkeyInfo setHotkeyDisplayWay(TooltipWay hotkeyDisplayWay) {
        this.hotkeyDisplayWay = hotkeyDisplayWay;
        return this;
    }

    public HotkeyRunnable getAction() {
        return this.action;
    }

    public HotkeyInfo setAction(HotkeyRunnable action) {
        this.action = action;
        return this;
    }
}

