/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class WebTreeModel<E extends MutableTreeNode>
extends DefaultTreeModel {
    public WebTreeModel(E root) {
        super((TreeNode)root);
    }

    public WebTreeModel(E root, boolean asksAllowsChildren) {
        super((TreeNode)root, asksAllowsChildren);
    }

    public void insertNodesInto(List<E> children, E parent, int index) {
        for (int i = children.size() - 1; i >= 0; --i) {
            parent.insert((MutableTreeNode)children.get(i), index);
        }
        int[] indices = new int[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            indices[i] = index + i;
        }
        this.nodesWereInserted((TreeNode)parent, indices);
    }

    public void insertNodesInto(E[] children, E parent, int index) {
        for (int i = children.length - 1; i >= 0; --i) {
            parent.insert((MutableTreeNode)children[i], index);
        }
        int[] indices = new int[children.length];
        for (int i = 0; i < children.length; ++i) {
            indices[i] = index + i;
        }
        this.nodesWereInserted((TreeNode)parent, indices);
    }

    public void removeNodesFromParent(List<E> nodes) {
        for (MutableTreeNode node : nodes) {
            this.removeNodeFromParent(node);
        }
    }

    public void removeNodesFromParent(E node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.removeNodeFromParent((MutableTreeNode)node.getChildAt(i));
        }
    }

    public void removeNodesFromParent(E[] nodes) {
        for (E node : nodes) {
            this.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    public void updateNode(E node) {
        if (node != null) {
            this.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)node), null, null);
        }
    }
}

