/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.separator.WebSeparator;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBarUI;
import com.alee.laf.toolbar.WhiteSpace;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.ReflectUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Shape;
import java.util.List;
import javax.swing.JToolBar;

public class WebToolBar
extends JToolBar
implements ShapeProvider,
LanguageContainerMethods {
    public WebToolBar() {
    }

    public WebToolBar(String name) {
        super(name);
    }

    public WebToolBar(String name, int orientation) {
        super(name, orientation);
    }

    public WebToolBar(int orientation) {
        super(orientation);
    }

    public void addToMiddle(Component component) {
        this.add(component, (Object)"MIDDLE");
    }

    public void addFill(Component component) {
        this.add(component, (Object)"FILL");
    }

    public void addToEnd(Component component) {
        this.add(component, (Object)"END");
    }

    @Override
    public void addSeparator() {
        this.addSeparator("START");
    }

    public WebSeparator addSeparatorToEnd() {
        return this.addSeparator("END");
    }

    public WebSeparator addSeparator(String constrain) {
        WebSeparator separator = new WebSeparator(this.getOrientation() == 0 ? 1 : 0);
        this.add((Component)separator, (Object)constrain);
        return separator;
    }

    public WebSeparator addSeparator(int spacing) {
        return this.addSeparator("START", spacing);
    }

    public WebSeparator addSeparatorToEnd(int spacing) {
        return this.addSeparator("END", spacing);
    }

    public WebSeparator addSeparator(String constrain, int spacing) {
        boolean hor = this.getOrientation() == 0;
        WebSeparator separator = new WebSeparator(hor ? 1 : 0);
        this.add((Component)separator.setMargin(hor ? 0 : spacing, hor ? spacing : 0, hor ? 0 : spacing, hor ? spacing : 0), (Object)constrain);
        return separator;
    }

    public void addSpacing() {
        this.addSpacing(StyleConstants.contentSpacing);
    }

    public void addSpacing(int spacing) {
        this.addSpacing(spacing, "START");
    }

    public void addSpacingToEnd() {
        this.addSpacingToEnd(StyleConstants.contentSpacing);
    }

    public void addSpacingToEnd(int spacing) {
        this.addSpacing(spacing, "END");
    }

    public void addSpacing(int spacing, String constrain) {
        this.add((Component)new WhiteSpace(spacing), (Object)constrain);
    }

    public void add(List<? extends Component> components, int index) {
        if (components != null) {
            for (int i = 0; i < components.size(); ++i) {
                this.add(components.get(i), index + i);
            }
        }
    }

    public void add(List<? extends Component> components, String constraints) {
        if (components != null) {
            for (Component component : components) {
                this.add(component, (Object)constraints);
            }
        }
    }

    public void add(List<? extends Component> components) {
        if (components != null) {
            for (Component component : components) {
                this.add(component);
            }
        }
    }

    public void add(int index, Component ... components) {
        if (components != null && components.length > 0) {
            for (int i = 0; i < components.length; ++i) {
                this.add(components[i], index + i);
            }
        }
    }

    public void add(String constraints, Component ... components) {
        if (components != null && components.length > 0) {
            for (Component component : components) {
                this.add(component, (Object)constraints);
            }
        }
    }

    public void add(Component ... components) {
        if (components != null && components.length > 0) {
            for (Component component : components) {
                this.add(component);
            }
        }
    }

    public Component getFirstComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    public Component getLastComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(this.getComponentCount() - 1);
        }
        return null;
    }

    public boolean isUndecorated() {
        return this.getWebUI().isUndecorated();
    }

    public void setUndecorated(boolean undecorated) {
        this.getWebUI().setUndecorated(undecorated);
    }

    public Painter getPainter() {
        return this.getWebUI().getPainter();
    }

    public void setPainter(Painter painter) {
        this.getWebUI().setPainter(painter);
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public void setRound(int round) {
        this.getWebUI().setRound(round);
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public void setShadeWidth(int shadeWidth) {
        this.getWebUI().setShadeWidth(shadeWidth);
    }

    @Override
    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    @Override
    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int spacing) {
        this.setMargin(spacing, spacing, spacing, spacing);
    }

    public ToolbarStyle getToolbarStyle() {
        return this.getWebUI().getToolbarStyle();
    }

    public void setToolbarStyle(ToolbarStyle toolbarStyle) {
        this.getWebUI().setToolbarStyle(toolbarStyle);
    }

    public int getSpacing() {
        return this.getWebUI().getSpacing();
    }

    public void setSpacing(int spacing) {
        this.getWebUI().setSpacing(spacing);
    }

    public Color getTopBgColor() {
        return this.getWebUI().getTopBgColor();
    }

    public void setTopBgColor(Color topBgColor) {
        this.getWebUI().setTopBgColor(topBgColor);
    }

    public Color getBottomBgColor() {
        return this.getWebUI().getBottomBgColor();
    }

    public void setBottomBgColor(Color bottomBgColor) {
        this.getWebUI().setBottomBgColor(bottomBgColor);
    }

    public Color getBorderColor() {
        return this.getWebUI().getBorderColor();
    }

    public void setBorderColor(Color lowerBorderColor) {
        this.getWebUI().setBorderColor(lowerBorderColor);
    }

    public ToolbarLayout getToolbarLayout() {
        return (ToolbarLayout)this.getLayout();
    }

    public boolean isFloating() {
        return this.getWebUI().isFloating();
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebToolBarUI getWebUI() {
        return (WebToolBarUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebToolBarUI)) {
            try {
                this.setUI((WebToolBarUI)ReflectUtils.createInstance(WebLookAndFeel.toolBarUI, new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebToolBarUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer(this, key);
    }

    @Override
    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer(this);
    }

    @Override
    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey(this);
    }
}

