/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.laf.StyleConstants;
import com.alee.laf.text.TextComponentLayout;
import com.alee.laf.text.WebTextFieldStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class WebTextFieldUI
extends BasicTextFieldUI
implements ShapeProvider,
SwingConstants,
BorderMethods {
    private JTextField textField = null;
    private boolean drawBorder = WebTextFieldStyle.drawBorder;
    private boolean drawFocus = WebTextFieldStyle.drawFocus;
    private int round = WebTextFieldStyle.round;
    private boolean drawShade = WebTextFieldStyle.drawShade;
    private int shadeWidth = WebTextFieldStyle.shadeWidth;
    private boolean drawBackground = WebTextFieldStyle.drawBackground;
    private boolean webColored = WebTextFieldStyle.webColored;
    private Painter painter = WebTextFieldStyle.painter;
    private Insets fieldMargin = WebTextFieldStyle.fieldMargin;
    private String inputPrompt = WebTextFieldStyle.inputPrompt;
    private Font inputPromptFont = WebTextFieldStyle.inputPromptFont;
    private Color inputPromptForeground = WebTextFieldStyle.inputPromptForeground;
    private int inputPromptPosition = WebTextFieldStyle.inputPromptPosition;
    private boolean hideInputPromptOnFocus = WebTextFieldStyle.hideInputPromptOnFocus;
    private JComponent leadingComponent = null;
    private JComponent trailingComponent = null;
    private boolean inputPromptSet = false;
    private FocusListener focusListener;
    private PropertyChangeListener accessibleChangeListener;
    private PropertyChangeListener orientationChangeListener;
    private PropertyChangeListener marginChangeListener;
    private ComponentAdapter componentResizeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebTextFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.textField = (JTextField)c;
        SwingUtils.setOrientation(this.textField);
        LookAndFeel.installProperty(this.textField, "opaque", Boolean.FALSE);
        this.textField.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.textField.setFocusable(true);
        this.textField.setMargin(WebTextFieldStyle.margin);
        this.textField.setBackground(Color.WHITE);
        this.textField.setSelectionColor(StyleConstants.textSelectionColor);
        this.textField.setForeground(Color.BLACK);
        this.textField.setSelectedTextColor(Color.BLACK);
        this.textField.setCaretColor(Color.GRAY);
        this.textField.setLayout(new TextComponentLayout(this.textField));
        PainterSupport.installPainter(this.textField, this.painter);
        this.updateBorder();
        this.focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                WebTextFieldUI.this.textField.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                WebTextFieldUI.this.textField.repaint();
            }
        };
        this.textField.addFocusListener(this.focusListener);
        this.accessibleChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebTextFieldUI.this.updateInnerComponents();
            }
        };
        this.textField.addPropertyChangeListener("enabled", this.accessibleChangeListener);
        this.orientationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebTextFieldUI.this.updateBorder();
            }
        };
        this.textField.addPropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.marginChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebTextFieldUI.this.updateBorder();
            }
        };
        this.textField.addPropertyChangeListener("margin", this.marginChangeListener);
        this.componentResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WebTextFieldUI.this.updateBorder();
            }
        };
    }

    @Override
    public void uninstallUI(JComponent c) {
        PainterSupport.uninstallPainter(this.textField, this.painter);
        this.textField.putClientProperty("HANDLES_ENABLE_STATE", null);
        this.textField.removeFocusListener(this.focusListener);
        this.textField.removePropertyChangeListener("enabled", this.accessibleChangeListener);
        this.textField.removePropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.textField.removePropertyChangeListener("margin", this.marginChangeListener);
        this.cleanupLeadingComponent();
        this.cleanupTrailingComponent();
        this.textField.setLayout(null);
        this.textField = null;
        super.uninstallUI(c);
    }

    @Override
    public Shape provideShape() {
        if (this.drawBorder) {
            return LafUtils.getWebBorderShape(this.textField, this.shadeWidth, this.round);
        }
        return SwingUtils.size(this.textField);
    }

    private void updateInnerComponents() {
        if (this.leadingComponent != null) {
            this.leadingComponent.setEnabled(this.textField.isEnabled());
        }
        if (this.trailingComponent != null) {
            this.trailingComponent.setEnabled(this.textField.isEnabled());
        }
    }

    public JComponent getLeadingComponent() {
        return this.leadingComponent;
    }

    public void setLeadingComponent(JComponent leadingComponent) {
        if (this.leadingComponent == leadingComponent) {
            return;
        }
        this.cleanupLeadingComponent();
        if (leadingComponent != null) {
            this.leadingComponent = leadingComponent;
            this.leadingComponent.addComponentListener(this.componentResizeListener);
            this.textField.add((Component)leadingComponent, "LEADING");
            this.updateInnerComponents();
        }
        this.textField.revalidate();
        this.updateBorder();
    }

    private void cleanupLeadingComponent() {
        if (this.leadingComponent != null) {
            this.leadingComponent.removeComponentListener(this.componentResizeListener);
            this.textField.remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    public JComponent getTrailingComponent() {
        return this.trailingComponent;
    }

    public void setTrailingComponent(JComponent trailingComponent) {
        if (this.trailingComponent == trailingComponent) {
            return;
        }
        this.cleanupTrailingComponent();
        if (trailingComponent != null) {
            this.trailingComponent = trailingComponent;
            this.trailingComponent.addComponentListener(this.componentResizeListener);
            this.textField.add((Component)trailingComponent, "TRAILING");
            this.updateInnerComponents();
        }
        this.textField.revalidate();
        this.updateBorder();
    }

    private void cleanupTrailingComponent() {
        if (this.trailingComponent != null) {
            this.trailingComponent.removeComponentListener(this.componentResizeListener);
            this.textField.remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    public void setFieldMargin(Insets margin) {
        this.fieldMargin = margin;
        this.updateBorder();
    }

    public Insets getFieldMargin() {
        return this.fieldMargin;
    }

    public String getInputPrompt() {
        return this.inputPrompt;
    }

    public void setInputPrompt(String inputPrompt) {
        this.inputPrompt = inputPrompt;
        this.inputPromptSet = inputPrompt != null && !inputPrompt.trim().equals("");
        this.updateInputPromptView();
    }

    public Font getInputPromptFont() {
        return this.inputPromptFont;
    }

    public void setInputPromptFont(Font inputPromptFont) {
        this.inputPromptFont = inputPromptFont;
        this.updateInputPromptView();
    }

    public Color getInputPromptForeground() {
        return this.inputPromptForeground;
    }

    public void setInputPromptForeground(Color inputPromptForeground) {
        this.inputPromptForeground = inputPromptForeground;
        this.updateInputPromptView();
    }

    public int getInputPromptPosition() {
        return this.inputPromptPosition;
    }

    public void setInputPromptPosition(int inputPromptPosition) {
        this.inputPromptPosition = inputPromptPosition;
        this.updateInputPromptView();
    }

    public boolean isHideInputPromptOnFocus() {
        return this.hideInputPromptOnFocus;
    }

    public void setHideInputPromptOnFocus(boolean hideInputPromptOnFocus) {
        this.hideInputPromptOnFocus = hideInputPromptOnFocus;
        this.updateInputPromptView();
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean drawShade) {
        this.drawShade = drawShade;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
        this.updateView();
    }

    public boolean isWebColored() {
        return this.webColored;
    }

    public void setWebColored(boolean webColored) {
        this.webColored = webColored;
        this.updateView();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        this.updateView();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.updateBorder();
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean drawFocus) {
        this.drawFocus = drawFocus;
        this.updateView();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        PainterSupport.uninstallPainter(this.textField, this.painter);
        this.painter = painter;
        this.getComponent().setOpaque(painter == null || painter.isOpaque(this.textField) != false);
        PainterSupport.installPainter(this.textField, this.painter);
        this.updateBorder();
    }

    private void updateInputPromptView() {
        if (this.isInputPromptVisible(this.getComponent())) {
            this.updateView();
        }
    }

    private boolean isInputPromptVisible(JTextComponent c) {
        return this.inputPromptSet && c.isEditable() && c.isEnabled() && (!this.hideInputPromptOnFocus || !c.isFocusOwner()) && c.getText().equals("");
    }

    private void updateView() {
        if (this.textField != null) {
            this.textField.repaint();
        }
    }

    @Override
    public void updateBorder() {
        if (this.textField != null) {
            JComponent tc;
            if (SwingUtils.isPreserveBorders(this.textField)) {
                return;
            }
            Insets m = this.painter != null ? this.painter.getMargin(this.getComponent()) : (this.drawBorder ? new Insets(this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1) : new Insets(0, 0, 0, 0));
            boolean ltr = this.textField.getComponentOrientation().isLeftToRight();
            Insets margin = this.textField.getMargin();
            if (margin != null) {
                m.top += margin.top;
                m.left = m.left + (ltr ? margin.left : margin.right);
                m.bottom += margin.bottom;
                m.right = m.right + (ltr ? margin.right : margin.left);
            }
            if (this.fieldMargin != null) {
                m.top += this.fieldMargin.top;
                m.left = m.left + (ltr ? this.fieldMargin.left : this.fieldMargin.right);
                m.bottom += this.fieldMargin.bottom;
                m.right = m.right + (ltr ? this.fieldMargin.right : this.fieldMargin.left);
            }
            JComponent lc = ltr ? this.leadingComponent : this.trailingComponent;
            JComponent jComponent = tc = ltr ? this.trailingComponent : this.leadingComponent;
            if (lc != null) {
                m.left += ((Component)lc).getPreferredSize().width;
            }
            if (tc != null) {
                m.right += ((Component)tc).getPreferredSize().width;
            }
            this.textField.setBorder(LafUtils.createWebBorder(m));
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent c = this.getComponent();
        Graphics2D g2d = (Graphics2D)g;
        if (c.isOpaque() && (this.painter == null || !this.painter.isOpaque(this.textField).booleanValue())) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (this.painter != null || this.drawBorder) {
            Object aa = LafUtils.setupAntialias(g2d);
            if (this.painter != null) {
                this.painter.paint(g2d, SwingUtils.size(c), c);
            } else if (this.drawBorder) {
                Color shadeColor = this.drawShade ? (this.drawFocus && c.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor) : null;
                LafUtils.drawWebStyle(g2d, c, shadeColor, this.shadeWidth, this.round, this.drawBackground, this.webColored);
            }
            LafUtils.restoreAntialias(g2d, aa);
        }
        Map hints = SwingUtils.setupTextAntialias(g2d);
        super.paintSafely(g);
        if (this.isInputPromptVisible(c)) {
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            Rectangle b = this.getVisibleEditorRect();
            Shape oc = LafUtils.intersectClip(g2d, b);
            g2d.setFont(this.inputPromptFont != null ? this.inputPromptFont : c.getFont());
            g2d.setPaint(this.inputPromptForeground != null ? this.inputPromptForeground : c.getForeground());
            FontMetrics fm = g2d.getFontMetrics();
            int x = this.inputPromptPosition == 0 ? b.x + b.width / 2 - fm.stringWidth(this.inputPrompt) / 2 : (ltr && this.inputPromptPosition == 10 || !ltr && this.inputPromptPosition == 11 ? b.x : b.x + b.width - fm.stringWidth(this.inputPrompt));
            g2d.drawString(this.inputPrompt, x, this.getBaseline(c, c.getWidth(), c.getHeight()));
            g2d.setClip(oc);
        }
        SwingUtils.restoreTextAntialias(g2d, hints);
    }

    @Override
    protected void paintBackground(Graphics g) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps = super.getPreferredSize(c);
        ++ps.width;
        if (this.leadingComponent != null || this.trailingComponent != null) {
            Dimension lps = c.getLayout().preferredLayoutSize(c);
            ps.height = Math.max(ps.height, lps.height);
        }
        if (this.painter != null) {
            ps = SwingUtils.max(ps, this.painter.getPreferredSize(c));
        }
        return ps;
    }
}

