/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.StyleConstants;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.JTextComponent;

public class WebEditorPaneUI
extends BasicEditorPaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new WebEditorPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JTextComponent textComponent = this.getComponent();
        SwingUtils.setOrientation(textComponent);
        LookAndFeel.installProperty(textComponent, "opaque", Boolean.TRUE);
        textComponent.setMargin(new Insets(2, 2, 2, 2));
        textComponent.setFocusable(true);
        textComponent.setBackground(Color.WHITE);
        textComponent.setSelectionColor(StyleConstants.textSelectionColor);
        textComponent.setForeground(Color.BLACK);
        textComponent.setSelectedTextColor(Color.BLACK);
        textComponent.setCaretColor(Color.GRAY);
    }

    @Override
    protected void paintSafely(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Map hints = SwingUtils.setupTextAntialias(g2d);
        super.paintSafely(g);
        SwingUtils.restoreTextAntialias(g2d, hints);
    }
}

