/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.table.WebTableUI;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.FontMethods;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class WebTable
extends JTable
implements FontMethods<WebTable> {
    private boolean editable = true;
    private int visibleRowCount = -1;

    public WebTable() {
    }

    public WebTable(TableModel dm) {
        super(dm);
    }

    public WebTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public WebTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public WebTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public WebTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public WebTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public void setSelectedRow(int row) {
        this.setSelectedRow(row, true);
    }

    public void setSelectedRow(int row, boolean shouldScroll) {
        this.clearSelection();
        this.addSelectedRow(row);
        if (shouldScroll) {
            this.scrollToRow(row);
        }
    }

    public void addSelectedRow(int row) {
        if (row != -1) {
            this.addColumnSelectionInterval(0, this.getColumnCount() - 1);
            this.addRowSelectionInterval(row, row);
        }
    }

    public void setSelectedRows(int startRow, int endRow) {
        this.clearSelection();
        this.addSelectedRows(startRow, endRow);
    }

    public void addSelectedRows(int startRow, int endRow) {
        if (startRow != -1 && endRow != -1) {
            this.addColumnSelectionInterval(0, this.getColumnCount() - 1);
            this.addRowSelectionInterval(startRow, endRow);
        }
    }

    public void setSelectedColumn(int column) {
        this.setSelectedColumn(column, true);
    }

    public void setSelectedColumn(int column, boolean shouldScroll) {
        this.clearSelection();
        this.addSelectedColumn(column);
        if (shouldScroll) {
            this.scrollToColumn(column);
        }
    }

    public void addSelectedColumn(int column) {
        if (column != -1) {
            this.addColumnSelectionInterval(column, column);
            this.addRowSelectionInterval(0, this.getRowCount() - 1);
        }
    }

    public void setSelectedColumns(int startColumn, int endColumn) {
        this.clearSelection();
        this.addSelectedColumns(startColumn, endColumn);
    }

    public void addSelectedColumns(int startColumn, int endColumn) {
        if (startColumn != -1 && endColumn != -1) {
            this.addColumnSelectionInterval(startColumn, endColumn);
            this.addRowSelectionInterval(0, this.getRowCount() - 1);
        }
    }

    public void scrollToRow(int row) {
        Rectangle lastCell;
        Rectangle firstCell = this.getCellRect(row, 0, true);
        Rectangle rect = GeometryUtils.getContainingRect(firstCell, lastCell = this.getCellRect(row, this.getColumnCount() - 1, true));
        if (rect != null) {
            this.scrollRectToVisible(rect);
        }
    }

    public void scrollToColumn(int column) {
        Rectangle lastCell;
        Rectangle firstCell = this.getCellRect(0, column, true);
        Rectangle rect = GeometryUtils.getContainingRect(firstCell, lastCell = this.getCellRect(this.getRowCount() - 1, column, true));
        if (rect != null) {
            this.scrollRectToVisible(rect);
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject event) {
        boolean editingStarted = super.editCellAt(row, column, event);
        if (editingStarted) {
            TableCellEditor cellEditor = this.getCellEditor();
            try {
                Object o = cellEditor.getClass().getMethod("getComponent", new Class[0]).invoke((Object)cellEditor, new Object[0]);
                if (o instanceof Component) {
                    ((Component)o).requestFocusInWindow();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return editingStarted;
    }

    public boolean stopCellEditing() {
        TableCellEditor cellEditor = this.getCellEditor();
        return cellEditor != null && cellEditor.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editable && super.isCellEditable(row, column);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.visibleRowCount = visibleRowCount;
        this.setPreferredScrollableViewportSize(null);
        JScrollPane scrollPane = SwingUtils.getScrollPane(this);
        if (scrollPane != null) {
            scrollPane.getViewport().invalidate();
        }
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.preferredViewportSize != null) {
            return this.preferredViewportSize;
        }
        Dimension ps = this.getPreferredSize();
        if (this.visibleRowCount != -1) {
            int rowHeight;
            if (this.getRowCount() > 0) {
                Rectangle r = this.getCellRect(0, 0, true);
                rowHeight = r.height;
            } else {
                rowHeight = this.getRowHeight();
            }
            ps.height = this.visibleRowCount * rowHeight;
        }
        return ps;
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setPreferredScrollableViewportSize(null);
    }

    public WebTableUI getWebUI() {
        return (WebTableUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getTableHeader() != null) {
            this.getTableHeader().updateUI();
        }
        this.configureEnclosingScrollPaneUI();
        if (this.getUI() == null || !(this.getUI() instanceof WebTableUI)) {
            try {
                this.setUI((WebTableUI)ReflectUtils.createInstance(WebLookAndFeel.tableUI, new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebTableUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    private void configureEnclosingScrollPaneUI() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            Component corner = scrollPane.getCorner("UPPER_TRAILING_CORNER");
            if (corner == null || corner instanceof UIResource) {
                corner = null;
                Object componentClass = UIManager.get("Table.scrollPaneCornerComponent");
                if (componentClass instanceof Class) {
                    try {
                        corner = (Component)((Class)componentClass).newInstance();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                scrollPane.setCorner("UPPER_TRAILING_CORNER", corner);
            }
        }
    }

    @Override
    public WebTable setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebTable setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebTable setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebTable setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebTable setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebTable setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebTable setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTable setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebTable setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebTable changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebTable setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTable setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTable setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }
}

