/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.laf.StyleConstants;
import com.alee.laf.scroll.WebScrollBarUI;
import com.alee.laf.scroll.WebScrollPaneCorner;
import com.alee.laf.scroll.WebScrollPaneStyle;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class WebScrollPaneUI
extends BasicScrollPaneUI
implements ShapeProvider {
    private boolean drawBorder = WebScrollPaneStyle.drawBorder;
    private Color borderColor = WebScrollPaneStyle.borderColor;
    private Color darkBorder = WebScrollPaneStyle.darkBorder;
    private int round = WebScrollPaneStyle.round;
    private int shadeWidth = WebScrollPaneStyle.shadeWidth;
    private Insets margin = WebScrollPaneStyle.margin;
    private boolean drawFocus = WebScrollPaneStyle.drawFocus;
    private boolean drawBackground = WebScrollPaneStyle.drawBackground;
    private WebScrollPaneCorner lowerTrailing;
    private WebScrollPaneCorner lowerLeading;
    private WebScrollPaneCorner upperTrailing;
    private PropertyChangeListener propertyChangeListener;
    protected FocusTracker focusTracker;
    private boolean focused = false;

    public static ComponentUI createUI(JComponent c) {
        return new WebScrollPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        ScrollBarUI hui;
        super.installUI(c);
        SwingUtils.setOrientation(this.scrollpane);
        LookAndFeel.installProperty(this.scrollpane, "opaque", Boolean.FALSE);
        this.scrollpane.setBackground(StyleConstants.backgroundColor);
        ScrollBarUI vui = this.scrollpane.getVerticalScrollBar().getUI();
        if (vui instanceof WebScrollBarUI) {
            WebScrollBarUI ui = (WebScrollBarUI)vui;
            ui.setPaintTrack(this.drawBorder);
        }
        if ((hui = this.scrollpane.getHorizontalScrollBar().getUI()) instanceof WebScrollBarUI) {
            WebScrollBarUI ui = (WebScrollBarUI)hui;
            ui.setPaintTrack(this.drawBorder);
        }
        LafUtils.setScrollBarStyleId(this.scrollpane, "scroll-pane");
        this.updateBorder();
        this.scrollpane.setCorner("LOWER_LEADING_CORNER", this.getLowerLeadingCorner());
        this.scrollpane.setCorner("LOWER_TRAILING_CORNER", this.getLowerTrailingCorner());
        this.scrollpane.setCorner("UPPER_TRAILING_CORNER", this.getUpperTrailing());
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebScrollPaneUI.this.scrollpane.setCorner("LOWER_LEADING_CORNER", WebScrollPaneUI.this.getLowerLeadingCorner());
                WebScrollPaneUI.this.scrollpane.setCorner("LOWER_TRAILING_CORNER", WebScrollPaneUI.this.getLowerTrailingCorner());
                WebScrollPaneUI.this.scrollpane.setCorner("UPPER_TRAILING_CORNER", WebScrollPaneUI.this.getUpperTrailing());
            }
        };
        this.scrollpane.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.focusTracker = new DefaultFocusTracker(){

            @Override
            public boolean isTrackingEnabled() {
                return WebScrollPaneUI.this.drawBorder && WebScrollPaneUI.this.drawFocus;
            }

            @Override
            public void focusChanged(boolean focused) {
                WebScrollPaneUI.this.focused = focused;
                WebScrollPaneUI.this.scrollpane.repaint();
            }
        };
        FocusManager.addFocusTracker(this.scrollpane, this.focusTracker);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.scrollpane.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.scrollpane.remove(this.getLowerLeadingCorner());
        this.scrollpane.remove(this.getLowerTrailingCorner());
        this.scrollpane.remove(this.getUpperTrailing());
        FocusManager.removeFocusTracker(this.focusTracker);
        super.uninstallUI(c);
    }

    private WebScrollPaneCorner getLowerLeadingCorner() {
        if (this.lowerLeading == null) {
            this.lowerLeading = new WebScrollPaneCorner("LOWER_LEADING_CORNER");
        }
        return this.lowerLeading;
    }

    private WebScrollPaneCorner getLowerTrailingCorner() {
        if (this.lowerTrailing == null) {
            this.lowerTrailing = new WebScrollPaneCorner("LOWER_TRAILING_CORNER");
        }
        return this.lowerTrailing;
    }

    private WebScrollPaneCorner getUpperTrailing() {
        if (this.upperTrailing == null) {
            this.upperTrailing = new WebScrollPaneCorner("UPPER_TRAILING_CORNER");
        }
        return this.upperTrailing;
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.scrollpane, this.getShadeWidth(), this.getRound());
    }

    private void updateBorder() {
        if (this.scrollpane != null) {
            if (SwingUtils.isPreserveBorders(this.scrollpane)) {
                return;
            }
            Insets insets = this.drawBorder ? new Insets(this.shadeWidth + 1 + this.margin.top, this.shadeWidth + 1 + this.margin.left, this.shadeWidth + 1 + this.margin.bottom, this.shadeWidth + 1 + this.margin.right) : new Insets(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right);
            this.scrollpane.setBorder(LafUtils.createWebBorder(insets));
        }
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.updateBorder();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean drawFocus) {
        this.drawFocus = drawFocus;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getDarkBorder() {
        return this.darkBorder;
    }

    public void setDarkBorder(Color darkBorder) {
        this.darkBorder = darkBorder;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.drawBorder) {
            LafUtils.drawWebStyle((Graphics2D)g, c, this.drawFocus && this.focused ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round, this.drawBackground, false);
        }
        super.paint(g, c);
    }
}

