/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.button;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.extended.panel.WebButtonGroup;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebButtonStyle;
import com.alee.utils.ColorUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.BorderMethods;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class WebButtonUI
extends BasicButtonUI
implements ShapeProvider,
SwingConstants,
BorderMethods {
    protected Color topBgColor = WebButtonStyle.topBgColor;
    protected Color bottomBgColor = WebButtonStyle.bottomBgColor;
    protected Color topSelectedBgColor = WebButtonStyle.topSelectedBgColor;
    protected Color bottomSelectedBgColor = WebButtonStyle.bottomSelectedBgColor;
    protected Color selectedForeground = WebButtonStyle.selectedForeground;
    protected boolean rolloverShine = WebButtonStyle.rolloverShine;
    protected Color shineColor = WebButtonStyle.shineColor;
    protected boolean rolloverDarkBorderOnly = WebButtonStyle.rolloverDarkBorderOnly;
    protected int round = WebButtonStyle.round;
    protected boolean drawShade = WebButtonStyle.drawShade;
    protected boolean rolloverShadeOnly = WebButtonStyle.rolloverShadeOnly;
    protected boolean showDisabledShade = WebButtonStyle.showDisabledShade;
    protected int shadeWidth = WebButtonStyle.shadeWidth;
    protected Insets margin = WebButtonStyle.margin;
    protected Color shadeColor = WebButtonStyle.shadeColor;
    protected int innerShadeWidth = WebButtonStyle.innerShadeWidth;
    protected Color innerShadeColor = WebButtonStyle.innerShadeColor;
    protected int leftRightSpacing = WebButtonStyle.leftRightSpacing;
    protected boolean shadeToggleIcon = WebButtonStyle.shadeToggleIcon;
    protected float shadeToggleIconTransparency = WebButtonStyle.shadeToggleIconTransparency;
    protected boolean drawFocus = WebButtonStyle.drawFocus;
    protected boolean rolloverDecoratedOnly = WebButtonStyle.rolloverDecoratedOnly;
    protected boolean animate = WebButtonStyle.animate;
    protected boolean undecorated = WebButtonStyle.undecorated;
    protected Painter painter = WebButtonStyle.painter;
    protected boolean moveIconOnPress = WebButtonStyle.moveIconOnPress;
    protected boolean drawTop = true;
    protected boolean drawLeft = true;
    protected boolean drawBottom = true;
    protected boolean drawRight = true;
    protected boolean drawTopLine = false;
    protected boolean drawLeftLine = false;
    protected boolean drawBottomLine = false;
    protected boolean drawRightLine = false;
    protected Color transparentShineColor = new Color(this.shineColor.getRed(), this.shineColor.getGreen(), this.shineColor.getBlue(), 0);
    protected boolean rollover = false;
    protected float transparency = 0.0f;
    protected Point mousePoint = null;
    protected WebTimer animator = null;
    protected AbstractButton button = null;
    protected boolean oldFocusPainted;
    protected boolean oldContentAreaFilled;
    protected boolean oldBorderPainted;
    protected boolean oldFocusable;
    protected MouseAdapter mouseAdapter;
    protected AncestorListener ancestorListener;
    protected PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebButtonUI();
    }

    @Override
    public void installUI(final JComponent c) {
        super.installUI(c);
        this.button = (AbstractButton)c;
        this.oldFocusPainted = this.button.isFocusPainted();
        this.oldContentAreaFilled = this.button.isContentAreaFilled();
        this.oldBorderPainted = this.button.isBorderPainted();
        this.oldFocusable = this.button.isFocusable();
        SwingUtils.setOrientation(this.button);
        this.button.setFocusPainted(false);
        this.button.setContentAreaFilled(false);
        this.button.setBorderPainted(false);
        this.button.setFocusable(true);
        LookAndFeel.installProperty(this.button, "opaque", Boolean.FALSE);
        PainterSupport.installPainter(this.button, this.painter);
        this.updateBorder();
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WebButtonUI.this.rollover = true;
                WebButtonUI.this.button.getModel().setRollover(true);
                WebButtonUI.this.mousePoint = e.getPoint();
                this.stopAnimator();
                if (WebButtonUI.this.painter == null && WebButtonUI.this.animate && (WebButtonUI.this.rolloverShine || WebButtonUI.this.rolloverDecoratedOnly || WebButtonUI.this.rolloverShadeOnly)) {
                    WebButtonUI.this.animator = new WebTimer("WebButtonUI.fadeInTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WebButtonUI.this.transparency += 0.075f;
                            if (WebButtonUI.this.transparency >= 1.0f) {
                                WebButtonUI.this.transparency = 1.0f;
                                WebButtonUI.this.animator.stop();
                            }
                            WebButtonUI.this.updateTransparentShineColor();
                            if (c.isEnabled()) {
                                c.repaint();
                            }
                        }
                    });
                    WebButtonUI.this.animator.start();
                } else {
                    WebButtonUI.this.transparency = 1.0f;
                    WebButtonUI.this.updateTransparentShineColor();
                    c.repaint();
                }
                this.refresh(c);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WebButtonUI.this.mousePoint = e.getPoint();
                this.stopAnimator();
                if (WebButtonUI.this.painter == null && WebButtonUI.this.animate && (WebButtonUI.this.rolloverShine || WebButtonUI.this.rolloverDecoratedOnly || WebButtonUI.this.rolloverShadeOnly)) {
                    WebButtonUI.this.animator = new WebTimer("WebButtonUI.fadeOutTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WebButtonUI.this.transparency -= 0.075f;
                            if (WebButtonUI.this.transparency <= 0.0f) {
                                WebButtonUI.this.rollover = false;
                                WebButtonUI.this.button.getModel().setRollover(false);
                                WebButtonUI.this.transparency = 0.0f;
                                WebButtonUI.this.mousePoint = null;
                                WebButtonUI.this.animator.stop();
                            }
                            WebButtonUI.this.updateTransparentShineColor();
                            if (c.isEnabled()) {
                                c.repaint();
                            }
                        }
                    });
                    WebButtonUI.this.animator.start();
                } else {
                    WebButtonUI.this.rollover = false;
                    WebButtonUI.this.button.getModel().setRollover(false);
                    WebButtonUI.this.transparency = 0.0f;
                    WebButtonUI.this.mousePoint = null;
                    WebButtonUI.this.updateTransparentShineColor();
                    c.repaint();
                }
                this.refresh(c);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!c.isShowing() || this.windowLostFocus()) {
                    WebButtonUI.this.mousePoint = null;
                    c.repaint();
                }
            }

            private boolean windowLostFocus() {
                Window wa = SwingUtils.getWindowAncestor(c);
                return wa == null || !wa.isVisible() || !wa.isActive();
            }

            private void stopAnimator() {
                if (WebButtonUI.this.animator != null) {
                    WebButtonUI.this.animator.stop();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                WebButtonUI.this.mousePoint = e.getPoint();
                if (WebButtonUI.this.painter == null && WebButtonUI.this.rolloverShine) {
                    this.refresh(c);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                WebButtonUI.this.mousePoint = e.getPoint();
                if (WebButtonUI.this.painter == null && WebButtonUI.this.rolloverShine) {
                    this.refresh(c);
                }
            }

            private void refresh(JComponent c2) {
                if (c2.isEnabled() && (WebButtonUI.this.animator == null || !WebButtonUI.this.animator.isRunning())) {
                    c2.repaint();
                }
            }
        };
        c.addMouseListener(this.mouseAdapter);
        c.addMouseMotionListener(this.mouseAdapter);
        this.ancestorListener = new AncestorAdapter(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                WebButtonUI.this.rollover = false;
                WebButtonUI.this.button.getModel().setRollover(false);
                WebButtonUI.this.transparency = 0.0f;
                WebButtonUI.this.mousePoint = null;
                WebButtonUI.this.updateTransparentShineColor();
                c.repaint();
            }
        };
        c.addAncestorListener(this.ancestorListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebButtonUI.this.updateBorder();
            }
        };
        c.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        PainterSupport.uninstallPainter(this.button, this.painter);
        c.removeMouseListener(this.mouseAdapter);
        c.removeMouseMotionListener(this.mouseAdapter);
        c.removeAncestorListener(this.ancestorListener);
        c.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        this.button.setBorderPainted(this.oldBorderPainted);
        this.button.setContentAreaFilled(this.oldContentAreaFilled);
        this.button.setFocusPainted(this.oldFocusPainted);
        this.button.setFocusable(this.oldFocusable);
        super.uninstallUI(c);
    }

    @Override
    public Shape provideShape() {
        if (this.painter != null || this.undecorated) {
            return SwingUtils.size(this.button);
        }
        return this.getButtonShape(this.button, true);
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color topBgColor) {
        this.topBgColor = topBgColor;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color bottomBgColor) {
        this.bottomBgColor = bottomBgColor;
    }

    public Color getTopSelectedBgColor() {
        return this.topSelectedBgColor;
    }

    public void setTopSelectedBgColor(Color topSelectedBgColor) {
        this.topSelectedBgColor = topSelectedBgColor;
    }

    public Color getBottomSelectedBgColor() {
        return this.bottomSelectedBgColor;
    }

    public void setBottomSelectedBgColor(Color bottomSelectedBgColor) {
        this.bottomSelectedBgColor = bottomSelectedBgColor;
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color selectedForeground) {
        this.selectedForeground = selectedForeground;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.rolloverDarkBorderOnly;
    }

    public void setRolloverDarkBorderOnly(boolean rolloverDarkBorderOnly) {
        this.rolloverDarkBorderOnly = rolloverDarkBorderOnly;
    }

    public boolean isRolloverShine() {
        return this.rolloverShine;
    }

    public void setRolloverShine(boolean rolloverShine) {
        this.rolloverShine = rolloverShine;
    }

    public Color getShineColor() {
        return this.shineColor;
    }

    public void setShineColor(Color shineColor) {
        this.shineColor = shineColor;
        this.updateTransparentShineColor();
    }

    private void updateTransparentShineColor() {
        this.transparentShineColor = new Color(this.shineColor.getRed(), this.shineColor.getGreen(), this.shineColor.getBlue(), Math.round(this.transparency * (float)this.shineColor.getAlpha()));
    }

    @Override
    public void updateBorder() {
        if (this.button != null) {
            this.button.setBorder(LafUtils.createWebBorder(this.getBorderInsets()));
        }
    }

    protected Insets getBorderInsets() {
        boolean ltr = this.button.getComponentOrientation().isLeftToRight();
        Insets m = new Insets(this.margin.top, (ltr ? this.margin.left : this.margin.right) + this.leftRightSpacing, this.margin.bottom, (ltr ? this.margin.right : this.margin.left) + this.leftRightSpacing);
        if (this.painter != null) {
            Insets pi = this.painter.getMargin(this.button);
            m.top += pi.top;
            m.bottom += pi.bottom;
            m.left = m.left + (ltr ? pi.left : pi.right);
            m.right = m.right + (ltr ? pi.right : pi.left);
        } else if (!this.undecorated) {
            boolean actualDrawLeft = ltr ? this.drawLeft : this.drawRight;
            boolean actualDrawLeftLine = ltr ? this.drawLeftLine : this.drawRightLine;
            boolean actualDrawRight = ltr ? this.drawRight : this.drawLeft;
            boolean actualDrawRightLine = ltr ? this.drawRightLine : this.drawLeftLine;
            m.top = m.top + ((this.drawTop ? this.shadeWidth + 1 : (this.drawTopLine ? 1 : 0)) + this.innerShadeWidth);
            m.left = m.left + ((actualDrawLeft ? this.shadeWidth + 1 : (actualDrawLeftLine ? 1 : 0)) + this.innerShadeWidth);
            m.bottom = m.bottom + ((this.drawBottom ? this.shadeWidth + 1 : (this.drawBottomLine ? 1 : 0)) + this.innerShadeWidth);
            m.right = m.right + ((actualDrawRight ? this.shadeWidth + 1 : (actualDrawRightLine ? 1 : 0)) + this.innerShadeWidth);
        }
        return m;
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean drawShade) {
        this.drawShade = drawShade;
    }

    public boolean isRolloverShadeOnly() {
        return this.rolloverShadeOnly;
    }

    public void setRolloverShadeOnly(boolean rolloverShadeOnly) {
        this.rolloverShadeOnly = rolloverShadeOnly;
    }

    public boolean isShowDisabledShade() {
        return this.showDisabledShade;
    }

    public void setShowDisabledShade(boolean showDisabledShade) {
        this.showDisabledShade = showDisabledShade;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
    }

    public int getInnerShadeWidth() {
        return this.innerShadeWidth;
    }

    public void setInnerShadeWidth(int innerShadeWidth) {
        this.innerShadeWidth = innerShadeWidth;
        this.updateBorder();
    }

    public Color getInnerShadeColor() {
        return this.innerShadeColor;
    }

    public void setInnerShadeColor(Color innerShadeColor) {
        this.innerShadeColor = innerShadeColor;
    }

    public int getLeftRightSpacing() {
        return this.leftRightSpacing;
    }

    public void setLeftRightSpacing(int leftRightSpacing) {
        this.leftRightSpacing = leftRightSpacing;
        this.updateBorder();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public boolean isShadeToggleIcon() {
        return this.shadeToggleIcon;
    }

    public void setShadeToggleIcon(boolean shadeToggleIcon) {
        this.shadeToggleIcon = shadeToggleIcon;
    }

    public float getShadeToggleIconTransparency() {
        return this.shadeToggleIconTransparency;
    }

    public void setShadeToggleIconTransparency(float shadeToggleIconTransparency) {
        this.shadeToggleIconTransparency = shadeToggleIconTransparency;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        this.undecorated = undecorated;
        this.updateBorder();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        PainterSupport.uninstallPainter(this.button, this.painter);
        this.painter = painter;
        PainterSupport.installPainter(this.button, this.painter);
        this.updateBorder();
    }

    public boolean isMoveIconOnPress() {
        return this.moveIconOnPress;
    }

    public void setMoveIconOnPress(boolean moveIconOnPress) {
        this.moveIconOnPress = moveIconOnPress;
    }

    public boolean isRolloverDecoratedOnly() {
        return this.rolloverDecoratedOnly;
    }

    public void setRolloverDecoratedOnly(boolean rolloverDecoratedOnly) {
        this.rolloverDecoratedOnly = rolloverDecoratedOnly;
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean drawFocus) {
        this.drawFocus = drawFocus;
    }

    public boolean isDrawBottom() {
        return this.drawBottom;
    }

    public void setDrawBottom(boolean drawBottom) {
        this.drawBottom = drawBottom;
        this.updateBorder();
    }

    public boolean isDrawLeft() {
        return this.drawLeft;
    }

    public void setDrawLeft(boolean drawLeft) {
        this.drawLeft = drawLeft;
        this.updateBorder();
    }

    public boolean isDrawRight() {
        return this.drawRight;
    }

    public void setDrawRight(boolean drawRight) {
        this.drawRight = drawRight;
        this.updateBorder();
    }

    public boolean isDrawTop() {
        return this.drawTop;
    }

    public void setDrawTop(boolean drawTop) {
        this.drawTop = drawTop;
        this.updateBorder();
    }

    public void setDrawSides(boolean top, boolean left, boolean bottom, boolean right) {
        this.drawTop = top;
        this.drawLeft = left;
        this.drawBottom = bottom;
        this.drawRight = right;
        this.updateBorder();
    }

    public boolean isDrawTopLine() {
        return this.drawTopLine;
    }

    public void setDrawTopLine(boolean drawTopLine) {
        this.drawTopLine = drawTopLine;
        this.updateBorder();
    }

    public boolean isDrawLeftLine() {
        return this.drawLeftLine;
    }

    public void setDrawLeftLine(boolean drawLeftLine) {
        this.drawLeftLine = drawLeftLine;
        this.updateBorder();
    }

    public boolean isDrawBottomLine() {
        return this.drawBottomLine;
    }

    public void setDrawBottomLine(boolean drawBottomLine) {
        this.drawBottomLine = drawBottomLine;
        this.updateBorder();
    }

    public boolean isDrawRightLine() {
        return this.drawRightLine;
    }

    public void setDrawRightLine(boolean drawRightLine) {
        this.drawRightLine = drawRightLine;
        this.updateBorder();
    }

    public void setDrawLines(boolean top, boolean left, boolean bottom, boolean right) {
        this.drawTopLine = top;
        this.drawLeftLine = left;
        this.drawBottomLine = bottom;
        this.drawRightLine = right;
        this.updateBorder();
    }

    public boolean isRollover() {
        return this.rollover;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel buttonModel = button.getModel();
        Graphics2D g2d = (Graphics2D)g;
        Object aa = LafUtils.setupAntialias(g2d);
        if (this.painter != null || !this.undecorated) {
            if (this.painter != null) {
                this.painter.paint(g2d, SwingUtils.size(c), c);
            } else if (!this.undecorated) {
                boolean pressed = buttonModel.isPressed() || buttonModel.isSelected();
                Shape borderShape = this.getButtonShape(button, true);
                if (this.isDrawButton(c, buttonModel)) {
                    int y;
                    int x;
                    boolean actualDrawRightLine;
                    boolean animatedTransparency = this.animate && this.rolloverDecoratedOnly && !pressed;
                    Composite oldComposite = LafUtils.setupAlphaComposite(g2d, Float.valueOf(this.transparency), animatedTransparency);
                    if (this.drawShade && (c.isEnabled() || this.isInButtonGroup(button) || this.showDisabledShade) && (!this.rolloverShadeOnly || this.rollover)) {
                        boolean setInner = !animatedTransparency && this.rolloverShadeOnly;
                        Composite oc = LafUtils.setupAlphaComposite(g2d, Float.valueOf(this.transparency), setInner);
                        LafUtils.drawShade(g2d, borderShape, this.getShadeColor(c), this.shadeWidth);
                        LafUtils.restoreComposite(g2d, oc, setInner);
                    }
                    g2d.setPaint(new GradientPaint(0.0f, this.drawTop ? (float)this.shadeWidth : 0.0f, pressed ? this.topSelectedBgColor : this.topBgColor, 0.0f, button.getHeight() - (this.drawBottom ? this.shadeWidth : 0), pressed ? this.bottomSelectedBgColor : this.bottomBgColor));
                    g2d.fill(this.getButtonShape(button, false));
                    if (this.rolloverShine && this.mousePoint != null && c.isEnabled()) {
                        Shape oldClip = LafUtils.intersectClip(g2d, borderShape);
                        g2d.setPaint(new RadialGradientPaint(this.mousePoint.x, (float)c.getHeight(), c.getWidth(), new float[]{0.0f, 1.0f}, new Color[]{this.transparentShineColor, StyleConstants.transparent}));
                        g2d.fill(borderShape);
                        LafUtils.restoreClip(g2d, oldClip);
                    }
                    if (pressed) {
                        LafUtils.drawShade(g2d, borderShape, this.innerShadeColor, this.innerShadeWidth, borderShape);
                    }
                    g2d.setPaint(c.isEnabled() ? (this.rolloverDarkBorderOnly && this.rollover ? this.getBorderColor() : (!this.rolloverDarkBorderOnly ? StyleConstants.darkBorderColor : StyleConstants.borderColor)) : StyleConstants.disabledBorderColor);
                    g2d.draw(borderShape);
                    boolean ltr = button.getComponentOrientation().isLeftToRight();
                    boolean actualDrawLeft = ltr ? this.drawLeft : this.drawRight;
                    boolean actualDrawLeftLine = ltr ? this.drawLeftLine : this.drawRightLine;
                    boolean actualDrawRight = ltr ? this.drawRight : this.drawLeft;
                    boolean bl = actualDrawRightLine = ltr ? this.drawRightLine : this.drawLeftLine;
                    if (!this.drawTop && this.drawTopLine) {
                        x = actualDrawLeft ? this.shadeWidth : 0;
                        g2d.setPaint(c.isEnabled() || this.isAfterEnabledButton(button) ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
                        g2d.drawLine(x, 0, x + c.getWidth() - (actualDrawLeft ? this.shadeWidth : 0) - (actualDrawRight ? this.shadeWidth + 1 : 0), 0);
                    }
                    if (!actualDrawLeft && actualDrawLeftLine) {
                        y = this.drawTop ? this.shadeWidth : 0;
                        g2d.setPaint(c.isEnabled() || this.isAfterEnabledButton(button) ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
                        g2d.drawLine(0, y, 0, y + c.getHeight() - (this.drawTop ? this.shadeWidth : 0) - (this.drawBottom ? this.shadeWidth + 1 : 0));
                    }
                    if (!this.drawBottom && this.drawBottomLine) {
                        x = actualDrawLeft ? this.shadeWidth : 0;
                        g2d.setPaint(c.isEnabled() || this.isBeforeEnabledButton(button) ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
                        g2d.drawLine(x, c.getHeight() - 1, x + c.getWidth() - (actualDrawLeft ? this.shadeWidth : 0) - (actualDrawRight ? this.shadeWidth + 1 : 0), c.getHeight() - 1);
                    }
                    if (!actualDrawRight && actualDrawRightLine) {
                        y = this.drawTop ? this.shadeWidth : 0;
                        g2d.setPaint(c.isEnabled() || this.isBeforeEnabledButton(button) ? StyleConstants.darkBorderColor : StyleConstants.disabledBorderColor);
                        g2d.drawLine(c.getWidth() - 1, y, c.getWidth() - 1, y + c.getHeight() - (this.drawTop ? this.shadeWidth : 0) - (this.drawBottom ? this.shadeWidth + 1 : 0));
                    }
                    LafUtils.restoreComposite(g2d, oldComposite, animatedTransparency);
                }
            }
        }
        if (buttonModel.isPressed() && this.moveIconOnPress) {
            g2d.translate(1, 1);
        }
        LafUtils.restoreAntialias(g2d, aa);
        Map hints = SwingUtils.setupTextAntialias(g2d);
        super.paint(g, c);
        SwingUtils.restoreTextAntialias(g2d, hints);
    }

    protected boolean isAfterEnabledButton(AbstractButton button) {
        WebButtonGroup group;
        Component before;
        int zOrder;
        Container container = button.getParent();
        if (container != null && container instanceof WebButtonGroup && (zOrder = container.getComponentZOrder(button)) > 0 && (before = (group = (WebButtonGroup)container).getComponent(zOrder - 1)) instanceof WebButton) {
            return before.isEnabled();
        }
        return false;
    }

    protected boolean isBeforeEnabledButton(AbstractButton button) {
        WebButtonGroup group;
        Component before;
        int zOrder;
        Container container = button.getParent();
        if (container != null && container instanceof WebButtonGroup && (zOrder = container.getComponentZOrder(button)) < container.getComponentCount() - 1 && (before = (group = (WebButtonGroup)container).getComponent(zOrder + 1)) instanceof WebButton) {
            return before.isEnabled();
        }
        return false;
    }

    protected boolean isInButtonGroup(AbstractButton button) {
        Container container = button.getParent();
        return container != null && container instanceof WebButtonGroup;
    }

    private Color getShadeColor(JComponent c) {
        return this.isFocusActive(c) ? StyleConstants.fieldFocusColor : this.shadeColor;
    }

    private boolean isFocusActive(JComponent c) {
        return c.isEnabled() && this.drawFocus && c.isFocusOwner();
    }

    private boolean isDrawButton(JComponent c, ButtonModel buttonModel) {
        return this.rolloverDecoratedOnly && this.rollover && c.isEnabled() || this.animate && this.transparency > 0.0f && c.isEnabled() || !this.rolloverDecoratedOnly || buttonModel.isSelected() || buttonModel.isPressed();
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtils.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(model.isPressed() || model.isSelected() ? this.selectedForeground : b.getForeground());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(b.getBackground().brighter());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(b.getBackground().darker());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    private Color getBorderColor() {
        return ColorUtils.getIntermediateColor(StyleConstants.borderColor, StyleConstants.darkBorderColor, this.transparency);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton button = (AbstractButton)c;
        ButtonModel buttonModel = button.getModel();
        Graphics2D g2d = (Graphics2D)g;
        boolean shadeToggleIcon = this.shadeToggleIcon && button instanceof JToggleButton && !buttonModel.isSelected();
        Composite old = LafUtils.setupAlphaComposite(g2d, Float.valueOf(this.shadeToggleIconTransparency), shadeToggleIcon);
        super.paintIcon(g, c, iconRect);
        LafUtils.restoreComposite(g2d, old, shadeToggleIcon);
    }

    protected Shape getButtonShape(AbstractButton button, boolean border) {
        boolean ltr = button.getComponentOrientation().isLeftToRight();
        boolean actualDrawLeft = ltr ? this.drawLeft : this.drawRight;
        boolean actualDrawRight = ltr ? this.drawRight : this.drawLeft;
        int x = actualDrawLeft ? this.shadeWidth : -this.shadeWidth - this.round - 1;
        int y = this.drawTop ? this.shadeWidth : -this.shadeWidth - this.round - 1;
        int maxX = actualDrawRight ? button.getWidth() - this.shadeWidth - 1 : button.getWidth() + this.shadeWidth + this.round;
        int maxY = this.drawBottom ? button.getHeight() - this.shadeWidth - 1 : button.getHeight() + this.shadeWidth + this.round;
        int width = maxX - x;
        int height = maxY - y;
        if (this.round > 0) {
            return new RoundRectangle2D.Double(x, y, width, height, this.round * 2 + (border ? 0 : 1), this.round * 2 + (border ? 0 : 1));
        }
        return new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps = super.getPreferredSize(c);
        if (this.painter != null) {
            ps = SwingUtils.max(ps, this.painter.getPreferredSize(c));
        }
        return ps;
    }
}

