/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition.effects.fade;

import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.effects.DefaultTransitionEffect;
import com.alee.utils.LafUtils;
import java.awt.Composite;
import java.awt.Graphics2D;

public class FadeTransitionEffect
extends DefaultTransitionEffect {
    private static final String FADE_MINIMUM_SPEED = "FADE_MINIMUM_SPEED";
    private static final String FADE_SPEED = "FADE_SPEED";
    private float minimumSpeed;
    private float speed;
    private float opacity;

    public float getMinimumSpeed() {
        return this.get(FADE_MINIMUM_SPEED, Float.valueOf(0.02f)).floatValue();
    }

    public void setMinimumSpeed(float speed) {
        this.put(FADE_MINIMUM_SPEED, Float.valueOf(speed));
    }

    public float getSpeed() {
        return this.get(FADE_SPEED, Float.valueOf(0.1f)).floatValue();
    }

    public void setSpeed(float speed) {
        this.put(FADE_SPEED, Float.valueOf(speed));
    }

    @Override
    public void prepareAnimation(ImageTransition imageTransition) {
        this.minimumSpeed = this.getMinimumSpeed();
        this.speed = this.getSpeed();
        this.opacity = 0.0f;
        imageTransition.repaint();
    }

    @Override
    public boolean performAnimation(ImageTransition imageTransition) {
        if (this.opacity < 1.0f) {
            this.opacity = Math.min(this.opacity + this.getCurrentSpeed(), 1.0f);
            imageTransition.repaint();
            return false;
        }
        return true;
    }

    private float getCurrentSpeed() {
        return Math.max(this.minimumSpeed, this.speed * (float)Math.sqrt((1.0f - this.opacity) / 1.0f));
    }

    @Override
    public void paint(Graphics2D g2d, ImageTransition transition) {
        Composite old = LafUtils.setupAlphaComposite(g2d, Float.valueOf(1.0f - this.opacity));
        g2d.drawImage(transition.getCurrentImage(), 0, 0, transition.getWidth(), transition.getHeight(), null);
        LafUtils.restoreComposite(g2d, old);
        LafUtils.setupAlphaComposite(g2d, Float.valueOf(this.opacity));
        g2d.drawImage(transition.getOtherImage(), 0, 0, transition.getWidth(), transition.getHeight(), null);
        LafUtils.restoreComposite(g2d, old);
    }
}

