/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.icon.OrientedIcon;
import com.alee.extended.label.WebVerticalLabel;
import com.alee.extended.panel.CollapsiblePaneListener;
import com.alee.extended.panel.WebCollapsiblePaneStyle;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsMethods;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.DataProvider;
import com.alee.utils.swing.WebTimer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class WebCollapsiblePane
extends WebPanel
implements SwingConstants,
ShapeProvider,
LanguageMethods,
SettingsMethods {
    protected boolean animate = WebCollapsiblePaneStyle.animate;
    protected ImageIcon expandIcon = WebCollapsiblePaneStyle.expandIcon;
    protected ImageIcon collapseIcon = WebCollapsiblePaneStyle.collapseIcon;
    protected Insets stateIconMargin = WebCollapsiblePaneStyle.stateIconMargin;
    protected boolean rotateStateIcon = WebCollapsiblePaneStyle.rotateStateIcon;
    protected boolean showStateIcon = WebCollapsiblePaneStyle.showStateIcon;
    protected int stateIconPostion = WebCollapsiblePaneStyle.stateIconPostion;
    protected int titlePanePostion = WebCollapsiblePaneStyle.titlePanePostion;
    protected Insets contentMargin = WebCollapsiblePaneStyle.contentMargin;
    protected List<CollapsiblePaneListener> listeners = new ArrayList<CollapsiblePaneListener>(1);
    protected ImageIcon cachedExpandIcon = null;
    protected ImageIcon cachedDisabledExpandIcon = null;
    protected ImageIcon cachedCollapseIcon = null;
    protected ImageIcon cachedDisabledCollapseIcon = null;
    protected DataProvider<Boolean> stateChangeHandler = null;
    protected boolean expanded = true;
    protected float transitionProgress = 1.0f;
    protected float expandSpeed = 0.1f;
    protected WebTimer animator = null;
    protected boolean customTitle = false;
    protected WebPanel headerPanel;
    protected Component titleComponent;
    protected WebButton expandButton;
    protected WebPanel contentPanel;
    protected Component content = null;

    public WebCollapsiblePane() {
        this("");
    }

    public WebCollapsiblePane(String title) {
        this(null, title);
    }

    public WebCollapsiblePane(ImageIcon icon, String title) {
        this(icon, title, null);
    }

    public WebCollapsiblePane(String title, Component content) {
        this(null, title, content);
    }

    public WebCollapsiblePane(Icon icon, String title, Component content) {
        this.content = content;
        this.setPaintFocus(true);
        this.setUndecorated(false);
        this.setWebColoredBackground(false);
        this.setRound(StyleConstants.smallRound);
        this.setLayout(new BorderLayout(0, 0));
        this.headerPanel = new WebPanel();
        this.headerPanel.setOpaque(true);
        this.headerPanel.setUndecorated(false);
        this.headerPanel.setShadeWidth(0);
        this.headerPanel.setLayout(new BorderLayout());
        this.headerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.isAllowAction(e)) {
                    WebCollapsiblePane.this.takeFocus();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.isAllowAction(e)) {
                    WebCollapsiblePane.this.invertExpandState();
                }
            }

            private boolean isAllowAction(MouseEvent e) {
                return SwingUtilities.isLeftMouseButton(e) && SwingUtils.size(WebCollapsiblePane.this).contains(e.getPoint());
            }
        });
        this.updateHeaderPosition();
        this.updateDefaultTitleComponent(icon, title);
        this.updateDefaultTitleBorder();
        this.expandButton = new WebButton(this.collapseIcon);
        this.expandButton.setUndecorated(true);
        this.expandButton.setDrawFocus(false);
        this.expandButton.setMoveIconOnPress(false);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebCollapsiblePane.this.invertExpandState();
                WebCollapsiblePane.this.takeFocus();
            }
        });
        this.setStateIcons();
        this.updateStateIconMargin();
        this.updateStateIconPosition();
        this.contentPanel = new WebPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                if (WebCollapsiblePane.this.titlePanePostion == 1 || WebCollapsiblePane.this.titlePanePostion == 3) {
                    if (WebCollapsiblePane.this.content != null) {
                        Insets insets = this.getInsets();
                        ps.width = insets.left + WebCollapsiblePane.this.content.getPreferredSize().width + insets.right;
                    }
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        ps.height = Math.round((float)ps.height * WebCollapsiblePane.this.transitionProgress);
                    }
                } else {
                    if (WebCollapsiblePane.this.content != null) {
                        Insets insets = this.getInsets();
                        ps.height = insets.top + WebCollapsiblePane.this.content.getPreferredSize().height + insets.bottom;
                    }
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        ps.width = Math.round((float)ps.width * WebCollapsiblePane.this.transitionProgress);
                    }
                }
                return ps;
            }
        };
        this.contentPanel.setOpaque(false);
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.contentPanel.setMargin(this.contentMargin);
        this.add((Component)this.contentPanel, (Object)"Center");
        if (this.content != null) {
            this.contentPanel.add(this.content, (Object)"Center");
        }
        this.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebCollapsiblePane.this.updateStateIcons();
            }
        });
    }

    protected void takeFocus() {
        if (this.isShowing() && this.isEnabled()) {
            this.expandButton.requestFocusInWindow();
        }
    }

    protected void updateDefaultTitleComponent() {
        this.updateDefaultTitleComponent(this.getIcon(), this.getTitle());
    }

    protected void updateDefaultTitleComponent(Icon icon, String title) {
        if (!this.customTitle) {
            if (this.titleComponent != null) {
                this.headerPanel.remove(this.titleComponent);
            }
            this.titleComponent = this.createDefaultTitleComponent(icon, title);
            this.headerPanel.add(this.titleComponent, (Object)"Center");
        }
    }

    protected void updateDefaultTitleBorder() {
        if (this.titleComponent != null && !this.customTitle) {
            Insets margin;
            Insets insets = margin = this.getIcon() != null || this.titlePanePostion != 2 || this.titlePanePostion == 4 ? new Insets(2, 2, 2, 2) : new Insets(2, 4, 2, 2);
            if (this.titlePanePostion == 2) {
                margin = new Insets(margin.right, margin.top, margin.left, margin.bottom);
            } else if (this.titlePanePostion == 4) {
                margin = new Insets(margin.left, margin.bottom, margin.right, margin.top);
            }
            ((WebLabel)this.titleComponent).setMargin(margin);
        }
    }

    protected void updateHeaderPosition() {
        this.updateHeaderSides();
        if (this.titlePanePostion == 1) {
            this.add((Component)this.headerPanel, (Object)"North");
        } else if (this.titlePanePostion == 3) {
            this.add((Component)this.headerPanel, (Object)"South");
        } else if (this.titlePanePostion == 2) {
            this.add((Component)this.headerPanel, (Object)"Before");
        } else if (this.titlePanePostion == 4) {
            this.add((Component)this.headerPanel, (Object)"After");
        }
        this.revalidate();
    }

    protected void updateHeaderSides() {
        this.headerPanel.setPaintSides(this.expanded && this.titlePanePostion == 3, this.expanded && this.titlePanePostion == 4, this.expanded && this.titlePanePostion == 1, this.expanded && this.titlePanePostion == 2);
    }

    protected void updateStateIconPosition() {
        if (this.showStateIcon) {
            if (this.titlePanePostion == 1 || this.titlePanePostion == 3) {
                this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPostion == 4 ? "After" : "Before"));
            } else if (this.titlePanePostion == 2) {
                this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPostion == 4 ? "First" : "Last"));
            } else if (this.titlePanePostion == 4) {
                this.headerPanel.add((Component)this.expandButton, (Object)(this.stateIconPostion == 4 ? "Last" : "First"));
            }
        } else {
            this.headerPanel.remove(this.expandButton);
        }
        this.headerPanel.revalidate();
    }

    protected void updateStateIconMargin() {
        this.expandButton.setMargin(this.stateIconMargin);
    }

    protected JComponent createDefaultTitleComponent(Icon icon, String title) {
        WebLabel defaultTitle = this.titlePanePostion == 2 ? new WebVerticalLabel(title, icon, 10, false) : (this.titlePanePostion == 4 ? new WebVerticalLabel(title, icon, 10, true) : new WebLabel(title, icon, 10));
        defaultTitle.setDrawShade(true);
        return defaultTitle;
    }

    public DataProvider<Boolean> getStateChangeHandler() {
        return this.stateChangeHandler;
    }

    public void setStateChangeHandler(DataProvider<Boolean> stateChangeHandler) {
        this.stateChangeHandler = stateChangeHandler;
    }

    public boolean isStateChangeEnabled() {
        return this.stateChangeHandler == null || this.stateChangeHandler.provide() != false;
    }

    public boolean isAnimating() {
        return this.animator != null && this.animator.isRunning();
    }

    public boolean invertExpandState() {
        return this.invertExpandState(this.animate);
    }

    public boolean invertExpandState(boolean animate) {
        return this.setExpanded(!this.isExpanded(), animate);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean setExpanded(boolean expanded) {
        return this.setExpanded(expanded, this.isShowing() && this.animate);
    }

    public boolean setExpanded(boolean expanded, boolean animate) {
        if (this.isEnabled()) {
            if (expanded) {
                return this.expand(animate);
            }
            return this.collapse(animate);
        }
        return false;
    }

    public boolean collapse() {
        return this.collapse(this.animate);
    }

    public boolean collapse(boolean animate) {
        if (!this.expanded || !this.isStateChangeEnabled()) {
            return false;
        }
        this.stopAnimation();
        this.expanded = false;
        this.setStateIcons();
        this.fireCollapsing();
        if (animate && this.isShowing()) {
            this.animator = new WebTimer("WebCollapsiblePane.collapseTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WebCollapsiblePane.this.transitionProgress > 0.0f) {
                        WebCollapsiblePane.this.transitionProgress = Math.max(0.0f, WebCollapsiblePane.this.transitionProgress - WebCollapsiblePane.this.expandSpeed);
                        WebCollapsiblePane.this.revalidate();
                    } else {
                        WebCollapsiblePane.this.transitionProgress = 0.0f;
                        WebCollapsiblePane.this.finishCollapseAction();
                        WebCollapsiblePane.this.animator.stop();
                    }
                }
            });
            this.animator.start();
        } else {
            this.transitionProgress = 0.0f;
            this.finishCollapseAction();
        }
        return true;
    }

    protected void finishCollapseAction() {
        this.updateHeaderSides();
        if (this.content != null) {
            this.content.setVisible(false);
        }
        this.revalidate();
        this.repaint();
        this.fireCollapsed();
    }

    public boolean expand() {
        return this.expand(this.animate);
    }

    public boolean expand(boolean animate) {
        if (this.expanded || !this.isStateChangeEnabled()) {
            return false;
        }
        this.stopAnimation();
        this.expanded = true;
        this.setStateIcons();
        if (this.content != null) {
            this.content.setVisible(true);
        }
        this.updateHeaderSides();
        this.fireExpanding();
        if (animate && this.isShowing()) {
            this.animator = new WebTimer("WebCollapsiblePane.expandTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WebCollapsiblePane.this.transitionProgress < 1.0f) {
                        WebCollapsiblePane.this.transitionProgress = Math.min(1.0f, WebCollapsiblePane.this.transitionProgress + WebCollapsiblePane.this.expandSpeed);
                        WebCollapsiblePane.this.revalidate();
                    } else {
                        WebCollapsiblePane.this.transitionProgress = 1.0f;
                        WebCollapsiblePane.this.finishExpandAction();
                        WebCollapsiblePane.this.animator.stop();
                    }
                }
            });
            this.animator.start();
        } else {
            this.transitionProgress = 1.0f;
            this.finishExpandAction();
        }
        return true;
    }

    protected void finishExpandAction() {
        this.revalidate();
        this.repaint();
        this.fireExpanded();
    }

    protected void stopAnimation() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
    }

    public int getTitlePanePostion() {
        return this.titlePanePostion;
    }

    public void setTitlePanePostion(int titlePanePostion) {
        this.titlePanePostion = titlePanePostion;
        this.updateDefaultTitleComponent();
        this.updateDefaultTitleBorder();
        this.updateHeaderPosition();
        this.updateStateIcons();
        this.updateStateIconPosition();
    }

    public Insets getContentMargin() {
        return this.contentMargin;
    }

    public void setContentMargin(Insets margin) {
        this.contentMargin = margin;
        this.contentPanel.setMargin(margin);
        this.revalidate();
    }

    public void setContentMargin(int top, int left, int bottom, int right) {
        this.setContentMargin(new Insets(top, left, bottom, right));
    }

    public void setContentMargin(int margin) {
        this.setContentMargin(margin, margin, margin, margin);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public Icon getIcon() {
        return this.customTitle ? null : ((WebLabel)this.titleComponent).getIcon();
    }

    public void setIcon(Icon icon) {
        if (!this.customTitle) {
            ((WebLabel)this.titleComponent).setIcon(icon);
            this.updateDefaultTitleBorder();
        }
    }

    public String getTitle() {
        return this.customTitle ? null : ((WebLabel)this.titleComponent).getText();
    }

    public void setTitle(String title) {
        if (!this.customTitle) {
            ((WebLabel)this.titleComponent).setText(title);
        }
    }

    public ImageIcon getCollapseIcon() {
        return this.collapseIcon;
    }

    public void setCollapseIcon(ImageIcon collapseIcon) {
        this.collapseIcon = collapseIcon;
        this.clearCachedCollapseIcons();
        this.setStateIcons();
    }

    public ImageIcon getExpandIcon() {
        return this.expandIcon;
    }

    public void setExpandIcon(ImageIcon expandIcon) {
        this.expandIcon = expandIcon;
        this.clearCachedExpandIcons();
        this.setStateIcons();
    }

    public Insets getStateIconMargin() {
        return this.stateIconMargin;
    }

    public void setStateIconMargin(Insets margin) {
        this.stateIconMargin = margin;
        this.updateStateIconMargin();
    }

    public boolean isRotateStateIcon() {
        return this.rotateStateIcon;
    }

    public void setRotateStateIcon(boolean rotateStateIcon) {
        this.rotateStateIcon = rotateStateIcon;
        this.updateStateIcons();
    }

    public boolean isShowStateIcon() {
        return this.showStateIcon;
    }

    public void setShowStateIcon(boolean showStateIcon) {
        this.showStateIcon = showStateIcon;
        this.updateStateIconPosition();
    }

    public int getStateIconPostion() {
        return this.stateIconPostion;
    }

    public void setStateIconPostion(int stateIconPostion) {
        this.stateIconPostion = stateIconPostion;
        this.updateStateIconPosition();
    }

    protected void updateStateIcons() {
        this.clearCachedCollapseIcons();
        this.clearCachedExpandIcons();
        this.setStateIcons();
    }

    protected void setStateIcons() {
        if (this.expanded) {
            this.expandButton.setIcon(this.getCachedCollapseIcon());
            this.expandButton.setDisabledIcon(this.getCachedDisabledCollapseIcon());
        } else {
            this.expandButton.setIcon(this.getCachedExpandIcon());
            this.expandButton.setDisabledIcon(this.getCachedDisabledExpandIcon());
        }
    }

    protected void clearCachedCollapseIcons() {
        this.cachedCollapseIcon = null;
        this.cachedDisabledCollapseIcon = null;
    }

    protected ImageIcon getCachedCollapseIcon() {
        if (this.cachedCollapseIcon == null) {
            if (!this.rotateStateIcon || this.titlePanePostion == 1 || this.titlePanePostion == 3) {
                this.cachedCollapseIcon = new OrientedIcon(this.collapseIcon);
            } else if (this.titlePanePostion == 2) {
                this.cachedCollapseIcon = ImageUtils.rotateImage90CCW(this.collapseIcon);
            } else if (this.titlePanePostion == 4) {
                this.cachedCollapseIcon = ImageUtils.rotateImage90CW(this.collapseIcon);
            }
        }
        return this.cachedCollapseIcon;
    }

    protected ImageIcon getCachedDisabledCollapseIcon() {
        if (this.cachedDisabledCollapseIcon == null) {
            this.cachedDisabledCollapseIcon = ImageUtils.createDisabledCopy(this.getCachedCollapseIcon());
        }
        return this.cachedDisabledCollapseIcon;
    }

    protected void clearCachedExpandIcons() {
        this.cachedExpandIcon = null;
        this.cachedDisabledExpandIcon = null;
    }

    protected ImageIcon getCachedExpandIcon() {
        if (this.cachedExpandIcon == null) {
            boolean ltr = this.getComponentOrientation().isLeftToRight();
            if (!this.rotateStateIcon || this.titlePanePostion == 1 || this.titlePanePostion == 3) {
                this.cachedExpandIcon = this.expandIcon;
            } else if (ltr ? this.titlePanePostion == 2 : this.titlePanePostion == 4) {
                this.cachedExpandIcon = ImageUtils.rotateImage90CCW(this.expandIcon);
            } else if (ltr ? this.titlePanePostion == 4 : this.titlePanePostion == 2) {
                this.cachedExpandIcon = ImageUtils.rotateImage90CW(this.expandIcon);
            }
        }
        return this.cachedExpandIcon;
    }

    protected ImageIcon getCachedDisabledExpandIcon() {
        if (this.cachedDisabledExpandIcon == null) {
            this.cachedDisabledExpandIcon = ImageUtils.createDisabledCopy(this.getCachedExpandIcon());
        }
        return this.cachedDisabledExpandIcon;
    }

    public WebPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public WebButton getExpandButton() {
        return this.expandButton;
    }

    public Component getTitleComponent() {
        return this.titleComponent;
    }

    public void setTitleComponent(Component titleComponent) {
        if (this.titleComponent != null) {
            this.headerPanel.remove(this.titleComponent);
        }
        if (titleComponent != null) {
            this.headerPanel.add(titleComponent, (Object)"Center");
        }
        this.titleComponent = titleComponent;
        this.customTitle = true;
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        if (this.content != null) {
            this.contentPanel.remove(content);
        }
        this.content = content;
        content.setVisible(this.transitionProgress > 0.0f);
        this.contentPanel.add(content, (Object)"Center");
        this.revalidate();
    }

    public List<CollapsiblePaneListener> getCollapsiblePaneListeners() {
        return CollectionUtils.copy(this.listeners);
    }

    public void setCollapsiblePaneListeners(List<CollapsiblePaneListener> listeners) {
        this.listeners = listeners;
    }

    public void addCollapsiblePaneListener(CollapsiblePaneListener listener) {
        this.listeners.add(listener);
    }

    public void removeCollapsiblePaneListener(CollapsiblePaneListener listener) {
        this.listeners.remove(listener);
    }

    public void fireExpanding() {
        for (CollapsiblePaneListener listener : CollectionUtils.copy(this.listeners)) {
            listener.expanding(this);
        }
    }

    public void fireExpanded() {
        for (CollapsiblePaneListener listener : CollectionUtils.copy(this.listeners)) {
            listener.expanded(this);
        }
    }

    public void fireCollapsing() {
        for (CollapsiblePaneListener listener : CollectionUtils.copy(this.listeners)) {
            listener.collapsing(this);
        }
    }

    public void fireCollapsed() {
        for (CollapsiblePaneListener listener : CollectionUtils.copy(this.listeners)) {
            listener.collapsed(this);
        }
    }

    public float getTransitionProgress() {
        return this.transitionProgress;
    }

    public Dimension getBasePreferredSize() {
        Dimension ps = this.getPreferredSize();
        if (this.content == null || this.transitionProgress <= 0.0f) {
            return ps;
        }
        Dimension cps = this.content.getPreferredSize();
        if (this.titlePanePostion == 1 || this.titlePanePostion == 3) {
            return new Dimension(ps.width, ps.height - Math.round((float)cps.height * this.transitionProgress));
        }
        return new Dimension(ps.width - Math.round((float)cps.width * this.transitionProgress), ps.height);
    }

    @Override
    public void setFocusable(boolean focusable) {
        this.expandButton.setFocusable(focusable);
    }

    @Override
    public boolean isFocusable() {
        return this.expandButton.isFocusable();
    }

    @Override
    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((Component)this, data);
    }

    @Override
    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((Component)this, key, data);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public void registerSettings(String key) {
        SettingsManager.registerComponent((Component)this, key);
    }

    @Override
    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((Component)this, key, defaultValueClass);
    }

    @Override
    public void registerSettings(String key, Object defaultValue) {
        SettingsManager.registerComponent((Component)this, key, defaultValue);
    }

    @Override
    public void registerSettings(String group, String key) {
        SettingsManager.registerComponent((Component)this, group, key);
    }

    @Override
    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent((Component)this, group, key, defaultValueClass);
    }

    @Override
    public void registerSettings(String group, String key, Object defaultValue) {
        SettingsManager.registerComponent((Component)this, group, key, defaultValue);
    }

    @Override
    public void registerSettings(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, key, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public <T extends DefaultValue> void registerSettings(String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, key, defaultValueClass, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, key, defaultValue, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public <T extends DefaultValue> void registerSettings(String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, group, key, defaultValueClass, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent((Component)this, group, key, defaultValue, loadInitialSettings, applySettingsChanges);
    }

    @Override
    public void registerSettings(SettingsProcessor settingsProcessor) {
        SettingsManager.registerComponent((Component)this, settingsProcessor);
    }

    @Override
    public void unregisterSettings() {
        SettingsManager.unregisterComponent(this);
    }

    @Override
    public void loadSettings() {
        SettingsManager.loadComponentSettings(this);
    }

    @Override
    public void saveSettings() {
        SettingsManager.saveComponentSettings(this);
    }
}

