/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.BorderPainter;
import com.alee.extended.painter.TitlePosition;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class TitledBorderPainter<E extends JComponent>
extends BorderPainter<E>
implements SwingConstants {
    protected int titleOffset = 4;
    protected int titleBorderGap = 3;
    protected TitlePosition titlePosition = TitlePosition.onLine;
    protected Color foreground = null;
    protected Color background = null;
    protected boolean clipTitleBackground = true;
    protected int titleAlignment;
    protected int titleSide;
    protected String titleText;
    protected int w;
    protected int h;
    protected boolean emptyTitle;
    protected FontMetrics fontMetrics;
    protected int titleAreaHeight;
    protected int titleWidth;
    protected int titleX;
    protected int titleY;
    protected double borderCenter;
    protected double borderPosition;
    protected Shape borderShape;
    protected boolean doClip;

    public TitledBorderPainter() {
        this((String)null);
    }

    public TitledBorderPainter(String titleText) {
        this(titleText, 10);
    }

    public TitledBorderPainter(String titleText, int titleAlignment) {
        this(titleText, titleAlignment, 1);
    }

    public TitledBorderPainter(String titleText, int titleAlignment, int titleSide) {
        this.titleText = titleText;
        this.titleAlignment = titleAlignment;
        this.titleSide = titleSide;
    }

    public int getTitleOffset() {
        return this.titleOffset;
    }

    public void setTitleOffset(int titleOffset) {
        this.titleOffset = titleOffset;
        this.updateAll();
    }

    public int getTitleBorderGap() {
        return this.titleBorderGap;
    }

    public void setTitleBorderGap(int titleBorderGap) {
        this.titleBorderGap = titleBorderGap;
        this.updateAll();
    }

    public int getTitleSide() {
        return this.titleSide;
    }

    public void setTitleSide(int titleSide) {
        this.titleSide = titleSide;
        this.updateAll();
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
        this.repaint();
    }

    public TitlePosition getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(TitlePosition titlePosition) {
        this.titlePosition = titlePosition;
        this.repaint();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.repaint();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
        this.repaint();
    }

    public boolean isClipTitleBackground() {
        return this.clipTitleBackground;
    }

    public void setClipTitleBackground(boolean clipTitleBackground) {
        this.clipTitleBackground = clipTitleBackground;
        this.repaint();
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
        this.updateAll();
    }

    @Override
    public Insets getMargin(E c) {
        Insets m = super.getMargin(c);
        if (!this.isEmptyTitle()) {
            switch (this.titleSide) {
                case 1: {
                    m.top += this.getTitleAreaHeight(c);
                    break;
                }
                case 2: {
                    m.left += this.getTitleAreaHeight(c);
                    break;
                }
                case 3: {
                    m.bottom += this.getTitleAreaHeight(c);
                    break;
                }
                case 4: {
                    m.right += this.getTitleAreaHeight(c);
                }
            }
        }
        return m;
    }

    @Override
    public Dimension getPreferredSize(E c) {
        if (this.isEmptyTitle()) {
            return super.getPreferredSize(c);
        }
        int titleAreaHeight = this.getTitleAreaHeight(c);
        int titleWidth = ((JComponent)c).getFontMetrics(((Component)c).getFont()).stringWidth(this.titleText);
        int border = Math.max(this.width, this.round);
        int title = Math.max(titleAreaHeight, border);
        switch (this.titleSide) {
            case 1: 
            case 3: {
                return new Dimension(border * 2 + titleWidth + this.titleOffset * 2 + this.titleBorderGap * 2, title + border);
            }
            case 2: 
            case 4: {
                return new Dimension(title + border, border * 2 + titleWidth + this.titleOffset * 2 + this.titleBorderGap * 2);
            }
        }
        return null;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        this.w = ((JComponent)c).getWidth();
        this.h = ((JComponent)c).getHeight();
        this.emptyTitle = this.isEmptyTitle();
        this.fontMetrics = this.emptyTitle ? null : ((JComponent)c).getFontMetrics(((Component)c).getFont());
        this.titleWidth = this.emptyTitle ? 0 : this.fontMetrics.stringWidth(this.titleText);
        this.titleAreaHeight = this.getTitleAreaHeight(c);
        this.titleX = this.getTitleX(c);
        this.titleY = this.getTitleY();
        this.borderCenter = (double)this.width / 2.0;
        this.borderPosition = this.getBorderPosition();
        this.borderShape = this.getBorderShape();
        this.doClip = this.clipTitleBackground && !this.emptyTitle && this.titlePosition.equals((Object)TitlePosition.onLine);
        Object aa = LafUtils.setupAntialias(g2d);
        Stroke os = LafUtils.setupStroke(g2d, this.stroke, this.stroke != null);
        if (this.background != null && !this.doClip) {
            g2d.setPaint(this.background);
            g2d.fill(this.borderShape);
        }
        Shape clipShape = this.doClip ? this.getBorderClipShape() : null;
        Shape oldClip = LafUtils.subtractClip(g2d, clipShape, this.doClip);
        if (this.background != null && this.doClip) {
            g2d.setPaint(this.background);
            g2d.fill(this.borderShape);
        }
        g2d.setPaint(this.color);
        g2d.draw(this.borderShape);
        LafUtils.restoreClip(g2d, oldClip, this.doClip);
        LafUtils.restoreStroke(g2d, os, this.stroke != null);
        LafUtils.restoreAntialias(g2d, aa);
        if (!this.emptyTitle) {
            g2d.setPaint(this.foreground != null ? this.foreground : ((Component)c).getForeground());
            switch (this.titleSide) {
                case 1: 
                case 3: {
                    Map hints = SwingUtils.setupTextAntialias(g2d);
                    g2d.drawString(this.titleText, this.titleX, this.titleY);
                    SwingUtils.restoreTextAntialias(g2d, hints);
                    break;
                }
            }
        }
    }

    protected int getTitleX(E c) {
        boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
        if (this.titleAlignment == 2 || this.titleAlignment == 10 && ltr || this.titleAlignment == 11 && !ltr) {
            return Math.max(this.width, this.round) + this.titleOffset + this.titleBorderGap;
        }
        if (this.titleAlignment == 4 || this.titleAlignment == 11 && ltr || this.titleAlignment == 10 && !ltr) {
            return this.w - Math.max(this.width, this.round) - this.titleOffset - this.titleBorderGap - this.titleWidth;
        }
        return this.w / 2 - this.titleWidth / 2;
    }

    protected int getTitleY() {
        int fontDescent = this.fontMetrics != null ? this.fontMetrics.getDescent() : 0;
        switch (this.titleSide) {
            case 1: {
                return this.titlePosition.equals((Object)TitlePosition.aboveLive) ? this.titleAreaHeight - this.width - fontDescent : this.titleAreaHeight - fontDescent;
            }
            case 3: {
                return this.titlePosition.equals((Object)TitlePosition.belowLine) ? this.h - this.width - fontDescent : this.h - fontDescent;
            }
            case 2: {
                break;
            }
        }
        return 0;
    }

    protected double getBorderPosition() {
        if (this.emptyTitle) {
            return this.borderCenter;
        }
        if (this.titlePosition.equals((Object)TitlePosition.onLine)) {
            return (double)this.titleAreaHeight / 2.0;
        }
        if (this.titlePosition.equals((Object)TitlePosition.aboveLive)) {
            return (double)this.titleAreaHeight - this.borderCenter;
        }
        return this.borderCenter;
    }

    protected int getTitleAreaHeight(E c) {
        if (this.isEmptyTitle()) {
            return this.width;
        }
        int height = ((JComponent)c).getFontMetrics(((Component)c).getFont()).getHeight();
        return this.titlePosition.equals((Object)TitlePosition.onLine) ? height : height + this.width;
    }

    protected boolean isEmptyTitle() {
        return this.titleText == null;
    }

    protected Shape getBorderShape() {
        RectangularShape rect = null;
        switch (this.titleSide) {
            case 1: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderPosition, (double)this.w - this.borderCenter * 2.0, (double)this.h - this.borderPosition - this.borderCenter);
                break;
            }
            case 2: {
                rect = new Rectangle2D.Double(this.borderPosition, this.borderCenter, (double)this.w - this.borderPosition - this.borderCenter, (double)this.h - this.borderCenter * 2.0);
                break;
            }
            case 3: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderCenter, (double)this.w - this.borderCenter * 2.0, (double)this.h - this.borderPosition - this.borderCenter);
                break;
            }
            case 4: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderCenter, (double)this.w - this.borderPosition - this.borderCenter, (double)this.h - this.borderCenter * 2.0);
            }
        }
        return this.round > 0 ? new RoundRectangle2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY(), ((RectangularShape)rect).getWidth(), ((RectangularShape)rect).getHeight(), this.round * 2, this.round * 2) : rect;
    }

    protected Shape getBorderClipShape() {
        if (this.emptyTitle) {
            return null;
        }
        switch (this.titleSide) {
            case 1: {
                return new RoundRectangle2D.Double(this.titleX - this.titleBorderGap, this.borderPosition - (double)(this.titleAreaHeight / 2), this.titleWidth + this.titleBorderGap * 2, this.titleAreaHeight, 3.0, 3.0);
            }
            case 3: {
                return new RoundRectangle2D.Double(this.titleX - this.titleBorderGap, (double)this.h - this.borderPosition - (double)(this.titleAreaHeight / 2), this.titleWidth + this.titleBorderGap * 2, this.titleAreaHeight, 3.0, 3.0);
            }
            case 2: {
                return null;
            }
            case 4: {
                return null;
            }
        }
        return null;
    }
}

