/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.AbstractPainter;
import com.alee.extended.painter.BorderPainterStyle;
import com.alee.utils.LafUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class BorderPainter<E extends JComponent>
extends AbstractPainter<E> {
    protected int width = BorderPainterStyle.width;
    protected int round = BorderPainterStyle.round;
    protected Color color = BorderPainterStyle.color;
    protected Stroke stroke = null;

    public BorderPainter() {
        this.updateStroke();
    }

    public BorderPainter(int width) {
        this.width = width;
    }

    public BorderPainter(Color color) {
        this.color = color;
        this.updateStroke();
    }

    public BorderPainter(int width, Color color) {
        this.width = width;
        this.color = color;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateStroke();
        this.updateAll();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        this.updateStroke();
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.repaint();
    }

    protected void updateStroke() {
        this.stroke = new BasicStroke(this.getWidth(), 1, 1);
    }

    @Override
    public Dimension getPreferredSize(E c) {
        return new Dimension(Math.max(this.width * 2, this.round * 2), Math.max(this.width * 2, this.round * 2));
    }

    @Override
    public Insets getMargin(E c) {
        Insets m = super.getMargin(c);
        return new Insets(m.top + this.width, m.left + this.width, m.bottom + this.width, m.right + this.width);
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E c) {
        if (this.width > 0 && this.stroke != null && this.color != null) {
            Object aa = LafUtils.setupAntialias(g2d);
            Stroke os = LafUtils.setupStroke(g2d, this.stroke, this.stroke != null);
            g2d.setPaint(this.color);
            g2d.draw(this.getBorderShape(bounds));
            LafUtils.restoreStroke(g2d, os, this.stroke != null);
            LafUtils.restoreAntialias(g2d, aa);
        }
    }

    protected RectangularShape getBorderShape(Rectangle bounds) {
        double shear;
        double d = shear = this.width == 1 ? 0.0 : (double)this.width / 2.0;
        if (this.round > 0) {
            return new RoundRectangle2D.Double((double)bounds.x + shear, (double)bounds.y + shear, (double)bounds.width - shear * 2.0 - 1.0, (double)bounds.height - shear * 2.0 - 1.0, this.round * 2, this.round * 2);
        }
        return new Rectangle2D.Double((double)bounds.x + shear, (double)bounds.y + shear, (double)bounds.width - shear * 2.0 - 1.0, (double)bounds.height - shear * 2.0 - 1.0);
    }
}

