/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.laf.StyleConstants;
import com.alee.laf.label.WebLabel;
import com.alee.managers.language.LanguageMethods;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;

public class WebStepLabel
extends WebLabel
implements ShapeProvider,
LanguageMethods {
    private Color topBgColor = StyleConstants.topBgColor;
    private Color bottomBgColor = StyleConstants.bottomBgColor;
    private Color selectedBgColor = StyleConstants.selectedBgColor;
    private Color borderColor = StyleConstants.darkBorderColor;
    private Color disabledBorderColor = StyleConstants.disabledBorderColor;
    private final Stroke stroke = new BasicStroke(2.5f, 1, 1, 1.0f);
    private boolean selected = false;

    public WebStepLabel() {
        this.setupSettings();
    }

    public WebStepLabel(Icon image) {
        super(image);
        this.setupSettings();
    }

    public WebStepLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.setupSettings();
    }

    public WebStepLabel(String text) {
        super(text);
        this.setupSettings();
    }

    public WebStepLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.setupSettings();
    }

    public WebStepLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.setupSettings();
    }

    protected void setupSettings() {
        this.setOpaque(false);
        this.setDrawShade(true);
        this.setForeground(Color.DARK_GRAY);
        this.setShadeColor(Color.LIGHT_GRAY);
        this.setMargin(8);
        this.setHorizontalAlignment(0);
        SwingUtils.setBoldFont(this);
        SwingUtils.setFontSize(this, 20);
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color topBgColor) {
        this.topBgColor = topBgColor;
        this.repaint();
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color bottomBgColor) {
        this.bottomBgColor = bottomBgColor;
        this.repaint();
    }

    public Color getSelectedBgColor() {
        return this.selectedBgColor;
    }

    public void setSelectedBgColor(Color selectedBgColor) {
        this.selectedBgColor = selectedBgColor;
        this.repaint();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.repaint();
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        this.disabledBorderColor = disabledBorderColor;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    @Override
    public Shape provideShape() {
        int width = this.getWidth();
        int height = this.getHeight();
        int length = Math.min(width, height);
        return new RoundRectangle2D.Double(width / 2 - length / 2 + 1, height / 2 - length / 2 + 1, length - 3, length - 3, this.getWidth() - 4, this.getHeight() - 4);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Object aa = LafUtils.setupAntialias(g2d);
        int width = this.getWidth();
        int height = this.getHeight();
        int length = Math.min(width, height);
        if (this.getBackground() != null) {
            if (this.selected) {
                g2d.setPaint(this.selectedBgColor);
            } else {
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.topBgColor, 0.0f, this.getHeight(), this.bottomBgColor));
            }
            g2d.fillRoundRect(width / 2 - length / 2 + 1, height / 2 - length / 2 + 1, length - 2, length - 2, this.getWidth() - 4, this.getHeight() - 4);
        }
        if (this.getBorderColor() != null) {
            g2d.setStroke(this.stroke);
            g2d.setPaint(this.isEnabled() ? this.borderColor : this.disabledBorderColor);
            g2d.drawRoundRect(width / 2 - length / 2 + 1, height / 2 - length / 2 + 1, length - 3, length - 3, this.getWidth() - 4, this.getHeight() - 4);
        }
        LafUtils.restoreAntialias(g2d, aa);
        super.paintComponent(g);
    }

    @Override
    public Dimension getPreferredSize() {
        int max;
        Dimension ps = super.getPreferredSize();
        ps.width = max = Math.max(ps.width, ps.height);
        ps.height = max;
        return ps;
    }
}

