/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.extended.drag.ImageDropHandler;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class WebImageDrop
extends JComponent {
    protected int round;
    protected int width;
    protected int height;
    protected BufferedImage actualImage;
    protected BufferedImage image;

    public WebImageDrop() {
        this(64, 64);
    }

    public WebImageDrop(int width, int height) {
        this(width, height, null);
    }

    public WebImageDrop(int width, int height, BufferedImage image) {
        this.width = width;
        this.height = height;
        this.round = Math.max(Math.max(width, height) / 10, 3);
        this.actualImage = image;
        this.image = image;
        this.updatePreview();
        SwingUtils.setOrientation(this);
        this.setTransferHandler(new ImageDropHandler(){

            @Override
            protected boolean imagesImported(List<ImageIcon> images) {
                for (ImageIcon image : images) {
                    try {
                        WebImageDrop.this.setImage(ImageUtils.getBufferedImage(image));
                        return true;
                    }
                    catch (Throwable e) {
                    }
                }
                return false;
            }
        });
    }

    public BufferedImage getImage() {
        return this.actualImage;
    }

    public BufferedImage getThumbnail() {
        return this.image;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        this.updatePreview();
    }

    public int getImageWidth() {
        return this.width;
    }

    public void setImageWidth(int width) {
        this.width = width;
        this.updatePreview();
    }

    public int getImageHeight() {
        return this.height;
    }

    public void setImageHeight(int height) {
        this.height = height;
        this.updatePreview();
    }

    public void setImage(BufferedImage image) {
        this.actualImage = image;
        this.image = image;
        this.updatePreview();
        this.repaint();
    }

    protected void updatePreview() {
        if (this.image != null) {
            this.image = ImageUtils.createPreviewImage(this.actualImage, this.width, this.height);
            BufferedImage f = ImageUtils.createCompatibleImage(this.image, 3);
            Graphics2D g2d = f.createGraphics();
            LafUtils.setupAntialias(g2d);
            g2d.setPaint(Color.WHITE);
            g2d.fillRoundRect(0, 0, this.image.getWidth(), this.image.getHeight(), this.round * 2, this.round * 2);
            g2d.setComposite(AlphaComposite.getInstance(5));
            g2d.drawImage((Image)this.image, 0, 0, null);
            g2d.dispose();
            this.image.flush();
            this.image = f;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        LafUtils.setupAntialias(g2d);
        if (this.image != null) {
            g2d.drawImage((Image)this.image, this.getWidth() / 2 - this.image.getWidth() / 2 + 1, this.getHeight() / 2 - this.image.getHeight() / 2 + 1, null);
        }
        RoundRectangle2D.Double border = new RoundRectangle2D.Double(this.getWidth() / 2 - this.width / 2 + 1, this.getHeight() / 2 - this.height / 2 + 1, this.width - (this.image == null ? 3 : 1), this.height - (this.image == null ? 3 : 1), this.round * 2, this.round * 2);
        if (this.image == null) {
            g2d.setPaint(new Color(242, 242, 242));
            g2d.fill(border);
            g2d.setStroke(new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{Math.max(5.0f, Math.min((float)(Math.max(this.width, this.height) / 6), 10.0f)), 8.0f}, 4.0f));
            g2d.setPaint(Color.LIGHT_GRAY);
            g2d.draw(border);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.width + 2, this.height + 2);
    }
}

