/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.drag.FileDragAndDropHandler;
import com.alee.extended.filechooser.FilesSelectionListener;
import com.alee.extended.filechooser.WebFilePlate;
import com.alee.extended.filefilter.AbstractFileFilter;
import com.alee.extended.layout.WrapFlowLayout;
import com.alee.laf.StyleConstants;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class WebFileDrop
extends WebPanel
implements LanguageMethods {
    public static final ImageIcon CROSS_ICON = new ImageIcon(WebFileDrop.class.getResource("icons/cross.png"));
    private static final BasicStroke dashStroke = new BasicStroke(3.0f, 1, 1, 1.0f, new float[]{8.0f, 8.0f}, 0.0f);
    public int dashRound = StyleConstants.smallRound;
    public int dashSideSpacing = 10;
    private Color dropBackground = new Color(242, 242, 242);
    private Color dropBorder = new Color(192, 192, 192);
    private final List<FilesSelectionListener> listeners = new ArrayList<FilesSelectionListener>(1);
    private boolean showRemoveButton = true;
    private boolean showFileExtensions = false;
    private boolean filesDragEnabled = false;
    private int dragAction = 2;
    private boolean filesDropEnabled = true;
    private boolean allowSameFiles = false;
    private AbstractFileFilter fileFilter = null;
    private boolean showDropText = true;
    private float dropTextOpacity = 1.0f;
    private String dropText = null;
    private List<File> selectedFiles = new ArrayList<File>();

    public WebFileDrop() {
        this.setBackground(Color.WHITE);
        this.setLayout(new WrapFlowLayout(true));
        this.setMargin(1, 1, 1, 1);
        this.setFocusable(true);
        this.setFont(SwingUtils.getDefaultLabelFont().deriveFont(1).deriveFont(20.0f));
        this.setShowDefaultDropText(true);
        this.setTransferHandler(new FileDragAndDropHandler(){

            @Override
            public boolean isDropEnabled() {
                return WebFileDrop.this.filesDropEnabled;
            }

            @Override
            public boolean filesDropped(List<File> files) {
                boolean anyAdded = false;
                for (File file : files) {
                    if (WebFileDrop.this.fileFilter != null && !WebFileDrop.this.fileFilter.accept(file) || !WebFileDrop.this.allowSameFiles && FileUtils.containtsFile(WebFileDrop.this.selectedFiles, file)) continue;
                    WebFileDrop.this.selectedFiles.add(file);
                    WebFileDrop.this.add((Component)WebFileDrop.this.createFilePlate(file));
                    anyAdded = true;
                }
                if (anyAdded) {
                    WebFileDrop.this.revalidate();
                    WebFileDrop.this.repaint();
                    WebFileDrop.this.fireSelectionChanged(WebFileDrop.this.selectedFiles);
                }
                return anyAdded;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WebFileDrop.this.requestFocusInWindow();
            }
        });
        this.addFileSelectionListener(new FilesSelectionListener(){
            private int filesCount = 0;
            private WebTimer animator = null;

            @Override
            public void selectionChanged(List<File> selectedFiles) {
                if (this.filesCount == 0 && selectedFiles.size() > 0) {
                    this.stopAnimator();
                    this.filesCount = selectedFiles.size();
                    this.animator = new WebTimer("WebFileDrop.textFadeOutTimer", (long)StyleConstants.animationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (WebFileDrop.this.dropTextOpacity > 0.0f) {
                                WebFileDrop.this.dropTextOpacity -= 0.1f;
                            }
                            WebFileDrop.this.dropTextOpacity = Math.max(WebFileDrop.this.dropTextOpacity, 0.0f);
                            WebFileDrop.this.repaint();
                            if (WebFileDrop.this.dropTextOpacity <= 0.0f) {
                                animator.stop();
                            }
                        }
                    });
                    this.animator.start();
                } else if (this.filesCount > 0 && selectedFiles.size() == 0) {
                    this.stopAnimator();
                    this.filesCount = selectedFiles.size();
                    this.animator = new WebTimer("WebFileDrop.textFadeInTimer", (long)StyleConstants.animationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (WebFileDrop.this.dropTextOpacity < 1.0f) {
                                WebFileDrop.this.dropTextOpacity += 0.1f;
                            }
                            WebFileDrop.this.dropTextOpacity = Math.min(WebFileDrop.this.dropTextOpacity, 1.0f);
                            WebFileDrop.this.repaint();
                            if (WebFileDrop.this.dropTextOpacity >= 1.0f) {
                                animator.stop();
                            }
                        }
                    });
                    this.animator.start();
                }
            }

            private void stopAnimator() {
                if (this.animator != null && this.animator.isRunning()) {
                    this.animator.stop();
                }
            }
        });
    }

    public boolean isShowDropText() {
        return this.showDropText;
    }

    public void setShowDropText(boolean showDropText) {
        this.showDropText = showDropText;
        this.repaint();
    }

    public boolean isFilesDragEnabled() {
        return this.filesDragEnabled;
    }

    public void setFilesDragEnabled(boolean filesDragEnabled) {
        this.filesDragEnabled = filesDragEnabled;
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public void setDragAction(int dragAction) {
        this.dragAction = dragAction;
    }

    public boolean isFilesDropEnabled() {
        return this.filesDropEnabled;
    }

    public void setFilesDropEnabled(boolean filesDropEnabled) {
        this.filesDropEnabled = filesDropEnabled;
    }

    public List<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setSelectedFiles(List<File> selectedFiles) {
        ArrayList<File> accepted = new ArrayList<File>();
        for (File file : selectedFiles) {
            if (this.fileFilter != null && !this.fileFilter.accept(file) || !this.allowSameFiles && FileUtils.containtsFile(accepted, file)) continue;
            accepted.add(file);
        }
        if (!FileUtils.equals(accepted, this.selectedFiles)) {
            this.selectedFiles = accepted;
            this.updateFilesList();
            this.fireSelectionChanged(accepted);
        }
    }

    public boolean isAllowSameFiles() {
        return this.allowSameFiles;
    }

    public void setAllowSameFiles(boolean allowSameFiles) {
        this.allowSameFiles = allowSameFiles;
        this.setSelectedFiles(this.selectedFiles);
    }

    public AbstractFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(AbstractFileFilter fileFilter) {
        this.fileFilter = fileFilter;
        this.setSelectedFiles(this.selectedFiles);
    }

    public boolean isShowRemoveButton() {
        return this.showRemoveButton;
    }

    public void setShowRemoveButton(boolean showRemoveButton) {
        this.showRemoveButton = showRemoveButton;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((WebFilePlate)this.getComponent(i)).setShowRemoveButton(showRemoveButton);
        }
    }

    public boolean isShowFileExtensions() {
        return this.showFileExtensions;
    }

    public void setShowFileExtensions(boolean showFileExtensions) {
        this.showFileExtensions = showFileExtensions;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((WebFilePlate)this.getComponent(i)).setShowFileExtensions(showFileExtensions);
        }
    }

    public Color getDropBackground() {
        return this.dropBackground;
    }

    public void setDropBackground(Color dropBackground) {
        this.dropBackground = dropBackground;
        this.repaint();
    }

    public Color getDropBorder() {
        return this.dropBorder;
    }

    public void setDropBorder(Color dropBorder) {
        this.dropBorder = dropBorder;
        this.repaint();
    }

    public int getDashRound() {
        return this.dashRound;
    }

    public void setDashRound(int dashRound) {
        this.dashRound = dashRound;
        this.repaint();
    }

    public int getDashSideSpacing() {
        return this.dashSideSpacing;
    }

    public void setDashSideSpacing(int dashSideSpacing) {
        this.dashSideSpacing = dashSideSpacing;
        this.repaint();
    }

    public String getDropText() {
        return this.dropText;
    }

    public void setDropText(String dropText) {
        this.dropText = dropText;
        this.repaint();
    }

    public void setShowDefaultDropText(boolean defaultDropText) {
        if (defaultDropText) {
            this.setLanguage("weblaf.ex.filedrop.drop", new Object[0]);
        } else {
            this.removeLanguage();
        }
        this.repaint();
    }

    public boolean isDropTextVisible() {
        return this.dropText != null && this.showDropText && this.dropTextOpacity > 0.0f;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isDropTextVisible()) {
            Graphics2D g2d = (Graphics2D)g;
            Composite old = LafUtils.setupAlphaComposite(g2d, Float.valueOf(this.dropTextOpacity));
            Object aa = LafUtils.setupAntialias(g2d);
            int dashX = this.dashSideSpacing + Math.round(dashStroke.getLineWidth() / 2.0f);
            int dashY = this.dashSideSpacing + Math.round(dashStroke.getLineWidth() / 2.0f);
            int dashWidth = this.getWidth() - this.dashSideSpacing * 2 - Math.round(dashStroke.getLineWidth());
            int dashHeight = this.getHeight() - this.dashSideSpacing * 2 - Math.round(dashStroke.getLineWidth());
            g2d.setPaint(this.dropBackground);
            g2d.fillRoundRect(dashX, dashY, dashWidth, dashHeight, this.dashRound * 2, this.dashRound * 2);
            Stroke os = LafUtils.setupStroke(g2d, dashStroke);
            g2d.setPaint(this.dropBorder);
            g2d.drawRoundRect(this.dashSideSpacing, this.dashSideSpacing, this.getWidth() - this.dashSideSpacing * 2 - 1, this.getHeight() - this.dashSideSpacing * 2 - 1, this.dashRound * 2, this.dashRound * 2);
            LafUtils.restoreStroke(g2d, os);
            LafUtils.restoreAntialias(g2d, aa);
            FontMetrics fm = g2d.getFontMetrics();
            if (dashWidth >= fm.stringWidth(this.dropText) && dashHeight > fm.getHeight()) {
                Map hints = SwingUtils.setupTextAntialias(g2d);
                Point ts = LafUtils.getTextCenterShear(fm, this.dropText);
                g2d.drawString(this.dropText, this.getWidth() / 2 + ts.x, this.getHeight() / 2 + ts.y);
                SwingUtils.restoreTextAntialias(g2d, hints);
            }
            LafUtils.restoreComposite(g2d, old);
        }
    }

    private void updateFilesList() {
        this.removeAll();
        for (File file : this.selectedFiles) {
            this.add((Component)this.createFilePlate(file));
        }
        this.revalidate();
        this.repaint();
    }

    private WebFilePlate createFilePlate(final File file) {
        WebFilePlate filePlate = new WebFilePlate(file);
        filePlate.setShowFileExtensions(this.showFileExtensions);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WebFileDrop.this.requestFocusInWindow();
            }
        });
        filePlate.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileDrop.this.selectedFiles.remove(file);
                WebFileDrop.this.fireSelectionChanged(WebFileDrop.this.selectedFiles);
            }
        });
        return filePlate;
    }

    public void addFileSelectionListener(FilesSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeFileSelectionListener(FilesSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireSelectionChanged(List<File> selectedFiles) {
        for (FilesSelectionListener listener : CollectionUtils.copy(this.listeners)) {
            listener.selectionChanged(selectedFiles);
        }
    }

    @Override
    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((Component)this, data);
    }

    @Override
    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((Component)this, key, data);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }
}

