/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.DirectoryChooserListener;
import com.alee.extended.filechooser.PathFieldListener;
import com.alee.extended.filechooser.WebPathField;
import com.alee.extended.filefilter.AbstractFileFilter;
import com.alee.extended.tree.FileTreeNode;
import com.alee.extended.tree.FileTreeRootType;
import com.alee.extended.tree.WebFileTree;
import com.alee.laf.GlobalConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class WebDirectoryChooserPanel
extends WebPanel {
    protected static final ImageIcon FOLDER_UP_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/folder_up.png"));
    protected static final ImageIcon FOLDER_HOME_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/folder_home.png"));
    protected static final ImageIcon FOLDER_NEW_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/folder_new.png"));
    protected static final ImageIcon REFRESH_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/refresh.png"));
    protected static final ImageIcon REMOVE_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/remove.png"));
    protected List<DirectoryChooserListener> listeners = new ArrayList<DirectoryChooserListener>(1);
    protected File selectedDirectory = FileUtils.getDiskRoots()[0];
    protected AbstractFileFilter filter = GlobalConstants.NON_HIDDEN_DIRECTORIES_FILTER;
    protected WebButton folderUp;
    protected WebButton folderHome;
    protected WebButton folderNew;
    protected WebButton refresh;
    protected WebButton remove;
    protected WebPathField webPathField;
    protected WebFileTree fileTree;
    protected TreeSelectionListener fileTreeListener;

    public WebDirectoryChooserPanel() {
        this.setOpaque(true);
        WebToolBar contolsToolbar = new WebToolBar(0);
        contolsToolbar.setToolbarStyle(ToolbarStyle.attached);
        contolsToolbar.setFloatable(false);
        this.folderUp = new WebButton(FOLDER_UP_ICON);
        this.folderUp.setLanguage("weblaf.ex.dirchooser.folderup", new Object[0]);
        this.folderUp.addHotkey(this, Hotkey.ALT_UP).setHotkeyDisplayWay(TooltipWay.down);
        this.folderUp.setRolloverDecoratedOnly(true);
        this.folderUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebDirectoryChooserPanel.this.selectedDirectory != null) {
                    WebDirectoryChooserPanel.this.updateSelectedDirectory(WebDirectoryChooserPanel.this.selectedDirectory.getParentFile(), true, true);
                }
            }
        });
        contolsToolbar.add((Component)this.folderUp);
        this.folderHome = new WebButton(FOLDER_HOME_ICON);
        this.folderHome.setLanguage("weblaf.ex.dirchooser.home", new Object[0]);
        this.folderHome.addHotkey(this, Hotkey.ALT_H).setHotkeyDisplayWay(TooltipWay.trailing);
        this.folderHome.setRolloverDecoratedOnly(true);
        this.folderHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDirectoryChooserPanel.this.updateSelectedDirectory(FileUtils.getUserHome(), true, true);
            }
        });
        contolsToolbar.add((Component)this.folderHome);
        contolsToolbar.addSeparator();
        for (final File file : FileTreeRootType.drives.getRoots()) {
            WebButton root = new WebButton(FileUtils.getFileIcon(file));
            TooltipManager.setTooltip((Component)root, FileUtils.getDisplayFileName(file));
            root.setRolloverDecoratedOnly(true);
            root.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebDirectoryChooserPanel.this.updateSelectedDirectory(file, true, true);
                }
            });
            contolsToolbar.add((Component)root);
        }
        this.refresh = new WebButton(REFRESH_ICON);
        this.refresh.setLanguage("weblaf.ex.dirchooser.refresh", new Object[0]);
        this.refresh.addHotkey(this, Hotkey.F5).setHotkeyDisplayWay(TooltipWay.leading);
        this.refresh.setRolloverDecoratedOnly(true);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebDirectoryChooserPanel.this.selectedDirectory != null) {
                    WebDirectoryChooserPanel.this.fileTree.reloadChilds(WebDirectoryChooserPanel.this.selectedDirectory);
                } else {
                    WebDirectoryChooserPanel.this.fileTree.reloadRootNode();
                }
            }
        });
        contolsToolbar.add((Component)this.refresh, (Object)"END");
        this.folderNew = new WebButton(FOLDER_NEW_ICON);
        this.folderNew.setLanguage("weblaf.ex.dirchooser.newfolder", new Object[0]);
        this.folderNew.addHotkey(this, Hotkey.CTRL_N).setHotkeyDisplayWay(TooltipWay.down);
        this.folderNew.setRolloverDecoratedOnly(true);
        this.folderNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebDirectoryChooserPanel.this.selectedDirectory != null) {
                    String defaultName = LanguageManager.get("weblaf.ex.dirchooser.newfolder.name");
                    String freeName = FileUtils.getAvailableName(WebDirectoryChooserPanel.this.selectedDirectory, defaultName);
                    File file = new File(WebDirectoryChooserPanel.this.selectedDirectory, freeName);
                    if (file.mkdir()) {
                        WebDirectoryChooserPanel.this.fileTree.addFile(WebDirectoryChooserPanel.this.selectedDirectory, file);
                        WebDirectoryChooserPanel.this.fileTree.startEditingFile(file);
                    } else {
                        String message = LanguageManager.get("weblaf.ex.dirchooser.newfolder.error.text");
                        String title = LanguageManager.get("weblaf.ex.dirchooser.newfolder.error.title");
                        WebOptionPane.showMessageDialog(WebDirectoryChooserPanel.this, message, title, 0);
                    }
                }
            }
        });
        contolsToolbar.add((Component)this.folderNew, (Object)"END");
        this.remove = new WebButton(REMOVE_ICON);
        this.remove.setLanguage("weblaf.ex.dirchooser.delete", new Object[0]);
        this.remove.addHotkey(this, Hotkey.DELETE).setHotkeyDisplayWay(TooltipWay.down);
        this.remove.setRolloverDecoratedOnly(true);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title;
                File file = WebDirectoryChooserPanel.this.fileTree.getSelectedFile();
                if (file == null) {
                    return;
                }
                String message = LanguageManager.get("weblaf.ex.dirchooser.delete.confirm.text");
                int confirm = WebOptionPane.showConfirmDialog(WebDirectoryChooserPanel.this, message, title = LanguageManager.get("weblaf.ex.dirchooser.delete.confirm.title"), 0, 3);
                if (confirm == 0) {
                    FileTreeNode parentNode = ((FileTreeNode)WebDirectoryChooserPanel.this.fileTree.getSelectedNode()).getParent();
                    int index = parentNode.indexOfFileChild(file);
                    int count = parentNode.getChildCount();
                    FileUtils.deleteFile(file);
                    WebDirectoryChooserPanel.this.fileTree.removeFile(file);
                    WebDirectoryChooserPanel.this.fileTree.setSelectedNode(count == 1 ? parentNode : (index < count - 1 ? parentNode.getChildAt(index) : parentNode.getChildAt(index - 1)));
                }
            }
        });
        contolsToolbar.add((Component)this.remove, (Object)"END");
        this.webPathField = new WebPathField(this.selectedDirectory);
        this.webPathField.setFileFilter(this.filter);
        this.webPathField.addPathFieldListener(new PathFieldListener(){

            @Override
            public void directoryChanged(File newDirectory) {
                WebDirectoryChooserPanel.this.updateSelectedDirectory(WebDirectoryChooserPanel.this.webPathField.getSelectedPath(), false, true);
            }
        });
        this.fileTree = new WebFileTree(FileTreeRootType.drives);
        this.fileTree.setVisibleRowCount(15);
        this.fileTree.setFileFilter(this.filter);
        this.fileTree.setSelectedFile(this.selectedDirectory, true);
        this.fileTree.setSelectionMode(1);
        this.fileTree.setEditable(true);
        this.fileTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                WebDirectoryChooserPanel.this.updateSelectedDirectory(WebDirectoryChooserPanel.this.fileTree.getSelectedFile(), true, false);
            }
        };
        this.fileTree.addTreeSelectionListener(this.fileTreeListener);
        this.fileTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                WebDirectoryChooserPanel.this.updateToolbarControlsState();
            }
        });
        WebScrollPane treeScroll = new WebScrollPane(this.fileTree);
        treeScroll.setPreferredWidth(400);
        this.setLayout(new BorderLayout(0, 3));
        this.add((Component)contolsToolbar, (Object)"North");
        WebPanel panel = new WebPanel(new BorderLayout(0, 1));
        panel.setMargin(0, 3, 2, 3);
        panel.add((Component)this.webPathField, (Object)"North");
        panel.add((Component)treeScroll, (Object)"Center");
        this.add((Component)panel, (Object)"Center");
        this.updateSelectedDirectory(null, true, true);
        this.updateToolbarControlsState();
    }

    protected void updateToolbarControlsState() {
        File selectedFile = this.fileTree.getSelectedFile();
        this.folderUp.setEnabled(selectedFile != null && selectedFile.getParentFile() != null);
        this.folderNew.setEnabled(selectedFile != null && selectedFile.canWrite());
        this.remove.setEnabled(selectedFile != null && selectedFile.getParentFile() != null && selectedFile.canWrite());
    }

    protected void updateSelectedDirectory(final File directory, boolean updatePath, boolean updateTree) {
        this.selectedDirectory = directory;
        if (updatePath) {
            this.webPathField.setSelectedPath(directory);
        }
        if (updateTree) {
            if (directory != null) {
                this.fileTree.expandToFile(directory, false, true, new Runnable(){

                    @Override
                    public void run() {
                        WebDirectoryChooserPanel.this.fileTree.removeTreeSelectionListener(WebDirectoryChooserPanel.this.fileTreeListener);
                        WebDirectoryChooserPanel.this.fileTree.setSelectedNode(WebDirectoryChooserPanel.this.fileTree.getNode(directory));
                        WebDirectoryChooserPanel.this.fileTree.addTreeSelectionListener(WebDirectoryChooserPanel.this.fileTreeListener);
                    }
                });
            } else {
                this.fileTree.clearSelection();
                this.fileTree.scrollToStart();
            }
        }
        this.fireSelectionChanged(this.selectedDirectory);
    }

    public AbstractFileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AbstractFileFilter filter) {
        this.filter = filter;
        this.fileTree.setFileFilter(filter);
    }

    public File getSelectedDirectory() {
        return this.selectedDirectory;
    }

    public void setSelectedDirectory(File selectedDirectory) {
        this.updateSelectedDirectory(selectedDirectory, true, true);
    }

    public boolean allowHotkeys() {
        return !this.fileTree.isEditing() && !this.webPathField.isEditing();
    }

    public void addDirectoryChooserListener(DirectoryChooserListener listener) {
        this.listeners.add(listener);
    }

    public void removeDirectoryChooserListener(DirectoryChooserListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSelectionChanged(File file) {
        for (DirectoryChooserListener listener : CollectionUtils.copy(this.listeners)) {
            listener.selectionChanged(file);
        }
    }
}

