/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.DockingPaneConstants;
import com.alee.extended.dock.DockingPaneInfo;
import com.alee.extended.layout.AbstractLayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;

public class DockingPaneLayout
extends AbstractLayoutManager
implements DockingPaneConstants {
    private boolean buttonPanesVisible = true;
    private String filledFrame = null;
    private Insets buttonsMargin = new Insets(1, 1, 1, 1);
    private int buttonSpacing = 0;
    private int buttonSidesSpacing = 20;
    private Insets framesMargin = new Insets(0, 0, 0, 0);
    private Insets contentMargin = new Insets(0, 0, 0, 0);
    private Map<Component, String> constraints = new HashMap<Component, String>();
    private DockingPaneInfo info = null;

    public boolean isButtonPanesVisible() {
        return this.buttonPanesVisible;
    }

    public void setButtonPanesVisible(boolean buttonPanesVisible) {
        this.buttonPanesVisible = buttonPanesVisible;
    }

    public String getFilledFrame() {
        return this.filledFrame;
    }

    public void setFilledFrame(String filledFrame) {
        this.filledFrame = filledFrame;
    }

    public Insets getButtonsMargin() {
        return this.buttonsMargin;
    }

    public void setButtonsMargin(Insets buttonsMargin) {
        this.buttonsMargin = buttonsMargin;
    }

    public int getButtonSpacing() {
        return this.buttonSpacing;
    }

    public void setButtonSpacing(int buttonSpacing) {
        this.buttonSpacing = buttonSpacing;
    }

    public int getButtonSidesSpacing() {
        return this.buttonSidesSpacing;
    }

    public void setButtonSidesSpacing(int buttonSidesSpacing) {
        this.buttonSidesSpacing = buttonSidesSpacing;
    }

    public Insets getFramesMargin() {
        return this.framesMargin;
    }

    public void setFramesMargin(Insets framesMargin) {
        this.framesMargin = framesMargin;
    }

    public Insets getContentMargin() {
        return this.contentMargin;
    }

    public void setContentMargin(Insets contentMargin) {
        this.contentMargin = contentMargin;
    }

    public Map<Component, String> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Map<Component, String> constraints) {
        this.constraints = constraints;
    }

    public DockingPaneInfo getDockingPaneInfo() {
        return this.info;
    }

    @Override
    public void addComponent(Component component, Object constraints) {
        this.constraints.put(component, (String)constraints);
    }

    @Override
    public void removeComponent(Component component) {
        this.constraints.remove(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.info = new DockingPaneInfo(this, parent);
        Dimension top = new Dimension(this.buttonsMargin.left + this.info.topButtonsSize.width + this.buttonsMargin.right, this.buttonsMargin.top + this.info.topButtonsSize.height + this.buttonsMargin.bottom);
        Dimension left = new Dimension(this.buttonsMargin.left + this.info.leftButtonsSize.width + this.buttonsMargin.right, this.buttonsMargin.top + this.info.leftButtonsSize.height + this.buttonsMargin.bottom);
        Dimension right = new Dimension(this.buttonsMargin.left + this.info.rightButtonsSize.width + this.buttonsMargin.right, this.buttonsMargin.top + this.info.rightButtonsSize.height + this.buttonsMargin.bottom);
        Dimension bottom = new Dimension(this.buttonsMargin.left + this.info.bottomButtonsSize.width + this.buttonsMargin.right, this.buttonsMargin.top + this.info.bottomButtonsSize.height + this.buttonsMargin.bottom);
        int width = this.info.margin.left + left.width + Math.max(top.width, bottom.width) + right.width + this.info.margin.right;
        int height = this.info.margin.top + top.height + Math.max(left.height, right.height) + bottom.height + this.info.margin.bottom;
        return new Dimension(width, height);
    }

    @Override
    public void layoutContainer(Container parent) {
        int y;
        Dimension ps;
        int x;
        Dimension pls = this.preferredLayoutSize(parent);
        this.info.rect.width = Math.max(this.info.rect.width, pls.width - this.info.margin.left - this.info.margin.right);
        this.info.rect.height = Math.max(this.info.rect.height, pls.height - this.info.margin.top - this.info.margin.bottom);
        this.info.updateBounds();
        if (this.info.hasTopButtons) {
            x = 0;
            for (Component component : this.info.topLeftButtons) {
                ps = component.getPreferredSize();
                component.setBounds(this.info.rect.x + this.info.leftButtonsPaneBounds.width + this.buttonsMargin.left + x, this.info.rect.y + this.buttonsMargin.top, ps.width, this.info.topButtonsSize.height);
                x += ps.width + this.buttonSpacing;
            }
            x = 0;
            for (Component component : this.info.topRightButtons) {
                ps = component.getPreferredSize();
                component.setBounds(this.info.rect.x + this.info.rect.width - this.info.rightButtonsPaneBounds.width - this.buttonsMargin.right - (x += ps.width), this.info.rect.y + this.buttonsMargin.top, ps.width, this.info.topButtonsSize.height);
                x += this.buttonSpacing;
            }
        }
        if (this.info.hasLeftButtons) {
            y = 0;
            for (Component component : this.info.leftTopButtons) {
                ps = component.getPreferredSize();
                component.setBounds(this.info.rect.x + this.buttonsMargin.left, this.info.rect.y + this.info.topButtonsPaneBounds.height + this.buttonsMargin.top + y, this.info.leftButtonsSize.width, ps.height);
                y += ps.height + this.buttonSpacing;
            }
            y = 0;
            for (Component component : this.info.leftBottomButtons) {
                ps = component.getPreferredSize();
                component.setBounds(this.info.rect.x + this.buttonsMargin.left, this.info.rect.y + this.info.rect.height - this.info.bottomButtonsPaneBounds.height - this.buttonsMargin.bottom - (y += ps.height), this.info.leftButtonsSize.width, ps.height);
                y += this.buttonSpacing;
            }
        }
        if (this.info.hasRightButtons) {
            y = 0;
            for (Component component : this.info.rightTopButtons) {
                ps = component.getPreferredSize();
                component.setBounds(this.info.rect.x + this.info.rect.width - this.buttonsMargin.right - this.info.rightButtonsSize.width, this.info.rect.y + this.info.topButtonsPaneBounds.height + this.buttonsMargin.top + y, this.info.rightButtonsSize.width, ps.height);
                y += ps.height + this.buttonSpacing;
            }
            y = 0;
            for (Component component : this.info.rightBottomButtons) {
                ps = component.getPreferredSize();
                component.setBounds(this.info.rect.x + this.info.rect.width - this.buttonsMargin.right - this.info.rightButtonsSize.width, this.info.rect.y + this.info.rect.height - this.info.bottomButtonsPaneBounds.height - this.buttonsMargin.bottom - (y += ps.height), this.info.rightButtonsSize.width, ps.height);
                y += this.buttonSpacing;
            }
        }
        if (this.info.hasBottomButtons) {
            x = 0;
            for (Component component : this.info.bottomLeftButtons) {
                ps = component.getPreferredSize();
                component.setBounds(this.info.rect.x + this.info.leftButtonsPaneBounds.width + this.buttonsMargin.left + x, this.info.rect.y + this.info.rect.height - this.buttonsMargin.bottom - this.info.bottomButtonsSize.height, ps.width, this.info.bottomButtonsSize.height);
                x += ps.width + this.buttonSpacing;
            }
            x = 0;
            for (Component component : this.info.bottomRightButtons) {
                ps = component.getPreferredSize();
                component.setBounds(this.info.rect.x + this.info.rect.width - this.info.rightButtonsPaneBounds.width - this.buttonsMargin.right - (x += ps.width), this.info.rect.y + this.info.rect.height - this.buttonsMargin.bottom - this.info.bottomButtonsSize.height, ps.width, this.info.bottomButtonsSize.height);
                x += this.buttonSpacing;
            }
        }
        if (this.info.topFrame != null) {
            this.info.topFrame.setBounds(this.info.topFrameBounds);
        }
        if (this.info.leftFrame != null) {
            this.info.leftFrame.setBounds(this.info.leftFrameBounds);
        }
        if (this.info.rightFrame != null) {
            this.info.rightFrame.setBounds(this.info.rightFrameBounds);
        }
        if (this.info.bottomFrame != null) {
            this.info.bottomFrame.setBounds(this.info.bottomFrameBounds);
        }
        if (this.info.content != null) {
            this.info.content.setBounds(this.info.contentBounds);
        }
    }
}

