/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.awt.Insets;
import java.util.StringTokenizer;

public class InsetsConverter
extends AbstractSingleValueConverter {
    @Override
    public boolean canConvert(Class type) {
        return type.equals(Insets.class);
    }

    @Override
    public Object fromString(String insets) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(insets, ",", false);
            int top = Integer.parseInt(tokenizer.nextToken().trim());
            int left = Integer.parseInt(tokenizer.nextToken().trim());
            int bottom = Integer.parseInt(tokenizer.nextToken().trim());
            int right = Integer.parseInt(tokenizer.nextToken().trim());
            return new Insets(top, left, bottom, right);
        }
        catch (Throwable e) {
            try {
                int spacing = Integer.parseInt(insets);
                return new Insets(spacing, spacing, spacing, spacing);
            }
            catch (Throwable ex) {
                return new Insets(0, 0, 0, 0);
            }
        }
    }

    @Override
    public String toString(Object object) {
        Insets insets = (Insets)object;
        return insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right;
    }
}

