/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.laf.StyleConstants;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ComponentUpdater
extends WebTimer
implements AncestorListener {
    private JComponent component;

    public ComponentUpdater(JComponent component) {
        super(StyleConstants.avgAnimationDelay);
        this.initialize(component);
    }

    public ComponentUpdater(JComponent component, long delay) {
        super(delay);
        this.initialize(component);
    }

    public ComponentUpdater(JComponent component, String name, long delay) {
        super(name, delay);
        this.initialize(component);
    }

    public ComponentUpdater(JComponent component, long delay, long initialDelay) {
        super(delay, initialDelay);
        this.initialize(component);
    }

    public ComponentUpdater(JComponent component, String name, long delay, long initialDelay) {
        super(name, delay, initialDelay);
        this.initialize(component);
    }

    public ComponentUpdater(JComponent component, long delay, ActionListener listener) {
        super(delay, listener);
        this.initialize(component);
    }

    public ComponentUpdater(JComponent component, String name, long delay, ActionListener listener) {
        super(name, delay, listener);
        this.initialize(component);
    }

    public ComponentUpdater(JComponent component, long delay, long initialDelay, ActionListener listener) {
        super(delay, initialDelay, listener);
        this.initialize(component);
    }

    public ComponentUpdater(JComponent component, String name, long delay, long initialDelay, ActionListener listener) {
        super(name, delay, initialDelay, listener);
        this.initialize(component);
    }

    private void initialize(JComponent component) {
        this.component = component;
        component.addAncestorListener(this);
    }

    public void uninstall() {
        this.component.removeAncestorListener(this);
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.start();
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.stop();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    public static ComponentUpdater install(JComponent component) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component);
    }

    public static ComponentUpdater install(JComponent component, long delay) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component, delay);
    }

    public static ComponentUpdater install(JComponent component, String name, long delay) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component, name, delay);
    }

    public static ComponentUpdater install(JComponent component, long delay, long initialDelay) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component, delay, initialDelay);
    }

    public static ComponentUpdater install(JComponent component, String name, long delay, long initialDelay) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component, name, delay, initialDelay);
    }

    public static ComponentUpdater install(JComponent component, long delay, ActionListener listener) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component, delay, listener);
    }

    public static ComponentUpdater install(JComponent component, String name, long delay, ActionListener listener) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component, name, delay, listener);
    }

    public static ComponentUpdater install(JComponent component, long delay, long initialDelay, ActionListener listener) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component, delay, initialDelay, listener);
    }

    public static ComponentUpdater install(JComponent component, String name, long delay, long initialDelay, ActionListener listener) {
        ComponentUpdater.uninstall(component);
        return new ComponentUpdater(component, name, delay, initialDelay, listener);
    }

    public static void uninstall(JComponent component) {
        for (AncestorListener listener : component.getAncestorListeners()) {
            if (!(listener instanceof ComponentUpdater)) continue;
            component.removeAncestorListener(listener);
        }
    }

    public static boolean isInstalled(JComponent component) {
        for (AncestorListener listener : component.getAncestorListeners()) {
            if (!(listener instanceof ComponentUpdater)) continue;
            return true;
        }
        return false;
    }
}

