/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

import com.alee.utils.FileUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.reflection.JarEntryType;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;

public class JarEntry {
    public static final String ID_PREFIX = "JE";
    public static ImageIcon jarIcon = new ImageIcon(JarEntry.class.getResource("icons/jar.png"));
    public static ImageIcon packageIcon = new ImageIcon(JarEntry.class.getResource("icons/package.png"));
    public static ImageIcon classIcon = new ImageIcon(JarEntry.class.getResource("icons/class.png"));
    public static ImageIcon javaIcon = new ImageIcon(JarEntry.class.getResource("icons/java.png"));
    public static ImageIcon fileIcon = new ImageIcon(JarEntry.class.getResource("icons/file.png"));
    private String id;
    private JarEntryType type;
    private String name;
    private ImageIcon icon;
    private JarEntry parent;
    private ZipEntry zipEntry;
    private List<JarEntry> childs = new ArrayList<JarEntry>();

    public JarEntry() {
        this.setParent(null);
    }

    public JarEntry(JarEntryType type, String name) {
        this.setType(type);
        this.setName(name);
        this.setParent(null);
    }

    public JarEntry(JarEntryType type, String name, JarEntry parent) {
        this.setType(type);
        this.setName(name);
        this.setParent(parent);
    }

    public JarEntry(JarEntryType type, String name, JarEntry parent, List<JarEntry> childs) {
        this.setType(type);
        this.setName(name);
        this.setParent(parent);
        this.setChilds(childs);
    }

    public String getId() {
        if (this.id == null) {
            this.setId();
        }
        return this.id;
    }

    private void setId() {
        this.setId(TextUtils.generateId(ID_PREFIX));
    }

    public void setId(String id) {
        this.id = id;
    }

    public JarEntryType getType() {
        return this.type;
    }

    public void setType(JarEntryType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JarEntry getParent() {
        return this.parent;
    }

    public void setParent(JarEntry parent) {
        this.parent = parent;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public void setZipEntry(ZipEntry zipEntry) {
        this.zipEntry = zipEntry;
    }

    public List<JarEntry> getChilds() {
        return this.childs;
    }

    public JarEntry getChild(int index) {
        return this.childs.get(index);
    }

    public JarEntry getChildByName(String name) {
        for (JarEntry child : this.childs) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public void setChilds(List<JarEntry> childs) {
        this.childs = childs;
    }

    public void addChild(JarEntry child) {
        this.childs.add(child);
    }

    public void addChild(int index, JarEntry child) {
        this.childs.add(index, child);
    }

    public void removeChild(JarEntry child) {
        this.childs.remove(child);
    }

    public ImageIcon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (this.type.equals((Object)JarEntryType.jarEntry)) {
            return jarIcon;
        }
        if (this.type.equals((Object)JarEntryType.packageEntry)) {
            return packageIcon;
        }
        if (this.type.equals((Object)JarEntryType.javaEntry)) {
            return javaIcon;
        }
        if (this.type.equals((Object)JarEntryType.classEntry)) {
            return classIcon;
        }
        ImageIcon icon = FileUtils.getStandartFileIcon(false, this.getEntryExtension(), 1.0f);
        if (icon != null) {
            return icon;
        }
        return fileIcon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public String getEntryExtension() {
        return FileUtils.getFileExtPart(this.name, false);
    }

    public boolean isClassEntry(Class classType) {
        return classType != null && classType.getCanonicalName().equals(this.getCanonicalEntryName());
    }

    public String getCanonicalEntryName() {
        String canonicalName = this.getName();
        for (JarEntry parent = this.getParent(); parent != null && !parent.getType().equals((Object)JarEntryType.jarEntry); parent = parent.getParent()) {
            canonicalName = parent.getName() + "." + canonicalName;
        }
        if (this.type.equals((Object)JarEntryType.classEntry) || this.type.equals((Object)JarEntryType.javaEntry)) {
            canonicalName = canonicalName.substring(0, canonicalName.lastIndexOf("."));
        }
        return canonicalName;
    }

    public String getCanonicalEntryPath() {
        String canonicalName = this.getName();
        for (JarEntry parent = this.getParent(); parent != null && !parent.getType().equals((Object)JarEntryType.jarEntry) && !parent.getParent().getType().equals((Object)JarEntryType.jarEntry); parent = parent.getParent()) {
            canonicalName = parent.getName() + "/" + canonicalName;
        }
        return canonicalName;
    }

    public List<JarEntry> getPath() {
        ArrayList<JarEntry> path = new ArrayList<JarEntry>();
        for (JarEntry current = this; current != null && !current.getType().equals((Object)JarEntryType.jarEntry); current = current.getParent()) {
            path.add(0, current);
        }
        return path;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof JarEntry && ((JarEntry)obj).getCanonicalEntryPath().equals(this.getCanonicalEntryPath());
    }

    public String toString() {
        return this.getName() + " (" + (Object)((Object)this.getType()) + ")";
    }
}

