/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.extended.colorchooser.GradientColorData;
import com.alee.extended.colorchooser.GradientData;
import com.alee.extended.painter.NinePatchIconPainter;
import com.alee.extended.painter.NinePatchStatePainter;
import com.alee.extended.painter.TexturePainter;
import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.tree.NodeState;
import com.alee.laf.tree.TreeState;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.collection.ValuesTable;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.xml.AliasProvider;
import com.alee.utils.xml.ColorConverter;
import com.alee.utils.xml.InsetsConverter;
import com.alee.utils.xml.PasswordConverter;
import com.alee.utils.xml.ResourceFile;
import com.alee.utils.xml.ResourceList;
import com.alee.utils.xml.ResourceLocation;
import com.alee.utils.xml.ResourceMap;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public final class XmlUtils {
    public static boolean aliasJdkClasses = true;
    public static final ColorConverter colorConverter = new ColorConverter();
    public static final InsetsConverter insetsConverter = new InsetsConverter();
    public static final PasswordConverter passwordConverter = new PasswordConverter();
    private static XStream xStream = null;

    public static XStream getXStream() {
        if (xStream == null) {
            XmlUtils.initializeXStream();
        }
        return xStream;
    }

    private static void initializeXStream() {
        try {
            xStream = new XStream(new DomDriver());
            if (aliasJdkClasses) {
                xStream.alias("Point", Point.class);
                xStream.useAttributeFor(Point.class, "x");
                xStream.useAttributeFor(Point.class, "y");
                xStream.alias("Dimension", Dimension.class);
                xStream.useAttributeFor(Dimension.class, "width");
                xStream.useAttributeFor(Dimension.class, "height");
                xStream.alias("Rectangle", Rectangle.class);
                xStream.useAttributeFor(Rectangle.class, "x");
                xStream.useAttributeFor(Rectangle.class, "y");
                xStream.useAttributeFor(Rectangle.class, "width");
                xStream.useAttributeFor(Rectangle.class, "height");
                xStream.alias("Font", Font.class);
                xStream.alias("Color", Color.class);
                xStream.registerConverter(colorConverter);
                xStream.alias("Insets", Insets.class);
                xStream.registerConverter(insetsConverter);
            }
            xStream.processAnnotations(ResourceLocation.class);
            xStream.processAnnotations(ResourceFile.class);
            xStream.processAnnotations(ResourceList.class);
            xStream.processAnnotations(ResourceMap.class);
            xStream.processAnnotations(ValuesTable.class);
            xStream.processAnnotations(TreeState.class);
            xStream.processAnnotations(NodeState.class);
            xStream.processAnnotations(GradientData.class);
            xStream.processAnnotations(GradientColorData.class);
            xStream.processAnnotations(HSBColor.class);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void processAnnotations(Class type) {
        XmlUtils.getXStream().processAnnotations(type);
    }

    public static void processAnnotations(Class[] types) {
        XmlUtils.getXStream().processAnnotations(types);
    }

    public static void alias(String name, Class type) {
        XmlUtils.getXStream().alias(name, type);
    }

    public static void useAttributeFor(Class type, String field) {
        XmlUtils.getXStream().useAttributeFor(type, field);
    }

    public static void addImplicitArray(Class type, String field) {
        XmlUtils.getXStream().addImplicitArray(type, field);
    }

    public static void addImplicitArray(Class type, String field, String itemName) {
        XmlUtils.getXStream().addImplicitArray(type, field, itemName);
    }

    public static void registerConverter(Converter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static void registerConverter(SingleValueConverter converter) {
        XmlUtils.getXStream().registerConverter(converter);
    }

    public static <T extends AliasProvider> void alias(Class<T> aliasProvider) {
        ReflectUtils.callStaticMethodSafely(aliasProvider, "provideAliases", XmlUtils.getXStream());
    }

    public static void toXML(Object obj, String file) {
        XmlUtils.toXML(obj, new File(file));
    }

    public static void toXML(Object obj, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            XmlUtils.toXML(obj, osw);
            osw.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String toXML(Object obj) {
        return XmlUtils.getXStream().toXML(obj);
    }

    public static void toXML(Object obj, Writer out) {
        XmlUtils.getXStream().toXML(obj, out);
    }

    public static void toXML(Object obj, OutputStream out) {
        XmlUtils.getXStream().toXML(obj, out);
    }

    public static <T> T fromXML(Reader reader) {
        return (T)XmlUtils.getXStream().fromXML(reader);
    }

    public static <T> T fromXML(InputStream input) {
        return (T)XmlUtils.getXStream().fromXML(input);
    }

    public static <T> T fromXML(URL url) {
        return (T)XmlUtils.getXStream().fromXML(url);
    }

    public static <T> T fromXML(File file) {
        return (T)XmlUtils.getXStream().fromXML(file);
    }

    public static <T> T fromXML(String xml) {
        return (T)XmlUtils.getXStream().fromXML(xml);
    }

    public static <T> T fromXML(Object source) {
        if (source instanceof URL) {
            return XmlUtils.fromXML((URL)source);
        }
        if (source instanceof String) {
            return XmlUtils.fromXML(new File((String)source));
        }
        if (source instanceof File) {
            return XmlUtils.fromXML((File)source);
        }
        if (source instanceof Reader) {
            return XmlUtils.fromXML((Reader)source);
        }
        if (source instanceof InputStream) {
            return XmlUtils.fromXML((InputStream)source);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromXML(ResourceFile resource) {
        switch (resource.getLocation()) {
            case url: {
                try {
                    return XmlUtils.fromXML(new URL(resource.getSource()));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            case filePath: {
                return XmlUtils.fromXML(new File(resource.getSource()));
            }
            case nearClass: {
                InputStream is = null;
                try {
                    is = Class.forName(resource.getClassName()).getResourceAsStream(resource.getSource());
                    if (is == null) {
                        String src = resource.getSource();
                        String cn = resource.getClassName();
                        throw new RuntimeException("Unable to read XML file \"" + src + "\" near class \"" + cn + "\"");
                    }
                    T src = XmlUtils.fromXML(is);
                    return src;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    T t = null;
                    return t;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    T t = null;
                    return t;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static String loadString(Object source) {
        return XmlUtils.loadString(XmlUtils.loadResourceFile(source));
    }

    public static String loadString(ResourceFile resource) {
        if (resource.getLocation().equals(ResourceLocation.url)) {
            try {
                return FileUtils.readToString(new BufferedReader(new InputStreamReader(new URL(resource.getSource()).openStream())));
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (resource.getLocation().equals(ResourceLocation.filePath)) {
            return FileUtils.readToString(new File(resource.getSource()));
        }
        if (resource.getLocation().equals(ResourceLocation.nearClass)) {
            try {
                return FileUtils.readToString(Class.forName(resource.getClassName()), resource.getSource());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static ImageIcon loadImageIcon(Object source) {
        return XmlUtils.loadImageIcon(XmlUtils.loadResourceFile(source));
    }

    public static ImageIcon loadImageIcon(ResourceFile resource) {
        if (resource.getLocation().equals(ResourceLocation.url)) {
            try {
                return new ImageIcon(new URL(resource.getSource()));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (resource.getLocation().equals(ResourceLocation.filePath)) {
            try {
                return new ImageIcon(new File(resource.getSource()).getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (resource.getLocation().equals(ResourceLocation.nearClass)) {
            try {
                return new ImageIcon(Class.forName(resource.getClassName()).getResource(resource.getSource()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static List<ImageIcon> loadImagesList(Object source) {
        return XmlUtils.loadImagesList(XmlUtils.loadResourceList(source));
    }

    public static List<ImageIcon> loadImagesList(ResourceList resourceList) {
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        for (ResourceFile resource : resourceList.getResources()) {
            ImageIcon imageIcon = XmlUtils.loadImageIcon(resource);
            if (imageIcon == null) continue;
            icons.add(imageIcon);
        }
        return icons;
    }

    public static NinePatchIcon loadNinePatchIcon(Object source) {
        return XmlUtils.loadNinePatchIcon(XmlUtils.loadResourceFile(source));
    }

    public static NinePatchIcon loadNinePatchIcon(ResourceFile resource) {
        return new NinePatchIcon(XmlUtils.loadImageIcon(resource));
    }

    public static NinePatchStatePainter loadNinePatchStatePainter(Object source) {
        return XmlUtils.loadNinePatchStatePainter(XmlUtils.loadResourceMap(source));
    }

    public static NinePatchStatePainter loadNinePatchStatePainter(ResourceMap resourceMap) {
        NinePatchStatePainter sbp = new NinePatchStatePainter();
        for (String key : resourceMap.getStates().keySet()) {
            sbp.addStateIcon(key, XmlUtils.loadNinePatchIcon(resourceMap.getState(key)));
        }
        return sbp;
    }

    public static NinePatchIconPainter loadNinePatchIconPainter(Object source) {
        return XmlUtils.loadNinePatchIconPainter(XmlUtils.loadResourceFile(source));
    }

    public static NinePatchIconPainter loadNinePatchIconPainter(ResourceFile resource) {
        return new NinePatchIconPainter(XmlUtils.loadNinePatchIcon(resource));
    }

    public static TexturePainter loadTexturePainter(Object source) {
        return XmlUtils.loadTexturePainter(XmlUtils.loadResourceFile(source));
    }

    public static TexturePainter loadTexturePainter(ResourceFile resource) {
        return new TexturePainter(XmlUtils.loadImageIcon(resource));
    }

    public static ResourceMap loadResourceMap(Object source) {
        return (ResourceMap)XmlUtils.fromXML(source);
    }

    public static ResourceList loadResourceList(Object source) {
        return (ResourceList)XmlUtils.fromXML(source);
    }

    public static ResourceFile loadResourceFile(Object source) {
        return (ResourceFile)XmlUtils.fromXML(source);
    }
}

