/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.MathUtils;
import com.alee.utils.text.SimpleTextProvider;
import com.alee.utils.text.TextProvider;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public final class TextUtils {
    private static final List<String> textSeparators = Arrays.asList(" ", ".", ",", ":", ";", "/", "\\", "\n", "\t", "|", "{", "}", "[", "]", "(", ")", "<", ">", "-", "+", "\"", "'", "*", "%", "$", "#", "@", "!", "~", "^", "&", "?");
    private static final SimpleTextProvider simpleTextProvider = new SimpleTextProvider();
    private static final int idPartLength = 5;
    private static final String defaultIdPrefix = "WebLaF";
    private static final String defaultIdSuffix = "ID";

    public static Integer findFirstNumber(String text) {
        StringBuilder sb = new StringBuilder("");
        for (int j = 0; j < text.length(); ++j) {
            char ch = text.charAt(j);
            if (Character.isDigit(ch)) {
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) break;
        }
        return Integer.parseInt(sb.toString());
    }

    public static String getWord(String text, int location) {
        int wordEnd;
        int wordStart = location;
        for (wordEnd = location; wordEnd < text.length() - 1 && !textSeparators.contains(text.substring(wordEnd, wordEnd + 1)); ++wordEnd) {
        }
        while (wordStart > 0 && !textSeparators.contains(text.substring(wordStart - 1, wordStart))) {
            --wordStart;
        }
        return wordStart == wordEnd ? null : text.substring(wordStart, wordEnd);
    }

    public static int getWordStart(String text, int location) {
        int wordStart;
        for (wordStart = location; wordStart > 0 && !textSeparators.contains(text.substring(wordStart - 1, wordStart)); --wordStart) {
        }
        return wordStart;
    }

    public static int getWordEnd(String text, int location) {
        int wordEnd;
        for (wordEnd = location; wordEnd < text.length() - 1 && !textSeparators.contains(text.substring(wordEnd, wordEnd + 1)); ++wordEnd) {
        }
        return wordEnd;
    }

    public static String removeFirstLines(String text, int count) {
        int index = 0;
        for (int found = 0; found < count; ++found) {
            if ((index = text.indexOf("\n", index)) != -1) {
                ++index;
                continue;
            }
            return "";
        }
        return text.substring(index);
    }

    public static List<String> split(String text, String separator) {
        return Arrays.asList(text.split(separator));
    }

    public static Point parsePoint(String text) {
        return TextUtils.parsePoint(text, ",");
    }

    public static Point parsePoint(String text, String separator) {
        String[] parts = text.split(separator);
        return parts.length == 2 ? new Point(Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim())) : null;
    }

    public static String removeControlSymbols(String text) {
        int length = text.length();
        char[] oldChars = new char[length];
        text.getChars(0, length, oldChars, 0);
        int newLen = 0;
        for (int j = 0; j < length; ++j) {
            char ch = oldChars[j];
            if (ch < ' ') continue;
            oldChars[newLen] = ch;
            ++newLen;
        }
        return text;
    }

    public static String shortenText(String text, int maxLength, boolean addDots) {
        return text.length() <= maxLength ? text : text.substring(0, maxLength > 3 && addDots ? maxLength - 3 : maxLength) + (addDots ? "..." : "");
    }

    public static List<String> stringToList(String string, String separator) {
        ArrayList<String> strings = new ArrayList<String>();
        if (string != null) {
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            while (tokenizer.hasMoreTokens()) {
                strings.add(tokenizer.nextToken().trim());
            }
        }
        return strings;
    }

    public static List<Integer> stringToIntList(String string, String separator) {
        List<String> stringList = TextUtils.stringToList(string, separator);
        if (stringList != null) {
            ArrayList<Integer> intList = new ArrayList<Integer>(stringList.size());
            for (String s : stringList) {
                intList.add(Integer.parseInt(s));
            }
            return intList;
        }
        return null;
    }

    public static String listToString(List list, String separator) {
        return TextUtils.listToString(list, separator, simpleTextProvider);
    }

    public static <T> String listToString(List<T> list, String separator, TextProvider<T> textProvider) {
        if (list != null && list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int end = list.size() - 1;
            for (int i = 0; i <= end; ++i) {
                stringBuilder.append(textProvider.provide(list.get(i)));
                stringBuilder.append(i != end ? separator : "");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static <E extends Enum<E>> String enumListToString(List<E> enumList) {
        if (enumList != null && enumList.size() > 0) {
            int end = enumList.size() - 1;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i <= end; ++i) {
                stringBuilder.append(enumList.get(i));
                stringBuilder.append(i != end ? "," : "");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static <E extends Enum<E>> List<E> enumStringToList(String enumString, Class<E> enumClass) {
        ArrayList<E> enumerations;
        if (enumString != null) {
            StringTokenizer tokenizer = new StringTokenizer(enumString, ",", false);
            enumerations = new ArrayList();
            while (tokenizer.hasMoreTokens()) {
                enumerations.add(Enum.valueOf(enumClass, tokenizer.nextToken().trim()));
            }
        } else {
            enumerations = new ArrayList<E>(0);
        }
        return enumerations;
    }

    public static String generateId() {
        return TextUtils.generateId(null, null);
    }

    public static String generateId(String prefix) {
        return TextUtils.generateId(prefix, null);
    }

    public static String generateId(String prefix, String suffix) {
        return (prefix == null ? defaultIdPrefix : prefix) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + TextUtils.generateId(5) + "-" + (suffix == null ? defaultIdSuffix : suffix);
    }

    private static String generateId(int length) {
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int next = 0;
            int range = 10;
            switch (MathUtils.random(3)) {
                case 0: {
                    next = 48;
                    range = 10;
                    break;
                }
                case 1: {
                    next = 97;
                    range = 26;
                    break;
                }
                case 2: {
                    next = 65;
                    range = 26;
                }
            }
            stringBuilder.append((char)(MathUtils.random(range) + next));
        }
        return stringBuilder.toString();
    }
}

