/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.graphics.filters.ShadowFilter;
import com.alee.laf.GlobalConstants;
import com.alee.laf.StyleConstants;
import com.alee.utils.FileUtils;
import com.alee.utils.ImageFilterUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SystemUtils;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageUtils {
    public static final String IMAGE_CACHE_SEPARATOR = ";#&;";
    private static Map<String, ImageIcon> mergedIconsCache = new HashMap<String, ImageIcon>();
    private static Map<String, BufferedImage> mergedImagesCache = new HashMap<String, BufferedImage>();
    public static final ImageIcon coloredChooserIcon = new ImageIcon(ImageUtils.class.getResource("icons/color/color.png"));
    public static final ImageIcon transarentChooserIcon = new ImageIcon(ImageUtils.class.getResource("icons/color/transparent.png"));
    private static Map<String, ImageIcon> iconsCache = new HashMap<String, ImageIcon>();
    private static final Map<String, ImageIcon> sizedPreviewCache = new HashMap<String, ImageIcon>();
    private static Map<String, ImageIcon> grayscaleCache = new HashMap<String, ImageIcon>();
    private static Map<String, ImageIcon> trasparentCache = new HashMap<String, ImageIcon>();

    public static boolean isImageContains(BufferedImage image, int x, int y) {
        return (image.getRGB(x, y) >> 24 & 0xFF) > 0;
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return SystemUtils.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        return SystemUtils.getGraphicsConfiguration().createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return ImageUtils.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int transparency) {
        return ImageUtils.createCompatibleImage(image.getWidth(), image.getHeight(), transparency);
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return ImageUtils.createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return ImageUtils.toCompatibleImage(image);
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        if (ImageUtils.isCompatibleImage(image)) {
            return image;
        }
        BufferedImage compatibleImage = SystemUtils.getGraphicsConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics2D g2d = compatibleImage.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return compatibleImage;
    }

    public static boolean isCompatibleImage(BufferedImage image) {
        return image.getColorModel().equals(SystemUtils.getGraphicsConfiguration().getColorModel());
    }

    public static ImageIcon cutImage(Shape shape, ImageIcon image) {
        return new ImageIcon(ImageUtils.cutImage(shape, image.getImage()));
    }

    public static BufferedImage cutImage(Shape shape, Image image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        BufferedImage cutImage = ImageUtils.createCompatibleImage(w, h, 3);
        Graphics2D g2d = cutImage.createGraphics();
        LafUtils.setupAntialias(g2d);
        g2d.setPaint(Color.WHITE);
        g2d.fill(shape);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return cutImage;
    }

    public static List<Image> toImagesList(List<? extends ImageIcon> imageIcons) {
        ArrayList<Image> images = new ArrayList<Image>(imageIcons.size());
        for (ImageIcon imageIcon : imageIcons) {
            images.add(imageIcon.getImage());
        }
        return images;
    }

    public static ImageIcon combineIcons(List<ImageIcon> icons) {
        return ImageUtils.combineIcons(0, icons);
    }

    public static ImageIcon combineIcons(int spacing, List<ImageIcon> icons) {
        if (icons == null || icons.size() == 0) {
            return null;
        }
        Image[] images = new Image[icons.size()];
        int i = 0;
        for (ImageIcon icon : icons) {
            images[i] = icon != null ? icon.getImage() : null;
            ++i;
        }
        return new ImageIcon(ImageUtils.combineIcons(spacing, images));
    }

    public static ImageIcon combineIcons(ImageIcon ... icons) {
        return ImageUtils.combineIcons(0, icons);
    }

    public static ImageIcon combineIcons(int spacing, ImageIcon ... icons) {
        if (icons == null || icons.length == 0) {
            return null;
        }
        Image[] images = new Image[icons.length];
        int i = 0;
        for (ImageIcon icon : icons) {
            images[i] = icon != null ? icon.getImage() : null;
            ++i;
        }
        return new ImageIcon(ImageUtils.combineIcons(spacing, images));
    }

    public static BufferedImage combineIcons(Image ... images) {
        return ImageUtils.combineIcons(0, images);
    }

    public static BufferedImage combineIcons(int spacing, Image ... images) {
        if (images == null || images.length == 0) {
            return null;
        }
        Dimension maxSize = new Dimension(0, 0);
        for (Image image : images) {
            if (image == null) continue;
            maxSize.width = maxSize.width + image.getWidth(null) + spacing;
            maxSize.height = Math.max(maxSize.height, image.getHeight(null));
        }
        maxSize.width -= spacing;
        if (maxSize.width <= 0 || maxSize.height <= 0) {
            return null;
        }
        BufferedImage bi = ImageUtils.createCompatibleImage(maxSize.width, maxSize.height, 3);
        Graphics2D g2d = bi.createGraphics();
        int x = 0;
        for (Image image : images) {
            if (image == null) continue;
            g2d.drawImage(image, x, 0, null);
            x += image.getWidth(null) + spacing;
        }
        g2d.dispose();
        return bi;
    }

    public static void clearMergedIconsCache() {
        mergedIconsCache.clear();
    }

    public static ImageIcon mergeIcons(List<ImageIcon> icons) {
        return ImageUtils.mergeIcons(null, icons);
    }

    public static ImageIcon mergeIcons(String key, List<ImageIcon> icons) {
        if (key != null && mergedIconsCache.containsKey(key)) {
            return mergedIconsCache.get(key);
        }
        if (icons == null || icons.size() == 0) {
            return null;
        }
        if (icons.size() == 1) {
            return icons.get(0);
        }
        Image[] images = new Image[icons.size()];
        int i = 0;
        for (ImageIcon icon : icons) {
            images[i] = icon != null ? icon.getImage() : null;
            ++i;
        }
        ImageIcon icon = new ImageIcon(ImageUtils.mergeImages(images));
        if (key != null) {
            mergedIconsCache.put(key, icon);
        }
        return icon;
    }

    public static ImageIcon mergeIcons(ImageIcon ... icons) {
        return ImageUtils.mergeIcons(null, icons);
    }

    public static ImageIcon mergeIcons(String key, ImageIcon ... icons) {
        if (key != null && mergedIconsCache.containsKey(key)) {
            return mergedIconsCache.get(key);
        }
        if (icons == null || icons.length == 0) {
            return null;
        }
        if (icons.length == 1) {
            return icons[0];
        }
        Image[] images = new Image[icons.length];
        int i = 0;
        for (ImageIcon icon : icons) {
            images[i] = icon != null ? icon.getImage() : null;
            ++i;
        }
        ImageIcon icon = new ImageIcon(ImageUtils.mergeImages(images));
        if (key != null) {
            mergedIconsCache.put(key, icon);
        }
        return icon;
    }

    public static void clearMergedImagesCache() {
        mergedImagesCache.clear();
    }

    public static BufferedImage mergeImages(Image ... images) {
        return ImageUtils.mergeImages(null, images);
    }

    public static BufferedImage mergeImages(String key, Image ... images) {
        if (key != null && mergedImagesCache.containsKey(key)) {
            return mergedImagesCache.get(key);
        }
        if (images == null || images.length == 0) {
            return null;
        }
        if (images.length == 1) {
            return ImageUtils.getBufferedImage(images[0]);
        }
        Dimension maxSize = new Dimension(0, 0);
        for (Image image : images) {
            if (image == null) continue;
            maxSize.width = Math.max(maxSize.width, image.getWidth(null));
            maxSize.height = Math.max(maxSize.height, image.getHeight(null));
        }
        if (maxSize.width <= 0 || maxSize.height <= 0) {
            return null;
        }
        BufferedImage bi = ImageUtils.createCompatibleImage(maxSize.width, maxSize.height, 3);
        Graphics2D g2d = bi.createGraphics();
        for (Image image : images) {
            if (image == null) continue;
            g2d.drawImage(image, 0, 0, null);
        }
        g2d.dispose();
        if (key != null) {
            mergedImagesCache.put(key, bi);
        }
        return bi;
    }

    public static BufferedImage loadImage(String src) {
        return ImageUtils.loadImage(new File(src));
    }

    public static BufferedImage loadImage(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ImageIcon loadImage(URL url) {
        try {
            return new ImageIcon(url);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ImageIcon loadImage(Class nearClass, String src) {
        try {
            return new ImageIcon(nearClass.getResource(src));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ImageIcon loadImage(InputStream inputStream) {
        try {
            return new ImageIcon(ImageIO.read(inputStream));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ImageIcon addBackground(ImageIcon imageIcon, Color background) {
        return new ImageIcon(ImageUtils.addBackground(ImageUtils.getBufferedImage(imageIcon), background));
    }

    public static BufferedImage addBackground(BufferedImage image, Color background) {
        BufferedImage bi = ImageUtils.createCompatibleImage(image);
        Graphics2D g2d = bi.createGraphics();
        g2d.setPaint(background);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return bi;
    }

    public static ImageIcon resizeCanvas(ImageIcon imageIcon, int width, int height) {
        return new ImageIcon(ImageUtils.resizeCanvas(ImageUtils.getBufferedImage(imageIcon), width, height));
    }

    public static BufferedImage resizeCanvas(BufferedImage image, int width, int height) {
        BufferedImage bi = ImageUtils.createCompatibleImage(image, width, height);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage((Image)image, width / 2 - image.getWidth() / 2, height / 2 - image.getHeight() / 2, null);
        g2d.dispose();
        return bi;
    }

    public static ImageIcon rotateImage90CW(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.rotateImage90CW(ImageUtils.getBufferedImage(imageIcon)));
    }

    public static BufferedImage rotateImage90CW(BufferedImage image) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(image.getHeight(), image.getWidth(), 3);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.translate(image.getHeight(), 0);
        g2d.rotate(1.5707963267948966);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static ImageIcon rotateImage90CCW(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.rotateImage90CCW(ImageUtils.getBufferedImage(imageIcon)));
    }

    public static BufferedImage rotateImage90CCW(BufferedImage image) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(image.getHeight(), image.getWidth(), 3);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.translate(0, image.getWidth());
        g2d.rotate(-1.5707963267948966);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static ImageIcon rotateImage180(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.rotateImage180(ImageUtils.getBufferedImage(imageIcon)));
    }

    public static BufferedImage rotateImage180(BufferedImage image) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.translate(image.getWidth(), image.getHeight());
        g2d.rotate(Math.PI);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static ImageIcon createEmptyIcon(int width, int height) {
        return new ImageIcon(ImageUtils.createEmptyImage(width, height));
    }

    public static BufferedImage createEmptyImage(int width, int height) {
        return ImageUtils.createCompatibleImage(width, height, 3);
    }

    public static ImageIcon createColorIcon(Color color) {
        return ImageUtils.createColorIcon(color, 16, 16);
    }

    public static ImageIcon createColorIcon(Color color, int width, int height) {
        return new ImageIcon(ImageUtils.createColorImage(color, width, height));
    }

    public static BufferedImage createColorImage(Color color) {
        return ImageUtils.createColorImage(color, 16, 16);
    }

    public static BufferedImage createColorImage(Color color, int width, int height) {
        BufferedImage image = ImageUtils.createCompatibleImage(width, height, 3);
        Graphics2D g2d = image.createGraphics();
        LafUtils.setupAntialias(g2d);
        g2d.setPaint(Color.GRAY);
        g2d.drawRoundRect(0, 0, width - 1, height - 1, StyleConstants.largeRound, StyleConstants.bigRound);
        g2d.setPaint(Color.WHITE);
        g2d.drawRoundRect(1, 1, width - 3, height - 3, StyleConstants.bigRound, StyleConstants.bigRound);
        g2d.setPaint(color);
        g2d.fillRoundRect(2, 2, width - 4, height - 4, StyleConstants.bigRound, StyleConstants.bigRound);
        g2d.dispose();
        return image;
    }

    public static ImageIcon createColorChooserIcon(Color color) {
        return new ImageIcon(ImageUtils.createColorChooserImage(color));
    }

    public static BufferedImage createColorChooserImage(Color color) {
        BufferedImage image = ImageUtils.createCompatibleImage(16, 16, 3);
        Graphics2D g2d = image.createGraphics();
        if (color == null || color.getAlpha() < 255) {
            g2d.drawImage(transarentChooserIcon.getImage(), 0, 0, null);
        }
        if (color != null) {
            g2d.setPaint(color);
            g2d.fillRect(2, 2, 13, 12);
        }
        g2d.drawImage(coloredChooserIcon.getImage(), 0, 0, null);
        g2d.dispose();
        return image;
    }

    public static void darkenImage(BufferedImage image, float darken) {
        Graphics2D g2d = image.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, darken));
        g2d.setPaint(Color.BLACK);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.dispose();
    }

    public static Color getImageAverageColor(ImageIcon icon) {
        int red = 0;
        int green = 0;
        int blue = 0;
        BufferedImage bi = ImageUtils.getBufferedImage(icon.getImage());
        for (int i = 0; i < icon.getIconWidth(); ++i) {
            for (int j = 0; j < icon.getIconHeight(); ++j) {
                int rgb = bi.getRGB(i, j);
                red += rgb >> 16 & 0xFF;
                green += rgb >> 8 & 0xFF;
                blue += rgb & 0xFF;
            }
        }
        int count = icon.getIconWidth() * icon.getIconHeight();
        return new Color(red / count, green / count, blue / count);
    }

    public static boolean isImageLoadable(String name) {
        return GlobalConstants.IMAGE_FORMATS.contains(FileUtils.getFileExtPart(name, false).toLowerCase());
    }

    public static ImageIcon createThumbnailIcon(String src) {
        return ImageUtils.createThumbnailIcon(src, 50);
    }

    public static ImageIcon createThumbnailIcon(String src, int size) {
        ImageIcon icon = ImageUtils.getImageIcon(src);
        if (icon != null) {
            ImageIcon imageIcon = ImageUtils.createPreviewIcon(icon.getImage(), size);
            if (imageIcon != null) {
                imageIcon.setDescription(icon.getIconWidth() + "x" + icon.getIconHeight());
            }
            return imageIcon;
        }
        return null;
    }

    public static ImageIcon createPreviewIcon(ImageIcon image, int size) {
        return ImageUtils.createPreviewIcon(image.getImage(), size);
    }

    public static ImageIcon createPreviewIcon(Image image, int size) {
        return ImageUtils.createPreviewIcon(ImageUtils.getBufferedImage(image), size);
    }

    public static ImageIcon createPreviewIcon(BufferedImage image, int size) {
        BufferedImage previewImage = ImageUtils.createPreviewImage(image, size);
        if (previewImage != null) {
            return new ImageIcon(previewImage);
        }
        return new ImageIcon();
    }

    public static BufferedImage createPreviewImage(BufferedImage image, Dimension fitTo) {
        return ImageUtils.createPreviewImage(image, fitTo.width, fitTo.height);
    }

    public static BufferedImage createPreviewImage(BufferedImage image, int width, int height) {
        if (image.getWidth() > width || image.getHeight() > height) {
            if ((float)height * ((float)image.getWidth() / (float)image.getHeight()) <= (float)width) {
                return ImageUtils.createPreviewImage(image, Math.max(height, Math.round((float)height * ((float)image.getWidth() / (float)image.getHeight()))));
            }
            return ImageUtils.createPreviewImage(image, Math.max(width, Math.round((float)width * ((float)image.getHeight() / (float)image.getWidth()))));
        }
        return image;
    }

    public static BufferedImage createPreviewImage(BufferedImage image, int length) {
        int height;
        int width;
        if (image == null) {
            return null;
        }
        if (image.getWidth() <= length && image.getHeight() <= length) {
            return image;
        }
        if (image.getWidth() > image.getHeight()) {
            width = length;
            height = Math.round((float)length * (float)image.getHeight() / (float)image.getWidth());
        } else if (image.getWidth() < image.getHeight()) {
            height = length;
            width = Math.round((float)length * (float)image.getWidth() / (float)image.getHeight());
        } else {
            width = height = length;
        }
        if (width >= 3 && height >= 3) {
            return new ResampleOp(width, height).filter(image, ImageUtils.createCompatibleImage(image));
        }
        int w = Math.max(1, width);
        int h = Math.max(1, height);
        BufferedImage rescaledImage = ImageUtils.createCompatibleImage(w, h, 3);
        Graphics2D g2d = rescaledImage.createGraphics();
        LafUtils.setupImageQuality(g2d);
        g2d.drawImage(image, 0, 0, width, height, null);
        g2d.dispose();
        return rescaledImage;
    }

    public static boolean isImageCached(String src) {
        return iconsCache.containsKey(src) && iconsCache.get(src) != null;
    }

    public static void setImageCache(String src, ImageIcon imageIcon) {
        iconsCache.put(src, imageIcon);
    }

    public static void clearImagesCache() {
        iconsCache.clear();
    }

    public static void clearImageCache(String src) {
        if (iconsCache.size() > 0 && iconsCache.containsKey(src)) {
            if (iconsCache.get(src) != null && iconsCache.get(src).getImage() != null) {
                iconsCache.get(src).getImage().flush();
            }
            iconsCache.remove(src);
        }
    }

    public static ImageIcon getImageIcon(File file) {
        return ImageUtils.getImageIcon(file, true);
    }

    public static ImageIcon getImageIcon(File file, boolean useCache) {
        return ImageUtils.getImageIcon(file.getAbsolutePath(), useCache);
    }

    public static ImageIcon getImageIcon(String src) {
        return ImageUtils.getImageIcon(src, true);
    }

    public static ImageIcon getImageIcon(String src, boolean useCache) {
        if (src != null && !src.trim().equals("")) {
            if (useCache && iconsCache.containsKey(src)) {
                ImageIcon imageIcon = iconsCache.get(src);
                if (imageIcon != null) {
                    return imageIcon;
                }
                iconsCache.remove(src);
                return ImageUtils.getImageIcon(src, useCache);
            }
            ImageIcon imageIcon = ImageUtils.createImageIcon(src);
            if (useCache) {
                iconsCache.put(src, imageIcon);
            }
            return imageIcon;
        }
        return null;
    }

    private static ImageIcon createImageIcon(String src) {
        if (!new File(src).exists()) {
            return new ImageIcon();
        }
        try {
            return new ImageIcon(ImageIO.read(new File(src)));
        }
        catch (Throwable e) {
            return new ImageIcon();
        }
    }

    public static ImageIcon getImageIcon(URL resource) {
        return ImageUtils.getImageIcon(resource, true);
    }

    public static ImageIcon getImageIcon(URL resource, boolean useCache) {
        if (resource != null) {
            String key = resource.toString();
            if (useCache && iconsCache.containsKey(key)) {
                ImageIcon imageIcon = iconsCache.get(key);
                if (imageIcon != null) {
                    return imageIcon;
                }
                iconsCache.remove(key);
                return ImageUtils.getImageIcon(key, useCache);
            }
            ImageIcon imageIcon = new ImageIcon(resource);
            if (useCache) {
                iconsCache.put(key, imageIcon);
            }
            return imageIcon;
        }
        return null;
    }

    public static BufferedImage copy(Image image) {
        return ImageUtils.copy(ImageUtils.getBufferedImage(image));
    }

    public static BufferedImage copy(BufferedImage bufferedImage) {
        BufferedImage newImage = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D g2d = newImage.createGraphics();
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return newImage;
    }

    public static BufferedImage getBufferedImage(URL url) {
        return ImageUtils.getBufferedImage(new ImageIcon(url));
    }

    public static BufferedImage getBufferedImage(String iconSrc) {
        return ImageUtils.getBufferedImage(new ImageIcon(iconSrc));
    }

    public static BufferedImage getBufferedImage(ImageIcon imageIcon) {
        return ImageUtils.getBufferedImage(imageIcon.getImage());
    }

    public static BufferedImage getBufferedImage(Image image) {
        if (image == null || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bi = ImageUtils.createCompatibleImage(image.getWidth(null), image.getHeight(null), 3);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return bi;
    }

    public static BufferedImage getBufferedImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            if (image != null) {
                return ImageUtils.getBufferedImage(image);
            }
            return ImageUtils.createBufferedImage(icon);
        }
        return ImageUtils.createBufferedImage(icon);
    }

    public static BufferedImage createBufferedImage(Icon icon) {
        BufferedImage bi = ImageUtils.createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g2d = bi.createGraphics();
        icon.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        return bi;
    }

    public static ImageIcon getImageIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return new ImageIcon(ImageUtils.getBufferedImage(icon));
    }

    public static ImageIcon getSizedImagePreview(String src, int length, boolean drawBorder) {
        if (sizedPreviewCache.containsKey(length + IMAGE_CACHE_SEPARATOR + src)) {
            return sizedPreviewCache.get(length + IMAGE_CACHE_SEPARATOR + src);
        }
        ImageIcon icon = ImageUtils.createThumbnailIcon(src, length);
        ImageIcon sized = ImageUtils.createSizedImagePreview(icon, length, drawBorder);
        sizedPreviewCache.put(length + IMAGE_CACHE_SEPARATOR + src, sized);
        return sized;
    }

    public static ImageIcon getSizedImagePreview(String id, ImageIcon icon, int length, boolean drawBorder) {
        if (sizedPreviewCache.containsKey(id)) {
            return sizedPreviewCache.get(id);
        }
        ImageIcon sized = ImageUtils.createSizedImagePreview(icon, length, drawBorder);
        sizedPreviewCache.put(id, sized);
        return sized;
    }

    public static ImageIcon createSizedImagePreview(ImageIcon icon, int length, boolean drawBorder) {
        BufferedImage bi = ImageUtils.createCompatibleImage(length += 4, length, 3);
        Graphics2D g2d = bi.createGraphics();
        if (icon != null) {
            g2d.drawImage(icon.getImage(), length / 2 - icon.getIconWidth() / 2, length / 2 - icon.getIconHeight() / 2, null);
        }
        if (drawBorder) {
            g2d.setPaint(Color.LIGHT_GRAY);
            g2d.drawRect(0, 0, length - 1, length - 1);
        }
        g2d.dispose();
        ImageIcon imageIcon = new ImageIcon(bi);
        imageIcon.setDescription(icon != null ? icon.getDescription() : null);
        return imageIcon;
    }

    public static void clearDisabledCopyCache() {
        grayscaleCache.clear();
    }

    public static void clearDisabledCopyCache(String id) {
        grayscaleCache.remove(id);
    }

    public static ImageIcon getDisabledCopy(String key, ImageIcon imageIcon) {
        if (grayscaleCache.containsKey(key)) {
            return grayscaleCache.get(key);
        }
        grayscaleCache.put(key, ImageUtils.createDisabledCopy(imageIcon));
        return grayscaleCache.get(key);
    }

    public static ImageIcon createDisabledCopy(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.createDisabledCopy(imageIcon.getImage()));
    }

    public static BufferedImage createDisabledCopy(Image img) {
        BufferedImage bi = ImageUtils.createGrayscaleCopy(img);
        BufferedImage bi2 = ImageUtils.createCompatibleImage(bi);
        Graphics2D g2d = bi2.createGraphics();
        LafUtils.setupAlphaComposite(g2d, Float.valueOf(StyleConstants.disabledIconsTransparency));
        g2d.drawImage((Image)bi, 0, 0, null);
        g2d.dispose();
        return bi2;
    }

    public static ImageIcon createGrayscaleCopy(ImageIcon imageIcon) {
        return new ImageIcon(ImageUtils.createGrayscaleCopy(imageIcon.getImage()));
    }

    public static BufferedImage createGrayscaleCopy(Image img) {
        return ImageUtils.createGrayscaleCopy(ImageUtils.getBufferedImage(img));
    }

    public static BufferedImage createGrayscaleCopy(BufferedImage img) {
        return ImageFilterUtils.applyGrayscaleFilter(img, null);
    }

    public static ImageIcon getTransparentCopy(String id, ImageIcon imageIcon, float trasparency) {
        if (trasparentCache.containsKey(id)) {
            return trasparentCache.get(id);
        }
        trasparentCache.put(id, ImageUtils.createTransparentCopy(imageIcon, trasparency));
        return trasparentCache.get(id);
    }

    public static ImageIcon createTransparentCopy(ImageIcon imageIcon, float trasparency) {
        BufferedImage bi = ImageUtils.createCompatibleImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 3);
        Graphics2D g2d = bi.createGraphics();
        LafUtils.setupAlphaComposite(g2d, Float.valueOf(trasparency));
        g2d.drawImage(imageIcon.getImage(), 0, 0, null);
        g2d.dispose();
        return new ImageIcon(bi);
    }

    public static BufferedImage createPrettyImage(Image image, int shadeWidth, int round) {
        return ImageUtils.createPrettyImage(ImageUtils.getBufferedImage(image), shadeWidth, round);
    }

    public static BufferedImage createPrettyImage(BufferedImage bufferedImage, int shadeWidth, int round) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        BufferedImage bi = ImageUtils.createCompatibleImage(width + shadeWidth * 2 + 1, height + shadeWidth * 2 + 1, 3);
        Graphics2D g2d = bi.createGraphics();
        LafUtils.setupAntialias(g2d);
        LafUtils.setupImageQuality(g2d);
        RoundRectangle2D.Double border = new RoundRectangle2D.Double(shadeWidth, shadeWidth, width, height, round, round);
        Shape old = g2d.getClip();
        g2d.setClip(border);
        g2d.drawImage((Image)bufferedImage, shadeWidth, shadeWidth, null);
        g2d.setClip(old);
        LafUtils.drawShade(g2d, border, StyleConstants.shadeColor, shadeWidth);
        g2d.setPaint(new LinearGradientPaint(0.0f, shadeWidth, 0.0f, height - shadeWidth, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(125, 125, 125, 48), new Color(125, 125, 125, 0), new Color(125, 125, 125, 48)}));
        g2d.fill(border);
        g2d.setColor(Color.GRAY);
        g2d.draw(border);
        g2d.dispose();
        return bi;
    }

    public static BufferedImage createImageShade(int w, int h, Shape shape, int shadeWidth, float shadeOpacity) {
        return ImageUtils.createImageShade(w, h, shape, shadeWidth, shadeOpacity, StyleConstants.transparent);
    }

    public static BufferedImage createImageShade(int w, int h, Shape shape, int shadeWidth, float shadeOpacity, Color clearColor) {
        int width = shadeWidth * 2 + w;
        int height = shadeWidth * 2 + h;
        BufferedImage bi = ImageUtils.createCompatibleImage(width, width, 3);
        Graphics2D ig = bi.createGraphics();
        LafUtils.setupAntialias(ig);
        ig.translate(shadeWidth, shadeWidth);
        ig.setPaint(Color.BLACK);
        ig.fill(shape);
        ig.dispose();
        ShadowFilter sf = new ShadowFilter(shadeWidth, 0, 0, shadeOpacity);
        BufferedImage shade = sf.filter(bi, null);
        if (clearColor != null) {
            Graphics2D g2d = shade.createGraphics();
            LafUtils.setupAntialias(g2d);
            g2d.translate(shadeWidth, shadeWidth);
            g2d.setComposite(AlphaComposite.getInstance(5));
            g2d.setPaint(clearColor);
            g2d.fill(shape);
            g2d.dispose();
        }
        return shade;
    }

    public static ImageIcon createSimpleUpArrowIcon(int shadeWidth) {
        return new ImageIcon(ImageUtils.createSimpleUpArrowImage(shadeWidth));
    }

    public static BufferedImage createSimpleUpArrowImage(int shadeWidth) {
        return ImageUtils.createImageShade(10, 10, ImageUtils.createUpArrowFill(), shadeWidth, 1.0f, Color.WHITE);
    }

    public static ImageIcon createUpArrowIcon(int shadeWidth) {
        return new ImageIcon(ImageUtils.createUpArrowImage(shadeWidth));
    }

    public static BufferedImage createUpArrowImage(int shadeWidth) {
        return ImageUtils.createArrowImage(ImageUtils.createUpArrowFill(), ImageUtils.createUpArrowBorder(), shadeWidth);
    }

    private static GeneralPath createUpArrowFill() {
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(0.0f, 7.0f);
        shape.lineTo(5.0f, 1.0f);
        shape.lineTo(10.0f, 7.0f);
        shape.closePath();
        return shape;
    }

    private static GeneralPath createUpArrowBorder() {
        GeneralPath border = new GeneralPath(0);
        border.moveTo(0.0f, 6.0f);
        border.lineTo(4.0f, 2.0f);
        border.lineTo(8.0f, 6.0f);
        border.closePath();
        return border;
    }

    public static ImageIcon createSimpleLeftArrowIcon(int shadeWidth) {
        return new ImageIcon(ImageUtils.createSimpleLeftArrowImage(shadeWidth));
    }

    public static BufferedImage createSimpleLeftArrowImage(int shadeWidth) {
        return ImageUtils.createImageShade(10, 10, ImageUtils.createLeftArrowFill(), shadeWidth, 1.0f, Color.WHITE);
    }

    public static ImageIcon createLeftArrowIcon(int shadeWidth) {
        return new ImageIcon(ImageUtils.createLeftArrowImage(shadeWidth));
    }

    public static BufferedImage createLeftArrowImage(int shadeWidth) {
        return ImageUtils.createArrowImage(ImageUtils.createLeftArrowFill(), ImageUtils.createLeftArrowBorder(), shadeWidth);
    }

    private static GeneralPath createLeftArrowFill() {
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(7.0f, 0.0f);
        shape.lineTo(1.0f, 5.0f);
        shape.lineTo(7.0f, 10.0f);
        shape.closePath();
        return shape;
    }

    private static GeneralPath createLeftArrowBorder() {
        GeneralPath border = new GeneralPath(0);
        border.moveTo(6.0f, 0.0f);
        border.lineTo(2.0f, 4.0f);
        border.lineTo(6.0f, 8.0f);
        border.closePath();
        return border;
    }

    public static ImageIcon createSimpleDownArrowIcon(int shadeWidth) {
        return new ImageIcon(ImageUtils.createSimpleDownArrowImage(shadeWidth));
    }

    public static BufferedImage createSimpleDownArrowImage(int shadeWidth) {
        return ImageUtils.createImageShade(10, 10, ImageUtils.createDownArrowFill(), shadeWidth, 1.0f, Color.WHITE);
    }

    public static ImageIcon createDownArrowIcon(int shadeWidth) {
        return new ImageIcon(ImageUtils.createDownArrowImage(shadeWidth));
    }

    public static BufferedImage createDownArrowImage(int shadeWidth) {
        return ImageUtils.createArrowImage(ImageUtils.createDownArrowFill(), ImageUtils.createDownArrowBorder(), shadeWidth);
    }

    private static GeneralPath createDownArrowFill() {
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(0.0f, 3.0f);
        shape.lineTo(5.0f, 9.0f);
        shape.lineTo(10.0f, 3.0f);
        shape.closePath();
        return shape;
    }

    private static GeneralPath createDownArrowBorder() {
        GeneralPath border = new GeneralPath(0);
        border.moveTo(0.0f, 3.0f);
        border.lineTo(4.0f, 7.0f);
        border.lineTo(8.0f, 3.0f);
        border.closePath();
        return border;
    }

    public static ImageIcon createSimpleRightArrowIcon(int shadeWidth) {
        return new ImageIcon(ImageUtils.createSimpleRightArrowImage(shadeWidth));
    }

    public static BufferedImage createSimpleRightArrowImage(int shadeWidth) {
        return ImageUtils.createImageShade(10, 10, ImageUtils.createRightArrowFill(), shadeWidth, 1.0f, Color.WHITE);
    }

    public static ImageIcon createRightArrowIcon(int shadeWidth) {
        return new ImageIcon(ImageUtils.createRightArrowImage(shadeWidth));
    }

    public static BufferedImage createRightArrowImage(int shadeWidth) {
        return ImageUtils.createArrowImage(ImageUtils.createRightArrowFill(), ImageUtils.createRightArrowBorder(), shadeWidth);
    }

    private static GeneralPath createRightArrowFill() {
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(3.0f, 0.0f);
        shape.lineTo(9.0f, 5.0f);
        shape.lineTo(3.0f, 10.0f);
        shape.closePath();
        return shape;
    }

    private static GeneralPath createRightArrowBorder() {
        GeneralPath border = new GeneralPath(0);
        border.moveTo(3.0f, 0.0f);
        border.lineTo(7.0f, 4.0f);
        border.lineTo(3.0f, 8.0f);
        border.closePath();
        return border;
    }

    private static BufferedImage createArrowImage(GeneralPath shape, GeneralPath border, int shadeWidth) {
        BufferedImage image = ImageUtils.createImageShade(10, 10, shape, shadeWidth, 1.0f, Color.BLACK);
        Graphics2D g2d = image.createGraphics();
        LafUtils.setupAntialias(g2d);
        g2d.setPaint(Color.WHITE);
        g2d.translate(shadeWidth, shadeWidth);
        g2d.draw(border);
        g2d.dispose();
        return image;
    }
}

