/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import java.awt.Color;
import java.util.Random;
import java.util.StringTokenizer;

public final class ColorUtils {
    public static Color removeAlpha(Color color) {
        if (color.getAlpha() != 255) {
            return new Color(color.getRGB(), false);
        }
        return color;
    }

    public static Color getTransparentColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color getIntermediateColor(Color color1, Color color2, float progress) {
        if (progress <= 0.0f) {
            return color1;
        }
        if (progress >= 1.0f) {
            return color2;
        }
        return new Color(ColorUtils.getIntermediateValue(color1.getRed(), color2.getRed(), progress), ColorUtils.getIntermediateValue(color1.getGreen(), color2.getGreen(), progress), ColorUtils.getIntermediateValue(color1.getBlue(), color2.getBlue(), progress), ColorUtils.getIntermediateValue(color1.getAlpha(), color2.getAlpha(), progress));
    }

    public static int getIntermediateValue(int value1, int value2, float progress) {
        return value1 + Math.round(((float)value2 - (float)value1) * progress);
    }

    public static Color getWebSafeColor(Color color) {
        return new Color(ColorUtils.getWebSafeValue(color.getRed()), ColorUtils.getWebSafeValue(color.getGreen()), ColorUtils.getWebSafeValue(color.getBlue()));
    }

    public static int getWebSafeValue(int value) {
        if (0 <= value && value <= 51) {
            return value > 51 - value ? 51 : 0;
        }
        if (51 <= value && value <= 102) {
            return 51 + value > 102 - value ? 102 : 51;
        }
        if (102 <= value && value <= 153) {
            return 102 + value > 153 - value ? 153 : 102;
        }
        if (153 <= value && value <= 204) {
            return 153 + value > 204 - value ? 204 : 153;
        }
        if (204 <= value && value <= 255) {
            return 204 + value > 255 - value ? 255 : 204;
        }
        return value;
    }

    public static String getHexColor(Color color) {
        return ColorUtils.getHexColor(color.getRGB());
    }

    public static String getHexColor(int rgb) {
        if (rgb == 0) {
            return "000000";
        }
        String hex = Integer.toHexString(rgb).toUpperCase();
        return hex.substring(2, hex.length());
    }

    public static Color parseHexColor(String hex) {
        return Color.decode((hex = hex.replaceAll(" ", "")).startsWith("#") ? hex : "#" + hex);
    }

    public static Color parseRgbColor(String rgb) {
        return ColorUtils.parseRgbColor(rgb, ",");
    }

    public static Color parseRgbColor(String rgb, String separator) {
        StringTokenizer st = new StringTokenizer(rgb = rgb.replaceAll(" ", ""), separator, false);
        int count = st.countTokens();
        if (count == 3) {
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        if (count == 4) {
            return new Color(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        return null;
    }

    public static Color black(int alpha) {
        return new Color(0, 0, 0, alpha);
    }

    public static Color white(int alpha) {
        return new Color(255, 255, 255, alpha);
    }

    public static Color getRandomSoftColor(Color base) {
        Random random = new Random();
        int red = random.nextInt(256);
        int green = random.nextInt(256);
        int blue = random.nextInt(256);
        if (base != null) {
            red = (red + base.getRed()) / 2;
            green = (green + base.getGreen()) / 2;
            blue = (blue + base.getBlue()) / 2;
        }
        return new Color(red, green, blue);
    }
}

