/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.extended.button.WebSplitButton;
import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.extended.label.WebMultiLineLabel;
import com.alee.extended.label.WebVerticalLabel;
import com.alee.laf.WebLookAndFeel;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.laf.Styleable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;

public enum SupportedComponent {
    label{

        @Override
        public boolean supportsPainters() {
            return true;
        }

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JLabel.class;
        }

        @Override
        public String getUIClassID() {
            return "LabelUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.labelUI;
        }
    }
    ,
    verticalLabel{

        @Override
        public boolean supportsPainters() {
            return true;
        }

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return WebVerticalLabel.class;
        }

        @Override
        public String getUIClassID() {
            return "VerticalLabelUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.verticalLabelUI;
        }
    }
    ,
    multiLineLabel{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return WebMultiLineLabel.class;
        }

        @Override
        public String getUIClassID() {
            return "MultiLineLabelUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.multiLineLabelUI;
        }
    }
    ,
    toolTip{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JToolTip.class;
        }

        @Override
        public String getUIClassID() {
            return "ToolTipUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.toolTipUI;
        }
    }
    ,
    button{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JButton.class;
        }

        @Override
        public String getUIClassID() {
            return "ButtonUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.buttonUI;
        }
    }
    ,
    splitButton{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return WebSplitButton.class;
        }

        @Override
        public String getUIClassID() {
            return "SplitButtonUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.splitButtonUI;
        }
    }
    ,
    toggleButton{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JToggleButton.class;
        }

        @Override
        public String getUIClassID() {
            return "ToggleButtonUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.toggleButtonUI;
        }
    }
    ,
    checkBox{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JCheckBox.class;
        }

        @Override
        public String getUIClassID() {
            return "CheckBoxUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.checkBoxUI;
        }
    }
    ,
    tristateCheckBox{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return WebTristateCheckBox.class;
        }

        @Override
        public String getUIClassID() {
            return "TristateCheckBoxUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.tristateCheckBoxUI;
        }
    }
    ,
    radioButton{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JRadioButton.class;
        }

        @Override
        public String getUIClassID() {
            return "RadioButtonUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.radioButtonUI;
        }
    }
    ,
    menuBar{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JMenuBar.class;
        }

        @Override
        public String getUIClassID() {
            return "MenuBarUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.menuBarUI;
        }
    }
    ,
    menu{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JMenu.class;
        }

        @Override
        public String getUIClassID() {
            return "MenuUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.menuUI;
        }
    }
    ,
    popupMenu{

        @Override
        public boolean supportsPainters() {
            return true;
        }

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JPopupMenu.class;
        }

        @Override
        public String getUIClassID() {
            return "PopupMenuUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.popupMenuUI;
        }
    }
    ,
    menuItem{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JMenuItem.class;
        }

        @Override
        public String getUIClassID() {
            return "MenuItemUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.menuItemUI;
        }
    }
    ,
    checkBoxMenuItem{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JCheckBoxMenuItem.class;
        }

        @Override
        public String getUIClassID() {
            return "CheckBoxMenuItemUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.checkBoxMenuItemUI;
        }
    }
    ,
    radioButtonMenuItem{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JRadioButtonMenuItem.class;
        }

        @Override
        public String getUIClassID() {
            return "RadioButtonMenuItemUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.radioButtonMenuItemUI;
        }
    }
    ,
    popupMenuSeparator{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JPopupMenu.Separator.class;
        }

        @Override
        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.popupMenuSeparatorUI;
        }
    }
    ,
    separator{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JSeparator.class;
        }

        @Override
        public String getUIClassID() {
            return "SeparatorUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.separatorUI;
        }
    }
    ,
    scrollBar{

        @Override
        public boolean supportsPainters() {
            return true;
        }

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JScrollBar.class;
        }

        @Override
        public String getUIClassID() {
            return "ScrollBarUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.scrollBarUI;
        }
    }
    ,
    scrollPane{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JScrollPane.class;
        }

        @Override
        public String getUIClassID() {
            return "ScrollPaneUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.scrollPaneUI;
        }
    }
    ,
    viewport{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JViewport.class;
        }

        @Override
        public String getUIClassID() {
            return "ViewportUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.viewportUI;
        }
    }
    ,
    textField{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JTextField.class;
        }

        @Override
        public String getUIClassID() {
            return "TextFieldUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.textFieldUI;
        }
    }
    ,
    passwordField{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JPasswordField.class;
        }

        @Override
        public String getUIClassID() {
            return "PasswordFieldUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.passwordFieldUI;
        }
    }
    ,
    formattedTextField{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JFormattedTextField.class;
        }

        @Override
        public String getUIClassID() {
            return "FormattedTextFieldUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.formattedTextFieldUI;
        }
    }
    ,
    textArea{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JTextArea.class;
        }

        @Override
        public String getUIClassID() {
            return "TextAreaUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.textAreaUI;
        }
    }
    ,
    editorPane{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JEditorPane.class;
        }

        @Override
        public String getUIClassID() {
            return "EditorPaneUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.editorPaneUI;
        }
    }
    ,
    textPane{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JTextPane.class;
        }

        @Override
        public String getUIClassID() {
            return "TextPaneUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.textPaneUI;
        }
    }
    ,
    toolBar{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JToolBar.class;
        }

        @Override
        public String getUIClassID() {
            return "ToolBarUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.toolBarUI;
        }
    }
    ,
    toolBarSeparator{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JToolBar.Separator.class;
        }

        @Override
        public String getUIClassID() {
            return "ToolBarSeparatorUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.toolBarSeparatorUI;
        }
    }
    ,
    table{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JTable.class;
        }

        @Override
        public String getUIClassID() {
            return "TableUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.tableUI;
        }
    }
    ,
    tableHeader{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JTableHeader.class;
        }

        @Override
        public String getUIClassID() {
            return "TableHeaderUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.tableHeaderUI;
        }
    }
    ,
    colorChooser{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JColorChooser.class;
        }

        @Override
        public String getUIClassID() {
            return "ColorChooserUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.colorChooserUI;
        }
    }
    ,
    fileChooser{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JFileChooser.class;
        }

        @Override
        public String getUIClassID() {
            return "FileChooserUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.fileChooserUI;
        }
    }
    ,
    panel{

        @Override
        public boolean supportsPainters() {
            return true;
        }

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JPanel.class;
        }

        @Override
        public String getUIClassID() {
            return "PanelUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.panelUI;
        }
    }
    ,
    rootPane{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JRootPane.class;
        }

        @Override
        public String getUIClassID() {
            return "RootPaneUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.rootPaneUI;
        }
    }
    ,
    tabbedPane{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JTabbedPane.class;
        }

        @Override
        public String getUIClassID() {
            return "TabbedPaneUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.tabbedPaneUI;
        }
    }
    ,
    splitPane{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JSplitPane.class;
        }

        @Override
        public String getUIClassID() {
            return "SplitPaneUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.splitPaneUI;
        }
    }
    ,
    progressBar{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JProgressBar.class;
        }

        @Override
        public String getUIClassID() {
            return "ProgressBarUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.progressBarUI;
        }
    }
    ,
    slider{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JSlider.class;
        }

        @Override
        public String getUIClassID() {
            return "SliderUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.sliderUI;
        }
    }
    ,
    spinner{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JSpinner.class;
        }

        @Override
        public String getUIClassID() {
            return "SpinnerUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.spinnerUI;
        }
    }
    ,
    tree{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JTree.class;
        }

        @Override
        public String getUIClassID() {
            return "TreeUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.treeUI;
        }
    }
    ,
    list{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JList.class;
        }

        @Override
        public String getUIClassID() {
            return "ListUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.listUI;
        }
    }
    ,
    comboBox{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JComboBox.class;
        }

        @Override
        public String getUIClassID() {
            return "ComboBoxUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.comboBoxUI;
        }
    }
    ,
    desktopPane{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JDesktopPane.class;
        }

        @Override
        public String getUIClassID() {
            return "DesktopPaneUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.desktopPaneUI;
        }
    }
    ,
    desktopIcon{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JInternalFrame.JDesktopIcon.class;
        }

        @Override
        public String getUIClassID() {
            return "DesktopIconUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.desktopIconUI;
        }
    }
    ,
    internalFrame{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JInternalFrame.class;
        }

        @Override
        public String getUIClassID() {
            return "InternalFrameUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.internalFrameUI;
        }
    }
    ,
    optionPane{

        @Override
        public Class<? extends JComponent> getComponentClass() {
            return JOptionPane.class;
        }

        @Override
        public String getUIClassID() {
            return "OptionPaneUI";
        }

        @Override
        public String getDefaultUIClass() {
            return WebLookAndFeel.optionPaneUI;
        }
    };

    private static final Map<SupportedComponent, ImageIcon> componentIcons;
    private static final Map<String, SupportedComponent> componentByUIClassID;

    public boolean supportsPainters() {
        return false;
    }

    public abstract Class<? extends JComponent> getComponentClass();

    public abstract String getUIClassID();

    public abstract String getDefaultUIClass();

    public String getComponentStyleId(JComponent component) {
        Styleable styleable = LafUtils.getStyleable(component);
        String styleId = styleable != null ? styleable.getStyleId() : "default";
        return styleId != null ? styleId : "default";
    }

    public Class<? extends ComponentUI> getUIClass() {
        Class type = ReflectUtils.getClassSafely(UIManager.getString(this.getUIClassID()));
        Class defaultType = ReflectUtils.getClassSafely(this.getDefaultUIClass());
        return ReflectUtils.isAssignable(defaultType, type) ? type : defaultType;
    }

    public ImageIcon getIcon() {
        ImageIcon icon = componentIcons.get((Object)this);
        if (icon == null) {
            icon = new ImageIcon(SupportedComponent.class.getResource("icons/component/" + (Object)((Object)this) + ".png"));
            componentIcons.put(this, icon);
        }
        return icon;
    }

    public static SupportedComponent getComponentTypeByUIClassID(String uiClassID) {
        if (componentByUIClassID.size() == 0) {
            for (SupportedComponent supportedComponent : SupportedComponent.values()) {
                componentByUIClassID.put(supportedComponent.getUIClassID(), supportedComponent);
            }
        }
        return componentByUIClassID.get(uiClassID);
    }

    public static List<SupportedComponent> getPainterSupportedComponents() {
        ArrayList<SupportedComponent> supportedComponents = new ArrayList<SupportedComponent>();
        for (SupportedComponent sc : SupportedComponent.values()) {
            if (!sc.supportsPainters()) continue;
            supportedComponents.add(sc);
        }
        return supportedComponents;
    }

    static {
        componentIcons = new EnumMap<SupportedComponent, ImageIcon>(SupportedComponent.class);
        componentByUIClassID = new HashMap<String, SupportedComponent>(SupportedComponent.values().length);
    }
}

