/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.managers.settings.SettingsListener;
import com.alee.managers.settings.SettingsManager;
import com.alee.managers.settings.SettingsProcessorData;
import java.awt.Component;
import java.io.Serializable;

public abstract class SettingsProcessor<C extends Component, V extends Serializable> {
    private static final String ERROR_PREFIX = "[SettingsProcessor] ";
    protected boolean loading;
    protected boolean saving;
    protected SettingsProcessorData data;

    public SettingsProcessor(Component component, String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        this(new SettingsProcessorData(component, group, key, defaultValue, loadInitialSettings, applySettingsChanges));
    }

    public SettingsProcessor(SettingsProcessorData data) {
        block7: {
            block6: {
                this.loading = false;
                this.saving = false;
                this.data = data;
                if (data.isLoadInitialSettings()) {
                    try {
                        this.load();
                    }
                    catch (Throwable e) {
                        if (!SettingsManager.isDisplayExceptions()) break block6;
                        System.err.println("[SettingsProcessor] Unable to load initial component settings for group \"" + data.getGroup() + "\" and key \"" + data.getKey() + "\" due to unexpected exception:");
                        e.printStackTrace();
                    }
                }
            }
            try {
                this.doInit(this.getComponent());
            }
            catch (Throwable e) {
                if (!SettingsManager.isDisplayExceptions()) break block7;
                System.err.println("[SettingsProcessor] Unable to initialize specific processor settings for component with group \"" + data.getGroup() + "\" and key \"" + data.getKey() + "\" due to unexpected exception:");
                e.printStackTrace();
            }
        }
        if (data.isApplySettingsChanges()) {
            SettingsManager.addSettingsListener(this.getGroup(), this.getKey(), new SettingsListener(){

                @Override
                public void settingsChanged(String group, String key, Object newValue) {
                    SettingsProcessor.this.load();
                }
            });
        }
    }

    public SettingsProcessorData getData() {
        return this.data;
    }

    public C getComponent() {
        return (C)this.data.getComponent();
    }

    public String getGroup() {
        return this.data.getGroup();
    }

    public String getKey() {
        return this.data.getKey();
    }

    public V getDefaultValue() {
        return (V)((Serializable)this.data.getDefaultValue());
    }

    public final void load() {
        if (this.loading || this.saving) {
            return;
        }
        this.loading = true;
        this.doLoad(this.getComponent());
        this.loading = false;
    }

    public final void save() {
        this.save(true);
    }

    public final void save(boolean onChange) {
        if (onChange && !SettingsManager.isSaveOnChange()) {
            return;
        }
        if (this.loading || this.saving) {
            return;
        }
        this.saving = true;
        this.doSave(this.getComponent());
        this.saving = false;
    }

    public final void destroy() {
        this.doDestroy(this.getComponent());
        this.data = null;
    }

    protected V loadValue() {
        return (V)((Serializable)SettingsManager.get(this.getGroup(), this.getKey(), this.getDefaultValue()));
    }

    protected void saveValue(V value) {
        SettingsManager.set(this.getGroup(), this.getKey(), value);
    }

    protected abstract void doInit(C var1);

    protected abstract void doDestroy(C var1);

    protected abstract void doLoad(C var1);

    protected abstract void doSave(C var1);
}

