/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.extended.colorchooser.WebGradientColorChooser;
import com.alee.extended.date.WebDateField;
import com.alee.extended.panel.WebAccordion;
import com.alee.extended.panel.WebCollapsiblePane;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.managers.settings.processors.AbstractButtonSettingsProcessor;
import com.alee.managers.settings.processors.JComboBoxSettingsProcessor;
import com.alee.managers.settings.processors.JPasswordFieldSettingsProcessor;
import com.alee.managers.settings.processors.JScrollBarSettingsProcessor;
import com.alee.managers.settings.processors.JSliderSettingsProcessor;
import com.alee.managers.settings.processors.JTabbedPaneSettingsProcessor;
import com.alee.managers.settings.processors.JTextComponentSettingsProcessor;
import com.alee.managers.settings.processors.WebAccordionSettingsProcessor;
import com.alee.managers.settings.processors.WebCollapsiblePaneSettingsProcessor;
import com.alee.managers.settings.processors.WebDateFieldSettingsProcessor;
import com.alee.managers.settings.processors.WebGradientColorChooserSettingsProcessor;
import com.alee.managers.settings.processors.WindowSettingsProcessor;
import com.alee.utils.ReflectUtils;
import java.awt.Component;
import java.awt.Window;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.text.JTextComponent;

public final class ComponentSettingsManager {
    private static final Map<Class, Class> settingsProcessorClasses = new LinkedHashMap<Class, Class>();
    private static final Map<Component, SettingsProcessor> settingsProcessors = new WeakHashMap<Component, SettingsProcessor>();
    private static boolean throwExceptions = true;
    private static boolean initialized = false;

    public static void initializeManager() {
        if (!initialized) {
            initialized = true;
            ComponentSettingsManager.registerSettingsProcessor(AbstractButton.class, AbstractButtonSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JComboBox.class, JComboBoxSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JSlider.class, JSliderSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(WebDateField.class, WebDateFieldSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JPasswordField.class, JPasswordFieldSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JTextComponent.class, JTextComponentSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JScrollBar.class, JScrollBarSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(WebCollapsiblePane.class, WebCollapsiblePaneSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(WebAccordion.class, WebAccordionSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(WebGradientColorChooser.class, WebGradientColorChooserSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(JTabbedPane.class, JTabbedPaneSettingsProcessor.class);
            ComponentSettingsManager.registerSettingsProcessor(Window.class, WindowSettingsProcessor.class);
        }
    }

    public static boolean isThrowExceptions() {
        return throwExceptions;
    }

    public static void setThrowExceptions(boolean throwExceptions) {
        ComponentSettingsManager.throwExceptions = throwExceptions;
    }

    public static boolean isComponentSupported(Component component) {
        return ComponentSettingsManager.isComponentSupported(component.getClass());
    }

    public static boolean isComponentSupported(Class componentType) {
        return ComponentSettingsManager.findSuitableSettingsProcessor(componentType) != null;
    }

    public static <T extends SettingsProcessor> void registerSettingsProcessor(Class componentType, Class<T> settingsProcessor) {
        settingsProcessorClasses.put(componentType, settingsProcessor);
    }

    private static Class findSuitableSettingsProcessor(Class componentType) {
        for (Class type : settingsProcessorClasses.keySet()) {
            if (!ReflectUtils.isAssignable(type, componentType)) continue;
            return settingsProcessorClasses.get(type);
        }
        return null;
    }

    private static SettingsProcessor createSettingsProcessor(SettingsProcessorData data) {
        Class settingsProcessorClass = ComponentSettingsManager.findSuitableSettingsProcessor(data.getComponent().getClass());
        if (settingsProcessorClass != null) {
            try {
                return (SettingsProcessor)ReflectUtils.createInstance(settingsProcessorClass, data);
            }
            catch (Throwable e) {
                if (throwExceptions) {
                    throw new RuntimeException("Cannot instantiate SettingsProcessor class: " + settingsProcessorClass.getCanonicalName() + ".", e);
                }
                return null;
            }
        }
        return null;
    }

    public static void registerComponent(SettingsProcessorData data) {
        SettingsProcessor settingsProcessor = ComponentSettingsManager.createSettingsProcessor(data);
        if (settingsProcessor != null) {
            ComponentSettingsManager.registerComponent(data.getComponent(), settingsProcessor);
        } else if (throwExceptions) {
            throw new RuntimeException("Component type " + data.getComponent().getClass().getCanonicalName() + " is not supported.");
        }
    }

    public static void registerComponent(Component component, SettingsProcessor settingsProcessor) {
        ComponentSettingsManager.unregisterComponent(component);
        settingsProcessors.put(component, settingsProcessor);
    }

    public static void loadSettings(Component component) {
        SettingsProcessor settingsProcessor = settingsProcessors.get(component);
        if (settingsProcessor != null) {
            settingsProcessor.load();
        } else if (throwExceptions) {
            throw new RuntimeException("Component " + component + " was not registered.");
        }
    }

    public static void saveSettings() {
        for (Map.Entry<Component, SettingsProcessor> entry : settingsProcessors.entrySet()) {
            ComponentSettingsManager.saveSettings(entry.getKey());
        }
    }

    public static void saveSettings(Component component) {
        SettingsProcessor settingsProcessor = settingsProcessors.get(component);
        if (settingsProcessor != null) {
            settingsProcessor.save(false);
        } else if (throwExceptions) {
            throw new RuntimeException("Component " + component + " was not registered.");
        }
    }

    public static void unregisterComponent(Component component) {
        SettingsProcessor settingsProcessor = settingsProcessors.get(component);
        if (settingsProcessor != null) {
            settingsProcessor.destroy();
            settingsProcessors.remove(component);
        }
    }
}

