/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.extended.layout.TableLayout;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.popup.PopupManager;
import com.alee.managers.popup.PopupWay;
import com.alee.managers.popup.WebPopup;
import com.alee.managers.style.skin.web.WebPanelPainter;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.AncestorEvent;

public class WebButtonPopup
extends WebPopup {
    private static final List<String> BUTTON_PROPERTIES = Arrays.asList("icon", "text", "horizontalAlignment", "verticalAlignment", "horizontalTextPosition", "verticalTextPosition", "iconTextGap", "border");
    private PopupWay popupWay;
    private final WebButton button;
    private final WebButton copiedButton;
    private final WebPanel container;

    public WebButtonPopup(final WebButton button, PopupWay popupWay) {
        this.popupWay = popupWay;
        this.button = button;
        this.setCloseOnFocusLoss(true);
        this.setFocusCycleRoot(false);
        this.setPainter(new WebButtonPopupPainter());
        this.copiedButton = this.copy(button);
        this.copiedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebButtonPopup.this.hidePopup(true);
            }
        });
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebButtonPopup.this.showPopup();
            }
        });
        button.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (BUTTON_PROPERTIES.contains(evt.getPropertyName())) {
                    WebButtonPopup.this.copySettings(button, WebButtonPopup.this.copiedButton);
                }
            }
        });
        button.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getID() == 1) {
                    WebButtonPopup.this.hidePopup(false);
                }
            }
        });
        button.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                WebButtonPopup.this.hidePopup(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                WebButtonPopup.this.updateBounds();
            }
        });
        button.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                WebButtonPopup.this.hidePopup(false);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                WebButtonPopup.this.updateBounds();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                WebButtonPopup.this.updateBounds();
            }
        });
        this.container = new WebPanel();
        this.container.setOpaque(false);
        this.container.setFocusCycleRoot(true);
        this.updateContent();
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                WebButtonPopup.this.updateBounds();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                WebButtonPopup.this.updateBounds();
            }
        });
    }

    private void updateContent() {
        this.removeAll();
        if (this.popupWay.equals((Object)PopupWay.downLeft)) {
            this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,0");
            this.add((Component)this.container, (Object)"0,1,1,1");
        } else if (this.popupWay.equals((Object)PopupWay.downCenter)) {
            this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,0");
            this.add((Component)this.container, (Object)"0,1,2,1");
        } else if (this.popupWay.equals((Object)PopupWay.downRight)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -1.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"0,0");
            this.add((Component)this.container, (Object)"0,1,1,1");
        }
        if (this.popupWay.equals((Object)PopupWay.upLeft)) {
            this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,1");
            this.add((Component)this.container, (Object)"0,0,1,0");
        } else if (this.popupWay.equals((Object)PopupWay.upCenter)) {
            this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,1");
            this.add((Component)this.container, (Object)"0,0,2,0");
        } else if (this.popupWay.equals((Object)PopupWay.upRight)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -1.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"0,1");
            this.add((Component)this.container, (Object)"0,0,1,0");
        }
        if (this.popupWay.equals((Object)PopupWay.leftUp)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-1.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,1");
            this.add((Component)this.container, (Object)"0,0,0,1");
        } else if (this.popupWay.equals((Object)PopupWay.leftCenter)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-1.0, -2.0, -1.0}}));
            this.add((Component)this.copiedButton, (Object)"1,1");
            this.add((Component)this.container, (Object)"0,0,0,2");
        } else if (this.popupWay.equals((Object)PopupWay.leftDown)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-2.0, -1.0}}));
            this.add((Component)this.copiedButton, (Object)"1,0");
            this.add((Component)this.container, (Object)"0,0,0,1");
        }
        if (this.popupWay.equals((Object)PopupWay.rightUp)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-1.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"0,1");
            this.add((Component)this.container, (Object)"1,0,1,1");
        } else if (this.popupWay.equals((Object)PopupWay.rightCenter)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-1.0, -2.0, -1.0}}));
            this.add((Component)this.copiedButton, (Object)"0,1");
            this.add((Component)this.container, (Object)"1,0,1,2");
        } else if (this.popupWay.equals((Object)PopupWay.rightDown)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-2.0, -1.0}}));
            this.add((Component)this.copiedButton, (Object)"0,0");
            this.add((Component)this.container, (Object)"1,0,1,1");
        }
        int margin = this.button.getShadeWidth() + 1;
        if (this.isDown()) {
            this.container.setMargin(new Insets(0, margin, margin, margin));
        } else if (this.isUp()) {
            this.container.setMargin(new Insets(margin, margin, 0, margin));
        } else if (this.isLeft()) {
            this.container.setMargin(new Insets(margin, margin, margin, 0));
        } else if (this.isRight()) {
            this.container.setMargin(new Insets(margin, 0, margin, margin));
        }
        this.revalidate();
    }

    @Override
    public void focusChanged(boolean focused) {
        super.focusChanged(focused);
        this.repaint();
    }

    public void setContent(Component component) {
        this.container.removeAll();
        this.container.add(component);
        this.container.revalidate();
    }

    public PopupWay getPopupWay() {
        return this.popupWay;
    }

    public void setPopupWay(PopupWay popupWay) {
        this.popupWay = popupWay;
        this.updateContent();
        this.updateBounds();
    }

    private WebButton copy(final WebButton button) {
        WebButton copy = new WebButton(){

            @Override
            public Dimension getPreferredSize() {
                return button.getSize();
            }
        };
        this.copySettings(button, copy);
        copy.setFocusable(true);
        copy.setUndecorated(true);
        copy.setCursor(button.getCursor());
        return copy;
    }

    private void copySettings(WebButton button, WebButton copy) {
        copy.setIcon(button.getIcon());
        copy.setText(button.getText());
        copy.setIconTextGap(button.getIconTextGap());
        copy.setHorizontalAlignment(button.getHorizontalAlignment());
        copy.setVerticalAlignment(button.getVerticalAlignment());
        copy.setHorizontalTextPosition(button.getHorizontalTextPosition());
        copy.setVerticalTextPosition(button.getVerticalTextPosition());
        copy.setBorder(button.getBorder());
    }

    @Override
    public void updateBounds() {
        if (this.isShowing() && this.button.isShowing()) {
            Point rl = SwingUtils.getRelativeLocation(this.button, this.getParent());
            Dimension ps = this.getPreferredSize();
            if (this.popupWay.equals((Object)PopupWay.downLeft)) {
                this.setBounds(new Rectangle(new Point(rl.x + this.button.getWidth() - ps.width, rl.y), ps));
            } else if (this.popupWay.equals((Object)PopupWay.downCenter)) {
                this.setBounds(new Rectangle(new Point(rl.x + this.button.getWidth() / 2 - ps.width / 2, rl.y), ps));
            } else if (this.popupWay.equals((Object)PopupWay.downRight)) {
                this.setBounds(new Rectangle(rl, ps));
            } else if (this.popupWay.equals((Object)PopupWay.upLeft)) {
                this.setBounds(new Rectangle(new Point(rl.x + this.button.getWidth() - ps.width, rl.y + this.button.getHeight() - ps.height), ps));
            } else if (this.popupWay.equals((Object)PopupWay.upCenter)) {
                this.setBounds(new Rectangle(new Point(rl.x + this.button.getWidth() / 2 - ps.width / 2, rl.y + this.button.getHeight() - ps.height), ps));
            } else if (this.popupWay.equals((Object)PopupWay.upRight)) {
                this.setBounds(new Rectangle(new Point(rl.x, rl.y + this.button.getHeight() - ps.height), ps));
            } else if (this.popupWay.equals((Object)PopupWay.leftUp)) {
                this.setBounds(new Rectangle(new Point(rl.x + this.button.getWidth() - ps.width, rl.y + this.button.getHeight() - ps.height), ps));
            } else if (this.popupWay.equals((Object)PopupWay.leftCenter)) {
                this.setBounds(new Rectangle(new Point(rl.x + this.button.getWidth() - ps.width, rl.y + this.button.getHeight() / 2 - ps.height / 2), ps));
            } else if (this.popupWay.equals((Object)PopupWay.leftDown)) {
                this.setBounds(new Rectangle(new Point(rl.x + this.button.getWidth() - ps.width, rl.y), ps));
            } else if (this.popupWay.equals((Object)PopupWay.rightUp)) {
                this.setBounds(new Rectangle(new Point(rl.x, rl.y + this.button.getHeight() - ps.height), ps));
            } else if (this.popupWay.equals((Object)PopupWay.rightCenter)) {
                this.setBounds(new Rectangle(new Point(rl.x, rl.y + this.button.getHeight() / 2 - ps.height / 2), ps));
            } else if (this.popupWay.equals((Object)PopupWay.rightDown)) {
                this.setBounds(new Rectangle(new Point(rl.x, rl.y), ps));
            }
            this.revalidate();
        }
    }

    @Override
    public boolean contains(Point p) {
        return this.getPopupShape(this).contains(p);
    }

    public Shape getPopupShape(WebButtonPopup c) {
        int shadeWidth = this.button.getShadeWidth();
        int round = this.button.getRound();
        int bh = this.button.getHeight() - 1;
        int bw = this.button.getWidth() - 1;
        int cw = c.getWidth() - 1;
        int ch = c.getHeight() - 1;
        Shape shape = null;
        if (this.isUpDown() && cw == bw || this.isLeftRight() && ch == bh) {
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth));
        } else if (this.popupWay.equals((Object)PopupWay.downLeft)) {
            shape = LafUtils.createRoundedShape(round, this.p(cw - bw + shadeWidth, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth), this.p(shadeWidth, bh), this.p(cw - bw + shadeWidth, bh));
        } else if (this.popupWay.equals((Object)PopupWay.downCenter)) {
            int shear = bw % 2;
            shape = LafUtils.createRoundedShape(round, this.p(cw / 2 - bw / 2 - shear + shadeWidth, shadeWidth), this.p(cw / 2 + bw / 2 - shadeWidth, shadeWidth), this.p(cw / 2 + bw / 2 - shadeWidth, bh), this.p(cw - shadeWidth, bh), this.p(cw - shadeWidth, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth), this.p(shadeWidth, bh), this.p(cw / 2 - bw / 2 - shear + shadeWidth, bh));
        } else if (this.popupWay.equals((Object)PopupWay.downRight)) {
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(bw - shadeWidth, shadeWidth), this.p(bw - shadeWidth, bh), this.p(cw - shadeWidth, bh), this.p(cw - shadeWidth, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth));
        } else if (this.popupWay.equals((Object)PopupWay.upLeft)) {
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, ch - shadeWidth), this.p(cw - bw + shadeWidth, ch - shadeWidth), this.p(cw - bw + shadeWidth, ch - bh), this.p(shadeWidth, ch - bh));
        } else if (this.popupWay.equals((Object)PopupWay.upCenter)) {
            int shear = bw % 2;
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, ch - bh), this.p(cw / 2 + bw / 2 - shadeWidth, ch - bh), this.p(cw / 2 + bw / 2 - shadeWidth, ch - shadeWidth), this.p(cw / 2 - bw / 2 - shear + shadeWidth, ch - shadeWidth), this.p(cw / 2 - bw / 2 - shear + shadeWidth, ch - bh), this.p(shadeWidth, ch - bh));
        } else if (this.popupWay.equals((Object)PopupWay.upRight)) {
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, ch - bh), this.p(bw - shadeWidth, ch - bh), this.p(bw - shadeWidth, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth));
        } else if (this.popupWay.equals((Object)PopupWay.leftUp)) {
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(cw - bw, shadeWidth), this.p(cw - bw, ch - bh + shadeWidth), this.p(cw - shadeWidth, ch - bh + shadeWidth), this.p(cw - shadeWidth, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth));
        } else if (this.popupWay.equals((Object)PopupWay.leftCenter)) {
            int shear = bh % 2;
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(cw - bw, shadeWidth), this.p(cw - bw, ch / 2 - bh / 2 + shadeWidth), this.p(cw - shadeWidth, ch / 2 - bh / 2 + shadeWidth), this.p(cw - shadeWidth, ch / 2 + bh / 2 + shear - shadeWidth), this.p(cw - bw, ch / 2 + bh / 2 + shear - shadeWidth), this.p(cw - bw, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth));
        } else if (this.popupWay.equals((Object)PopupWay.leftDown)) {
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, bh - shadeWidth), this.p(cw - bw, bh - shadeWidth), this.p(cw - bw, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth));
        } else if (this.popupWay.equals((Object)PopupWay.rightUp)) {
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, ch - bh + shadeWidth), this.p(bw, ch - bh + shadeWidth), this.p(bw, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, ch - shadeWidth), this.p(shadeWidth, ch - shadeWidth));
        } else if (this.popupWay.equals((Object)PopupWay.rightCenter)) {
            int shear = bh % 2;
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, ch / 2 - bh / 2 + shadeWidth), this.p(bw, ch / 2 - bh / 2 + shadeWidth), this.p(bw, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, ch - shadeWidth), this.p(bw, ch - shadeWidth), this.p(bw, ch / 2 + bh / 2 + shear - shadeWidth), this.p(shadeWidth, ch / 2 + bh / 2 + shear - shadeWidth));
        } else if (this.popupWay.equals((Object)PopupWay.rightDown)) {
            shape = LafUtils.createRoundedShape(round, this.p(shadeWidth, shadeWidth), this.p(cw - shadeWidth, shadeWidth), this.p(cw - shadeWidth, ch - shadeWidth), this.p(bw, ch - shadeWidth), this.p(bw, bh - shadeWidth), this.p(shadeWidth, bh - shadeWidth));
        }
        return shape;
    }

    private boolean isUpDown() {
        return this.isUp() || this.isDown();
    }

    private boolean isDown() {
        return this.popupWay.equals((Object)PopupWay.downLeft) || this.popupWay.equals((Object)PopupWay.downCenter) || this.popupWay.equals((Object)PopupWay.downRight);
    }

    private boolean isUp() {
        return this.popupWay.equals((Object)PopupWay.upLeft) || this.popupWay.equals((Object)PopupWay.upCenter) || this.popupWay.equals((Object)PopupWay.upRight);
    }

    private boolean isLeftRight() {
        return this.isLeft() || this.isRight();
    }

    private boolean isRight() {
        return this.popupWay.equals((Object)PopupWay.rightUp) || this.popupWay.equals((Object)PopupWay.rightCenter) || this.popupWay.equals((Object)PopupWay.rightDown);
    }

    private boolean isLeft() {
        return this.popupWay.equals((Object)PopupWay.leftUp) || this.popupWay.equals((Object)PopupWay.leftCenter) || this.popupWay.equals((Object)PopupWay.leftDown);
    }

    private Point p(int x, int y) {
        return new Point(x, y);
    }

    @Override
    public Shape provideShape() {
        return this.getPopupShape(this);
    }

    public void showPopup() {
        PopupManager.showPopup(this.button, (WebPopup)this, false);
    }

    @Override
    public void hidePopup() {
        this.hidePopup(false);
    }

    public void hidePopup(boolean requestFocus) {
        if (this.isCloseOnFocusLoss() && this.button.isFocusable() && requestFocus) {
            this.button.requestFocusInWindow();
            return;
        }
        super.hidePopup();
        if (this.button.isFocusable() && requestFocus) {
            this.button.requestFocusInWindow();
        }
    }

    protected class WebButtonPopupPainter
    extends WebPanelPainter<WebButtonPopup> {
        protected WebButtonPopupPainter() {
        }

        @Override
        public void paint(Graphics2D g2d, Rectangle bounds, WebButtonPopup c) {
            LafUtils.drawCustomWebBorder(g2d, c, WebButtonPopup.this.getPopupShape(c), WebButtonPopup.this.button.isFocusable() && WebButtonPopup.this.button.isDrawFocus() && this.focused ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, WebButtonPopup.this.button.getShadeWidth(), true, this.isWebColoredBackground());
        }
    }
}

