/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.updaters;

import com.alee.managers.hotkey.HotkeyInfo;
import com.alee.managers.language.data.Value;
import com.alee.managers.language.updaters.LanguageUpdater;
import java.awt.Component;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class DefaultLanguageUpdater<E extends Component>
implements LanguageUpdater<E> {
    public static final String INPUT_PROMPT = "inputPropmt";
    public static final String DROP_TEXT = "dropText";
    private static final Map<Component, HotkeyInfo> hotkeysCache = new WeakHashMap<Component, HotkeyInfo>();

    @Override
    public Class getComponentClass() {
        try {
            return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected static void cacheHotkey(Component component, HotkeyInfo hotkeyInfo) {
        hotkeysCache.put(component, hotkeyInfo);
    }

    protected static boolean isHotkeyCached(Component component) {
        return hotkeysCache.containsKey(component);
    }

    protected static HotkeyInfo getCachedHotkey(Component component) {
        return hotkeysCache.get(component);
    }

    protected String getDefaultText(Value value, Object ... data) {
        return this.getDefaultText(null, value, data);
    }

    protected String getDefaultText(String state, Value value, Object ... data) {
        return this.getDefaultText(state, false, value, data);
    }

    protected String getDefaultText(String state, boolean defaultState, Value value, Object ... data) {
        String text = value.getText(state, defaultState);
        return data != null && text != null ? this.formatDefaultText(text, data) : text;
    }

    private String formatDefaultText(String text, Object[] data) {
        return String.format(text, data);
    }
}

