/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.data;

import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipConverter;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.Value;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;

public class ValueConverter
implements Converter {
    private static final String LANGUAGE = "lang";
    private static final String MNEMONIC = "mnemonic";
    private static final String HOTKEY = "hotkey";
    private static final String STATE = "state";
    private static final String TIP_TYPE = "type";
    private static final String TIP_WAY = "way";
    private static final String TIP_DELAY = "delay";
    public static final String TOOLTIP_KEY = "tooltip";

    @Override
    public boolean canConvert(Class type) {
        return Value.class.getCanonicalName().equals(type.getCanonicalName());
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Value value = (Value)source;
        if (value.getLang() != null) {
            writer.addAttribute(LANGUAGE, value.getLang());
        }
        if (value.getMnemonic() != null) {
            writer.addAttribute(MNEMONIC, value.getMnemonic().toString());
        }
        if (value.getHotkey() != null) {
            writer.addAttribute(HOTKEY, value.getHotkey());
        }
        if (value.getTexts() != null && value.getTexts().size() == 1 && (value.getTooltips() == null || value.getTooltips().size() == 0)) {
            Text text = value.getTextObject(0);
            if (text.getState() != null) {
                writer.addAttribute(STATE, text.getState());
            }
            writer.setValue(text.getText());
        } else if (value.getTooltips() != null && value.getTooltips().size() == 1 && (value.getTexts() == null || value.getTexts().size() == 0)) {
            Tooltip tooltip = value.getTooltipObject(0);
            if (TooltipConverter.shouldWriteDelay(tooltip)) {
                writer.addAttribute(TIP_DELAY, tooltip.getDelay().toString());
            }
            if (TooltipConverter.shouldWriteWay(tooltip)) {
                writer.addAttribute(TIP_WAY, tooltip.getWay().toString());
            }
            if (TooltipConverter.shouldWriteType(tooltip)) {
                writer.addAttribute(TIP_TYPE, tooltip.getType().toString());
            }
            writer.addAttribute(STATE, TOOLTIP_KEY);
            writer.setValue(tooltip.getText());
        } else if (value.getTexts() != null && value.getTexts().size() > 0 || value.getTooltips() != null && value.getTooltips().size() > 0) {
            context.convertAnother(value.getTexts());
            context.convertAnother(value.getTooltips());
        } else {
            writer.setValue("");
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Value value = new Value();
        value.setLang(reader.getAttribute(LANGUAGE));
        String mnemonicValue = reader.getAttribute(MNEMONIC);
        value.setMnemonic(mnemonicValue != null ? Character.valueOf(mnemonicValue.charAt(0)) : null);
        value.setHotkey(reader.getAttribute(HOTKEY));
        String state = reader.getAttribute(STATE);
        TooltipType tipType = TooltipConverter.parseType(reader.getAttribute(TIP_TYPE));
        TooltipWay tipWay = TooltipConverter.parseWay(reader.getAttribute(TIP_WAY));
        Integer tipDelay = TooltipConverter.parseDelay(reader.getAttribute(TIP_DELAY));
        String text = reader.getValue();
        ArrayList<Text> texts = new ArrayList<Text>();
        ArrayList<Tooltip> tooltips = new ArrayList<Tooltip>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("text")) {
                texts.add((Text)context.convertAnother(value, Text.class));
            } else if (reader.getNodeName().equals(TOOLTIP_KEY)) {
                tooltips.add((Tooltip)context.convertAnother(value, Tooltip.class));
            }
            reader.moveUp();
        }
        if (texts.size() == 0 && tooltips.size() == 0) {
            if (state != null && state.equals(TOOLTIP_KEY)) {
                value.setTooltips(CollectionUtils.copy(new Tooltip(tipType, tipWay, tipDelay, text)));
                value.setTexts(null);
            } else {
                value.setTexts(CollectionUtils.copy(new Text(text, state)));
                value.setTooltips(null);
            }
        } else {
            value.setTexts(texts.size() > 0 ? texts : null);
            value.setTooltips(tooltips.size() > 0 ? tooltips : null);
        }
        return value;
    }
}

