/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.laf.WebLookAndFeel;
import com.alee.managers.language.LanguageConstants;
import com.alee.managers.language.LanguageKeyListener;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageUpdaterComparator;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.LanguageInfo;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.TooltipType;
import com.alee.managers.language.data.Value;
import com.alee.managers.language.updaters.AbstractButtonLU;
import com.alee.managers.language.updaters.DialogLU;
import com.alee.managers.language.updaters.FrameLU;
import com.alee.managers.language.updaters.JFileChooserLU;
import com.alee.managers.language.updaters.JInternalFrameLU;
import com.alee.managers.language.updaters.JLabelLU;
import com.alee.managers.language.updaters.JProgressBarLU;
import com.alee.managers.language.updaters.JTabbedPaneLU;
import com.alee.managers.language.updaters.JTextComponentLU;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.language.updaters.WebCollapsiblePaneLU;
import com.alee.managers.language.updaters.WebFileDropLU;
import com.alee.managers.language.updaters.WebFormattedTextFieldLU;
import com.alee.managers.language.updaters.WebPasswordFieldLU;
import com.alee.managers.language.updaters.WebTextFieldLU;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public final class LanguageManager
implements LanguageConstants {
    public static final ImageIcon other = new ImageIcon(LanguageManager.class.getResource("icons/lang/other.png"));
    private static final Object supportedLanguagesLock = new Object();
    private static final List<String> supportedLanguages = CollectionUtils.copy("en", "ru", "pl", "ar", "es", "fr", "pt", "de");
    public static String DEFAULT;
    private static String language;
    private static ComponentOrientation orientation;
    private static TooltipType defaultTooltipType;
    private static final Object languageListenersLock;
    private static final List<LanguageListener> languageListeners;
    private static final Object languageKeyListenersLock;
    private static final Map<String, List<LanguageKeyListener>> languageKeyListeners;
    private static Dictionary globalDictionary;
    private static final Map<String, Value> globalCache;
    private static final List<Dictionary> dictionaries;
    private static final Object componentsLock;
    private static final Map<Component, String> components;
    private static final Map<Component, Object[]> componentsData;
    private static final Map<Component, String> componentKeysCache;
    private static final Map<Component, AncestorListener> componentsListeners;
    private static final Object languageContainersLock;
    private static final Map<Container, String> languageContainers;
    private static final Object updatersLock;
    private static final LanguageUpdaterComparator languageUpdaterComparator;
    private static final List<LanguageUpdater> updaters;
    private static final Map<Component, LanguageUpdater> customUpdaters;
    private static final Map<Class, LanguageUpdater> updatersCache;
    private static final Map<Component, List<WebCustomTooltip>> tooltipsCache;
    private static final Map<String, ImageIcon> languageIcons;
    private static boolean initialized;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            language = supportedLanguages.contains(DEFAULT) ? DEFAULT : "en";
            LanguageManager.updateLocale();
            globalDictionary = new Dictionary();
            XmlUtils.processAnnotations(Dictionary.class);
            XmlUtils.processAnnotations(LanguageInfo.class);
            XmlUtils.processAnnotations(Record.class);
            XmlUtils.processAnnotations(Value.class);
            XmlUtils.processAnnotations(Text.class);
            XmlUtils.processAnnotations(Tooltip.class);
            XmlUtils.processAnnotations(TooltipType.class);
            LanguageManager.registerLanguageUpdater(new JLabelLU());
            LanguageManager.registerLanguageUpdater(new AbstractButtonLU());
            LanguageManager.registerLanguageUpdater(new JTextComponentLU());
            LanguageManager.registerLanguageUpdater(new JTabbedPaneLU());
            LanguageManager.registerLanguageUpdater(new WebTextFieldLU());
            LanguageManager.registerLanguageUpdater(new WebFormattedTextFieldLU());
            LanguageManager.registerLanguageUpdater(new WebPasswordFieldLU());
            LanguageManager.registerLanguageUpdater(new JProgressBarLU());
            LanguageManager.registerLanguageUpdater(new JFileChooserLU());
            LanguageManager.registerLanguageUpdater(new FrameLU());
            LanguageManager.registerLanguageUpdater(new DialogLU());
            LanguageManager.registerLanguageUpdater(new JInternalFrameLU());
            LanguageManager.registerLanguageUpdater(new WebFileDropLU());
            LanguageManager.registerLanguageUpdater(new WebCollapsiblePaneLU());
            LanguageManager.addLanguageListener(new LanguageListener(){

                @Override
                public void languageChanged(String oldLang, String newLang) {
                    this.updateAll();
                }

                @Override
                public void dictionaryAdded(Dictionary dictionary) {
                    this.updateSmart(dictionary);
                }

                @Override
                public void dictionaryRemoved(Dictionary dictionary) {
                    this.updateSmart(dictionary);
                }

                @Override
                public void dictionariesCleared() {
                    this.updateAll();
                }

                private void updateAll() {
                    if (languageKeyListeners.size() > 0) {
                        LanguageManager.fireAllLanguageKeysUpdated();
                    }
                    LanguageManager.updateAllComponents();
                }

                private void updateSmart(Dictionary dictionary) {
                    List<String> relevantKeys = this.gatherKeys(dictionary);
                    if (languageKeyListeners.size() > 0) {
                        for (String key : relevantKeys) {
                            LanguageManager.fireLanguageKeyUpdated(key);
                        }
                    }
                    LanguageManager.updateAllComponents(relevantKeys);
                }

                private List<String> gatherKeys(Dictionary dictionary) {
                    ArrayList<String> relevantKeys = new ArrayList<String>();
                    this.gatherKeys(dictionary, relevantKeys);
                    return relevantKeys;
                }

                private void gatherKeys(Dictionary dictionary, List<String> relevantKeys) {
                    if (dictionary.getRecords() != null) {
                        for (Record record : dictionary.getRecords()) {
                            relevantKeys.add(record.getKey());
                        }
                    }
                    if (dictionary.getSubdictionaries() != null) {
                        for (Dictionary subDictionary : dictionary.getSubdictionaries()) {
                            this.gatherKeys(subDictionary, relevantKeys);
                        }
                    }
                }
            });
            LanguageManager.loadDefaultDictionary();
        }
    }

    public static void loadDefaultDictionary() {
        LanguageManager.addDictionary(WebLookAndFeel.class, "resources/language.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSupportedLanguages() {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            return CollectionUtils.copy(supportedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSupportedLanguages(Collection<String> supportedLanguages) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            LanguageManager.supportedLanguages.clear();
            LanguageManager.supportedLanguages.addAll(supportedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSupportedLanguages(String ... supportedLanguages) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            LanguageManager.supportedLanguages.clear();
            Collections.addAll(LanguageManager.supportedLanguages, supportedLanguages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSupportedLanguage(String language) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.add(language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSupportedLanguage(String language, Dictionary dictionary) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            LanguageManager.addDictionary(dictionary);
            supportedLanguages.add(language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSupportedLanguage(String language) {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.remove(language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSupportedLanguages() {
        Object object = supportedLanguagesLock;
        synchronized (object) {
            supportedLanguages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerComponent(final Component component, String key, Object ... data) {
        if (data != null && data.length == 0) {
            data = null;
        }
        Object object = componentsLock;
        synchronized (object) {
            components.put(component, key);
            if (data != null) {
                componentsData.put(component, data);
            }
        }
        LanguageManager.updateComponent(component, key, new Object[0]);
        object = componentsLock;
        synchronized (object) {
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                AncestorAdapter listener = new AncestorAdapter(){

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                        LanguageManager.updateComponentKey(component);
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                        LanguageManager.updateComponent(component, new Object[0]);
                    }
                };
                jComponent.addAncestorListener(listener);
                componentsListeners.put(component, listener);
            }
        }
    }

    public static void updateComponentsTree(Component component) {
        LanguageManager.updateComponentKey(component);
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                LanguageManager.updateComponentsTree(child);
            }
        }
    }

    private static void updateComponentKey(Component component) {
        String key = LanguageManager.getComponentKey(component);
        if (key != null) {
            String oldKey = componentKeysCache.get(component);
            String newKey = LanguageManager.combineWithContainerKeysImpl(component, key);
            if (oldKey == null || !CompareUtils.equals(oldKey, newKey)) {
                LanguageManager.updateComponent(component, key, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterComponent(Component component) {
        Object object = componentsLock;
        synchronized (object) {
            components.remove(component);
            componentsData.remove(component);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                AncestorListener listener = componentsListeners.get(jComponent);
                jComponent.removeAncestorListener(listener);
                componentsListeners.remove(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRegisteredComponent(Component component) {
        Object object = componentsLock;
        synchronized (object) {
            return components.containsKey(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getComponentKey(Component component) {
        Object object = componentsLock;
        synchronized (object) {
            return components.get(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageUpdater(LanguageUpdater updater) {
        Object object = updatersLock;
        synchronized (object) {
            updaters.add(updater);
            updatersCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageUpdater(LanguageUpdater updater) {
        Object object = updatersLock;
        synchronized (object) {
            updaters.remove(updater);
            updatersCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageUpdater(Component component, LanguageUpdater updater) {
        Object object = updatersLock;
        synchronized (object) {
            customUpdaters.put(component, updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageUpdater(Component component) {
        Object object = updatersLock;
        synchronized (object) {
            customUpdaters.remove(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageUpdater getLanguageUpdater(Component component) {
        Object object = updatersLock;
        synchronized (object) {
            LanguageUpdater customUpdater = customUpdaters.get(component);
            if (customUpdater != null) {
                return customUpdater;
            }
            LanguageUpdater updater = updatersCache.get(component.getClass());
            if (updater != null) {
                return updater;
            }
            ArrayList<LanguageUpdater> foundUpdaters = new ArrayList<LanguageUpdater>();
            for (LanguageUpdater lu : updaters) {
                if (!lu.getComponentClass().isInstance(component)) continue;
                foundUpdaters.add(lu);
            }
            if (foundUpdaters.size() == 1) {
                updater = (LanguageUpdater)foundUpdaters.get(0);
            } else if (foundUpdaters.size() > 1) {
                Collections.sort(foundUpdaters, languageUpdaterComparator);
                updater = (LanguageUpdater)foundUpdaters.get(0);
            }
            updatersCache.put(component.getClass(), updater);
            return updater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAllComponents() {
        Object object = componentsLock;
        synchronized (object) {
            for (Map.Entry<Component, String> entry : components.entrySet()) {
                LanguageManager.updateComponent(entry.getKey(), entry.getValue(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAllComponents(List<String> keys) {
        Object object = componentsLock;
        synchronized (object) {
            for (Map.Entry<Component, String> entry : components.entrySet()) {
                if (!keys.contains(entry.getValue())) continue;
                LanguageManager.updateComponent(entry.getKey(), entry.getValue(), new Object[0]);
            }
        }
    }

    public static void updateComponent(Component component, Object ... data) {
        String key = components.get(component);
        if (key != null) {
            LanguageManager.updateComponent(component, key, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateComponent(Component component, String key, Object ... data) {
        Object[] actualData;
        if (data != null && data.length == 0) {
            data = null;
        }
        Value value = LanguageManager.getNotNullValue(component, key);
        Object object = componentsLock;
        synchronized (object) {
            if (data != null) {
                componentsData.put(component, data);
                actualData = data;
            } else {
                actualData = componentsData.get(component);
            }
        }
        LanguageUpdater updater = LanguageManager.getLanguageUpdater(component);
        if (updater != null) {
            updater.update(component, key, value, LanguageManager.parseData(actualData));
        }
        boolean swingComponent = component instanceof JComponent;
        if (tooltipsCache.containsKey(component)) {
            if (swingComponent) {
                ((JComponent)component).setToolTipText(null);
            }
            TooltipManager.removeTooltips(component, tooltipsCache.get(component));
            tooltipsCache.get(component).clear();
        }
        if (value != null && value.getTooltips() != null && value.getTooltips().size() > 0) {
            for (Tooltip tooltip : value.getTooltips()) {
                if (tooltip.getType().equals((Object)TooltipType.swing)) {
                    if (!swingComponent) continue;
                    ((JComponent)component).setToolTipText(tooltip.getText());
                    continue;
                }
                if (tooltip.getDelay() != null) {
                    LanguageManager.cacheTip(TooltipManager.setTooltip(component, tooltip.getText(), tooltip.getWay(), (int)tooltip.getDelay()));
                    continue;
                }
                LanguageManager.cacheTip(TooltipManager.setTooltip(component, tooltip.getText()));
            }
        }
    }

    private static Object[] parseData(Object ... data) {
        if (data != null) {
            Object[] finalData = new Object[data.length];
            for (int i = 0; i < data.length; ++i) {
                Object object = data[i];
                finalData[i] = object != null && object instanceof DataProvider ? ((DataProvider)object).provide() : object;
            }
            return finalData;
        }
        return null;
    }

    private static void cacheTip(WebCustomTooltip tooltip) {
        Component component = tooltip.getComponent();
        if (!tooltipsCache.containsKey(component)) {
            tooltipsCache.put(component, new ArrayList());
        }
        tooltipsCache.get(component).add(tooltip);
    }

    public static ImageIcon getLanguageIcon(String language) {
        ImageIcon icon;
        if (languageIcons.containsKey(language)) {
            return languageIcons.get(language);
        }
        try {
            URL res = LanguageManager.class.getResource("icons/lang/" + language + ".png");
            icon = new ImageIcon(res);
        }
        catch (Throwable e) {
            icon = other;
        }
        languageIcons.put(language, icon);
        return icon;
    }

    public static ImageIcon setLanguageIcon(String language, ImageIcon icon) {
        return languageIcons.put(language, icon);
    }

    public static TooltipType getDefaultTooltipType() {
        return defaultTooltipType;
    }

    public static void setDefaultTooltipType(TooltipType defaultTooltipType) {
        LanguageManager.defaultTooltipType = defaultTooltipType;
    }

    public static String getLanguage() {
        return language;
    }

    public static boolean isCurrentLanguage(String language) {
        return LanguageManager.language.equals(language);
    }

    public static void setLanguage(String language) {
        if (initialized) {
            if (language == null || LanguageManager.getLanguage().trim().toLowerCase().equals(language.trim().toLowerCase())) {
                return;
            }
            ComponentOrientation oldComponentOrientation = LanguageManager.getOrientation();
            String oldLanguage = LanguageManager.language;
            LanguageManager.language = language;
            LanguageManager.updateLocale();
            LanguageManager.rebuildCache();
            if (oldComponentOrientation.isLeftToRight() != LanguageManager.getOrientation().isLeftToRight()) {
                SwingUtils.updateGlobalOrientations();
            }
            LanguageManager.fireLanguageChanged(oldLanguage, language);
        } else {
            DEFAULT = language;
        }
    }

    private static void updateLocale() {
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!locale.getLanguage().equals(language)) continue;
            Locale.setDefault(locale);
            return;
        }
        Locale.setDefault(new Locale(language));
    }

    public static boolean isLeftToRight() {
        return LanguageManager.getOrientation().isLeftToRight();
    }

    public static ComponentOrientation getOrientation() {
        if (orientation != null) {
            return orientation;
        }
        return ComponentOrientation.getOrientation(Locale.getDefault());
    }

    public static ComponentOrientation getOppositeOrientation() {
        return LanguageManager.isLeftToRight() ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
    }

    public static void setOrientation(boolean leftToRight) {
        LanguageManager.setOrientation(leftToRight ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT);
    }

    public static void setOrientation(ComponentOrientation orientation) {
        LanguageManager.orientation = orientation;
        SwingUtils.updateGlobalOrientations();
    }

    public static void changeOrientation() {
        LanguageManager.setOrientation(!LanguageManager.getOrientation().isLeftToRight());
    }

    public static Dictionary getGlobalDictionary() {
        return globalDictionary;
    }

    public static List<Dictionary> getDictionaries() {
        return CollectionUtils.copy(dictionaries);
    }

    public static Dictionary loadDictionary(Class nearClass, String resource) {
        return LanguageManager.loadDictionary(nearClass.getResource(resource));
    }

    public static Dictionary loadDictionary(URL url) {
        return (Dictionary)XmlUtils.fromXML(url);
    }

    public static Dictionary loadDictionary(String path) {
        return LanguageManager.loadDictionary(new File(path));
    }

    public static Dictionary loadDictionary(File file) {
        return (Dictionary)XmlUtils.fromXML(file);
    }

    public static Dictionary addDictionary(Class nearClass, String resource) {
        return LanguageManager.addDictionary(LanguageManager.loadDictionary(nearClass, resource));
    }

    public static Dictionary addDictionary(URL url) {
        return LanguageManager.addDictionary(LanguageManager.loadDictionary(url));
    }

    public static Dictionary addDictionary(String path) {
        return LanguageManager.addDictionary(LanguageManager.loadDictionary(path));
    }

    public static Dictionary addDictionary(File file) {
        return LanguageManager.addDictionary(LanguageManager.loadDictionary(file));
    }

    public static Dictionary addDictionary(Dictionary dictionary) {
        if (LanguageManager.isDictionaryAdded(dictionary)) {
            LanguageManager.removeDictionary(dictionary);
        }
        dictionaries.add(dictionary);
        LanguageManager.mergeDictionary(dictionary);
        LanguageManager.updateCache(dictionary);
        LanguageManager.fireDictionaryAdded(dictionary);
        return dictionary;
    }

    public static Dictionary removeDictionary(String id) {
        return LanguageManager.removeDictionary(LanguageManager.getDictionary(id));
    }

    public static Dictionary removeDictionary(Dictionary dictionary) {
        if (dictionary != null && LanguageManager.isDictionaryAdded(dictionary)) {
            globalDictionary.clear();
            dictionaries.remove(dictionary);
            for (Dictionary d : dictionaries) {
                LanguageManager.mergeDictionary(d);
            }
            LanguageManager.rebuildCache();
            LanguageManager.fireDictionaryRemoved(dictionary);
            return dictionary;
        }
        return null;
    }

    public static boolean isDictionaryAdded(Dictionary dictionary) {
        return LanguageManager.isDictionaryAdded(dictionary.getId());
    }

    public static boolean isDictionaryAdded(String id) {
        for (Dictionary dictionary : dictionaries) {
            if (!dictionary.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static Dictionary getDictionary(String id) {
        for (Dictionary dictionary : dictionaries) {
            if (!dictionary.getId().equals(id)) continue;
            return dictionary;
        }
        return null;
    }

    private static void mergeDictionary(Dictionary dictionary) {
        LanguageManager.mergeDictionary(dictionary.getPrefix(), dictionary);
    }

    private static void mergeDictionary(String prefix, Dictionary dictionary) {
        String string = prefix = prefix != null && !prefix.equals("") ? prefix + "." : "";
        if (dictionary.getRecords() != null) {
            for (Record record : dictionary.getRecords()) {
                Record clone = record.clone();
                clone.setKey(prefix + clone.getKey());
                globalDictionary.addRecord(clone);
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary subDictionary : dictionary.getSubdictionaries()) {
                String sp = subDictionary.getPrefix();
                String subPrefix = prefix + (sp != null && !sp.equals("") ? sp : "");
                LanguageManager.mergeDictionary(subPrefix, subDictionary);
            }
        }
    }

    public static void clearDictionaries() {
        globalDictionary.clear();
        dictionaries.clear();
        LanguageManager.clearCache();
        LanguageManager.fireDictionariesCleared();
    }

    public static List<String> getSupportedLanguages(String dictionaryId) {
        return LanguageManager.getSupportedLanguages(LanguageManager.getDictionary(dictionaryId));
    }

    public static List<String> getSupportedLanguages(Dictionary dictionary) {
        return dictionary == null ? Collections.EMPTY_LIST : dictionary.getSupportedLanguages();
    }

    public static String get(String key) {
        Value value = LanguageManager.getValue(key);
        return value != null ? value.getText() : key;
    }

    public static Character getMnemonic(String key) {
        Value value = LanguageManager.getValue(key);
        return value != null ? value.getMnemonic() : null;
    }

    public static Value getValue(String key) {
        return globalCache != null ? globalCache.get(key) : null;
    }

    public static Value getNotNullValue(String key) {
        Value value = LanguageManager.getValue(key);
        if (value != null) {
            return value;
        }
        Value tmpValue = new Value(LanguageManager.getLanguage(), key);
        globalCache.put(key, tmpValue);
        return tmpValue;
    }

    public static String get(Component component, String key) {
        return LanguageManager.get(LanguageManager.combineWithContainerKeys(component, key));
    }

    public static Character getMnemonic(Component component, String key) {
        return LanguageManager.getMnemonic(LanguageManager.combineWithContainerKeys(component, key));
    }

    public static Value getValue(Component component, String key) {
        return LanguageManager.getValue(LanguageManager.combineWithContainerKeys(component, key));
    }

    public static Value getNotNullValue(Component component, String key) {
        return LanguageManager.getNotNullValue(LanguageManager.combineWithContainerKeys(component, key));
    }

    public static Value getValue(Component component, String key, String additionalKey) {
        return LanguageManager.getValue(LanguageManager.combineWithContainerKeys(component, key) + "." + additionalKey);
    }

    public static Value getNotNullValue(Component component, String key, String additionalKey) {
        return LanguageManager.getNotNullValue(LanguageManager.combineWithContainerKeys(component, key) + "." + additionalKey);
    }

    public static String combineWithContainerKeys(Component component, String key) {
        String cachedKey = componentKeysCache.get(component);
        return cachedKey != null ? cachedKey : LanguageManager.combineWithContainerKeysImpl(component, key);
    }

    private static String combineWithContainerKeysImpl(Component component, String key) {
        StringBuilder sb = new StringBuilder(key);
        if (component != null) {
            for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
                String containerKey = LanguageManager.getLanguageContainerKey(parent);
                if (containerKey == null) continue;
                sb.insert(0, containerKey + ".");
            }
        }
        String cachedKey = sb.toString();
        componentKeysCache.put(component, cachedKey);
        return cachedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLanguageContainer(Container container, String key) {
        Object object = languageContainersLock;
        synchronized (object) {
            languageContainers.put(container, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLanguageContainer(Container container) {
        Object object = languageContainersLock;
        synchronized (object) {
            languageContainers.remove(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLanguageContainerKey(Container container) {
        Object object = languageContainersLock;
        synchronized (object) {
            return languageContainers.get(container);
        }
    }

    private static void rebuildCache() {
        LanguageManager.clearCache();
        LanguageManager.updateCache(globalDictionary);
    }

    private static void clearCache() {
        globalCache.clear();
    }

    private static void updateCache(Dictionary dictionary) {
        LanguageManager.updateCache(dictionary.getPrefix(), dictionary);
    }

    private static void updateCache(String prefix, Dictionary dictionary) {
        String string = prefix = prefix != null && !prefix.equals("") ? prefix + "." : "";
        if (dictionary.getRecords() != null) {
            for (Record record : dictionary.getRecords()) {
                Value value = record.getValue(language);
                if (value != null && value.getHotkey() == null && record.getHotkey() != null) {
                    value.setHotkey(record.getHotkey());
                }
                globalCache.put(prefix + record.getKey(), value);
            }
        }
        if (dictionary.getSubdictionaries() != null) {
            for (Dictionary subDictionary : dictionary.getSubdictionaries()) {
                String sp = subDictionary.getPrefix();
                String subPrefix = prefix + (sp != null && !sp.equals("") ? sp : "");
                LanguageManager.updateCache(subPrefix, subDictionary);
            }
        }
    }

    public static String getDefaultLanguageKey() {
        String systemLang = LanguageManager.getSystemLanguageKey();
        return supportedLanguages.contains(systemLang) ? systemLang : "en";
    }

    public static String getSystemLanguageKey() {
        return System.getProperty("user.language");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanguageListener> getLanguageListeners() {
        Object object = languageListenersLock;
        synchronized (object) {
            return CollectionUtils.copy(languageListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageListener(LanguageListener listener) {
        Object object = languageListenersLock;
        synchronized (object) {
            languageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageListener(LanguageListener listener) {
        Object object = languageListenersLock;
        synchronized (object) {
            languageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageChanged(String oldLang, String newLang) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener listener : languageListeners) {
                listener.languageChanged(oldLang, newLang);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionaryAdded(Dictionary dictionary) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener listener : languageListeners) {
                listener.dictionaryAdded(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionaryRemoved(Dictionary dictionary) {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener listener : languageListeners) {
                listener.dictionaryRemoved(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionariesCleared() {
        Object object = languageListenersLock;
        synchronized (object) {
            for (LanguageListener listener : languageListeners) {
                listener.dictionariesCleared();
            }
        }
    }

    public static Map<String, List<LanguageKeyListener>> getLanguageKeyListeners() {
        return languageKeyListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageKeyListener(String key, LanguageKeyListener listener) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            List<LanguageKeyListener> listeners = languageKeyListeners.get(key);
            if (listeners == null) {
                listeners = new ArrayList<LanguageKeyListener>();
                languageKeyListeners.put(key, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageKeyListener(LanguageKeyListener listener) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            for (Map.Entry<String, List<LanguageKeyListener>> entry : languageKeyListeners.entrySet()) {
                entry.getValue().remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageKeyListeners(String key) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            languageKeyListeners.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageKeyUpdated(String key) {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            List<LanguageKeyListener> listeners = languageKeyListeners.get(key);
            if (listeners != null) {
                Value value = LanguageManager.getValue(key);
                for (LanguageKeyListener listener : CollectionUtils.copy(listeners)) {
                    listener.languageKeyUpdated(key, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireAllLanguageKeysUpdated() {
        Object object = languageKeyListenersLock;
        synchronized (object) {
            for (Map.Entry<String, List<LanguageKeyListener>> entry : languageKeyListeners.entrySet()) {
                Value value = LanguageManager.getValue(entry.getKey());
                for (LanguageKeyListener listener : CollectionUtils.copy((Collection)entry.getValue())) {
                    listener.languageKeyUpdated(entry.getKey(), value);
                }
            }
        }
    }

    static {
        language = DEFAULT = LanguageManager.getDefaultLanguageKey();
        defaultTooltipType = TooltipType.weblaf;
        languageListenersLock = new Object();
        languageListeners = new ArrayList<LanguageListener>();
        languageKeyListenersLock = new Object();
        languageKeyListeners = new HashMap<String, List<LanguageKeyListener>>();
        globalCache = new HashMap<String, Value>();
        dictionaries = new ArrayList<Dictionary>();
        componentsLock = new Object();
        components = new WeakHashMap<Component, String>();
        componentsData = new WeakHashMap<Component, Object[]>();
        componentKeysCache = new WeakHashMap<Component, String>();
        componentsListeners = new WeakHashMap<Component, AncestorListener>();
        languageContainersLock = new Object();
        languageContainers = new WeakHashMap<Container, String>();
        updatersLock = new Object();
        languageUpdaterComparator = new LanguageUpdaterComparator();
        updaters = new ArrayList<LanguageUpdater>();
        customUpdaters = new WeakHashMap<Component, LanguageUpdater>();
        updatersCache = new HashMap<Class, LanguageUpdater>();
        tooltipsCache = new WeakHashMap<Component, List<WebCustomTooltip>>();
        languageIcons = new HashMap<String, ImageIcon>();
        initialized = false;
    }
}

