/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.glasspane;

import com.alee.managers.glasspane.WebGlassPane;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JRootPane;

public final class GlassPaneManager {
    private static final Map<JRootPane, WebGlassPane> registeredWindows = new WeakHashMap<JRootPane, WebGlassPane>();

    public static WebGlassPane getGlassPane(Component component) {
        return GlassPaneManager.getGlassPane(SwingUtils.getRootPane(component));
    }

    public static WebGlassPane getGlassPane(JRootPane rootPane) {
        if (rootPane != null) {
            if (registeredWindows.containsKey(rootPane)) {
                return registeredWindows.get(rootPane);
            }
            WebGlassPane glassPane = new WebGlassPane(rootPane);
            rootPane.setGlassPane(glassPane);
            glassPane.setVisible(true);
            rootPane.invalidate();
            registeredWindows.put(rootPane, glassPane);
            return glassPane;
        }
        return null;
    }
}

