/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.tree.NodeState;
import com.alee.laf.tree.TreeState;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.LinkedHashMap;
import java.util.Map;

public class TreeStateConverter
extends ReflectionConverter {
    public TreeStateConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(TreeState.class);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TreeState treeState = (TreeState)source;
        for (Map.Entry<String, NodeState> entry : treeState.getStates().entrySet()) {
            String nodeId = entry.getKey();
            NodeState nodeState = entry.getValue();
            writer.startNode("node");
            writer.addAttribute("id", nodeId);
            writer.addAttribute("expanded", "" + nodeState.isExpanded());
            writer.addAttribute("selected", "" + nodeState.isSelected());
            writer.endNode();
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        LinkedHashMap<String, NodeState> states = new LinkedHashMap<String, NodeState>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeIdAttribue = reader.getAttribute("id");
            String nodeId = nodeIdAttribue != null ? nodeIdAttribue : reader.getNodeName();
            String expandedAttribue = reader.getAttribute("expanded");
            String expanded = expandedAttribue != null ? expandedAttribue : "false";
            String selectedAttribue = reader.getAttribute("selected");
            String selected = selectedAttribue != null ? selectedAttribue : "false";
            states.put(nodeId, new NodeState(Boolean.parseBoolean(expanded), Boolean.parseBoolean(selected)));
            reader.moveUp();
        }
        return new TreeState(states);
    }
}

