/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tooltip;

import com.alee.laf.tooltip.WebTooltipStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.BorderMethods;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class WebToolTipUI
extends BasicToolTipUI
implements ShapeProvider,
BorderMethods {
    private JComponent tooltip = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebToolTipUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tooltip = c;
        SwingUtils.setOrientation(this.tooltip);
        LookAndFeel.installProperty(this.tooltip, "opaque", Boolean.FALSE);
        this.tooltip.setBackground(WebTooltipStyle.backgroundColor);
        this.tooltip.setForeground(WebTooltipStyle.textColor);
        this.updateBorder();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.tooltip = null;
        super.uninstallUI(c);
    }

    @Override
    public Shape provideShape() {
        return new RoundRectangle2D.Double(0.0, 0.0, this.tooltip.getWidth(), this.tooltip.getHeight(), WebTooltipStyle.round * 2, WebTooltipStyle.round * 2);
    }

    @Override
    public void updateBorder() {
        if (SwingUtils.isPreserveBorders(this.tooltip)) {
            return;
        }
        this.tooltip.setBorder(LafUtils.createWebBorder(WebTooltipStyle.contentMargin));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        Object aa = LafUtils.setupAntialias(g2d);
        Composite oc = LafUtils.setupAlphaComposite(g2d, Float.valueOf(WebTooltipStyle.trasparency));
        g2d.setPaint(c.getBackground());
        g2d.fillRoundRect(0, 0, c.getWidth(), c.getHeight(), WebTooltipStyle.round * 2, WebTooltipStyle.round * 2);
        LafUtils.restoreComposite(g2d, oc);
        LafUtils.restoreAntialias(g2d, aa);
        Map taa = SwingUtils.setupTextAntialias(g2d);
        super.paint(g, c);
        SwingUtils.restoreTextAntialias(g2d, taa);
    }
}

