/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.spinner;

import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class WebSpinnerUI
extends BasicSpinnerUI
implements ShapeProvider,
BorderMethods {
    private static final ImageIcon UP_ICON = new ImageIcon(WebSpinnerUI.class.getResource("icons/up.png"));
    private static final ImageIcon DOWN_ICON = new ImageIcon(WebSpinnerUI.class.getResource("icons/down.png"));
    private boolean drawBorder = StyleConstants.drawBorder;
    private boolean drawFocus = StyleConstants.drawFocus;
    private int round = StyleConstants.smallRound;
    private int shadeWidth = StyleConstants.shadeWidth;

    public static ComponentUI createUI(JComponent c) {
        return new WebSpinnerUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.spinner);
        LookAndFeel.installProperty(this.spinner, "opaque", Boolean.FALSE);
        this.spinner.setBackground(Color.WHITE);
        this.updateBorder();
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.spinner, this.getShadeWidth(), this.getRound());
    }

    @Override
    public void updateBorder() {
        if (this.spinner != null) {
            if (SwingUtils.isPreserveBorders(this.spinner)) {
                return;
            }
            if (this.drawBorder) {
                this.spinner.setBorder(BorderFactory.createEmptyBorder(this.shadeWidth + 2, this.shadeWidth + 2, this.shadeWidth + 2, this.shadeWidth + 2));
            } else {
                this.spinner.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        this.updateBorder();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.updateBorder();
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean drawFocus) {
        this.drawFocus = drawFocus;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        LafUtils.drawWebStyle((Graphics2D)g, c, this.drawFocus && SwingUtils.hasFocusOwner(this.spinner) ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round);
        super.paint(g, c);
    }

    @Override
    protected Component createNextButton() {
        WebButton nextButton = WebButton.createIconWebButton(UP_ICON, StyleConstants.smallRound, 1, 2);
        nextButton.setLeftRightSpacing(1);
        nextButton.setDrawFocus(false);
        nextButton.setFocusable(false);
        nextButton.setName("Spinner.nextButton");
        this.installNextButtonListeners(nextButton);
        return nextButton;
    }

    @Override
    protected Component createPreviousButton() {
        WebButton previousButton = WebButton.createIconWebButton(DOWN_ICON, StyleConstants.smallRound, 1, 2);
        previousButton.setLeftRightSpacing(1);
        previousButton.setDrawFocus(false);
        previousButton.setFocusable(false);
        previousButton.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(previousButton);
        return previousButton;
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = super.createEditor();
        WebSpinnerUI.installFieldUI(((JSpinner.DefaultEditor)editor).getTextField(), this.spinner);
        return editor;
    }

    public static void installFieldUI(JFormattedTextField field, final JSpinner spinner) {
        field.setMargin(new Insets(0, 0, 0, 0));
        field.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        WebTextFieldUI textFieldUI = new WebTextFieldUI();
        textFieldUI.setDrawBorder(false);
        field.setUI(textFieldUI);
        field.setOpaque(true);
        field.setBackground(Color.WHITE);
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                spinner.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                spinner.repaint();
            }
        });
    }
}

