/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.extended.panel.WebButtonGroup;
import com.alee.extended.window.ComponentMoveAdapter;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebResizeCorner;
import com.alee.laf.rootpane.WebRootPaneLayout;
import com.alee.laf.rootpane.WebRootPaneStyle;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.ProprietaryUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class WebRootPaneUI
extends BasicRootPaneUI
implements SwingConstants {
    public static ImageIcon minimizeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/minimize.png"));
    public static ImageIcon minimizeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/minimize_active.png"));
    public static ImageIcon maximizeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/maximize.png"));
    public static ImageIcon maximizeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/maximize_active.png"));
    public static ImageIcon restoreIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/restore.png"));
    public static ImageIcon restoreActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/restore_active.png"));
    public static ImageIcon closeIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/close.png"));
    public static ImageIcon closeActiveIcon = new ImageIcon(WebRootPaneUI.class.getResource("icons/close_active.png"));
    protected Color topBg = WebRootPaneStyle.topBg;
    protected Color middleBg = WebRootPaneStyle.middleBg;
    protected Color borderColor = WebRootPaneStyle.borderColor;
    protected Color innerBorderColor = WebRootPaneStyle.innerBorderColor;
    protected int shadeWidth = WebRootPaneStyle.shadeWidth;
    protected int inactiveShadeWidth = WebRootPaneStyle.inactiveShadeWidth;
    protected int round = WebRootPaneStyle.round;
    protected Insets margin = WebRootPaneStyle.margin;
    protected boolean drawWatermark = WebRootPaneStyle.drawWatermark;
    protected ImageIcon watermark = WebRootPaneStyle.watermark;
    protected int maxTitleWidth = WebRootPaneStyle.maxTitleWidth;
    protected String emptyTitleText = "   ";
    protected boolean showTitleComponent = WebRootPaneStyle.showTitleComponent;
    protected boolean showMenuBar = WebRootPaneStyle.showMenuBar;
    protected boolean showWindowButtons = WebRootPaneStyle.showWindowButtons;
    protected boolean showMinimizeButton = WebRootPaneStyle.showMinimizeButton;
    protected boolean showMaximizeButton = WebRootPaneStyle.showMaximizeButton;
    protected boolean showCloseButton = WebRootPaneStyle.showCloseButton;
    protected boolean groupButtons = WebRootPaneStyle.groupButtons;
    protected boolean attachButtons = WebRootPaneStyle.attachButtons;
    protected boolean showResizeCorner = WebRootPaneStyle.showResizeCorner;
    protected boolean styled = false;
    protected JRootPane root;
    protected Window window;
    protected Frame frame;
    protected Dialog dialog;
    protected int state;
    protected LayoutManager layoutManager;
    protected LayoutManager savedOldLayout;
    protected WindowFocusListener windowFocusListener;
    protected PropertyChangeListener titleChangeListener;
    protected PropertyChangeListener resizableChangeListener;
    protected WindowStateListener windowStateListener;
    protected JComponent titleComponent;
    protected WebButtonGroup windowButtons;
    protected WebResizeCorner resizeCorner;

    public static ComponentUI createUI(JComponent c) {
        return new WebRootPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.root = (JRootPane)c;
        SwingUtils.setOrientation(this.root);
        this.root.setBackground(StyleConstants.backgroundColor);
        this.installWindowDecorations();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallWindowDecorations();
        this.layoutManager = null;
        this.root = null;
    }

    public boolean isStyled() {
        return this.styled;
    }

    public Color getTopBg() {
        return this.topBg;
    }

    public void setTopBg(Color topBg) {
        this.topBg = topBg;
        this.root.repaint();
    }

    public Color getMiddleBg() {
        return this.middleBg;
    }

    public void setMiddleBg(Color middleBg) {
        this.middleBg = middleBg;
        this.root.repaint();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.root.repaint();
    }

    public Color getInnerBorderColor() {
        return this.innerBorderColor;
    }

    public void setInnerBorderColor(Color innerBorderColor) {
        this.innerBorderColor = innerBorderColor;
        this.root.repaint();
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        int diff = shadeWidth - this.shadeWidth;
        this.shadeWidth = shadeWidth;
        if (this.styled && this.window != null) {
            Rectangle b = this.window.getBounds();
            this.window.setBounds(b.x - diff, b.y - diff, b.width + diff * 2, b.height + diff * 2);
            this.installBorder();
            this.root.revalidate();
            this.root.repaint();
        }
    }

    public int getInactiveShadeWidth() {
        return this.inactiveShadeWidth;
    }

    public void setInactiveShadeWidth(int inactiveShadeWidth) {
        this.inactiveShadeWidth = inactiveShadeWidth;
        if (this.styled) {
            this.installBorder();
            this.root.revalidate();
            this.root.repaint();
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        if (this.styled) {
            this.updateWindowButtonsStyle();
            this.root.revalidate();
            this.root.repaint();
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        if (this.styled) {
            this.installBorder();
            this.root.revalidate();
            this.root.repaint();
        }
    }

    public boolean isDrawWatermark() {
        return this.drawWatermark;
    }

    public void setDrawWatermark(boolean drawWatermark) {
        this.drawWatermark = drawWatermark;
        if (this.styled) {
            this.root.repaint();
        }
    }

    public ImageIcon getWatermark() {
        if (this.watermark == null && this.drawWatermark) {
            this.watermark = new ImageIcon(WebRootPaneUI.class.getResource("icons/watermark.png"));
        }
        return this.watermark;
    }

    public void setWatermark(ImageIcon watermark) {
        this.watermark = watermark;
    }

    public int getMaxTitleWidth() {
        return this.maxTitleWidth;
    }

    public void setMaxTitleWidth(int maxTitleWidth) {
        this.maxTitleWidth = maxTitleWidth;
        if (this.isStyled() && this.titleComponent != null) {
            this.titleComponent.revalidate();
            this.titleComponent.repaint();
        }
    }

    public String getEmptyTitleText() {
        return this.emptyTitleText;
    }

    public void setEmptyTitleText(String emptyTitleText) {
        this.emptyTitleText = emptyTitleText;
        if (this.isStyled() && this.titleComponent != null) {
            this.titleComponent.revalidate();
            this.titleComponent.repaint();
        }
    }

    public JComponent getTitleComponent() {
        return this.titleComponent;
    }

    public void setTitleComponent(JComponent titleComponent) {
        this.titleComponent = titleComponent;
        this.root.revalidate();
    }

    public WebButtonGroup getWindowButtons() {
        return this.windowButtons;
    }

    public WebResizeCorner getResizeCorner() {
        return this.resizeCorner;
    }

    public boolean isShowResizeCorner() {
        return this.showResizeCorner;
    }

    public void setShowResizeCorner(boolean showResizeCorner) {
        this.showResizeCorner = showResizeCorner;
        this.root.revalidate();
    }

    public boolean isShowTitleComponent() {
        return this.showTitleComponent;
    }

    public void setShowTitleComponent(boolean showTitleComponent) {
        this.showTitleComponent = showTitleComponent;
        this.root.revalidate();
    }

    public boolean isShowWindowButtons() {
        return this.showWindowButtons;
    }

    public void setShowWindowButtons(boolean showWindowButtons) {
        this.showWindowButtons = showWindowButtons;
        this.root.revalidate();
    }

    public boolean isShowMinimizeButton() {
        return this.showMinimizeButton;
    }

    public void setShowMinimizeButton(boolean showMinimizeButton) {
        this.showMinimizeButton = showMinimizeButton;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isShowMaximizeButton() {
        return this.showMaximizeButton;
    }

    public void setShowMaximizeButton(boolean showMaximizeButton) {
        this.showMaximizeButton = showMaximizeButton;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isShowCloseButton() {
        return this.showCloseButton;
    }

    public void setShowCloseButton(boolean showCloseButton) {
        this.showCloseButton = showCloseButton;
        this.updateButtons();
        this.root.revalidate();
    }

    public boolean isGroupButtons() {
        return this.groupButtons;
    }

    public void setGroupButtons(boolean groupButtons) {
        this.groupButtons = groupButtons;
        this.updateButtons();
        this.root.revalidate();
        this.root.repaint();
    }

    public boolean isAttachButtons() {
        return this.attachButtons;
    }

    public void setAttachButtons(boolean attachButtons) {
        this.attachButtons = attachButtons;
        this.updateButtons();
        this.root.revalidate();
        this.root.repaint();
    }

    public boolean isShowMenuBar() {
        return this.showMenuBar;
    }

    public void setShowMenuBar(boolean showMenuBar) {
        this.showMenuBar = showMenuBar;
        this.root.revalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallWindowDecorations();
            if (style != 0) {
                this.installWindowDecorations();
            }
        }
    }

    protected void installWindowDecorations() {
        if (this.root.getWindowDecorationStyle() != 0) {
            this.window = this.root != null ? SwingUtils.getWindowAncestor(this.root) : null;
            this.frame = this.window instanceof Frame ? (Frame)this.window : null;
            this.dialog = this.window instanceof Dialog ? (Dialog)this.window : null;
            this.installProperties();
            this.installListeners();
            this.installTransparency();
            this.installBorder();
            this.installLayout();
            this.installDecorationComponents();
            this.styled = true;
        }
    }

    protected void uninstallWindowDecorations() {
        if (this.styled) {
            this.uninstallProperties();
            this.uninstallListeners();
            this.uninstallTransparency();
            this.uninstallBorder();
            this.uninstallLayout();
            this.uninstallDecorationComponents();
            this.window = null;
            this.frame = null;
            this.dialog = null;
            this.styled = false;
        }
    }

    protected void installProperties() {
        if (this.isFrame()) {
            this.frame.setMaximizedBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        }
    }

    protected void uninstallProperties() {
        if (this.isFrame()) {
            this.frame.setMaximizedBounds(null);
        }
    }

    protected void installListeners() {
        this.windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                WebRootPaneUI.this.root.repaint();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                WebRootPaneUI.this.root.repaint();
            }
        };
        this.window.addWindowFocusListener(this.windowFocusListener);
        this.titleChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebRootPaneUI.this.titleComponent.revalidate();
                WebRootPaneUI.this.titleComponent.repaint();
            }
        };
        this.window.addPropertyChangeListener("iconImage", this.titleChangeListener);
        this.window.addPropertyChangeListener("title", this.titleChangeListener);
        this.resizableChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebRootPaneUI.this.updateButtons();
            }
        };
        this.window.addPropertyChangeListener("resizable", this.resizableChangeListener);
        if (this.isFrame()) {
            this.state = this.frame.getState();
            this.windowStateListener = new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    WebRootPaneUI.this.state = e.getNewState();
                    WebRootPaneUI.this.installBorder();
                }
            };
            this.window.addWindowStateListener(this.windowStateListener);
        }
    }

    protected void uninstallListeners() {
        this.window.removeWindowFocusListener(this.windowFocusListener);
        this.window.removePropertyChangeListener("iconImage", this.titleChangeListener);
        this.window.removePropertyChangeListener("title", this.titleChangeListener);
        this.window.removePropertyChangeListener("resizable", this.resizableChangeListener);
        if (this.isFrame()) {
            this.window.removeWindowStateListener(this.windowStateListener);
        }
    }

    protected void installTransparency() {
        if (ProprietaryUtils.isWindowTransparencyAllowed()) {
            this.root.setOpaque(false);
            ProprietaryUtils.setWindowOpaque(this.window, false);
        }
    }

    protected void uninstallTransparency() {
        if (ProprietaryUtils.isWindowTransparencyAllowed()) {
            this.root.setOpaque(true);
            ProprietaryUtils.setWindowOpaque(this.window, true);
        }
    }

    protected void installBorder() {
        if (!this.isFrameMaximized()) {
            this.root.setBorder(BorderFactory.createEmptyBorder(this.shadeWidth + 1 + this.margin.top, this.shadeWidth + 1 + this.margin.left, this.shadeWidth + 1 + this.margin.bottom, this.shadeWidth + 1 + this.margin.right));
        } else {
            this.root.setBorder(BorderFactory.createEmptyBorder(1 + this.margin.top, 1 + this.margin.left, 1 + this.margin.bottom, 1 + this.margin.right));
        }
    }

    protected void uninstallBorder() {
        this.root.setBorder(null);
    }

    protected void installLayout() {
        if (this.layoutManager == null) {
            this.layoutManager = new WebRootPaneLayout();
        }
        this.savedOldLayout = this.root.getLayout();
        this.root.setLayout(this.layoutManager);
    }

    protected void uninstallLayout() {
        if (this.savedOldLayout != null) {
            this.root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    protected void installDecorationComponents() {
        this.titleComponent = this.createDefaultTitleComponent();
        this.root.add(this.titleComponent);
        this.updateButtons();
        this.resizeCorner = new WebResizeCorner();
        this.root.add(this.resizeCorner);
    }

    protected JComponent createDefaultTitleComponent() {
        WebLabel titleIcon = new WebLabel(){

            @Override
            public Icon getIcon() {
                return WebRootPaneUI.this.getWindowIcon();
            }
        };
        final TitleLabel titleLabel = new TitleLabel();
        titleLabel.setDrawShade(true);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                titleLabel.setHorizontalAlignment(titleLabel.getRequiredSize().width > titleLabel.getWidth() ? 10 : 0);
            }
        });
        SwingUtils.setFontSize(titleLabel, 13);
        ComponentMoveAdapter cma = new ComponentMoveAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (WebRootPaneUI.this.isFrame() && WebRootPaneUI.this.isShowMaximizeButton() && SwingUtils.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    if (WebRootPaneUI.this.isFrameMaximized()) {
                        WebRootPaneUI.this.restore();
                    } else {
                        WebRootPaneUI.this.maximize();
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (this.dragging && WebRootPaneUI.this.isFrameMaximized()) {
                    this.initialPoint = new Point(this.initialPoint.x + WebRootPaneUI.this.shadeWidth, this.initialPoint.y + WebRootPaneUI.this.shadeWidth);
                    WebRootPaneUI.this.restore();
                }
                super.mouseDragged(e);
            }
        };
        titleLabel.addMouseListener(cma);
        titleLabel.addMouseMotionListener(cma);
        WebPanel titlePanel = new WebPanel(new BorderLayout(5, 0));
        titlePanel.setOpaque(false);
        titlePanel.setMargin(4, 5, 4, 10);
        titlePanel.add((Component)titleIcon, (Object)"Before");
        titlePanel.add((Component)titleLabel, (Object)"Center");
        return titlePanel;
    }

    protected void updateButtons() {
        if (this.windowButtons != null) {
            this.root.remove(this.windowButtons);
        }
        boolean isFrame = this.isFrame();
        JComponent[] buttons = new JComponent[3];
        if (this.showMinimizeButton && isFrame) {
            WebButton minimize = new WebButton(minimizeIcon);
            minimize.setName("minimize");
            minimize.setRolloverIcon(minimizeActiveIcon);
            minimize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebRootPaneUI.this.iconify();
                }
            });
            buttons[0] = minimize;
        }
        if (this.showMaximizeButton && this.isResizable() && isFrame) {
            WebButton maximize = new WebButton((Icon)maximizeIcon){

                @Override
                public Icon getIcon() {
                    return WebRootPaneUI.this.isFrameMaximized() ? restoreIcon : maximizeIcon;
                }

                @Override
                public Icon getRolloverIcon() {
                    return WebRootPaneUI.this.isFrameMaximized() ? restoreActiveIcon : maximizeActiveIcon;
                }
            };
            maximize.setName("maximize");
            maximize.setRolloverIcon(maximizeActiveIcon);
            maximize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WebRootPaneUI.this.isFrame()) {
                        if (WebRootPaneUI.this.isFrameMaximized()) {
                            WebRootPaneUI.this.restore();
                        } else {
                            WebRootPaneUI.this.maximize();
                        }
                    }
                }
            });
            buttons[1] = maximize;
        }
        if (this.showCloseButton) {
            WebButton close = new WebButton(closeIcon);
            close.setName("close");
            close.setRolloverIcon(closeActiveIcon);
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WebRootPaneUI.this.close();
                }
            });
            buttons[2] = close;
        }
        this.windowButtons = new WebButtonGroup(buttons){

            @Override
            public void updateButtonsStyling() {
                if (WebRootPaneUI.this.groupButtons) {
                    super.updateButtonsStyling();
                }
            }
        };
        this.updateWindowButtonsStyle();
        this.root.add(this.windowButtons);
    }

    protected void updateWindowButtonsStyle() {
        if (this.windowButtons != null) {
            this.windowButtons.setButtonsDrawFocus(false);
            this.windowButtons.setButtonsShadeWidth(WebRootPaneStyle.buttonsShadeWidth);
            this.windowButtons.setButtonsRound(this.round);
            this.windowButtons.setButtonsMargin(WebRootPaneStyle.buttonsMargin);
            if (this.attachButtons) {
                this.windowButtons.setButtonsDrawTop(false);
                this.windowButtons.setButtonsDrawRight(this.round > 0);
            }
        }
    }

    protected void uninstallDecorationComponents() {
        if (this.titleComponent != null) {
            this.root.remove(this.titleComponent);
            this.titleComponent = null;
        }
        if (this.windowButtons != null) {
            this.root.remove(this.windowButtons);
            this.windowButtons = null;
        }
        if (this.resizeCorner != null) {
            this.root.remove(this.resizeCorner);
            this.resizeCorner = null;
        }
    }

    protected String getWindowTitle() {
        if (this.isDialog()) {
            return this.dialog.getTitle();
        }
        if (this.isFrame()) {
            return this.frame.getTitle();
        }
        return null;
    }

    protected ImageIcon getWindowIcon() {
        List<Image> images;
        List<Image> list = images = this.window != null ? this.window.getIconImages() : null;
        if (images != null && images.size() > 1) {
            int bestIndex = 0;
            int bestDiff = Math.abs(images.get(bestIndex).getWidth(null) - 16);
            for (int i = 1; i < images.size() && bestDiff != 0; ++i) {
                int diff = Math.abs(images.get(i).getWidth(null) - 16);
                if (diff >= bestDiff) continue;
                bestIndex = i;
                bestDiff = diff;
            }
            return this.generateProperIcon(images.get(bestIndex));
        }
        if (images != null && images.size() == 1) {
            return this.generateProperIcon(images.get(0));
        }
        return new ImageIcon();
    }

    protected ImageIcon generateProperIcon(Image image) {
        if (image.getWidth(null) <= 16) {
            return new ImageIcon(image);
        }
        return ImageUtils.createPreviewIcon(image, 16);
    }

    protected void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    protected void iconify() {
        if (this.frame != null) {
            this.frame.setExtendedState(1);
        }
    }

    protected void maximize() {
        if (this.frame != null) {
            this.frame.setExtendedState(6);
        }
    }

    protected void restore() {
        if (this.frame != null) {
            this.frame.setExtendedState(0);
        }
    }

    protected boolean isResizable() {
        return this.isDialog() ? this.dialog.isResizable() : this.isFrame() && this.frame.isResizable();
    }

    protected boolean isFrame() {
        return this.frame != null;
    }

    protected boolean isFrameMaximized() {
        return this.isFrame() && this.state == 6;
    }

    protected boolean isDialog() {
        return this.dialog != null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.styled) {
            Graphics2D g2d = (Graphics2D)g;
            Object aa = LafUtils.setupAntialias(g2d);
            boolean max = this.isFrameMaximized();
            if (max) {
                g2d.setPaint(new GradientPaint(0.0f, 0.0f, this.topBg, 0.0f, 30.0f, this.middleBg));
                g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
                g2d.setPaint(this.borderColor);
                g2d.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
                g2d.setPaint(this.innerBorderColor);
                g2d.drawRect(1, 1, c.getWidth() - 3, c.getHeight() - 3);
                if (this.drawWatermark) {
                    Shape old = LafUtils.intersectClip(g2d, this.getWatermarkClip(c));
                    g2d.drawImage(this.getWatermark().getImage(), 2, 2, null);
                    LafUtils.restoreClip(g2d, old);
                }
            } else {
                if (this.shadeWidth > 0) {
                    int diff = this.isActive(c) ? 0 : this.shadeWidth - this.inactiveShadeWidth;
                    this.getShadeIcon(c).paintIcon(g2d, diff, diff, c.getWidth() - diff * 2, c.getHeight() - diff * 2);
                }
                g2d.setPaint(new GradientPaint(0.0f, this.shadeWidth, this.topBg, 0.0f, this.shadeWidth + 30, this.middleBg));
                g2d.fillRoundRect(this.shadeWidth, this.shadeWidth, c.getWidth() - this.shadeWidth * 2, c.getHeight() - this.shadeWidth * 2, this.round * 2, this.round * 2);
                g2d.setPaint(this.borderColor);
                g2d.drawRoundRect(this.shadeWidth, this.shadeWidth, c.getWidth() - this.shadeWidth * 2 - 1, c.getHeight() - this.shadeWidth * 2 - 1, this.round * 2 - 2, this.round * 2 - 2);
                g2d.setPaint(this.innerBorderColor);
                g2d.drawRoundRect(this.shadeWidth + 1, this.shadeWidth + 1, c.getWidth() - this.shadeWidth * 2 - 3, c.getHeight() - this.shadeWidth * 2 - 3, this.round * 2 - 4, this.round * 2 - 4);
                if (this.drawWatermark) {
                    Shape old = LafUtils.intersectClip(g2d, this.getWatermarkClip(c));
                    g2d.drawImage(this.getWatermark().getImage(), this.shadeWidth + 2, this.shadeWidth + 2, null);
                    LafUtils.restoreClip(g2d, old);
                }
            }
            LafUtils.restoreAntialias(g2d, aa);
        }
    }

    protected RoundRectangle2D.Double getWatermarkClip(JComponent c) {
        return new RoundRectangle2D.Double(this.shadeWidth + 2, this.shadeWidth + 2, c.getWidth() - this.shadeWidth * 2 - 3, c.getHeight() - this.shadeWidth * 2 - 3, this.round * 2 - 4, this.round * 2 - 4);
    }

    protected NinePatchIcon getShadeIcon(JComponent c) {
        if (this.shadeWidth > 0) {
            return NinePatchUtils.getShadeIcon(this.getShadeWidth(c), this.round, 0.8f);
        }
        return null;
    }

    protected int getShadeWidth(JComponent c) {
        return this.isActive(c) ? this.shadeWidth : this.inactiveShadeWidth;
    }

    protected boolean isActive(JComponent c) {
        return SwingUtils.getWindowAncestor(c).isFocused();
    }

    protected class TitleLabel
    extends WebLabel {
        protected TitleLabel() {
        }

        @Override
        public String getText() {
            String title = WebRootPaneUI.this.getWindowTitle();
            return title != null && !title.equals("") ? title : WebRootPaneUI.this.emptyTitleText;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension ps = super.getPreferredSize();
            ps.width = Math.min(ps.width, WebRootPaneUI.this.maxTitleWidth);
            return ps;
        }

        public Dimension getRequiredSize() {
            return super.getPreferredSize();
        }
    }
}

