/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.radiobutton;

import com.alee.laf.StyleConstants;
import com.alee.laf.list.WebListElement;
import com.alee.laf.radiobutton.WebRadioButtonStyle;
import com.alee.laf.tree.WebTreeElement;
import com.alee.utils.ColorUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.WebTimer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class WebRadioButtonUI
extends BasicRadioButtonUI
implements ShapeProvider {
    public static final int MAX_DARKNESS = 5;
    public static List<ImageIcon> CHECK_STATES = new ArrayList<ImageIcon>();
    public static ImageIcon DISABLED_CHECK = null;
    private Color borderColor = WebRadioButtonStyle.borderColor;
    private Color darkBorderColor = WebRadioButtonStyle.darkBorderColor;
    private Color disabledBorderColor = WebRadioButtonStyle.disabledBorderColor;
    private Color topBgColor = WebRadioButtonStyle.topBgColor;
    private Color bottomBgColor = WebRadioButtonStyle.bottomBgColor;
    private Color topSelectedBgColor = WebRadioButtonStyle.topSelectedBgColor;
    private Color bottomSelectedBgColor = WebRadioButtonStyle.bottomSelectedBgColor;
    private int shadeWidth = WebRadioButtonStyle.shadeWidth;
    private Insets margin = WebRadioButtonStyle.margin;
    private boolean animated = WebRadioButtonStyle.animated;
    private boolean rolloverDarkBorderOnly = WebRadioButtonStyle.rolloverDarkBorderOnly;
    public Stroke borderStroke = new BasicStroke(1.5f);
    private int iconWidth = 16;
    private int iconHeight = 16;
    private int bgDarkness = 0;
    private boolean rollover;
    private WebTimer bgTimer;
    private int checkIcon;
    private boolean checking;
    private WebTimer checkTimer;
    private Rectangle iconRect;
    private JRadioButton radioButton;
    private MouseAdapter mouseAdapter;
    private ItemListener itemListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebRadioButtonUI();
    }

    @Override
    public void installUI(final JComponent c) {
        super.installUI(c);
        this.radioButton = (JRadioButton)c;
        SwingUtils.setOrientation(this.radioButton);
        LookAndFeel.installProperty(this.radioButton, "opaque", Boolean.FALSE);
        this.checkIcon = this.radioButton.isSelected() ? CHECK_STATES.size() - 1 : 0;
        this.updateBorder();
        this.updateIcon(this.radioButton);
        this.bgTimer = new WebTimer("WebRadioButtonUI.bgUpdater", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebRadioButtonUI.this.rollover && WebRadioButtonUI.this.bgDarkness < 5) {
                    WebRadioButtonUI.this.bgDarkness++;
                    c.repaint();
                } else if (!WebRadioButtonUI.this.rollover && WebRadioButtonUI.this.bgDarkness > 0) {
                    WebRadioButtonUI.this.bgDarkness--;
                    c.repaint();
                } else {
                    WebRadioButtonUI.this.bgTimer.stop();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WebRadioButtonUI.this.rollover = true;
                if (WebRadioButtonUI.this.isAnimated()) {
                    WebRadioButtonUI.this.bgTimer.start();
                } else {
                    WebRadioButtonUI.this.bgDarkness = 5;
                    c.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WebRadioButtonUI.this.rollover = false;
                if (WebRadioButtonUI.this.isAnimated()) {
                    WebRadioButtonUI.this.bgTimer.start();
                } else {
                    WebRadioButtonUI.this.bgDarkness = 0;
                    c.repaint();
                }
            }
        };
        this.radioButton.addMouseListener(this.mouseAdapter);
        this.checkTimer = new WebTimer("WebRadioButtonUI.iconUpdater", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebRadioButtonUI.this.checking && WebRadioButtonUI.this.checkIcon < CHECK_STATES.size() - 1) {
                    WebRadioButtonUI.this.checkIcon++;
                    c.repaint();
                } else if (!WebRadioButtonUI.this.checking && WebRadioButtonUI.this.checkIcon > 0) {
                    WebRadioButtonUI.this.checkIcon--;
                    c.repaint();
                } else {
                    WebRadioButtonUI.this.checkTimer.stop();
                }
            }
        });
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (WebRadioButtonUI.this.animated) {
                    if (WebRadioButtonUI.this.radioButton.isSelected()) {
                        WebRadioButtonUI.this.checking = true;
                        WebRadioButtonUI.this.checkTimer.start();
                    } else {
                        WebRadioButtonUI.this.checking = false;
                        WebRadioButtonUI.this.checkTimer.start();
                    }
                } else {
                    WebRadioButtonUI.this.checkTimer.stop();
                    WebRadioButtonUI.this.checkIcon = WebRadioButtonUI.this.radioButton.isSelected() ? CHECK_STATES.size() - 1 : 0;
                    c.repaint();
                }
            }
        };
        this.radioButton.addItemListener(this.itemListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.radioButton.removeMouseListener(this.mouseAdapter);
        this.radioButton.removeItemListener(this.itemListener);
        this.radioButton.setIcon(null);
        this.radioButton = null;
        super.uninstallUI(c);
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.radioButton, this.getShadeWidth(), this.getRound());
    }

    private void updateBorder() {
        if (SwingUtils.isPreserveBorders(this.radioButton)) {
            return;
        }
        boolean ltr = this.radioButton.getComponentOrientation().isLeftToRight();
        Insets m = new Insets(this.margin.top, ltr ? this.margin.left : this.margin.right, this.margin.bottom, ltr ? this.margin.right : this.margin.left);
        this.radioButton.setBorder(LafUtils.createWebBorder(m));
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public boolean isAnimated() {
        return this.animated && (this.radioButton == null || this.radioButton.getParent() == null || !(this.radioButton.getParent() instanceof WebListElement) && !(this.radioButton.getParent() instanceof WebTreeElement));
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.rolloverDarkBorderOnly;
    }

    public void setRolloverDarkBorderOnly(boolean rolloverDarkBorderOnly) {
        this.rolloverDarkBorderOnly = rolloverDarkBorderOnly;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getDarkBorderColor() {
        return this.darkBorderColor;
    }

    public void setDarkBorderColor(Color darkBorderColor) {
        this.darkBorderColor = darkBorderColor;
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        this.disabledBorderColor = disabledBorderColor;
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color topBgColor) {
        this.topBgColor = topBgColor;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color bottomBgColor) {
        this.bottomBgColor = bottomBgColor;
    }

    public Color getTopSelectedBgColor() {
        return this.topSelectedBgColor;
    }

    public void setTopSelectedBgColor(Color topSelectedBgColor) {
        this.topSelectedBgColor = topSelectedBgColor;
    }

    public Color getBottomSelectedBgColor() {
        return this.bottomSelectedBgColor;
    }

    public void setBottomSelectedBgColor(Color bottomSelectedBgColor) {
        this.bottomSelectedBgColor = bottomSelectedBgColor;
    }

    public int getRound() {
        return 6;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }

    private void updateIcon(final JRadioButton radioButton) {
        radioButton.setIcon(new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                WebRadioButtonUI.this.iconRect = new Rectangle(x, y, WebRadioButtonUI.this.iconWidth, WebRadioButtonUI.this.iconHeight);
                Graphics2D g2d = (Graphics2D)g;
                Object aa = LafUtils.setupAntialias(g2d);
                int round = WebRadioButtonUI.this.iconWidth - WebRadioButtonUI.this.shadeWidth * 2 - 2;
                Rectangle iconRect = new Rectangle(x + WebRadioButtonUI.this.shadeWidth, y + WebRadioButtonUI.this.shadeWidth, WebRadioButtonUI.this.iconWidth - WebRadioButtonUI.this.shadeWidth * 2 - 1, WebRadioButtonUI.this.iconHeight - WebRadioButtonUI.this.shadeWidth * 2 - 1);
                RoundRectangle2D.Double shape = new RoundRectangle2D.Double(iconRect.x, iconRect.y, iconRect.width, iconRect.height, round, round);
                if (c.isEnabled()) {
                    LafUtils.drawShade(g2d, shape, c.isEnabled() && c.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, WebRadioButtonUI.this.shadeWidth);
                }
                int radius = Math.round((float)Math.sqrt(iconRect.width * iconRect.width / 2));
                g2d.setPaint(new RadialGradientPaint(iconRect.x + iconRect.width / 2, (float)(iconRect.y + iconRect.height / 2), radius, new float[]{0.0f, 1.0f}, WebRadioButtonUI.this.getBgColors(radioButton)));
                g2d.fill(shape);
                Stroke os = LafUtils.setupStroke(g2d, WebRadioButtonUI.this.borderStroke);
                g2d.setPaint(c.isEnabled() ? (WebRadioButtonUI.this.rolloverDarkBorderOnly ? ColorUtils.getIntermediateColor(WebRadioButtonUI.this.borderColor, WebRadioButtonUI.this.darkBorderColor, WebRadioButtonUI.this.getProgress()) : WebRadioButtonUI.this.darkBorderColor) : WebRadioButtonUI.this.disabledBorderColor);
                g2d.draw(shape);
                LafUtils.restoreStroke(g2d, os);
                if (WebRadioButtonUI.this.checkIcon > 0) {
                    ImageIcon icon = radioButton.isEnabled() ? CHECK_STATES.get(WebRadioButtonUI.this.checkIcon) : DISABLED_CHECK;
                    g2d.drawImage(icon.getImage(), x + WebRadioButtonUI.this.iconWidth / 2 - icon.getIconWidth() / 2, y + WebRadioButtonUI.this.iconHeight / 2 - icon.getIconHeight() / 2, radioButton);
                }
                LafUtils.restoreAntialias(g2d, aa);
            }

            @Override
            public int getIconWidth() {
                return WebRadioButtonUI.this.iconWidth;
            }

            @Override
            public int getIconHeight() {
                return WebRadioButtonUI.this.iconHeight;
            }
        });
    }

    private Color[] getBgColors(JRadioButton radioButton) {
        if (radioButton.isEnabled()) {
            float progress = this.getProgress();
            if (progress < 1.0f) {
                return new Color[]{ColorUtils.getIntermediateColor(this.topBgColor, this.topSelectedBgColor, progress), ColorUtils.getIntermediateColor(this.bottomBgColor, this.bottomSelectedBgColor, progress)};
            }
            return new Color[]{this.topSelectedBgColor, this.bottomSelectedBgColor};
        }
        return new Color[]{this.topBgColor, this.bottomBgColor};
    }

    private float getProgress() {
        return (float)this.bgDarkness / 5.0f;
    }

    public Rectangle getIconRect() {
        return this.iconRect != null ? new Rectangle(this.iconRect) : new Rectangle();
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        Map hints = SwingUtils.setupTextAntialias(g);
        super.paint(g, c);
        SwingUtils.restoreTextAntialias(g, hints);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtils.getFontMetrics(c, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(b.getBackground().brighter());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(b.getBackground().darker());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    static {
        CHECK_STATES.add(StyleConstants.EMPTY_ICON);
        for (int i = 1; i <= 3; ++i) {
            CHECK_STATES.add(new ImageIcon(WebRadioButtonUI.class.getResource("icons/c" + i + ".png")));
        }
        DISABLED_CHECK = ImageUtils.getDisabledCopy("WebRadioButton.disabled.check", CHECK_STATES.get(CHECK_STATES.size() - 1));
    }
}

