/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.progressbar;

import com.alee.laf.StyleConstants;
import com.alee.laf.progressbar.WebProgressBarStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.ThreadUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.BorderMethods;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class WebProgressBarUI
extends BasicProgressBarUI
implements ShapeProvider,
BorderMethods {
    private static final int indeterminateStep = 20;
    private static final int determinateAnimationWidth = 120;
    private static final AffineTransform moveX = new AffineTransform();
    private Color bgTop = WebProgressBarStyle.bgTop;
    private Color bgBottom = WebProgressBarStyle.bgBottom;
    private Color progressTopColor = WebProgressBarStyle.progressTopColor;
    private Color progressBottomColor = WebProgressBarStyle.progressBottomColor;
    private Color indeterminateBorder = WebProgressBarStyle.indeterminateBorder;
    private Color highlightWhite = WebProgressBarStyle.highlightWhite;
    private Color highlightDarkWhite = WebProgressBarStyle.highlightDarkWhite;
    private int round = WebProgressBarStyle.round;
    private int innerRound = WebProgressBarStyle.innerRound;
    private int shadeWidth = WebProgressBarStyle.shadeWidth;
    private boolean paintIndeterminateBorder = WebProgressBarStyle.paintIndeterminateBorder;
    private int preferredProgressWidth = WebProgressBarStyle.preferredProgressWidth;
    private final int determinateAnimationPause = 1500;
    private int animationLocation = 0;
    private WebTimer animator = null;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebProgressBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.progressBar);
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
        this.progressBar.setBorderPainted(false);
        this.progressBar.setForeground(Color.DARK_GRAY);
        this.updateBorder();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebProgressBarUI.this.updateAnimator(WebProgressBarUI.this.progressBar);
            }
        };
        this.progressBar.addPropertyChangeListener("indeterminate", this.propertyChangeListener);
        this.progressBar.addPropertyChangeListener("enabled", this.propertyChangeListener);
        this.updateAnimator(this.progressBar);
        c.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                WebProgressBarUI.this.updateAnimator(WebProgressBarUI.this.progressBar);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                WebProgressBarUI.this.updateAnimator(WebProgressBarUI.this.progressBar);
            }
        });
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.propertyChangeListener);
        if (this.animator != null) {
            this.animator.stop();
        }
        super.uninstallUI(c);
    }

    @Override
    public void updateBorder() {
        if (this.progressBar != null) {
            if (SwingUtils.isPreserveBorders(this.progressBar)) {
                return;
            }
            this.progressBar.setBorder(LafUtils.createWebBorder(this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1, this.shadeWidth + 1));
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getInnerRound() {
        return this.innerRound;
    }

    public void setInnerRound(int innerRound) {
        this.innerRound = innerRound;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public boolean isPaintIndeterminateBorder() {
        return this.paintIndeterminateBorder;
    }

    public void setPaintIndeterminateBorder(boolean paintIndeterminateBorder) {
        this.paintIndeterminateBorder = paintIndeterminateBorder;
    }

    public int getPreferredProgressWidth() {
        return this.preferredProgressWidth;
    }

    public void setPreferredProgressWidth(int preferredProgressWidth) {
        this.preferredProgressWidth = preferredProgressWidth;
    }

    public Color getBgTop() {
        return this.bgTop;
    }

    public void setBgTop(Color bgTop) {
        this.bgTop = bgTop;
    }

    public Color getBgBottom() {
        return this.bgBottom;
    }

    public void setBgBottom(Color bgBottom) {
        this.bgBottom = bgBottom;
    }

    public Color getProgressTopColor() {
        return this.progressTopColor;
    }

    public void setProgressTopColor(Color progressTopColor) {
        this.progressTopColor = progressTopColor;
    }

    public Color getProgressBottomColor() {
        return this.progressBottomColor;
    }

    public void setProgressBottomColor(Color progressBottomColor) {
        this.progressBottomColor = progressBottomColor;
    }

    public Color getIndeterminateBorder() {
        return this.indeterminateBorder;
    }

    public void setIndeterminateBorder(Color indeterminateBorder) {
        this.indeterminateBorder = indeterminateBorder;
    }

    public Color getHighlightWhite() {
        return this.highlightWhite;
    }

    public void setHighlightWhite(Color highlightWhite) {
        this.highlightWhite = highlightWhite;
    }

    public Color getHighlightDarkWhite() {
        return this.highlightDarkWhite;
    }

    public void setHighlightDarkWhite(Color highlightDarkWhite) {
        this.highlightDarkWhite = highlightDarkWhite;
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.progressBar, this.getShadeWidth(), this.getRound());
    }

    private void updateAnimator(final JProgressBar progressBar) {
        if (this.animator != null) {
            this.animator.stop();
        }
        if (SwingUtils.getWindowAncestor(progressBar) != null && progressBar.isShowing() && progressBar.isEnabled()) {
            if (progressBar.isIndeterminate()) {
                this.animationLocation = 0;
                this.animator = new WebTimer("WebProgressBarUI.animator", (long)StyleConstants.animationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (WebProgressBarUI.this.animationLocation < 39) {
                            WebProgressBarUI.this.animationLocation++;
                        } else {
                            WebProgressBarUI.this.animationLocation = 0;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressBar.repaint();
                            }
                        });
                    }
                });
                this.animator.setUseEventDispatchThread(false);
            } else {
                this.animationLocation = -120;
                this.animator = new WebTimer("WebProgressBarUI.animator", (long)StyleConstants.animationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (WebProgressBarUI.this.animationLocation < WebProgressBarUI.this.getProgressWidth()) {
                            WebProgressBarUI.this.animationLocation += 15;
                            this.refresh(progressBar);
                        } else {
                            WebProgressBarUI.this.animationLocation = -120;
                            this.refresh(progressBar);
                            ThreadUtils.sleepSafely(1500L);
                        }
                    }

                    private void refresh(final JProgressBar progressBar2) {
                        if (!progressBar2.isIndeterminate() && progressBar2.getValue() > progressBar2.getMinimum()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    progressBar2.repaint();
                                }
                            });
                        }
                    }
                });
            }
            this.animator.setUseEventDispatchThread(false);
            this.animator.start();
        }
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        Dimension ph = super.getPreferredInnerHorizontal();
        ph.width = this.preferredProgressWidth;
        return ph;
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        Dimension pv = super.getPreferredInnerVertical();
        pv.height = this.preferredProgressWidth;
        return pv;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Object aa = LafUtils.setupAntialias(g);
        super.paint(g, c);
        LafUtils.restoreAntialias(g, aa);
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        this.paintProgressBarBorder(c, g2d);
        Shape is = this.getInnerProgressShape(c);
        Shape oldClip = g2d.getClip();
        Area newClip = new Area(is);
        newClip.intersect(new Area(oldClip));
        g2d.setClip(newClip);
        GeneralPath bs = this.getIndeterminateProgressShape(c);
        AffineTransform at = new AffineTransform();
        at.translate(this.animationLocation, 0.0);
        bs.transform(at);
        for (int x = 0; x < c.getWidth() - this.shadeWidth * 2 - 4 - 1 + 40; x += 40) {
            g2d.setPaint(new GradientPaint(0.0f, this.shadeWidth, this.progressTopColor, 0.0f, c.getHeight() - this.shadeWidth, this.progressBottomColor));
            g2d.fill(bs);
            if (this.paintIndeterminateBorder) {
                g2d.setPaint(this.indeterminateBorder);
                g2d.draw(bs);
            }
            bs.transform(moveX);
        }
        if (this.progressBar.isStringPainted() && this.progressBar.getString() != null && this.progressBar.getString().trim().length() > 0) {
            int tw = g2d.getFontMetrics().stringWidth(this.progressBar.getString());
            float percentage = (float)tw / (float)(this.progressBar.getWidth() * 2);
            float start = 0.5f - percentage;
            float end = 0.5f + percentage;
            g2d.setPaint(new LinearGradientPaint(0.0f, 0.0f, this.progressBar.getWidth(), 0.0f, new float[]{start / 2.0f, start, end, end + (1.0f - end) / 2.0f}, new Color[]{StyleConstants.transparent, this.highlightWhite, this.highlightWhite, StyleConstants.transparent}));
            g2d.fill(is);
        }
        g2d.setClip(oldClip);
        if (c.isEnabled()) {
            LafUtils.drawShade(g2d, is, StyleConstants.shadeColor, this.shadeWidth);
        }
        g2d.setPaint(c.isEnabled() ? Color.GRAY : Color.LIGHT_GRAY);
        g2d.draw(is);
        this.drawProgressBarText(g2d);
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        this.paintProgressBarBorder(c, g2d);
        if (this.progressBar.getValue() > this.progressBar.getMinimum()) {
            Shape is = this.getInnerProgressShape(c);
            if (c.isEnabled()) {
                LafUtils.drawShade(g2d, is, StyleConstants.shadeColor, this.shadeWidth);
            }
            if (this.progressBar.getOrientation() == 0) {
                g2d.setPaint(new GradientPaint(0.0f, this.shadeWidth, this.progressTopColor, 0.0f, c.getHeight() - this.shadeWidth, this.progressBottomColor));
            } else if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                g2d.setPaint(new GradientPaint(this.shadeWidth, 0.0f, this.progressTopColor, c.getWidth() - this.shadeWidth, 0.0f, this.progressBottomColor));
            } else {
                g2d.setPaint(new GradientPaint(this.shadeWidth, 0.0f, this.progressBottomColor, c.getWidth() - this.shadeWidth, 0.0f, this.progressTopColor));
            }
            g2d.fill(is);
            if (c.isEnabled()) {
                Shape oldClip = g2d.getClip();
                Area newClip = new Area(is);
                newClip.intersect(new Area(oldClip));
                g2d.setClip(newClip);
                if (this.progressBar.getOrientation() == 0) {
                    g2d.setPaint(new RadialGradientPaint(this.shadeWidth * 2 + this.animationLocation + 60, (float)(this.progressBar.getHeight() / 2), 60.0f, new float[]{0.0f, 1.0f}, new Color[]{this.highlightDarkWhite, StyleConstants.transparent}));
                } else if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                    g2d.setPaint(new RadialGradientPaint(c.getWidth() / 2, (float)(c.getHeight() - this.shadeWidth * 2 - this.animationLocation - 60), 60.0f, new float[]{0.0f, 1.0f}, new Color[]{this.highlightDarkWhite, StyleConstants.transparent}));
                } else {
                    g2d.setPaint(new RadialGradientPaint(c.getWidth() / 2, (float)(this.shadeWidth * 2 + this.animationLocation + 60), 60.0f, new float[]{0.0f, 1.0f}, new Color[]{this.highlightDarkWhite, StyleConstants.transparent}));
                }
                g2d.fill(is);
                g2d.setClip(oldClip);
            }
            g2d.setPaint(c.isEnabled() ? Color.GRAY : Color.LIGHT_GRAY);
            g2d.draw(is);
        }
        this.drawProgressBarText(g2d);
    }

    private void drawProgressBarText(Graphics2D g2d) {
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 1) {
                g2d.translate(this.progressBar.getWidth() / 2, this.progressBar.getHeight() / 2);
                g2d.rotate((double)(this.progressBar.getComponentOrientation().isLeftToRight() ? -1 : 1) * Math.PI / 2.0);
                g2d.translate(-this.progressBar.getWidth() / 2, -this.progressBar.getHeight() / 2);
            }
            String string = this.progressBar.getString();
            Point ts = LafUtils.getTextCenterShear(g2d.getFontMetrics(), string);
            if (!this.progressBar.isEnabled()) {
                g2d.setPaint(Color.WHITE);
                g2d.drawString(string, this.progressBar.getWidth() / 2 + ts.x + 1, this.progressBar.getHeight() / 2 + ts.y + 1);
            }
            g2d.setPaint(this.progressBar.isEnabled() ? this.progressBar.getForeground() : StyleConstants.disabledTextColor);
            g2d.drawString(string, this.progressBar.getWidth() / 2 + ts.x, this.progressBar.getHeight() / 2 + ts.y);
            if (this.progressBar.getOrientation() == 1) {
                g2d.rotate((double)(this.progressBar.getComponentOrientation().isLeftToRight() ? 1 : -1) * Math.PI / 2.0);
            }
        }
    }

    private void paintProgressBarBorder(JComponent c, Graphics2D g2d) {
        Shape bs = this.getProgressShape(c);
        if (c.isEnabled()) {
            LafUtils.drawShade(g2d, bs, StyleConstants.shadeColor, this.shadeWidth);
        }
        if (this.progressBar.getOrientation() == 0) {
            g2d.setPaint(new GradientPaint(0.0f, this.shadeWidth, this.bgTop, 0.0f, c.getHeight() - this.shadeWidth, this.bgBottom));
        } else {
            g2d.setPaint(new GradientPaint(this.shadeWidth, 0.0f, this.bgTop, c.getWidth() - this.shadeWidth, 0.0f, this.bgBottom));
        }
        g2d.fill(bs);
        g2d.setPaint(c.isEnabled() ? Color.GRAY : Color.LIGHT_GRAY);
        g2d.draw(bs);
    }

    private Shape getProgressShape(JComponent c) {
        if (this.round > 0) {
            return new RoundRectangle2D.Double(this.shadeWidth, this.shadeWidth, c.getWidth() - this.shadeWidth * 2 - 1, c.getHeight() - this.shadeWidth * 2 - 1, this.round * 2, this.round * 2);
        }
        return new Rectangle2D.Double(this.shadeWidth, this.shadeWidth, c.getWidth() - this.shadeWidth * 2 - 1, c.getHeight() - this.shadeWidth * 2 - 1);
    }

    private Shape getInnerProgressShape(JComponent c) {
        int progress = this.getProgressWidth();
        if (this.progressBar.getOrientation() == 0) {
            if (this.innerRound > 0) {
                return new RoundRectangle2D.Double(this.shadeWidth * 2, this.shadeWidth * 2, progress - 1, c.getHeight() - this.shadeWidth * 4 - 1, this.innerRound * 2, this.innerRound * 2);
            }
            return new Rectangle2D.Double(this.shadeWidth * 2, this.shadeWidth * 2, progress - 1, c.getHeight() - this.shadeWidth * 4 - 1);
        }
        if (this.progressBar.getComponentOrientation().isLeftToRight()) {
            if (this.innerRound > 0) {
                return new RoundRectangle2D.Double(this.shadeWidth * 2, c.getHeight() - progress - this.shadeWidth * 2, c.getWidth() - this.shadeWidth * 4 - 1, progress - 1, this.innerRound * 2, this.innerRound * 2);
            }
            return new Rectangle2D.Double(this.shadeWidth * 2, c.getHeight() - progress - this.shadeWidth * 2, c.getWidth() - this.shadeWidth * 4 - 1, progress - 1);
        }
        if (this.innerRound > 0) {
            return new RoundRectangle2D.Double(this.shadeWidth * 2, this.shadeWidth * 2, c.getWidth() - this.shadeWidth * 4 - 1, progress - 1, this.innerRound * 2, this.innerRound * 2);
        }
        return new Rectangle2D.Double(this.shadeWidth * 2, this.shadeWidth * 2, c.getWidth() - this.shadeWidth * 4 - 1, progress - 1);
    }

    private int getProgressWidth() {
        int progress = this.progressBar.isIndeterminate() ? (this.progressBar.getOrientation() == 0 ? this.progressBar.getWidth() - this.shadeWidth * 4 : this.progressBar.getHeight() - this.shadeWidth * 4) : (this.progressBar.getOrientation() == 0 ? (int)((float)(this.progressBar.getWidth() - this.shadeWidth * 4) * ((float)(this.progressBar.getValue() - this.progressBar.getMinimum()) / (float)(this.progressBar.getMaximum() - this.progressBar.getMinimum()))) : (int)((float)(this.progressBar.getHeight() - this.shadeWidth * 4) * ((float)(this.progressBar.getValue() - this.progressBar.getMinimum()) / (float)(this.progressBar.getMaximum() - this.progressBar.getMinimum()))));
        return progress;
    }

    private GeneralPath getIndeterminateProgressShape(JComponent c) {
        GeneralPath gp = new GeneralPath(0);
        gp.moveTo(this.shadeWidth * 2 - 40, c.getHeight() - this.shadeWidth - 1);
        gp.lineTo(this.shadeWidth * 2 - 20, this.shadeWidth);
        gp.lineTo(this.shadeWidth * 2, this.shadeWidth);
        gp.lineTo(this.shadeWidth * 2 - 20, c.getHeight() - this.shadeWidth - 1);
        gp.closePath();
        return gp;
    }

    static {
        moveX.translate(40.0, 0.0);
    }
}

