/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.panel;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.extended.painter.PartialDecoration;
import com.alee.laf.panel.AdaptivePanelPainter;
import com.alee.laf.panel.PanelPainter;
import com.alee.laf.panel.WebPanelStyle;
import com.alee.managers.style.StyleManager;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.PainterShapeProvider;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.laf.Styleable;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class WebPanelUI
extends BasicPanelUI
implements Styleable,
ShapeProvider,
BorderMethods,
PartialDecoration {
    protected boolean undecorated = WebPanelStyle.undecorated;
    protected boolean paintFocus = WebPanelStyle.drawFocus;
    protected Insets margin = WebPanelStyle.margin;
    protected boolean paintTop = true;
    protected boolean paintLeft = true;
    protected boolean paintBottom = true;
    protected boolean paintRight = true;
    protected boolean paintTopLine = false;
    protected boolean paintLeftLine = false;
    protected boolean paintBottomLine = false;
    protected boolean paintRightLine = false;
    protected PanelPainter painter;
    protected PropertyChangeListener propertyChangeListener;
    protected String styleId;
    protected JPanel panel;

    public static ComponentUI createUI(JComponent c) {
        return new WebPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.panel = (JPanel)c;
        SwingUtils.setOrientation(this.panel);
        StyleManager.applySkin(this.panel);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebPanelUI.this.updateBorder();
            }
        };
        this.panel.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.panel.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        StyleManager.removeSkin(this.panel);
        this.panel = null;
        super.uninstallUI(c);
    }

    @Override
    public String getStyleId() {
        return this.styleId;
    }

    @Override
    public void setStyleId(String id) {
        this.styleId = id;
        StyleManager.applySkin(this.panel);
    }

    @Override
    public Shape provideShape() {
        if (this.painter != null && this.painter instanceof PainterShapeProvider) {
            return ((PainterShapeProvider)((Object)this.painter)).provideShape(this.panel, SwingUtils.size(this.panel));
        }
        return SwingUtils.size(this.panel);
    }

    @Override
    public void updateBorder() {
        LafUtils.updateBorder(this.panel, this.margin, this.painter);
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        this.undecorated = undecorated;
        if (this.painter != null) {
            this.painter.setUndecorated(undecorated);
        }
    }

    public boolean isPaintFocus() {
        return this.paintFocus;
    }

    public void setPaintFocus(boolean paint) {
        this.paintFocus = paint;
        if (this.painter != null) {
            this.painter.setPaintFocus(paint);
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public boolean isPaintTop() {
        return this.paintTop;
    }

    @Override
    public void setPaintTop(boolean top) {
        this.paintTop = top;
        if (this.painter != null) {
            this.painter.setPaintTop(top);
        }
    }

    public boolean isPaintLeft() {
        return this.paintLeft;
    }

    @Override
    public void setPaintLeft(boolean left) {
        this.paintLeft = left;
        if (this.painter != null) {
            this.painter.setPaintLeft(left);
        }
    }

    public boolean isPaintBottom() {
        return this.paintBottom;
    }

    @Override
    public void setPaintBottom(boolean bottom) {
        this.paintBottom = bottom;
        if (this.painter != null) {
            this.painter.setPaintBottom(bottom);
        }
    }

    public boolean isPaintRight() {
        return this.paintRight;
    }

    @Override
    public void setPaintRight(boolean right) {
        this.paintRight = right;
        if (this.painter != null) {
            this.painter.setPaintRight(right);
        }
    }

    @Override
    public void setPaintSides(boolean top, boolean left, boolean bottom, boolean right) {
        this.paintTop = top;
        this.paintLeft = left;
        this.paintBottom = bottom;
        this.paintRight = right;
        if (this.painter != null) {
            this.painter.setPaintSides(top, left, bottom, right);
        }
    }

    public boolean isPaintTopLine() {
        return this.paintTopLine;
    }

    @Override
    public void setPaintTopLine(boolean top) {
        this.paintTopLine = top;
        if (this.painter != null) {
            this.painter.setPaintTopLine(top);
        }
    }

    public boolean isPaintLeftLine() {
        return this.paintLeftLine;
    }

    @Override
    public void setPaintLeftLine(boolean left) {
        this.paintLeftLine = left;
        if (this.painter != null) {
            this.painter.setPaintLeftLine(left);
        }
    }

    public boolean isPaintBottomLine() {
        return this.paintBottomLine;
    }

    @Override
    public void setPaintBottomLine(boolean bottom) {
        this.paintBottomLine = bottom;
        if (this.painter != null) {
            this.painter.setPaintBottomLine(bottom);
        }
    }

    public boolean isPaintRightLine() {
        return this.paintRightLine;
    }

    @Override
    public void setPaintRightLine(boolean right) {
        this.paintRightLine = right;
        if (this.painter != null) {
            this.painter.setPaintRightLine(right);
        }
    }

    @Override
    public void setPaintSideLines(boolean top, boolean left, boolean bottom, boolean right) {
        this.paintTopLine = top;
        this.paintLeftLine = left;
        this.paintBottomLine = bottom;
        this.paintRightLine = right;
        if (this.painter != null) {
            this.painter.setPaintSideLines(top, left, bottom, right);
        }
    }

    public int getRound() {
        Integer round = (Integer)StyleManager.getPainterPropertyValue(this.panel, "round");
        return round != null ? round : WebPanelStyle.round;
    }

    public void setRound(int round) {
        StyleManager.setCustomPainterProperty(this.panel, "round", round);
    }

    public int getShadeWidth() {
        Integer shadeWidth = (Integer)StyleManager.getPainterPropertyValue(this.panel, "shadeWidth");
        return shadeWidth != null ? shadeWidth : WebPanelStyle.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        StyleManager.setCustomPainterProperty(this.panel, "shadeWidth", shadeWidth);
    }

    public float getShadeTransparency() {
        Float shadeTransparency = (Float)StyleManager.getPainterPropertyValue(this.panel, "shadeTransparency");
        return shadeTransparency != null ? shadeTransparency.floatValue() : WebPanelStyle.shadeTransparency;
    }

    public void setShadeTransparency(float transparency) {
        StyleManager.setCustomPainterProperty(this.panel, "shadeTransparency", Float.valueOf(transparency));
    }

    public Stroke getBorderStroke() {
        Stroke borderStroke = (Stroke)StyleManager.getPainterPropertyValue(this.panel, "borderStroke");
        return borderStroke != null ? borderStroke : WebPanelStyle.borderStroke;
    }

    public void setBorderStroke(Stroke stroke) {
        StyleManager.setCustomPainterProperty(this.panel, "borderStroke", stroke);
    }

    public Color getBorderColor() {
        Color borderColor = (Color)StyleManager.getPainterPropertyValue(this.panel, "borderColor");
        return borderColor != null ? borderColor : WebPanelStyle.borderColor;
    }

    public void setBorderColor(Color color) {
        StyleManager.setCustomPainterProperty(this.panel, "borderColor", color);
    }

    public Color getDisabledBorderColor() {
        Color disabledBorderColor = (Color)StyleManager.getPainterPropertyValue(this.panel, "disabledBorderColor");
        return disabledBorderColor != null ? disabledBorderColor : WebPanelStyle.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        StyleManager.setCustomPainterProperty(this.panel, "disabledBorderColor", color);
    }

    public boolean isPaintBackground() {
        Boolean paintBackground = (Boolean)StyleManager.getPainterPropertyValue(this.panel, "paintBackground");
        return paintBackground != null ? paintBackground : WebPanelStyle.paintBackground;
    }

    public void setPaintBackground(boolean paint) {
        StyleManager.setCustomPainterProperty(this.panel, "paintBackground", paint);
    }

    public boolean isWebColoredBackground() {
        Boolean webColored = (Boolean)StyleManager.getPainterPropertyValue(this.panel, "webColoredBackground");
        return webColored != null ? webColored : WebPanelStyle.webColoredBackground;
    }

    public void setWebColoredBackground(boolean webColored) {
        StyleManager.setCustomPainterProperty(this.panel, "webColoredBackground", webColored);
    }

    public Painter getPainter() {
        return LafUtils.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        PanelPainter properPainter = (PanelPainter)LafUtils.getProperPainter(painter, PanelPainter.class, AdaptivePanelPainter.class);
        PainterSupport.uninstallPainter(this.panel, this.painter);
        PanelPainter oldPainter = this.painter;
        this.painter = properPainter;
        this.applyPainterSettings(properPainter);
        PainterSupport.installPainter(this.panel, properPainter);
        LafUtils.firePainterChanged(this.panel, oldPainter, properPainter);
    }

    private void applyPainterSettings(PanelPainter painter) {
        if (painter != null) {
            painter.setUndecorated(this.undecorated);
            painter.setPaintFocus(this.paintFocus);
            painter.setPaintSides(this.paintTop, this.paintLeft, this.paintBottom, this.paintRight);
            painter.setPaintSideLines(this.paintTopLine, this.paintLeftLine, this.paintBottomLine, this.paintRightLine);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, SwingUtils.size(c), c);
        }
    }
}

