/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class WebListModel<T>
extends AbstractListModel {
    protected Vector<T> delegate = new Vector();

    public WebListModel() {
    }

    public WebListModel(T ... data) {
        Collections.addAll(this.delegate, data);
    }

    public WebListModel(Collection<T> data) {
        this.delegate.addAll(data);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.delegate.elementAt(index);
    }

    public List<T> getElements() {
        return new ArrayList<T>(this.delegate);
    }

    public void copyInto(T[] array) {
        this.delegate.copyInto(array);
    }

    public void trimToSize() {
        this.delegate.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.delegate.ensureCapacity(minCapacity);
    }

    public void setSize(int newSize) {
        int oldSize = this.delegate.size();
        this.delegate.setSize(newSize);
        if (oldSize > newSize) {
            this.fireIntervalRemoved(this, newSize, oldSize - 1);
        } else if (oldSize < newSize) {
            this.fireIntervalAdded(this, oldSize, newSize - 1);
        }
    }

    public int capacity() {
        return this.delegate.capacity();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Enumeration<T> elements() {
        return this.delegate.elements();
    }

    public boolean contains(T elem) {
        return this.delegate.contains(elem);
    }

    public int indexOf(T elem) {
        return this.delegate.indexOf(elem);
    }

    public int indexOf(T elem, int index) {
        return this.delegate.indexOf(elem, index);
    }

    public int lastIndexOf(T elem) {
        return this.delegate.lastIndexOf(elem);
    }

    public int lastIndexOf(T elem, int index) {
        return this.delegate.lastIndexOf(elem, index);
    }

    public T elementAt(int index) {
        return this.delegate.elementAt(index);
    }

    public T firstElement() {
        return this.delegate.firstElement();
    }

    public T lastElement() {
        return this.delegate.lastElement();
    }

    public void setElementAt(T obj, int index) {
        this.delegate.setElementAt(obj, index);
        this.fireContentsChanged(this, index, index);
    }

    public void removeElementAt(int index) {
        this.delegate.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void insertElementAt(T obj, int index) {
        this.delegate.insertElementAt(obj, index);
        this.fireIntervalAdded(this, index, index);
    }

    public void addElement(T obj) {
        int index = this.delegate.size();
        this.delegate.addElement(obj);
        this.fireIntervalAdded(this, index, index);
    }

    public void addElements(T ... objects) {
        if (objects.length > 0) {
            int index = this.delegate.size();
            Collections.addAll(this.delegate, objects);
            this.fireIntervalAdded(this, index, this.delegate.size() - 1);
        }
    }

    public void addElements(Collection<T> objects) {
        if (objects.size() > 0) {
            int index = this.delegate.size();
            this.delegate.addAll(objects);
            this.fireIntervalAdded(this, index, this.delegate.size() - 1);
        }
    }

    public void setElements(Collection<T> objects) {
        this.clear();
        if (objects.size() > 0) {
            this.delegate.addAll(objects);
            this.fireIntervalAdded(this, 0, this.delegate.size() - 1);
        }
    }

    public boolean removeElement(T object) {
        int index = this.indexOf(object);
        boolean rv = this.delegate.removeElement(object);
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        return rv;
    }

    public void removeElements(T ... objects) {
        for (T object : objects) {
            this.removeElement(object);
        }
    }

    public void removeElements(Collection<T> objects) {
        for (T object : objects) {
            this.removeElement(object);
        }
    }

    public void removeAllElements() {
        int index1 = this.delegate.size() - 1;
        this.delegate.removeAllElements();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void removeAllBefore(int index) {
        for (int i = 0; i < index; ++i) {
            this.delegate.removeElementAt(index);
        }
        if (index > 0) {
            this.fireIntervalRemoved(this, 0, index - 1);
        }
    }

    public void removeAllAfter(int index) {
        int lastIndex;
        for (int i = lastIndex = this.size() - 1; i > index; --i) {
            this.delegate.removeElementAt(i);
        }
        if (lastIndex > index) {
            this.fireIntervalRemoved(this, index + 1, lastIndex);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Object[] toArray() {
        Object[] rv = new Object[this.delegate.size()];
        this.delegate.copyInto(rv);
        return rv;
    }

    public T get(int index) {
        return this.delegate.elementAt(index);
    }

    public T set(int index, T element) {
        T rv = this.delegate.elementAt(index);
        this.delegate.setElementAt(element, index);
        this.fireContentsChanged(this, index, index);
        return rv;
    }

    public void add(int index, T element) {
        this.delegate.insertElementAt(element, index);
        this.fireIntervalAdded(this, index, index);
    }

    public T remove(int index) {
        T rv = this.delegate.elementAt(index);
        this.delegate.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
        return rv;
    }

    public void clear() {
        int index1 = this.delegate.size() - 1;
        this.delegate.removeAllElements();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex must be <= toIndex");
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            this.delegate.removeElementAt(i);
        }
        this.fireIntervalRemoved(this, fromIndex, toIndex);
    }

    public void update(T element) {
        int index = this.indexOf(element);
        if (index != -1) {
            this.fireContentsChanged(this, index, index);
        }
    }
}

