/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.label;

import com.alee.extended.painter.Painter;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.label.WebLabelUI;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.managers.style.StyleManager;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.Styleable;
import com.alee.utils.swing.FontMethods;
import com.alee.utils.swing.SizeMethods;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;

public class WebLabel
extends JLabel
implements Styleable,
LanguageMethods,
FontMethods<WebLabel>,
SizeMethods<WebLabel> {
    public WebLabel() {
    }

    public WebLabel(Insets margin) {
        this.setMargin(margin);
    }

    public WebLabel(Icon image) {
        super(image);
    }

    public WebLabel(Icon image, Insets margin) {
        super(image);
        this.setMargin(margin);
    }

    public WebLabel(int horizontalAlignment) {
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public WebLabel(int horizontalAlignment, Insets margin) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.setMargin(margin);
    }

    public WebLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public WebLabel(Icon image, int horizontalAlignment, Insets margin) {
        super(image, horizontalAlignment);
        this.setMargin(margin);
    }

    public WebLabel(String text) {
        super(text);
    }

    public WebLabel(String text, Insets margin) {
        super(text);
        this.setMargin(margin);
    }

    public WebLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public WebLabel(String text, int horizontalAlignment, Insets margin) {
        super(text, horizontalAlignment);
        this.setMargin(margin);
    }

    public WebLabel(String text, Icon icon) {
        super(text, icon, 10);
    }

    public WebLabel(String text, Icon icon, Insets margin) {
        super(text, icon, 10);
        this.setMargin(margin);
    }

    public WebLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    public WebLabel(String text, Icon icon, int horizontalAlignment, Insets margin) {
        super(text, icon, horizontalAlignment);
        this.setMargin(margin);
    }

    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    public WebLabel setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
        return this;
    }

    public WebLabel setMargin(int spacing) {
        return this.setMargin(spacing, spacing, spacing, spacing);
    }

    public Painter getPainter() {
        return StyleManager.getPainter(this);
    }

    public WebLabel setPainter(Painter painter) {
        StyleManager.setCustomPainter(this, painter);
        return this;
    }

    public boolean isDrawShade() {
        return this.getWebUI().isDrawShade();
    }

    public WebLabel setDrawShade(boolean drawShade) {
        this.getWebUI().setDrawShade(drawShade);
        return this;
    }

    public Color getShadeColor() {
        return this.getWebUI().getShadeColor();
    }

    public WebLabel setShadeColor(Color shadeColor) {
        this.getWebUI().setShadeColor(shadeColor);
        return this;
    }

    public Float getTransparency() {
        return this.getWebUI().getTransparency();
    }

    public WebLabel setTransparency(Float transparency) {
        this.getWebUI().setTransparency(transparency);
        return this;
    }

    @Override
    public String getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public void setStyleId(String id) {
        this.getWebUI().setStyleId(id);
    }

    public WebLabelUI getWebUI() {
        return (WebLabelUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebLabelUI)) {
            try {
                this.setUI((WebLabelUI)ReflectUtils.createInstance(WebLookAndFeel.labelUI, new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebLabelUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public void setLanguage(String key, Object ... data) {
        LanguageManager.registerComponent(this, key, data);
    }

    @Override
    public void updateLanguage(Object ... data) {
        LanguageManager.updateComponent((Component)this, data);
    }

    @Override
    public void updateLanguage(String key, Object ... data) {
        LanguageManager.updateComponent((Component)this, key, data);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater updater) {
        LanguageManager.registerLanguageUpdater(this, updater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }

    @Override
    public WebLabel setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebLabel setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebLabel setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebLabel setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebLabel setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebLabel setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebLabel setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebLabel setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebLabel setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebLabel changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebLabel setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebLabel setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebLabel setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebLabel setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebLabel setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebLabel setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebLabel setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return SizeUtils.getPreferredSize(this, super.getPreferredSize());
    }

    public static WebLabel createTranslatedLabel(String key) {
        WebLabel label = new WebLabel();
        label.setLanguage(key, new Object[0]);
        return label;
    }

    public static WebLabel createTranslatedLabel(String key, Object ... data) {
        WebLabel label = new WebLabel();
        label.setLanguage(key, data);
        return label;
    }

    public static WebLabel createTranslatedLabel(int halign, String key) {
        WebLabel label = new WebLabel(halign);
        label.setLanguage(key, new Object[0]);
        return label;
    }

    public static WebLabel createTranslatedLabel(int halign, String key, Object ... data) {
        WebLabel label = new WebLabel(halign);
        label.setLanguage(key, data);
        return label;
    }

    public static WebLabel createTranslatedLabel(Icon icon, String key) {
        WebLabel label = new WebLabel(icon);
        label.setLanguage(key, new Object[0]);
        return label;
    }

    public static WebLabel createTranslatedLabel(Icon icon, String key, Object ... data) {
        WebLabel label = new WebLabel(icon);
        label.setLanguage(key, data);
        return label;
    }

    public static WebLabel createTranslatedLabel(int halign, Icon icon, String key) {
        WebLabel label = new WebLabel(icon, halign);
        label.setLanguage(key, new Object[0]);
        return label;
    }

    public static WebLabel createTranslatedLabel(int halign, Icon icon, String key, Object ... data) {
        WebLabel label = new WebLabel(icon, halign);
        label.setLanguage(key, data);
        return label;
    }
}

