/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.extended.drag.FileDragAndDropHandler;
import com.alee.extended.filechooser.PathFieldListener;
import com.alee.extended.filechooser.WebFileChooserField;
import com.alee.extended.filechooser.WebFileTable;
import com.alee.extended.filechooser.WebPathField;
import com.alee.extended.filefilter.AbstractFileFilter;
import com.alee.extended.filefilter.FilterGroupType;
import com.alee.extended.filefilter.GroupedFileFilter;
import com.alee.extended.filefilter.NonHiddenFilter;
import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.list.FileElement;
import com.alee.extended.list.FileListViewType;
import com.alee.extended.list.WebFileList;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.tree.WebFileTree;
import com.alee.laf.GlobalConstants;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.combobox.WebComboBoxCellRenderer;
import com.alee.laf.combobox.WebComboBoxElement;
import com.alee.laf.combobox.WebComboBoxStyle;
import com.alee.laf.filechooser.FileApproveText;
import com.alee.laf.filechooser.FileChooserListener;
import com.alee.laf.filechooser.FileChooserType;
import com.alee.laf.filechooser.FileChooserViewType;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.WebList;
import com.alee.laf.list.editor.ListEditAdapter;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.menu.WebRadioButtonMenuItem;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollBar;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.text.WebTextField;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.DataProvider;
import com.alee.utils.swing.DefaultFileFilterListCellRenderer;
import com.alee.utils.text.FileNameProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class WebFileChooserPanel
extends WebPanel {
    public static final ImageIcon BACKWARD_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/backward.png"));
    public static final ImageIcon FORWARD_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/forward.png"));
    public static final ImageIcon HISTORY_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/history.png"));
    public static final ImageIcon FOLDER_UP_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_up.png"));
    public static final ImageIcon FOLDER_HOME_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_home.png"));
    public static final ImageIcon FOLDER_NEW_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/folder_new.png"));
    public static final ImageIcon REFRESH_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/refresh.png"));
    public static final ImageIcon REMOVE_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/remove.png"));
    public static final ImageIcon VIEW_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/view.png"));
    public static final ImageIcon VIEW_ICONS_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/icons.png"));
    public static final ImageIcon VIEW_TILES_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/tiles.png"));
    public static final ImageIcon VIEW_TABLE_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/table.png"));
    public static final ImageIcon SETTINGS_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/settings.png"));
    public static final ImageIcon APPROVE_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/approve.png"));
    public static final ImageIcon CANCEL_ICON = new ImageIcon(WebFileChooserPanel.class.getResource("icons/cancel.png"));
    public static final FileNameProvider quotedFileNameProvider = new FileNameProvider(){

        @Override
        public String provide(File object) {
            return "\"" + super.provide(object) + "\"";
        }
    };
    protected boolean showControlButtons;
    protected FileChooserType chooserType;
    protected boolean showHiddenFiles = false;
    protected AbstractFileFilter fileFilter;
    protected List<AbstractFileFilter> availableFilters;
    protected FileChooserViewType viewType = FileChooserViewType.tiles;
    protected boolean multiSelectionEnabled = false;
    protected File currentFolder = null;
    protected int currentHistoryIndex = -1;
    protected List<File> navigationHistory = new ArrayList<File>();
    protected ActionListener approveListener;
    protected ActionListener cancelListener;
    protected List<FileChooserListener> chooserListeners = new ArrayList<FileChooserListener>(1);
    protected WebButton backward;
    protected WebButton forward;
    protected WebButton history;
    protected WebPathField pathField;
    protected PathFieldListener pathFieldListener;
    protected WebButton folderUp;
    protected WebButton folderHome;
    protected WebButton folderNew;
    protected WebButton refresh;
    protected WebButton remove;
    protected WebButton view;
    protected WebFileTree fileTree;
    protected TreeSelectionListener fileTreeListener;
    protected WebScrollPane treeScroll;
    protected WebFileList fileList;
    protected WebScrollPane fileListScroll;
    protected WebFileTable fileTable;
    protected WebScrollPane fileTableScroll;
    protected WebSplitPane centralSplit;
    protected WebFileChooserField selectedFilesViewField;
    protected WebTextField selectedFilesTextField;
    protected WebPanel selectedFilesPanel;
    protected WebPanel controlsPanel;
    protected WebComboBox fileFilters;
    protected WebButton approveButton;
    protected WebButton cancelButton;
    protected DataProvider<Boolean> hotkeysAllowed = new DataProvider<Boolean>(){

        @Override
        public Boolean provide() {
            return !WebFileChooserPanel.this.fileTree.isEditing() && !WebFileChooserPanel.this.fileList.isEditing() && !WebFileChooserPanel.this.fileTable.isEditing() && !WebFileChooserPanel.this.pathField.isEditing() && !WebFileChooserPanel.this.selectedFilesTextField.isFocusOwner();
        }
    };
    protected HiddenFilesFilter hiddenFilesFilter = new HiddenFilesFilter();

    public WebFileChooserPanel() {
        this(FileChooserType.open, false);
    }

    public WebFileChooserPanel(FileChooserType chooserType) {
        this(chooserType, false);
    }

    public WebFileChooserPanel(boolean showControlButtons) {
        this(FileChooserType.open, showControlButtons);
    }

    public WebFileChooserPanel(FileChooserType chooserType, boolean showControlButtons) {
        this.showControlButtons = showControlButtons;
        this.chooserType = chooserType;
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.createNorthContent(), (Object)"North");
        this.add(this.createCenterContent(), (Object)"Center");
        this.add(this.createSouthContent(), (Object)"South");
        this.updateSelectionMode();
        this.updateDirectoryComponentFilters();
        this.setFileFilter(GlobalConstants.ALL_FILES_FILTER);
        this.restoreButtonText();
    }

    protected Component createNorthContent() {
        final WebToolBar toolBar = new WebToolBar(0);
        toolBar.setToolbarStyle(ToolbarStyle.attached);
        toolBar.setSpacing(0);
        toolBar.setFloatable(false);
        toolBar.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                this.updateToolbarStyle();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                this.updateToolbarStyle();
            }

            private void updateToolbarStyle() {
                toolBar.setUndecorated(SwingUtils.isLafDecorated(WebFileChooserPanel.this));
            }
        });
        this.add((Component)toolBar, (Object)"North");
        this.backward = new WebButton(BACKWARD_ICON);
        this.backward.setLanguage("weblaf.filechooser.back", new Object[0]);
        this.backward.addHotkey(this, Hotkey.ALT_LEFT).setHotkeyDisplayWay(TooltipWay.down);
        this.backward.setRolloverDecoratedOnly(true);
        this.backward.setFocusable(false);
        this.backward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebFileChooserPanel.this.hotkeysAllowed.provide().booleanValue()) {
                    WebFileChooserPanel.this.updateHistoryState(WebFileChooserPanel.this.currentHistoryIndex - 1);
                }
            }
        });
        this.forward = new WebButton(FORWARD_ICON);
        this.forward.setLanguage("weblaf.filechooser.forward", new Object[0]);
        this.forward.addHotkey(this, Hotkey.ALT_RIGHT).setHotkeyDisplayWay(TooltipWay.trailing);
        this.forward.setRolloverDecoratedOnly(true);
        this.forward.setFocusable(false);
        this.forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebFileChooserPanel.this.hotkeysAllowed.provide().booleanValue()) {
                    WebFileChooserPanel.this.updateHistoryState(WebFileChooserPanel.this.currentHistoryIndex + 1);
                }
            }
        });
        this.history = new WebButton(HISTORY_ICON);
        this.history.setLanguage("weblaf.filechooser.history", new Object[0]);
        this.history.setRolloverDecoratedOnly(true);
        this.history.setFocusable(false);
        this.history.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final WebPopupMenu historyPopup = new WebPopupMenu();
                final WebList historyList = new WebList(WebFileChooserPanel.this.navigationHistory);
                historyList.setOpaque(false);
                historyList.setVisibleRowCount(Math.min(10, WebFileChooserPanel.this.navigationHistory.size()));
                historyList.setRolloverSelectionEnabled(true);
                historyList.setCellRenderer(new WebComboBoxCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        WebComboBoxElement renderer = (WebComboBoxElement)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                        File file = (File)value;
                        if (file == null) {
                            renderer.setIcon(FileUtils.getMyComputerIcon());
                            renderer.setText(LanguageManager.get("weblaf.filechooser.root"));
                        } else {
                            renderer.setIcon(FileUtils.getFileIcon(file));
                            renderer.setText(TextUtils.shortenText(FileUtils.getDisplayFileName(file), 40, true));
                        }
                        renderer.setBoldFont(index == WebFileChooserPanel.this.currentHistoryIndex);
                        return renderer;
                    }
                });
                historyList.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        WebFileChooserPanel.this.updateHistoryState(historyList.getSelectedIndex());
                        historyPopup.setVisible(false);
                    }
                });
                WebScrollPane scrollPane = new WebScrollPane((Component)historyList, false, false);
                scrollPane.setOpaque(false);
                scrollPane.getViewport().setOpaque(false);
                scrollPane.setShadeWidth(0);
                WebScrollBar vsb = scrollPane.getWebVerticalScrollBar();
                vsb.setMargin(WebComboBoxStyle.scrollBarMargin);
                vsb.setPaintButtons(WebComboBoxStyle.scrollBarButtonsVisible);
                vsb.setPaintTrack(WebComboBoxStyle.scrollBarTrackVisible);
                LafUtils.setScrollBarStyleId(scrollPane, "combo-box");
                historyPopup.add(scrollPane);
                historyPopup.showBelowMiddle(WebFileChooserPanel.this.history);
                historyList.setSelectedIndex(WebFileChooserPanel.this.currentHistoryIndex);
                historyList.scrollToCell(WebFileChooserPanel.this.currentHistoryIndex);
            }
        });
        this.pathField = new WebPathField();
        this.pathFieldListener = new PathFieldListener(){

            @Override
            public void directoryChanged(File newDirectory) {
                WebFileChooserPanel.this.updateCurrentFolder(newDirectory, UpdateSource.path);
            }
        };
        this.pathField.addPathFieldListener(this.pathFieldListener);
        this.folderUp = new WebButton(FOLDER_UP_ICON);
        this.folderUp.setLanguage("weblaf.filechooser.folderup", new Object[0]);
        this.folderUp.addHotkey(this, Hotkey.ALT_UP).setHotkeyDisplayWay(TooltipWay.down);
        this.folderUp.setRolloverDecoratedOnly(true);
        this.folderUp.setFocusable(false);
        this.folderUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebFileChooserPanel.this.hotkeysAllowed.provide().booleanValue() && WebFileChooserPanel.this.currentFolder != null) {
                    WebFileChooserPanel.this.updateCurrentFolder(WebFileChooserPanel.this.currentFolder.getParentFile(), UpdateSource.toolbar);
                }
            }
        });
        this.folderHome = new WebButton(FOLDER_HOME_ICON);
        this.folderHome.setLanguage("weblaf.filechooser.home", new Object[0]);
        this.folderHome.addHotkey(this, Hotkey.ALT_HOME).setHotkeyDisplayWay(TooltipWay.down);
        this.folderHome.setRolloverDecoratedOnly(true);
        this.folderHome.setFocusable(false);
        this.folderHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebFileChooserPanel.this.hotkeysAllowed.provide().booleanValue()) {
                    WebFileChooserPanel.this.updateCurrentFolder(FileUtils.getUserHome(), UpdateSource.toolbar);
                }
            }
        });
        this.refresh = new WebButton(REFRESH_ICON);
        this.refresh.setLanguage("weblaf.filechooser.refresh", new Object[0]);
        this.refresh.addHotkey(this, Hotkey.F5).setHotkeyDisplayWay(TooltipWay.down);
        this.refresh.setRolloverDecoratedOnly(true);
        this.refresh.setFocusable(false);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebFileChooserPanel.this.hotkeysAllowed.provide().booleanValue()) {
                    WebFileChooserPanel.this.reloadCurrentFolder();
                }
            }
        });
        this.folderNew = new WebButton(FOLDER_NEW_ICON);
        this.folderNew.setLanguage("weblaf.filechooser.newfolder", new Object[0]);
        this.folderNew.addHotkey(this, Hotkey.CTRL_N).setHotkeyDisplayWay(TooltipWay.down);
        this.folderNew.setRolloverDecoratedOnly(true);
        this.folderNew.setFocusable(false);
        this.folderNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebFileChooserPanel.this.hotkeysAllowed.provide().booleanValue() && WebFileChooserPanel.this.currentFolder != null) {
                    String defaultName = LanguageManager.get("weblaf.filechooser.newfolder.name");
                    String freeName = FileUtils.getAvailableName(WebFileChooserPanel.this.currentFolder, defaultName);
                    File file = new File(WebFileChooserPanel.this.currentFolder, freeName);
                    if (file.mkdir()) {
                        WebFileChooserPanel.this.reloadCurrentFolder();
                        WebFileChooserPanel.this.setSelectedFile(file);
                        WebFileChooserPanel.this.editSelectedFileName();
                    } else {
                        String message = LanguageManager.get("weblaf.filechooser.newfolder.error.text");
                        String title = LanguageManager.get("weblaf.filechooser.newfolder.error.title");
                        WebOptionPane.showMessageDialog(WebFileChooserPanel.this, message, title, 0);
                    }
                }
            }
        });
        this.remove = new WebButton(REMOVE_ICON);
        this.remove.setLanguage("weblaf.filechooser.delete", new Object[0]);
        this.remove.addHotkey(this, Hotkey.DELETE).setHotkeyDisplayWay(TooltipWay.down);
        this.remove.setRolloverDecoratedOnly(true);
        this.remove.setEnabled(false);
        this.remove.setFocusable(false);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebFileChooserPanel.this.hotkeysAllowed.provide().booleanValue()) {
                    WebFileChooserPanel.this.deleteSelectedFiles();
                }
            }
        });
        this.view = new WebButton(VIEW_ICON);
        this.view.setLanguage("weblaf.filechooser.view", new Object[0]);
        this.view.setRolloverDecoratedOnly(true);
        this.view.setFocusable(false);
        this.view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPopupMenu viewChoose = new WebPopupMenu();
                WebRadioButtonMenuItem icons = new WebRadioButtonMenuItem(VIEW_ICONS_ICON);
                icons.setLanguage("weblaf.filechooser.view.icons", new Object[0]);
                icons.setSelected(WebFileChooserPanel.this.getViewType().equals((Object)FileChooserViewType.icons));
                icons.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebFileChooserPanel.this.setViewType(FileChooserViewType.icons);
                    }
                });
                viewChoose.add(icons);
                WebRadioButtonMenuItem tiles = new WebRadioButtonMenuItem(VIEW_TILES_ICON);
                tiles.setLanguage("weblaf.filechooser.view.tiles", new Object[0]);
                tiles.setSelected(WebFileChooserPanel.this.getViewType().equals((Object)FileChooserViewType.tiles));
                tiles.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebFileChooserPanel.this.setViewType(FileChooserViewType.tiles);
                    }
                });
                viewChoose.add(tiles);
                WebRadioButtonMenuItem table = new WebRadioButtonMenuItem(VIEW_TABLE_ICON);
                table.setLanguage("weblaf.filechooser.view.table", new Object[0]);
                table.setSelected(WebFileChooserPanel.this.getViewType().equals((Object)FileChooserViewType.table));
                table.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WebFileChooserPanel.this.setViewType(FileChooserViewType.table);
                    }
                });
                viewChoose.add(table);
                ButtonGroup viewGroup = new ButtonGroup();
                viewGroup.add(icons);
                viewGroup.add(tiles);
                viewGroup.add(table);
                viewChoose.showBelowMiddle(WebFileChooserPanel.this.view);
            }
        });
        toolBar.add((Component)this.backward);
        toolBar.add((Component)this.forward);
        toolBar.add((Component)this.history);
        toolBar.addFill(this.pathField);
        toolBar.addToEnd(this.folderUp);
        toolBar.addToEnd(this.folderHome);
        toolBar.addToEnd(this.refresh);
        toolBar.addSeparatorToEnd();
        toolBar.addToEnd(this.folderNew);
        toolBar.addToEnd(this.remove);
        toolBar.addSeparatorToEnd();
        toolBar.addToEnd(this.view);
        return toolBar;
    }

    protected void updateHistoryState(int historyIndex) {
        if (historyIndex >= 0 && historyIndex < this.navigationHistory.size()) {
            this.currentHistoryIndex = historyIndex;
            this.updateCurrentFolder(this.navigationHistory.get(historyIndex), UpdateSource.history);
        }
    }

    protected Component createCenterContent() {
        this.createFileTree();
        this.createFileList();
        this.createFileTable();
        this.centralSplit = new WebSplitPane(1);
        this.centralSplit.setOneTouchExpandable(true);
        this.centralSplit.setLeftComponent(this.treeScroll);
        this.centralSplit.setRightComponent(this.fileListScroll);
        this.centralSplit.setDividerLocation(160);
        this.centralSplit.setMargin(4, 4, 4, 4);
        return this.centralSplit;
    }

    protected void createFileTree() {
        this.fileTree = new WebFileTree();
        this.fileTree.setAutoExpandSelectedNode(true);
        this.fileTree.setSelectionMode(1);
        this.fileTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (WebFileChooserPanel.this.fileTree.getSelectionCount() > 0) {
                    WebFileChooserPanel.this.updateCurrentFolder(WebFileChooserPanel.this.fileTree.getSelectedFile(), UpdateSource.tree);
                }
            }
        };
        this.fileTree.addTreeSelectionListener(this.fileTreeListener);
        this.treeScroll = new WebScrollPane(this.fileTree, true);
        this.treeScroll.setPreferredSize(new Dimension(160, 1));
    }

    protected void createFileList() {
        this.fileList = new WebFileList();
        this.fileList.setGenerateThumbnails(true);
        this.fileList.setDropMode(DropMode.ON);
        this.fileList.setEditable(true);
        this.fileList.setPreferredColumnCount(3);
        this.fileList.setPreferredRowCount(5);
        this.fileList.setTransferHandler(new FilesLocateDropHandler(UpdateSource.list));
        this.fileList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "openFolder");
        this.fileList.getActionMap().put("openFolder", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return WebFileChooserPanel.this.fileList.getSelectedIndex() != -1;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = WebFileChooserPanel.this.fileList.getSelectedFile();
                if (file.isDirectory()) {
                    WebFileChooserPanel.this.updateCurrentFolder(file, UpdateSource.list);
                }
            }
        });
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0 && WebFileChooserPanel.this.fileList.getSelectedIndex() != -1) {
                    File file = WebFileChooserPanel.this.fileList.getSelectedFile();
                    if (file.isDirectory()) {
                        WebFileChooserPanel.this.updateCurrentFolder(file, UpdateSource.list);
                    } else {
                        WebFileChooserPanel.this.fireApproveAction(new ActionEvent(WebFileChooserPanel.this.fileList, e.getID(), "Files selected", e.getWhen(), e.getModifiers()));
                    }
                }
            }
        });
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WebFileChooserPanel.this.updateSelectedFilesField();
            }
        });
        this.fileList.addListEditListener(new ListEditAdapter(){

            @Override
            public void editFinished(int index, Object oldValue, Object newValue) {
                File file = ((FileElement)newValue).getFile();
                WebFileChooserPanel.this.reloadCurrentFolder();
                WebFileChooserPanel.this.fileList.setSelectedFile(file);
            }
        });
        this.fileListScroll = this.fileList.getScrollView();
        this.fileListScroll.setHorizontalScrollBarPolicy(31);
        this.fileListScroll.setVerticalScrollBarPolicy(22);
    }

    protected void createFileTable() {
        this.fileTable = new WebFileTable();
        this.fileTable.setOpaque(false);
        this.fileTable.setTransferHandler(new FilesLocateDropHandler(UpdateSource.table));
        this.fileTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "openFolder");
        this.fileTable.getActionMap().put("openFolder", new AbstractAction(){

            @Override
            public boolean isEnabled() {
                return WebFileChooserPanel.this.fileTable.getSelectedRow() != -1;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = WebFileChooserPanel.this.fileTable.getSelectedFile();
                if (file.isDirectory()) {
                    WebFileChooserPanel.this.updateCurrentFolder(file, UpdateSource.table);
                }
            }
        });
        this.fileTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0 && WebFileChooserPanel.this.fileTable.getSelectedRow() != -1) {
                    File file = WebFileChooserPanel.this.fileTable.getSelectedFile();
                    if (file.isDirectory()) {
                        WebFileChooserPanel.this.updateCurrentFolder(file, UpdateSource.table);
                    } else {
                        WebFileChooserPanel.this.fireApproveAction(new ActionEvent(WebFileChooserPanel.this.fileTable, e.getID(), "Files selected", e.getWhen(), e.getModifiers()));
                    }
                }
            }
        });
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                WebFileChooserPanel.this.updateSelectedFilesField();
            }
        });
        this.fileTable.getDefaultEditor(File.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                File file = WebFileChooserPanel.this.fileTable.getSelectedFile();
                WebFileChooserPanel.this.reloadCurrentFolder();
                WebFileChooserPanel.this.fileTable.setSelectedFile(file);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.fileTableScroll = new WebScrollPane(this.fileTable, true);
        this.fileTableScroll.getViewport().setOpaque(true);
        this.fileTableScroll.getViewport().setBackground(Color.WHITE);
        this.fileTableScroll.setHorizontalScrollBarPolicy(31);
        this.fileTableScroll.setVerticalScrollBarPolicy(22);
    }

    protected Component createSouthContent() {
        final WebPanel southPanel = new WebPanel();
        southPanel.setLayout(new ToolbarLayout(4));
        southPanel.setOpaque(false);
        southPanel.setMargin(0, 4, 4, 4);
        this.add((Component)southPanel, (Object)"South");
        WebLabel selectedFilesLabel = new WebLabel();
        selectedFilesLabel.setLanguage("weblaf.filechooser.files.selected", new Object[0]);
        selectedFilesLabel.setDrawShade(true);
        selectedFilesLabel.setMargin(0, 4, 0, 0);
        southPanel.add((Component)selectedFilesLabel);
        this.selectedFilesViewField = new WebFileChooserField(false);
        this.selectedFilesViewField.setShowRemoveButton(false);
        this.selectedFilesViewField.setShowFileShortName(true);
        this.selectedFilesViewField.setFilesDropEnabled(false);
        this.selectedFilesTextField = new WebTextField(0, true);
        this.selectedFilesTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                WebFileChooserPanel.this.updateApproveButtonState(null);
            }
        });
        this.selectedFilesTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.approveButton.doClick(0);
            }
        });
        this.selectedFilesPanel = new WebPanel(this.chooserType == FileChooserType.save ? this.selectedFilesTextField : this.selectedFilesViewField);
        southPanel.add((Component)this.selectedFilesPanel, (Object)"FILL");
        this.fileFilters = new WebComboBox();
        this.fileFilters.setRenderer(new DefaultFileFilterListCellRenderer());
        this.fileFilters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.setActiveFileFilter((AbstractFileFilter)WebFileChooserPanel.this.fileFilters.getSelectedItem(), false);
            }
        });
        this.approveButton = new WebButton("", APPROVE_ICON);
        this.approveButton.setRolloverShine(StyleConstants.highlightControlButtons);
        this.approveButton.setShineColor(StyleConstants.greenHighlight);
        this.approveButton.putClientProperty("fill.component.cell", true);
        this.approveButton.setEnabled(false);
        this.approveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.fireApproveAction(e);
            }
        });
        this.cancelButton = new WebButton("", CANCEL_ICON);
        this.cancelButton.setLanguage("weblaf.filechooser.cancel", new Object[0]);
        this.cancelButton.setRolloverShine(StyleConstants.highlightControlButtons);
        this.cancelButton.setShineColor(StyleConstants.redHighlight);
        this.cancelButton.putClientProperty("fill.component.cell", true);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserPanel.this.fireCancelAction(e);
            }
        });
        this.controlsPanel = new WebPanel();
        this.updateControls();
        southPanel.add((Component)this.controlsPanel, (Object)"END");
        SwingUtils.equalizeComponentsSize(this.approveButton, this.cancelButton);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                WebFileChooserPanel.this.approveButton.setPreferredSize(null);
                WebFileChooserPanel.this.cancelButton.setPreferredSize(null);
                SwingUtils.equalizeComponentsSize(WebFileChooserPanel.this.approveButton, WebFileChooserPanel.this.cancelButton);
                southPanel.revalidate();
            }
        };
        this.approveButton.addPropertyChangeListener("text", pcl);
        this.cancelButton.addPropertyChangeListener("text", pcl);
        return southPanel;
    }

    public FileChooserViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(FileChooserViewType viewType) {
        boolean viewChanged = viewType.getComponentIndex() != this.viewType.getComponentIndex();
        this.viewType = viewType;
        switch (viewType) {
            case icons: {
                this.fileList.setPreferredColumnCount(7);
                this.fileList.setPreferredRowCount(4);
                this.fileList.setFileListViewType(FileListViewType.icons);
                this.centralSplit.setRightComponent(this.fileListScroll);
                if (!viewChanged) break;
                this.fileList.setSelectedFiles(this.fileTable.getSelectedFiles());
                this.fileList.requestFocusInWindow();
                break;
            }
            case tiles: {
                this.fileList.setPreferredColumnCount(3);
                this.fileList.setPreferredRowCount(6);
                this.fileList.setFileListViewType(FileListViewType.tiles);
                this.centralSplit.setRightComponent(this.fileListScroll);
                if (!viewChanged) break;
                this.fileList.setSelectedFiles(this.fileTable.getSelectedFiles());
                this.fileList.requestFocusInWindow();
                break;
            }
            case table: {
                this.centralSplit.setRightComponent(this.fileTableScroll);
                if (!viewChanged) break;
                this.fileTable.setSelectedFiles(this.fileList.getSelectedFiles());
                this.fileTable.requestFocusInWindow();
            }
        }
        this.centralSplit.revalidate();
    }

    public void setCurrentFolder(File folder) {
        this.updateCurrentFolder(folder, UpdateSource.other);
    }

    protected void updateCurrentFolder(File file, UpdateSource updateSource) {
        File toSelect = null;
        if (file != null && !FileUtils.isDirectory(file)) {
            toSelect = file;
            file = file.getParentFile();
        }
        if (file == null && !SystemUtils.isWindows()) {
            file = FileUtils.getDiskRoots()[0];
        }
        if (FileUtils.equals(this.currentFolder, file)) {
            if (toSelect != null) {
                this.setSelectedFile(toSelect);
            }
            this.updateControlsState();
            return;
        }
        if (updateSource != UpdateSource.history) {
            if (this.currentHistoryIndex > -1) {
                while (this.currentHistoryIndex + 1 < this.navigationHistory.size()) {
                    this.navigationHistory.remove(this.currentHistoryIndex + 1);
                }
            }
            this.navigationHistory.add(file);
            this.currentHistoryIndex = this.navigationHistory.size() - 1;
        }
        if (updateSource != UpdateSource.path) {
            this.updatePath(file);
        }
        if (updateSource != UpdateSource.tree) {
            this.updateTree(file);
        }
        this.updateList(file);
        this.updateTable(file);
        this.currentFolder = file;
        this.updateControlsState();
        if (toSelect != null) {
            this.setSelectedFile(toSelect);
        }
        this.fireDirectoryChanged(this.currentFolder);
    }

    protected void updateControlsState() {
        this.backward.setEnabled(this.currentHistoryIndex > 0);
        this.forward.setEnabled(this.currentHistoryIndex + 1 < this.navigationHistory.size());
        this.folderNew.setEnabled(this.currentFolder != null);
        this.folderUp.setEnabled(SystemUtils.isWindows() ? this.currentFolder != null : this.currentFolder != null && this.currentFolder.getParentFile() != null);
    }

    public List<File> getSelectedFiles() {
        if (this.chooserType == FileChooserType.save) {
            return Arrays.asList(new File(this.currentFolder, this.selectedFilesTextField.getText()));
        }
        List<File> files = this.getAllSelectedFiles();
        return this.getFilteredSelectedFiles(files);
    }

    protected List<File> getFilteredSelectedFiles(List<File> allFiles) {
        return FileUtils.filterFiles(allFiles, this.fileFilter);
    }

    protected List<File> getAllSelectedFiles() {
        List<File> files = this.viewType.getComponentIndex() == 0 ? this.fileList.getSelectedFiles() : (this.viewType.getComponentIndex() == 1 ? this.fileTable.getSelectedFiles() : new ArrayList<File>(0));
        return files;
    }

    public void setSelectedFile(File file) {
        if (this.viewType.getComponentIndex() == 0) {
            this.fileList.setSelectedFile(file);
        }
        if (this.viewType.getComponentIndex() == 1) {
            this.fileTable.setSelectedFile(file);
        }
    }

    public void setSelectedFiles(File[] files) {
        this.setSelectedFiles(CollectionUtils.toList(files));
    }

    public void setSelectedFiles(Collection<File> files) {
        if (this.viewType.getComponentIndex() == 0) {
            this.fileList.setSelectedFiles(files);
        }
        if (this.viewType.getComponentIndex() == 1) {
            this.fileTable.setSelectedFiles(files);
        }
    }

    protected void updateSelectedFilesField() {
        List<File> allFiles = this.getAllSelectedFiles();
        List<File> files = this.getFilteredSelectedFiles(allFiles);
        this.folderNew.setEnabled(this.currentFolder != null);
        this.remove.setEnabled(this.currentFolder != null && allFiles.size() > 0);
        if (this.chooserType == FileChooserType.save) {
            File file;
            if (files.size() > 0 && FileUtils.isFile(file = files.get(0))) {
                this.selectedFilesViewField.setSelectedFile(file);
                this.selectedFilesTextField.setText(file.getName());
            }
        } else {
            this.selectedFilesViewField.setSelectedFiles(files);
            this.selectedFilesTextField.setText(TextUtils.listToString(files, ", ", quotedFileNameProvider));
        }
        this.updateApproveButtonState(files);
        this.fireFileSelectionChanged(files);
    }

    protected void updateApproveButtonState(List<File> files) {
        if (this.chooserType == FileChooserType.save) {
            this.approveButton.setEnabled(!this.selectedFilesTextField.getText().trim().equals(""));
        } else {
            if (files == null) {
                files = this.getFilteredSelectedFiles(this.getAllSelectedFiles());
            }
            this.approveButton.setEnabled(files.size() > 0);
        }
    }

    protected void updateSelectedFilesFieldPanel() {
        this.selectedFilesPanel.removeAll();
        this.selectedFilesPanel.add((Component)(this.chooserType == FileChooserType.save ? this.selectedFilesTextField : this.selectedFilesViewField));
        this.selectedFilesPanel.revalidate();
    }

    protected void updatePath(File file) {
        this.pathField.removePathFieldListener(this.pathFieldListener);
        this.pathField.setSelectedPath(file);
        this.pathField.addPathFieldListener(this.pathFieldListener);
    }

    protected void updateTree(final File file) {
        if (file != null) {
            this.fileTree.expandToFile(file, false, false, new Runnable(){

                @Override
                public void run() {
                    WebFileChooserPanel.this.fileTree.removeTreeSelectionListener(WebFileChooserPanel.this.fileTreeListener);
                    WebFileChooserPanel.this.fileTree.setSelectedNode(WebFileChooserPanel.this.fileTree.getNode(file));
                    WebFileChooserPanel.this.fileTree.addTreeSelectionListener(WebFileChooserPanel.this.fileTreeListener);
                }
            });
        } else {
            this.fileTree.clearSelection();
            this.fileTree.scrollToStart();
        }
    }

    protected void updateList(File file) {
        this.fileList.setDisplayedDirectory(file);
    }

    protected void updateTable(File file) {
        this.fileTable.setDisplayedDirectory(file);
    }

    protected void updateFiltersComboBox() {
        this.fileFilters.setModel(new DefaultComboBoxModel<Object>(this.availableFilters.toArray()));
    }

    public void setActiveFileFilter(AbstractFileFilter fileFilter) {
        this.setActiveFileFilter(fileFilter, true);
    }

    protected void setActiveFileFilter(AbstractFileFilter fileFilter, boolean select) {
        if (!this.availableFilters.contains(fileFilter)) {
            fileFilter = this.availableFilters.get(0);
        }
        this.fileFilter = fileFilter;
        if (select) {
            this.fileFilters.setSelectedItem(fileFilter);
        }
        this.updateFileComponentFilters();
    }

    protected void updateFileComponentFilters() {
        this.fileList.setFileFilter(this.applyHiddenFilesFilter(this.applyOrDirectoriesFilter(this.fileFilter)));
        this.fileTable.setFileFilter(this.applyHiddenFilesFilter(this.applyOrDirectoriesFilter(this.fileFilter)));
    }

    protected void updateDirectoryComponentFilters() {
        this.pathField.setFileFilter(this.applyHiddenFilesFilter(GlobalConstants.DIRECTORIES_FILTER));
        this.fileTree.setFileFilter(this.applyHiddenFilesFilter(GlobalConstants.DIRECTORIES_FILTER));
    }

    protected GroupedFileFilter applyOrDirectoriesFilter(AbstractFileFilter fileFilter) {
        return new GroupedFileFilter(FilterGroupType.OR, fileFilter, GlobalConstants.DIRECTORIES_FILTER);
    }

    protected GroupedFileFilter applyHiddenFilesFilter(AbstractFileFilter fileFilter) {
        return new GroupedFileFilter(FilterGroupType.AND, fileFilter, this.hiddenFilesFilter);
    }

    public void reloadCurrentFolder() {
        if (this.currentFolder != null) {
            FileUtils.clearFilesCaches(this.currentFolder.listFiles());
        }
        this.pathField.updatePath();
        this.fileTree.reloadChilds(this.currentFolder);
        this.fileList.reloadFiles();
        this.fileTable.reloadFiles();
    }

    public void editSelectedFileName() {
        if (this.viewType.getComponentIndex() == 0) {
            this.fileList.editSelectedCell();
        }
        if (this.viewType.getComponentIndex() == 1) {
            this.fileTable.editSelectedFileName();
        }
    }

    public void deleteSelectedFiles() {
        List<File> files = this.getAllSelectedFiles();
        if (files.isEmpty()) {
            return;
        }
        WebPanel all = new WebPanel(new BorderLayout(0, 5));
        all.add((Component)new WebLabel(LanguageManager.get("weblaf.filechooser.delete.confirm.text")), (Object)"North");
        WebPanel deleteFilesPanel = new WebPanel(new VerticalFlowLayout(0, 0, 5, true, false));
        deleteFilesPanel.setMargin(3);
        deleteFilesPanel.setBackground(Color.WHITE);
        for (File file : files) {
            deleteFilesPanel.add((Component)new WebLabel(file.getName(), (Icon)FileUtils.getFileIcon(file), 2));
        }
        WebScrollPane scroll = new WebScrollPane(deleteFilesPanel){

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                JScrollBar vsb = this.getVerticalScrollBar();
                if (vsb != null && vsb.isShowing()) {
                    ps.width += vsb.getPreferredSize().width;
                }
                ps.height = Math.min(ps.height, 100);
                return ps;
            }
        };
        all.add((Component)scroll, (Object)"Center");
        String title = LanguageManager.get("weblaf.filechooser.delete.confirm.title");
        int confirm = WebOptionPane.showConfirmDialog(this, all, title, 0, 3);
        if (confirm == 0) {
            FileUtils.deleteFiles(files);
            this.reloadCurrentFolder();
        }
    }

    public ActionListener getApproveListener() {
        return this.approveListener;
    }

    public void setApproveListener(ActionListener approveListener) {
        this.approveListener = approveListener;
    }

    public ActionListener getCancelListener() {
        return this.cancelListener;
    }

    public void setCancelListener(ActionListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    protected void fireApproveAction(ActionEvent e) {
        if (this.approveListener != null) {
            this.approveListener.actionPerformed(e);
        }
    }

    protected void fireCancelAction(ActionEvent e) {
        if (this.cancelListener != null) {
            this.cancelListener.actionPerformed(e);
        }
    }

    public List<AbstractFileFilter> getAvailableFilters() {
        return this.availableFilters;
    }

    public AbstractFileFilter getActiveFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.setFileFilter(FileUtils.transformFileFilter(fileFilter));
    }

    public void setFileFilter(javax.swing.filechooser.FileFilter fileFilter) {
        this.setFileFilter(FileUtils.transformFileFilter(fileFilter));
    }

    public void setFileFilter(AbstractFileFilter fileFilter) {
        this.availableFilters = Arrays.asList(fileFilter);
        this.updateFiltersComboBox();
        this.setActiveFileFilter(fileFilter);
    }

    public void setFileFilters(FileFilter[] fileFilters) {
        this.setFileFilters(0, fileFilters);
    }

    public void setFileFilters(int index, FileFilter[] fileFilters) {
        this.availableFilters = new ArrayList<AbstractFileFilter>(fileFilters.length);
        for (FileFilter fileFilter : fileFilters) {
            this.availableFilters.add(FileUtils.transformFileFilter(fileFilter));
        }
        this.updateFiltersComboBox();
        this.setActiveFileFilter(this.availableFilters.get(index));
    }

    public void setFileFilters(javax.swing.filechooser.FileFilter[] fileFilters) {
        this.setFileFilters(0, fileFilters);
    }

    public void setFileFilters(int index, javax.swing.filechooser.FileFilter[] fileFilters) {
        this.availableFilters = new ArrayList<AbstractFileFilter>(fileFilters.length);
        for (javax.swing.filechooser.FileFilter filtfileFilter : fileFilters) {
            this.availableFilters.add(FileUtils.transformFileFilter(filtfileFilter));
        }
        this.updateFiltersComboBox();
        this.setActiveFileFilter(this.availableFilters.get(index));
    }

    public void setFileFilters(AbstractFileFilter[] fileFilters) {
        this.setFileFilters(0, fileFilters);
    }

    public void setFileFilters(int index, AbstractFileFilter[] fileFilters) {
        this.availableFilters = Arrays.asList(fileFilters);
        this.updateFiltersComboBox();
        this.setActiveFileFilter(this.availableFilters.get(index));
    }

    public void setFileFilters(List<AbstractFileFilter> fileFilters) {
        this.setFileFilters(0, fileFilters);
    }

    public void setFileFilters(int index, List<AbstractFileFilter> fileFilters) {
        this.availableFilters = CollectionUtils.copy(fileFilters);
        this.updateFiltersComboBox();
        this.setActiveFileFilter(this.availableFilters.get(index));
    }

    public boolean isShowControlButtons() {
        return this.showControlButtons;
    }

    public void setShowControlButtons(boolean showControlButtons) {
        this.showControlButtons = showControlButtons;
        this.updateControls();
    }

    protected void updateControls() {
        this.controlsPanel.removeAll();
        this.controlsPanel.add((Component)(this.showControlButtons ? new GroupPanel(4, this.fileFilters, this.approveButton, this.cancelButton) : this.fileFilters));
    }

    public String getApproveButtonText() {
        return this.approveButton.getText();
    }

    public void restoreButtonText() {
        this.setApproveButtonText((String)null);
    }

    public void setApproveButtonText(String text) {
        if (text == null) {
            this.setApproveButtonText(this.chooserType == FileChooserType.save ? FileApproveText.save : (this.chooserType == FileChooserType.open ? FileApproveText.open : FileApproveText.choose));
        } else {
            this.approveButton.removeLanguage();
            this.approveButton.setText(text);
        }
    }

    public void setApproveButtonText(FileApproveText approveText) {
        this.setApproveButtonLanguage(approveText.getLanguageKey());
    }

    public void setApproveButtonLanguage(String key) {
        this.approveButton.setLanguage(key, new Object[0]);
    }

    public FileChooserType getChooserType() {
        return this.chooserType;
    }

    public void setChooserType(FileChooserType chooserType) {
        this.chooserType = chooserType;
        this.updateSelectionMode();
        this.updateSelectedFilesFieldPanel();
        this.updateSelectedFilesField();
        this.restoreButtonText();
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
        this.updateDirectoryComponentFilters();
        this.updateFileComponentFilters();
    }

    public void addFileChooserListener(FileChooserListener listener) {
        this.chooserListeners.add(listener);
    }

    public void removeFileChooserListener(FileChooserListener listener) {
        this.chooserListeners.remove(listener);
    }

    protected void fireDirectoryChanged(File newDirectory) {
        for (FileChooserListener listener : CollectionUtils.copy(this.chooserListeners)) {
            listener.directoryChanged(newDirectory);
        }
    }

    protected void fireFileSelectionChanged(List<File> selectedFiles) {
        for (FileChooserListener listener : CollectionUtils.copy(this.chooserListeners)) {
            listener.selectionChanged(selectedFiles);
        }
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
        this.updateSelectionMode();
    }

    protected void updateSelectionMode() {
        boolean ms = this.multiSelectionEnabled && this.chooserType != FileChooserType.save;
        int mode = ms ? 2 : 0;
        this.fileList.setSelectionMode(mode);
        this.fileTable.setSelectionMode(mode);
        this.selectedFilesViewField.setMultiSelectionEnabled(ms);
    }

    public boolean isGenerateThumbnails() {
        return this.fileList.isGenerateThumbnails();
    }

    public void setGenerateThumbnails(boolean generate) {
        this.fileList.setGenerateThumbnails(generate);
    }

    protected class HiddenFilesFilter
    extends NonHiddenFilter {
        protected HiddenFilesFilter() {
        }

        @Override
        public ImageIcon getIcon() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public boolean accept(File file) {
            return WebFileChooserPanel.this.showHiddenFiles || !file.isHidden();
        }
    }

    protected class FilesLocateDropHandler
    extends FileDragAndDropHandler {
        protected UpdateSource updateSource;

        public FilesLocateDropHandler(UpdateSource updateSource) {
            this.updateSource = updateSource;
        }

        @Override
        public boolean filesDropped(List<File> files) {
            if (files.size() > 0) {
                File file = files.get(0);
                if (files.size() == 1 && FileUtils.isDirectory(file)) {
                    WebFileChooserPanel.this.updateCurrentFolder(file, this.updateSource);
                } else {
                    WebFileChooserPanel.this.updateCurrentFolder(file.getParentFile(), this.updateSource);
                    WebFileChooserPanel.this.setSelectedFiles(files);
                }
                return true;
            }
            return false;
        }
    }

    protected static enum UpdateSource {
        path,
        tree,
        list,
        table,
        toolbar,
        history,
        other;

    }
}

