/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.checkbox;

import com.alee.extended.checkbox.CheckState;
import com.alee.laf.StyleConstants;
import com.alee.laf.checkbox.CheckIcon;
import com.alee.laf.checkbox.SimpleCheckIcon;
import com.alee.laf.checkbox.WebCheckBoxStyle;
import com.alee.laf.list.WebListElement;
import com.alee.utils.ColorUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicCheckBoxUI;
import javax.swing.tree.TreeCellRenderer;

public class WebCheckBoxUI
extends BasicCheckBoxUI
implements ShapeProvider {
    public static final int MAX_DARKNESS = 5;
    public static final int UPDATE_DELAY = 40;
    protected static final float[] fractions = new float[]{0.0f, 1.0f};
    protected Color borderColor = WebCheckBoxStyle.borderColor;
    protected Color darkBorderColor = WebCheckBoxStyle.darkBorderColor;
    protected Color disabledBorderColor = WebCheckBoxStyle.disabledBorderColor;
    protected Color topBgColor = WebCheckBoxStyle.topBgColor;
    protected Color bottomBgColor = WebCheckBoxStyle.bottomBgColor;
    protected Color topSelectedBgColor = WebCheckBoxStyle.topSelectedBgColor;
    protected Color bottomSelectedBgColor = WebCheckBoxStyle.bottomSelectedBgColor;
    protected int round = WebCheckBoxStyle.round;
    protected int shadeWidth = WebCheckBoxStyle.shadeWidth;
    protected Insets margin = WebCheckBoxStyle.margin;
    protected boolean animated = WebCheckBoxStyle.animated;
    protected boolean rolloverDarkBorderOnly = WebCheckBoxStyle.rolloverDarkBorderOnly;
    protected Stroke borderStroke = WebCheckBoxStyle.borderStroke;
    protected int iconWidth = WebCheckBoxStyle.iconWidth;
    protected int iconHeight = WebCheckBoxStyle.iconHeight;
    protected int bgDarkness = 0;
    protected boolean rollover;
    protected WebTimer bgTimer;
    protected CheckIcon checkIcon;
    protected boolean checking;
    protected WebTimer checkTimer;
    protected Rectangle iconRect;
    protected JCheckBox checkBox = null;
    protected PropertyChangeListener enabledStateListener;
    protected PropertyChangeListener modelChangeListener;
    protected MouseAdapter mouseAdapter;
    protected ItemListener itemListener;

    public static ComponentUI createUI(JComponent c) {
        return new WebCheckBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.checkBox = (JCheckBox)c;
        this.checkIcon = this.createCheckStateIcon();
        this.checkIcon.setEnabled(this.checkBox.isEnabled());
        this.checkIcon.setState(this.checkBox.isSelected() ? CheckState.checked : CheckState.unchecked);
        SwingUtils.setOrientation(this.checkBox);
        LookAndFeel.installProperty(this.checkBox, "opaque", Boolean.FALSE);
        this.checkBox.setIcon(this.createIcon());
        this.setAnimated(this.isAnimatedByDefault());
        this.updateBorder();
        this.installEnabledStateListeners();
        this.installRolloverListeners();
        this.installStateChangeListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallEnabledStateListeners();
        this.uninstallRolloverListeners();
        this.uninstallStateChangeListeners();
        this.checkBox.setIcon(null);
        this.checkIcon = null;
        this.checkBox = null;
        super.uninstallUI(c);
    }

    protected CheckIcon createCheckStateIcon() {
        return new SimpleCheckIcon();
    }

    protected void installEnabledStateListeners() {
        this.enabledStateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebCheckBoxUI.this.checkIcon.setEnabled(WebCheckBoxUI.this.checkBox.isEnabled());
            }
        };
        this.checkBox.addPropertyChangeListener("enabled", this.enabledStateListener);
    }

    protected void uninstallEnabledStateListeners() {
        this.checkBox.removePropertyChangeListener("enabled", this.enabledStateListener);
    }

    protected void installRolloverListeners() {
        this.bgTimer = new WebTimer("WebCheckBoxUI.bgUpdater", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebCheckBoxUI.this.rollover && WebCheckBoxUI.this.bgDarkness < 5) {
                    ++WebCheckBoxUI.this.bgDarkness;
                    WebCheckBoxUI.this.checkBox.repaint();
                } else if (!WebCheckBoxUI.this.rollover && WebCheckBoxUI.this.bgDarkness > 0) {
                    --WebCheckBoxUI.this.bgDarkness;
                    WebCheckBoxUI.this.checkBox.repaint();
                } else {
                    WebCheckBoxUI.this.bgTimer.stop();
                }
            }
        });
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WebCheckBoxUI.this.rollover = true;
                if (WebCheckBoxUI.this.isAnimated() && WebCheckBoxUI.this.checkBox.isEnabled()) {
                    WebCheckBoxUI.this.bgTimer.start();
                } else {
                    WebCheckBoxUI.this.bgDarkness = 5;
                    WebCheckBoxUI.this.checkBox.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WebCheckBoxUI.this.rollover = false;
                if (WebCheckBoxUI.this.isAnimated() && WebCheckBoxUI.this.checkBox.isEnabled()) {
                    WebCheckBoxUI.this.bgTimer.start();
                } else {
                    WebCheckBoxUI.this.bgDarkness = 0;
                    WebCheckBoxUI.this.checkBox.repaint();
                }
            }
        };
        this.checkBox.addMouseListener(this.mouseAdapter);
    }

    protected void uninstallRolloverListeners() {
        this.checkBox.removeMouseListener(this.mouseAdapter);
    }

    protected void installStateChangeListeners() {
        this.checkTimer = new WebTimer("WebCheckBoxUI.iconUpdater", 40L, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebCheckBoxUI.this.checkIcon.isTransitionCompleted()) {
                    WebCheckBoxUI.this.checkIcon.finishTransition();
                    WebCheckBoxUI.this.checkTimer.stop();
                } else {
                    WebCheckBoxUI.this.checkIcon.doStep();
                    WebCheckBoxUI.this.checkBox.repaint();
                }
            }
        });
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WebCheckBoxUI.this.performStateChanged();
            }
        };
        this.checkBox.addItemListener(this.itemListener);
        this.modelChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                WebCheckBoxUI.this.performStateChanged();
            }
        };
        this.checkBox.addPropertyChangeListener("model", this.modelChangeListener);
    }

    protected void performStateChanged() {
        if (this.isAnimationAllowed() && this.isAnimated() && this.checkBox.isEnabled()) {
            this.checkIcon.setNextState(this.checkBox.isSelected() ? CheckState.checked : CheckState.unchecked);
            this.checkTimer.start();
        } else {
            this.checkTimer.stop();
            this.checkIcon.setState(this.checkBox.isSelected() ? CheckState.checked : CheckState.unchecked);
            this.checkBox.repaint();
        }
    }

    protected void uninstallStateChangeListeners() {
        this.checkBox.removeItemListener(this.itemListener);
        this.checkBox.removePropertyChangeListener(this.modelChangeListener);
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.checkBox, this.getShadeWidth(), this.getRound());
    }

    protected boolean isAnimatedByDefault() {
        return WebCheckBoxStyle.animated && !ReflectUtils.containsInClassOrSuperclassName(this.checkBox.getClass(), "com.jidesoft.swing.TristateCheckBox");
    }

    protected boolean isAnimationAllowed() {
        Container parent = this.checkBox.getParent();
        if (parent == null) {
            return true;
        }
        Class<?> parentClass = parent.getClass();
        return !ReflectUtils.containsInClassOrSuperclassName(parentClass, "com.jidesoft.swing.CheckBoxList") && !ReflectUtils.containsInClassOrSuperclassName(parentClass, "com.jidesoft.swing.CheckBoxTreeCellRenderer");
    }

    protected void updateBorder() {
        if (SwingUtils.isPreserveBorders(this.checkBox)) {
            return;
        }
        boolean ltr = this.checkBox.getComponentOrientation().isLeftToRight();
        Insets m = new Insets(this.margin.top, ltr ? this.margin.left : this.margin.right, this.margin.bottom, ltr ? this.margin.right : this.margin.left);
        this.checkBox.setBorder(LafUtils.createWebBorder(m));
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public boolean isAnimated() {
        return this.animated && (this.checkBox == null || this.checkBox.getParent() == null || !(this.checkBox.getParent() instanceof WebListElement) && !(this.checkBox.getParent() instanceof TreeCellRenderer));
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isRolloverDarkBorderOnly() {
        return this.rolloverDarkBorderOnly;
    }

    public void setRolloverDarkBorderOnly(boolean rolloverDarkBorderOnly) {
        this.rolloverDarkBorderOnly = rolloverDarkBorderOnly;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getDarkBorderColor() {
        return this.darkBorderColor;
    }

    public void setDarkBorderColor(Color darkBorderColor) {
        this.darkBorderColor = darkBorderColor;
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        this.disabledBorderColor = disabledBorderColor;
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color topBgColor) {
        this.topBgColor = topBgColor;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color bottomBgColor) {
        this.bottomBgColor = bottomBgColor;
    }

    public Color getTopSelectedBgColor() {
        return this.topSelectedBgColor;
    }

    public void setTopSelectedBgColor(Color topSelectedBgColor) {
        this.topSelectedBgColor = topSelectedBgColor;
    }

    public Color getBottomSelectedBgColor() {
        return this.bottomSelectedBgColor;
    }

    public void setBottomSelectedBgColor(Color bottomSelectedBgColor) {
        this.bottomSelectedBgColor = bottomSelectedBgColor;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }

    protected Icon createIcon() {
        return new CheckBoxIcon();
    }

    protected Color[] getBgColors() {
        if (this.checkBox.isEnabled()) {
            float darkness = this.getBgDarkness();
            if (darkness < 1.0f) {
                return new Color[]{ColorUtils.getIntermediateColor(this.topBgColor, this.topSelectedBgColor, darkness), ColorUtils.getIntermediateColor(this.bottomBgColor, this.bottomSelectedBgColor, darkness)};
            }
            return new Color[]{this.topSelectedBgColor, this.bottomSelectedBgColor};
        }
        return new Color[]{this.topBgColor, this.bottomBgColor};
    }

    protected float getBgDarkness() {
        return (float)this.bgDarkness / 5.0f;
    }

    public Rectangle getIconRect() {
        return this.iconRect != null ? new Rectangle(this.iconRect) : new Rectangle();
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        Map hints = SwingUtils.setupTextAntialias(g);
        super.paint(g, c);
        SwingUtils.restoreTextAntialias(g, hints);
    }

    protected void paintIcon(Graphics2D g2d, int x, int y) {
        this.paintIconBackground(g2d, x, y);
        this.paintCheckIcon(g2d, x, y);
    }

    protected void paintIconBackground(Graphics2D g2d, int x, int y) {
        boolean enabled = this.checkBox.isEnabled();
        Rectangle iconRect = new Rectangle(x + this.shadeWidth, y + this.shadeWidth, this.iconWidth - this.shadeWidth * 2 - 1, this.iconHeight - this.shadeWidth * 2 - 1);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(iconRect.x, iconRect.y, iconRect.width, iconRect.height, this.round * 2, this.round * 2);
        if (enabled) {
            Color shadeColor = this.checkBox.isFocusOwner() ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor;
            LafUtils.drawShade(g2d, shape, shadeColor, this.shadeWidth);
        }
        int radius = Math.round((float)Math.sqrt(iconRect.width * iconRect.width / 2));
        int cx = iconRect.x + iconRect.width / 2;
        int cy = iconRect.y + iconRect.height / 2;
        g2d.setPaint(new RadialGradientPaint(cx, (float)cy, radius, fractions, this.getBgColors()));
        g2d.fill(shape);
        Stroke os = LafUtils.setupStroke(g2d, this.borderStroke);
        g2d.setPaint(enabled ? (this.rolloverDarkBorderOnly ? ColorUtils.getIntermediateColor(this.borderColor, this.darkBorderColor, this.getBgDarkness()) : this.darkBorderColor) : this.disabledBorderColor);
        g2d.draw(shape);
        LafUtils.restoreStroke(g2d, os);
    }

    protected void paintCheckIcon(Graphics2D g2d, int x, int y) {
        this.checkIcon.paintIcon(this.checkBox, g2d, x, y, this.iconWidth, this.iconHeight);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = SwingUtils.getFontMetrics(b, g);
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(b.getBackground().brighter());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(b.getBackground().darker());
            SwingUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }

    protected class CheckBoxIcon
    implements Icon {
        protected CheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            WebCheckBoxUI.this.iconRect = new Rectangle(x, y, WebCheckBoxUI.this.iconWidth, WebCheckBoxUI.this.iconHeight);
            Graphics2D g2d = (Graphics2D)g;
            Object aa = LafUtils.setupAntialias(g2d);
            WebCheckBoxUI.this.paintIcon(g2d, x, y);
            LafUtils.restoreAntialias(g2d, aa);
        }

        @Override
        public int getIconWidth() {
            return WebCheckBoxUI.this.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return WebCheckBoxUI.this.getIconHeight();
        }
    }
}

